(ns bling.fonts.ansi-shadow)



;;   █████╗ ███╗   ██╗███████╗██╗    ███████╗██╗  ██╗ █████╗ ██████╗  ██████╗ ██╗    ██╗
;;  ██╔══██╗████╗  ██║██╔════╝██║    ██╔════╝██║  ██║██╔══██╗██╔══██╗██╔═══██╗██║    ██║
;;  ███████║██╔██╗ ██║███████╗██║    ███████╗███████║███████║██║  ██║██║   ██║██║ █╗ ██║
;;  ██╔══██║██║╚██╗██║╚════██║██║    ╚════██║██╔══██║██╔══██║██║  ██║██║   ██║██║███╗██║
;;  ██║  ██║██║ ╚████║███████║██║    ███████║██║  ██║██║  ██║██████╔╝╚██████╔╝╚███╔███╔╝
;;  ╚═╝  ╚═╝╚═╝  ╚═══╝╚══════╝╚═╝    ╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝╚═════╝  ╚═════╝  ╚══╝╚══╝ 

(def ansi-shadow
'{:font-name "ANSI Shadow",
 :example
 [" █████╗ ███╗   ██╗███████╗██╗    ███████╗██╗  ██╗ █████╗ ██████╗  ██████╗ ██╗    ██╗"
  "██╔══██╗████╗  ██║██╔════╝██║    ██╔════╝██║  ██║██╔══██╗██╔══██╗██╔═══██╗██║    ██║"
  "███████║██╔██╗ ██║███████╗██║    ███████╗███████║███████║██║  ██║██║   ██║██║ █╗ ██║"
  "██╔══██║██║╚██╗██║╚════██║██║    ╚════██║██╔══██║██╔══██║██║  ██║██║   ██║██║███╗██║"
  "██║  ██║██║ ╚████║███████║██║    ███████║██║  ██║██║  ██║██████╔╝╚██████╔╝╚███╔███╔╝"
  "╚═╝  ╚═╝╚═╝  ╚═══╝╚══════╝╚═╝    ╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝╚═════╝  ╚═════╝  ╚══╝╚══╝ "],
 :desc "",
 :more-info
 "https://web.archive.org/web/20120819044459/http://www.roysac.com/thedrawfonts-tdf.asp",
 :url "",
 :example-text "ANSI",
 :font-sym ansi-shadow,
 :widest-char "M",
 :char-height 7,
 :max-char-width 11,
 :missing-chars ["{" "|" "}" "~" "Ä" "Ö" "Ü" "ä" "ö" "ü" "ß"],
 :chars-array-map
 {" "
  {:bands ["    " "    " "    " "    " "    " "    " "    "],
   :i 0,
   :character " ",
   :width 4,
   :height 7},
  "!"
  {:bands ["██╗" "██║" "██║" "╚═╝" "██╗" "╚═╝" "   "],
   :i 1,
   :character "!",
   :width 3,
   :height 7},
  "\""
  {:bands
   ["██╗██╗" "╚═╝╚═╝" "      " "      " "      " "      " "      "],
   :i 2,
   :character "\"",
   :width 6,
   :height 7},
  "#"
  {:bands
   [" ██╗ ██╗ "
    "████████╗"
    "╚██╔═██╔╝"
    "████████╗"
    "╚██╔═██╔╝"
    " ╚═╝ ╚═╝ "
    "         "],
   :i 3,
   :character "#",
   :width 9,
   :height 7},
  "$"
  {:bands
   ["▄▄███▄▄·"
    "██╔════╝"
    "███████╗"
    "╚════██║"
    "███████║"
    "╚═▀▀▀══╝"
    "        "],
   :i 4,
   :character "$",
   :width 8,
   :height 7},
  "%"
  {:bands
   ["██╗ ██╗"
    "╚═╝██╔╝"
    "  ██╔╝ "
    " ██╔╝  "
    "██╔╝██╗"
    "╚═╝ ╚═╝"
    "       "],
   :i 5,
   :character "%",
   :width 7,
   :height 7},
  "&"
  {:bands
   ["   ██╗   "
    "   ██║   "
    "████████╗"
    "██╔═██╔═╝"
    "██████║  "
    "╚═════╝  "
    "         "],
   :i 6,
   :character "&",
   :width 9,
   :height 7},
  "'"
  {:bands ["██╗" "╚═╝" "   " "   " "   " "   " "   "],
   :i 7,
   :character "'",
   :width 3,
   :height 7},
  "("
  {:bands [" ██╗" "██╔╝" "██║ " "██║ " "╚██╗" " ╚═╝" "    "],
   :i 8,
   :character "(",
   :width 4,
   :height 7},
  ")"
  {:bands ["██╗ " "╚██╗" " ██║" " ██║" "██╔╝" "╚═╝ " "    "],
   :i 9,
   :character ")",
   :width 4,
   :height 7},
  "*"
  {:bands
   ["      " "▄ ██╗▄" " ████╗" "▀╚██╔▀" "  ╚═╝ " "      " "       "],
   :i 10,
   :character "*",
   :width 6,
   :height 7},
  "+"
  {:bands
   ["       "
    "  ██╗  "
    "██████╗"
    "╚═██╔═╝"
    "  ╚═╝  "
    "       "
    "       "],
   :i 11,
   :character "+",
   :width 7,
   :height 7},
  ","
  {:bands ["   " "   " "   " "   " "▄█╗" "╚═╝" "   "],
   :i 12,
   :character ",",
   :width 3,
   :height 7},
  "-"
  {:bands
   ["      " "      " "█████╗" "╚════╝" "      " "      " "      "],
   :i 13,
   :character "-",
   :width 6,
   :height 7},
  "."
  {:bands ["   " "   " "   " "   " "██╗" "╚═╝" "   "],
   :i 14,
   :character ".",
   :width 3,
   :height 7},
  "/"
  {:bands
   ["    ██╗"
    "   ██╔╝"
    "  ██╔╝ "
    " ██╔╝  "
    "██╔╝   "
    "╚═╝    "
    "       "],
   :i 15,
   :character "/",
   :width 7,
   :height 7},
  "0"
  {:bands
   [" ██████╗ "
    "██╔═████╗"
    "██║██╔██║"
    "████╔╝██║"
    "╚██████╔╝"
    " ╚═════╝ "
    "         "],
   :i 16,
   :character "0",
   :width 9,
   :height 7},
  "1"
  {:bands [" ██╗" "███║" "╚██║" " ██║" " ██║" " ╚═╝" "    "],
   :i 17,
   :character "1",
   :width 4,
   :height 7},
  "2"
  {:bands
   ["██████╗ "
    "╚════██╗"
    " █████╔╝"
    "██╔═══╝ "
    "███████╗"
    "╚══════╝"
    "        "],
   :i 18,
   :character "2",
   :width 8,
   :height 7},
  "3"
  {:bands
   ["██████╗ "
    "╚════██╗"
    " █████╔╝"
    " ╚═══██╗"
    "██████╔╝"
    "╚═════╝ "
    "        "],
   :i 19,
   :character "3",
   :width 8,
   :height 7},
  "4"
  {:bands
   ["██╗  ██╗"
    "██║  ██║"
    "███████║"
    "╚════██║"
    "     ██║"
    "     ╚═╝"
    "        "],
   :i 20,
   :character "4",
   :width 8,
   :height 7},
  "5"
  {:bands
   ["███████╗"
    "██╔════╝"
    "███████╗"
    "╚════██║"
    "███████║"
    "╚══════╝"
    "        "],
   :i 21,
   :character "5",
   :width 8,
   :height 7},
  "6"
  {:bands
   [" ██████╗ "
    "██╔════╝ "
    "███████╗ "
    "██╔═══██╗"
    "╚██████╔╝"
    " ╚═════╝ "
    "         "],
   :i 22,
   :character "6",
   :width 9,
   :height 7},
  "7"
  {:bands
   ["███████╗"
    "╚════██║"
    "    ██╔╝"
    "   ██╔╝ "
    "   ██║  "
    "   ╚═╝  "
    "        "],
   :i 23,
   :character "7",
   :width 8,
   :height 7},
  "8"
  {:bands
   [" █████╗ "
    "██╔══██╗"
    "╚█████╔╝"
    "██╔══██╗"
    "╚█████╔╝"
    " ╚════╝ "
    "        "],
   :i 24,
   :character "8",
   :width 8,
   :height 7},
  "9"
  {:bands
   [" █████╗ "
    "██╔══██╗"
    "╚██████║"
    " ╚═══██║"
    " █████╔╝"
    " ╚════╝ "
    "        "],
   :i 25,
   :character "9",
   :width 8,
   :height 7},
  ":"
  {:bands ["   " "██╗" "╚═╝" "██╗" "╚═╝" "   " "   "],
   :i 26,
   :character ":",
   :width 3,
   :height 7},
  ";"
  {:bands ["   " "██╗" "╚═╝" "▄█╗" "▀═╝" "   " "   "],
   :i 27,
   :character ";",
   :width 3,
   :height 7},
  "<"
  {:bands ["  ██╗" " ██╔╝" "██╔╝ " "╚██╗ " " ╚██╗" "  ╚═╝" "     "],
   :i 28,
   :character "<",
   :width 5,
   :height 7},
  "="
  {:bands
   ["       "
    "██████╗"
    "╚═════╝"
    "██████╗"
    "╚═════╝"
    "       "
    "       "],
   :i 29,
   :character "=",
   :width 7,
   :height 7},
  ">"
  {:bands ["██╗  " "╚██╗ " " ╚██╗" " ██╔╝" "██╔╝ " "╚═╝  " "     "],
   :i 30,
   :character ">",
   :width 5,
   :height 7},
  "?"
  {:bands
   ["██████╗ "
    "╚════██╗"
    "  ▄███╔╝"
    "  ▀▀══╝ "
    "  ██╗   "
    "  ╚═╝   "
    "        "],
   :i 31,
   :character "?",
   :width 8,
   :height 7},
  "@"
  {:bands
   [" ██████╗ "
    "██╔═══██╗"
    "██║██╗██║"
    "██║██║██║"
    "╚█║████╔╝"
    " ╚╝╚═══╝ "
    "         "],
   :i 32,
   :character "@",
   :width 9,
   :height 7},
  "A"
  {:bands
   [" █████╗ "
    "██╔══██╗"
    "███████║"
    "██╔══██║"
    "██║  ██║"
    "╚═╝  ╚═╝"
    "        "],
   :i 33,
   :character "A",
   :width 8,
   :height 7},
  "B"
  {:bands
   ["██████╗ "
    "██╔══██╗"
    "██████╔╝"
    "██╔══██╗"
    "██████╔╝"
    "╚═════╝ "
    "        "],
   :i 34,
   :character "B",
   :width 8,
   :height 7},
  "C"
  {:bands
   [" ██████╗"
    "██╔════╝"
    "██║     "
    "██║     "
    "╚██████╗"
    " ╚═════╝"
    "        "],
   :i 35,
   :character "C",
   :width 8,
   :height 7},
  "D"
  {:bands
   ["██████╗ "
    "██╔══██╗"
    "██║  ██║"
    "██║  ██║"
    "██████╔╝"
    "╚═════╝ "
    "        "],
   :i 36,
   :character "D",
   :width 8,
   :height 7},
  "E"
  {:bands
   ["███████╗"
    "██╔════╝"
    "█████╗  "
    "██╔══╝  "
    "███████╗"
    "╚══════╝"
    "        "],
   :i 37,
   :character "E",
   :width 8,
   :height 7},
  "F"
  {:bands
   ["███████╗"
    "██╔════╝"
    "█████╗  "
    "██╔══╝  "
    "██║     "
    "╚═╝     "
    "        "],
   :i 38,
   :character "F",
   :width 8,
   :height 7},
  "G"
  {:bands
   [" ██████╗ "
    "██╔════╝ "
    "██║  ███╗"
    "██║   ██║"
    "╚██████╔╝"
    " ╚═════╝ "
    "         "],
   :i 39,
   :character "G",
   :width 9,
   :height 7},
  "H"
  {:bands
   ["██╗  ██╗"
    "██║  ██║"
    "███████║"
    "██╔══██║"
    "██║  ██║"
    "╚═╝  ╚═╝"
    "        "],
   :i 40,
   :character "H",
   :width 8,
   :height 7},
  "I"
  {:bands ["██╗" "██║" "██║" "██║" "██║" "╚═╝" "   "],
   :i 41,
   :character "I",
   :width 3,
   :height 7},
  "J"
  {:bands
   ["     ██╗"
    "     ██║"
    "     ██║"
    "██   ██║"
    "╚█████╔╝"
    " ╚════╝ "
    "        "],
   :i 42,
   :character "J",
   :width 8,
   :height 7},
  "K"
  {:bands
   ["██╗  ██╗"
    "██║ ██╔╝"
    "█████╔╝ "
    "██╔═██╗ "
    "██║  ██╗"
    "╚═╝  ╚═╝"
    "        "],
   :i 43,
   :character "K",
   :width 8,
   :height 7},
  "L"
  {:bands
   ["██╗     "
    "██║     "
    "██║     "
    "██║     "
    "███████╗"
    "╚══════╝"
    "        "],
   :i 44,
   :character "L",
   :width 8,
   :height 7},
  "M"
  {:bands
   ["███╗   ███╗"
    "████╗ ████║"
    "██╔████╔██║"
    "██║╚██╔╝██║"
    "██║ ╚═╝ ██║"
    "╚═╝     ╚═╝"
    "           "],
   :i 45,
   :character "M",
   :width 11,
   :height 7},
  "N"
  {:bands
   ["███╗   ██╗"
    "████╗  ██║"
    "██╔██╗ ██║"
    "██║╚██╗██║"
    "██║ ╚████║"
    "╚═╝  ╚═══╝"
    "          "],
   :i 46,
   :character "N",
   :width 10,
   :height 7},
  "O"
  {:bands
   [" ██████╗ "
    "██╔═══██╗"
    "██║   ██║"
    "██║   ██║"
    "╚██████╔╝"
    " ╚═════╝ "
    "         "],
   :i 47,
   :character "O",
   :width 9,
   :height 7},
  "P"
  {:bands
   ["██████╗ "
    "██╔══██╗"
    "██████╔╝"
    "██╔═══╝ "
    "██║     "
    "╚═╝     "
    "        "],
   :i 48,
   :character "P",
   :width 8,
   :height 7},
  "Q"
  {:bands
   [" ██████╗ "
    "██╔═══██╗"
    "██║   ██║"
    "██║▄▄ ██║"
    "╚██████╔╝"
    " ╚══▀▀═╝ "
    "         "],
   :i 49,
   :character "Q",
   :width 9,
   :height 7},
  "R"
  {:bands
   ["██████╗ "
    "██╔══██╗"
    "██████╔╝"
    "██╔══██╗"
    "██║  ██║"
    "╚═╝  ╚═╝"
    "        "],
   :i 50,
   :character "R",
   :width 8,
   :height 7},
  "S"
  {:bands
   ["███████╗"
    "██╔════╝"
    "███████╗"
    "╚════██║"
    "███████║"
    "╚══════╝"
    "        "],
   :i 51,
   :character "S",
   :width 8,
   :height 7},
  "T"
  {:bands
   ["████████╗"
    "╚══██╔══╝"
    "   ██║   "
    "   ██║   "
    "   ██║   "
    "   ╚═╝   "
    "         "],
   :i 52,
   :character "T",
   :width 9,
   :height 7},
  "U"
  {:bands
   ["██╗   ██╗"
    "██║   ██║"
    "██║   ██║"
    "██║   ██║"
    "╚██████╔╝"
    " ╚═════╝ "
    "         "],
   :i 53,
   :character "U",
   :width 9,
   :height 7},
  "V"
  {:bands
   ["██╗   ██╗"
    "██║   ██║"
    "██║   ██║"
    "╚██╗ ██╔╝"
    " ╚████╔╝ "
    "  ╚═══╝  "
    "         "],
   :i 54,
   :character "V",
   :width 9,
   :height 7},
  "W"
  {:bands
   ["██╗    ██╗"
    "██║    ██║"
    "██║ █╗ ██║"
    "██║███╗██║"
    "╚███╔███╔╝"
    " ╚══╝╚══╝ "
    "          "],
   :i 55,
   :character "W",
   :width 10,
   :height 7},
  "X"
  {:bands
   ["██╗  ██╗"
    "╚██╗██╔╝"
    " ╚███╔╝ "
    " ██╔██╗ "
    "██╔╝ ██╗"
    "╚═╝  ╚═╝"
    "        "],
   :i 56,
   :character "X",
   :width 8,
   :height 7},
  "Y"
  {:bands
   ["██╗   ██╗"
    "╚██╗ ██╔╝"
    " ╚████╔╝ "
    "  ╚██╔╝  "
    "   ██║   "
    "   ╚═╝   "
    "         "],
   :i 57,
   :character "Y",
   :width 9,
   :height 7},
  "Z"
  {:bands
   ["███████╗"
    "╚══███╔╝"
    "  ███╔╝ "
    " ███╔╝  "
    "███████╗"
    "╚══════╝"
    "        "],
   :i 58,
   :character "Z",
   :width 8,
   :height 7},
  "["
  {:bands ["███╗" "██╔╝" "██║ " "██║ " "███╗" "╚══╝" "    "],
   :i 59,
   :character "[",
   :width 4,
   :height 7},
  "\\"
  {:bands
   ["██╗    "
    "╚██╗   "
    " ╚██╗  "
    "  ╚██╗ "
    "   ╚██╗"
    "    ╚═╝"
    "       "],
   :i 60,
   :character "\\",
   :width 7,
   :height 7},
  "]"
  {:bands ["███╗" "╚██║" " ██║" " ██║" "███║" "╚══╝" "    "],
   :i 61,
   :character "]",
   :width 4,
   :height 7},
  "^"
  {:bands
   [" ███╗ " "██╔██╗" "╚═╝╚═╝" "      " "      " "      " "      "],
   :i 62,
   :character "^",
   :width 6,
   :height 7},
  "_"
  {:bands
   ["        "
    "        "
    "        "
    "        "
    "███████╗"
    "╚══════╝"
    "        "],
   :i 63,
   :character "_",
   :width 8,
   :height 7},
  "`"
  {:bands
   ["██╗     "
    "╚██╗    "
    " ╚═╝    "
    "        "
    "        "
    "        "
    "       "],
   :i 64,
   :character "`",
   :width 8,
   :height 7},
  "a"
  {:bands
   [" █████╗ "
    "██╔══██╗"
    "███████║"
    "██╔══██║"
    "██║  ██║"
    "╚═╝  ╚═╝"
    "        "],
   :i 65,
   :character "a",
   :width 8,
   :height 7},
  "b"
  {:bands
   ["██████╗ "
    "██╔══██╗"
    "██████╔╝"
    "██╔══██╗"
    "██████╔╝"
    "╚═════╝ "
    "        "],
   :i 66,
   :character "b",
   :width 8,
   :height 7},
  "c"
  {:bands
   [" ██████╗"
    "██╔════╝"
    "██║     "
    "██║     "
    "╚██████╗"
    " ╚═════╝"
    "        "],
   :i 67,
   :character "c",
   :width 8,
   :height 7},
  "d"
  {:bands
   ["██████╗ "
    "██╔══██╗"
    "██║  ██║"
    "██║  ██║"
    "██████╔╝"
    "╚═════╝ "
    "        "],
   :i 68,
   :character "d",
   :width 8,
   :height 7},
  "e"
  {:bands
   ["███████╗"
    "██╔════╝"
    "█████╗  "
    "██╔══╝  "
    "███████╗"
    "╚══════╝"
    "        "],
   :i 69,
   :character "e",
   :width 8,
   :height 7},
  "f"
  {:bands
   ["███████╗"
    "██╔════╝"
    "█████╗  "
    "██╔══╝  "
    "██║     "
    "╚═╝     "
    "        "],
   :i 70,
   :character "f",
   :width 8,
   :height 7},
  "g"
  {:bands
   [" ██████╗ "
    "██╔════╝ "
    "██║  ███╗"
    "██║   ██║"
    "╚██████╔╝"
    " ╚═════╝ "
    "         "],
   :i 71,
   :character "g",
   :width 9,
   :height 7},
  "h"
  {:bands
   ["██╗  ██╗"
    "██║  ██║"
    "███████║"
    "██╔══██║"
    "██║  ██║"
    "╚═╝  ╚═╝"
    "        "],
   :i 72,
   :character "h",
   :width 8,
   :height 7},
  "i"
  {:bands ["██╗" "██║" "██║" "██║" "██║" "╚═╝" "   "],
   :i 73,
   :character "i",
   :width 3,
   :height 7},
  "j"
  {:bands
   ["     ██╗"
    "     ██║"
    "     ██║"
    "██   ██║"
    "╚█████╔╝"
    " ╚════╝ "
    "        "],
   :i 74,
   :character "j",
   :width 8,
   :height 7},
  "k"
  {:bands
   ["██╗  ██╗"
    "██║ ██╔╝"
    "█████╔╝ "
    "██╔═██╗ "
    "██║  ██╗"
    "╚═╝  ╚═╝"
    "        "],
   :i 75,
   :character "k",
   :width 8,
   :height 7},
  "l"
  {:bands
   ["██╗     "
    "██║     "
    "██║     "
    "██║     "
    "███████╗"
    "╚══════╝"
    "        "],
   :i 76,
   :character "l",
   :width 8,
   :height 7},
  "m"
  {:bands
   ["███╗   ███╗"
    "████╗ ████║"
    "██╔████╔██║"
    "██║╚██╔╝██║"
    "██║ ╚═╝ ██║"
    "╚═╝     ╚═╝"
    "           "],
   :i 77,
   :character "m",
   :width 11,
   :height 7},
  "n"
  {:bands
   ["███╗   ██╗"
    "████╗  ██║"
    "██╔██╗ ██║"
    "██║╚██╗██║"
    "██║ ╚████║"
    "╚═╝  ╚═══╝"
    "          "],
   :i 78,
   :character "n",
   :width 10,
   :height 7},
  "o"
  {:bands
   [" ██████╗ "
    "██╔═══██╗"
    "██║   ██║"
    "██║   ██║"
    "╚██████╔╝"
    " ╚═════╝ "
    "         "],
   :i 79,
   :character "o",
   :width 9,
   :height 7},
  "p"
  {:bands
   ["██████╗ "
    "██╔══██╗"
    "██████╔╝"
    "██╔═══╝ "
    "██║     "
    "╚═╝     "
    "        "],
   :i 80,
   :character "p",
   :width 8,
   :height 7},
  "q"
  {:bands
   [" ██████╗ "
    "██╔═══██╗"
    "██║   ██║"
    "██║▄▄ ██║"
    "╚██████╔╝"
    " ╚══▀▀═╝ "
    "         "],
   :i 81,
   :character "q",
   :width 9,
   :height 7},
  "r"
  {:bands
   ["██████╗ "
    "██╔══██╗"
    "██████╔╝"
    "██╔══██╗"
    "██║  ██║"
    "╚═╝  ╚═╝"
    "        "],
   :i 82,
   :character "r",
   :width 8,
   :height 7},
  "s"
  {:bands
   ["███████╗"
    "██╔════╝"
    "███████╗"
    "╚════██║"
    "███████║"
    "╚══════╝"
    "        "],
   :i 83,
   :character "s",
   :width 8,
   :height 7},
  "t"
  {:bands
   ["████████╗"
    "╚══██╔══╝"
    "   ██║   "
    "   ██║   "
    "   ██║   "
    "   ╚═╝   "
    "         "],
   :i 84,
   :character "t",
   :width 9,
   :height 7},
  "u"
  {:bands
   ["██╗   ██╗"
    "██║   ██║"
    "██║   ██║"
    "██║   ██║"
    "╚██████╔╝"
    " ╚═════╝ "
    "         "],
   :i 85,
   :character "u",
   :width 9,
   :height 7},
  "v"
  {:bands
   ["██╗   ██╗"
    "██║   ██║"
    "██║   ██║"
    "╚██╗ ██╔╝"
    " ╚████╔╝ "
    "  ╚═══╝  "
    "         "],
   :i 86,
   :character "v",
   :width 9,
   :height 7},
  "w"
  {:bands
   ["██╗    ██╗"
    "██║    ██║"
    "██║ █╗ ██║"
    "██║███╗██║"
    "╚███╔███╔╝"
    " ╚══╝╚══╝ "
    "          "],
   :i 87,
   :character "w",
   :width 10,
   :height 7},
  "x"
  {:bands
   ["██╗  ██╗"
    "╚██╗██╔╝"
    " ╚███╔╝ "
    " ██╔██╗ "
    "██╔╝ ██╗"
    "╚═╝  ╚═╝"
    "        "],
   :i 88,
   :character "x",
   :width 8,
   :height 7},
  "y"
  {:bands
   ["██╗   ██╗"
    "╚██╗ ██╔╝"
    " ╚████╔╝ "
    "  ╚██╔╝  "
    "   ██║   "
    "   ╚═╝   "
    "         "],
   :i 89,
   :character "y",
   :width 9,
   :height 7},
  "z"
  {:bands
   ["███████╗"
    "╚══███╔╝"
    "  ███╔╝ "
    " ███╔╝  "
    "███████╗"
    "╚══════╝"
    "        "],
   :i 90,
   :character "z",
   :width 8,
   :height 7}}})