(ns bling.fonts.big-money)



;;  $$$$$$$\  $$\                $$\      $$\
;;  $$  __$$\ \__|               $$$\    $$$ |
;;  $$ |  $$ |$$\  $$$$$$\       $$$$\  $$$$ | $$$$$$\  $$$$$$$\   $$$$$$\  $$\   $$\
;;  $$$$$$$\ |$$ |$$  __$$\      $$\$$\$$ $$ |$$  __$$\ $$  __$$\ $$  __$$\ $$ |  $$ |
;;  $$  __$$\ $$ |$$ /  $$ |     $$ \$$$  $$ |$$ /  $$ |$$ |  $$ |$$$$$$$$ |$$ |  $$ |
;;  $$ |  $$ |$$ |$$ |  $$ |     $$ |\$  /$$ |$$ |  $$ |$$ |  $$ |$$   ____|$$ |  $$ |
;;  $$$$$$$  |$$ |\$$$$$$$ |     $$ | \_/ $$ |\$$$$$$  |$$ |  $$ |\$$$$$$$\ \$$$$$$$ |
;;  \_______/ \__| \____$$ |     \__|     \__| \______/ \__|  \__| \_______| \____$$ |
;;                $$\   $$ |                                                $$\   $$ |
;;                \$$$$$$  |                                                \$$$$$$  |
;;                 \______/                                                  \______/

(def big-money
'{:font-name "Big Money",
 :example
 ["$$$$$$$\\  $$\\                $$\\      $$\\"
  "$$  __$$\\ \\__|               $$$\\    $$$ |"
  "$$ |  $$ |$$\\  $$$$$$\\       $$$$\\  $$$$ | $$$$$$\\  $$$$$$$\\   $$$$$$\\  $$\\   $$\\"
  "$$$$$$$\\ |$$ |$$  __$$\\      $$\\$$\\$$ $$ |$$  __$$\\ $$  __$$\\ $$  __$$\\ $$ |  $$ |"
  "$$  __$$\\ $$ |$$ /  $$ |     $$ \\$$$  $$ |$$ /  $$ |$$ |  $$ |$$$$$$$$ |$$ |  $$ |"
  "$$ |  $$ |$$ |$$ |  $$ |     $$ |\\$  /$$ |$$ |  $$ |$$ |  $$ |$$   ____|$$ |  $$ |"
  "$$$$$$$  |$$ |\\$$$$$$$ |     $$ | \\_/ $$ |\\$$$$$$  |$$ |  $$ |\\$$$$$$$\\ \\$$$$$$$ |"
  "\\_______/ \\__| \\____$$ |     \\__|     \\__| \\______/ \\__|  \\__| \\_______| \\____$$ |"
  "              $$\\   $$ |                                                $$\\   $$ |"
  "              \\$$$$$$  |                                                \\$$$$$$  |"
  "               \\______/                                                  \\______/"],
 :desc
 "bigmoney-nw : by nathan bloomfield (xzovik@gmail.com)\n  based on art from the legendary MAKEMONEYFAST chain letter\n\n  History:\n  5-30-2007 : first version (required characters only)",
 :example-text "Money",
 :font-sym big-money,
 :widest-char "@",
 :char-height 11,
 :max-char-width 16,
 :missing-chars [],
 :chars-array-map
 {" "
  {:bands
   ["     "
    "     "
    "     "
    "     "
    "     "
    "     "
    "     "
    "     "
    "     "
    "     "
    "     "],
   :i 0,
   :character " ",
   :width 5,
   :height 11},
  "!"
  {:bands
   ["$$\\ "
    "$$ |"
    "$$ |"
    "$$ |"
    "\\__|"
    "    "
    "$$\\ "
    "\\__|"
    "    "
    "    "
    "    "],
   :i 1,
   :character "!",
   :width 4,
   :height 11},
  "\""
  {:bands
   ["$$\\ $$\\ "
    "$$ |$$ |"
    "$$ |$$ |"
    "\\__|\\__|"
    "        "
    "        "
    "        "
    "        "
    "        "
    "        "
    "        "],
   :i 2,
   :character "\"",
   :width 8,
   :height 11},
  "#"
  {:bands
   ["  $$\\ $$\\   "
    "  $$ \\$$ \\  "
    "$$$$$$$$$$\\ "
    "\\_$$  $$   |"
    "$$$$$$$$$$\\ "
    "\\_$$  $$  _|"
    "  $$ |$$ |  "
    "  \\__|\\__|  "
    "            "
    "            "
    "            "],
   :i 3,
   :character "#",
   :width 12,
   :height 11},
  "$"
  {:bands
   ["   $$\\    "
    " $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  \\__|"
    "\\$$$$$$\\  "
    " \\___ $$\\ "
    "$$\\  \\$$ |"
    "\\$$$$$$  |"
    " \\_$$  _/ "
    "   \\ _/   "
    "          "],
   :i 4,
   :character "$",
   :width 10,
   :height 11},
  "%"
  {:bands
   ["$$\\   $$\\ "
    "\\__| $$  |"
    "    $$  / "
    "   $$  /  "
    "  $$  /   "
    " $$  /    "
    "$$  / $$\\ "
    "\\__/  \\__|"
    "          "
    "          "
    "          "],
   :i 5,
   :character "%",
   :width 10,
   :height 11},
  "&"
  {:bands
   [" $$$\\     "
    "$$ $$\\    "
    "\\$$$\\ |   "
    "$$\\$$\\$$\\ "
    "$$ \\$$ __|"
    "$$ |\\$$\\  "
    " $$$$ $$\\ "
    " \\____\\__|"
    "          "
    "          "
    "          "],
   :i 6,
   :character "&",
   :width 10,
   :height 11},
  "'"
  {:bands
   ["$$\\ "
    "$  |"
    "\\_/ "
    "    "
    "    "
    "    "
    "    "
    "    "
    "    "
    "    "
    "    "],
   :i 7,
   :character "'",
   :width 4,
   :height 11},
  "("
  {:bands
   ["  $$$\\ "
    " $$  _|"
    "$$  /  "
    "$$ |   "
    "$$ |   "
    "\\$$\\   "
    " \\$$$\\ "
    "  \\___|"
    "       "
    "       "
    "       "],
   :i 8,
   :character "(",
   :width 7,
   :height 11},
  ")"
  {:bands
   ["$$$\\   "
    " \\$$\\  "
    "  \\$$\\ "
    "   $$ |"
    "   $$ |"
    "  $$  |"
    "$$$  / "
    "\\___/  "
    "       "
    "       "
    "       "],
   :i 9,
   :character ")",
   :width 7,
   :height 11},
  "*"
  {:bands
   ["         "
    " $$\\$$\\  "
    " \\$$$  | "
    "$$$$$$$\\ "
    "\\_$$$ __|"
    " $$ $$\\  "
    " \\__\\__| "
    "         "
    "         "
    "         "
    "         "],
   :i 10,
   :character "*",
   :width 9,
   :height 11},
  "+"
  {:bands
   ["          "
    "   $$\\    "
    "   $$ |   "
    "$$$$$$$$\\ "
    "\\__$$  __|"
    "   $$ |   "
    "   \\__|   "
    "          "
    "          "
    "          "
    "          "],
   :i 11,
   :character "+",
   :width 10,
   :height 11},
  ","
  {:bands
   ["    "
    "    "
    "    "
    "    "
    "    "
    "    "
    "$$\\ "
    "$  |"
    "\\_/ "
    "    "
    "    "],
   :i 12,
   :character ",",
   :width 4,
   :height 11},
  "-"
  {:bands
   ["        "
    "        "
    "        "
    "$$$$$$\\ "
    "\\______|"
    "        "
    "        "
    "        "
    "        "
    "        "
    "        "],
   :i 13,
   :character "-",
   :width 8,
   :height 11},
  "."
  {:bands
   ["    "
    "    "
    "    "
    "    "
    "    "
    "    "
    "$$\\ "
    "\\__|"
    "    "
    "    "
    "    "],
   :i 14,
   :character ".",
   :width 4,
   :height 11},
  "/"
  {:bands
   ["      $$\\ "
    "     $$  |"
    "    $$  / "
    "   $$  /  "
    "  $$  /   "
    " $$  /    "
    "$$  /     "
    "\\__/      "
    "          "
    "          "
    "          "],
   :i 15,
   :character "/",
   :width 10,
   :height 11},
  "0"
  {:bands
   [" $$$$$$\\  "
    "$$$ __$$\\ "
    "$$$$\\ $$ |"
    "$$\\$$\\$$ |"
    "$$ \\$$$$ |"
    "$$ |\\$$$ |"
    "\\$$$$$$  /"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 16,
   :character "0",
   :width 10,
   :height 11},
  "1"
  {:bands
   ["  $$\\   "
    "$$$$ |  "
    "\\_$$ |  "
    "  $$ |  "
    "  $$ |  "
    "  $$ |  "
    "$$$$$$\\ "
    "\\______|"
    "        "
    "        "
    "        "],
   :i 17,
   :character "1",
   :width 8,
   :height 11},
  "2"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "\\__/  $$ |"
    " $$$$$$  |"
    "$$  ____/ "
    "$$ |      "
    "$$$$$$$$\\ "
    "\\________|"
    "          "
    "          "
    "          "],
   :i 18,
   :character "2",
   :width 10,
   :height 11},
  "3"
  {:bands
   [" $$$$$$\\  "
    "$$ ___$$\\ "
    "\\_/   $$ |"
    "  $$$$$ / "
    "  \\___$$\\ "
    "$$\\   $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 19,
   :character "3",
   :width 10,
   :height 11},
  "4"
  {:bands
   ["$$\\   $$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$$$$$$$ |"
    "\\_____$$ |"
    "      $$ |"
    "      $$ |"
    "      \\__|"
    "          "
    "          "
    "          "],
   :i 20,
   :character "4",
   :width 10,
   :height 11},
  "5"
  {:bands
   ["$$$$$$$\\  "
    "$$  ____| "
    "$$ |      "
    "$$$$$$$\\  "
    "\\_____$$\\ "
    "$$\\   $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 21,
   :character "5",
   :width 10,
   :height 11},
  "6"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  \\__|"
    "$$$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    " $$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 22,
   :character "6",
   :width 10,
   :height 11},
  "7"
  {:bands
   ["$$$$$$$$\\ "
    "\\____$$  |"
    "    $$  / "
    "   $$  /  "
    "  $$  /   "
    " $$  /    "
    "$$  /     "
    "\\__/      "
    "          "
    "          "
    "          "],
   :i 23,
   :character "7",
   :width 10,
   :height 11},
  "8"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    " $$$$$$  |"
    "$$  __$$< "
    "$$ /  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 24,
   :character "8",
   :width 10,
   :height 11},
  "9"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "\\$$$$$$$ |"
    " \\____$$ |"
    "$$\\   $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 25,
   :character "9",
   :width 10,
   :height 11},
  ":"
  {:bands
   ["    "
    "    "
    "$$\\ "
    "\\__|"
    "    "
    "$$\\ "
    "\\__|"
    "    "
    "    "
    "    "
    "    "],
   :i 26,
   :character ":",
   :width 4,
   :height 11},
  ";"
  {:bands
   ["    "
    "    "
    "$$\\ "
    "\\__|"
    "    "
    "$$\\ "
    "$  |"
    "\\_/ "
    "    "
    "    "
    "    "],
   :i 27,
   :character ";",
   :width 4,
   :height 11},
  "<"
  {:bands
   ["   $$\\ "
    "  $$  |"
    " $$  / "
    "$$  /  "
    "\\$$<   "
    " \\$$\\  "
    "  \\$$\\ "
    "   \\__|"
    "       "
    "       "
    "       "],
   :i 28,
   :character "<",
   :width 7,
   :height 11},
  "="
  {:bands
   ["      "
    "      "
    "$$$$\\ "
    "\\____|"
    "$$$$\\ "
    "\\____|"
    "      "
    "      "
    "      "
    "      "
    "      "],
   :i 29,
   :character "=",
   :width 6,
   :height 11},
  ">"
  {:bands
   ["$$\\    "
    "\\$$\\   "
    " \\$$\\  "
    "  \\$$\\ "
    "  $$  |"
    " $$  / "
    "$$  /  "
    "\\__/   "
    "       "
    "       "
    "       "],
   :i 30,
   :character ">",
   :width 7,
   :height 11},
  "?"
  {:bands
   [" $$$$\\  "
    "$$  $$\\ "
    "\\__/$$ |"
    "   $$  |"
    "  $$  / "
    "  \\__/  "
    "  $$\\   "
    "  \\__|  "
    "        "
    "        "
    "        "],
   :i 31,
   :character "?",
   :width 8,
   :height 11},
  "@"
  {:bands
   ["    $$$$$$\\     "
    "  $$$ ___$$$\\   "
    " $$ _/   \\_$$\\  "
    "$$ / $$$$$\\ $$\\ "
    "$$ |$$  $$ |$$ |"
    "$$ |$$ /$$ |$$ |"
    "$$ |\\$$$$$$$$  |"
    "\\$$\\ \\________/ "
    " \\$$$\\   $$$\\   "
    "  \\_$$$$$$  _|  "
    "    \\______/    "],
   :i 32,
   :character "@",
   :width 16,
   :height 11},
  "A"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "$$$$$$$$ |"
    "$$  __$$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\__|  \\__|"
    "          "
    "          "
    "          "],
   :i 33,
   :character "A",
   :width 10,
   :height 11},
  "B"
  {:bands
   ["$$$$$$$\\  "
    "$$  __$$\\ "
    "$$ |  $$ |"
    "$$$$$$$\\ |"
    "$$  __$$\\ "
    "$$ |  $$ |"
    "$$$$$$$  |"
    "\\_______/ "
    "          "
    "          "
    "          "],
   :i 34,
   :character "B",
   :width 10,
   :height 11},
  "C"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  \\__|"
    "$$ |      "
    "$$ |      "
    "$$ |  $$\\ "
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 35,
   :character "C",
   :width 10,
   :height 11},
  "D"
  {:bands
   ["$$$$$$$\\  "
    "$$  __$$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$$$$$$  |"
    "\\_______/ "
    "          "
    "          "
    "          "],
   :i 36,
   :character "D",
   :width 10,
   :height 11},
  "E"
  {:bands
   ["$$$$$$$$\\ "
    "$$  _____|"
    "$$ |      "
    "$$$$$\\    "
    "$$  __|   "
    "$$ |      "
    "$$$$$$$$\\ "
    "\\________|"
    "          "
    "          "
    "          "],
   :i 37,
   :character "E",
   :width 10,
   :height 11},
  "F"
  {:bands
   ["$$$$$$$$\\ "
    "$$  _____|"
    "$$ |      "
    "$$$$$\\    "
    "$$  __|   "
    "$$ |      "
    "$$ |      "
    "\\__|      "
    "          "
    "          "
    "          "],
   :i 38,
   :character "F",
   :width 10,
   :height 11},
  "G"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  \\__|"
    "$$ |$$$$\\ "
    "$$ |\\_$$ |"
    "$$ |  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 39,
   :character "G",
   :width 10,
   :height 11},
  "H"
  {:bands
   ["$$\\   $$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$$$$$$$ |"
    "$$  __$$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\__|  \\__|"
    "          "
    "          "
    "          "],
   :i 40,
   :character "H",
   :width 10,
   :height 11},
  "I"
  {:bands
   ["$$$$$$\\ "
    "\\_$$  _|"
    "  $$ |  "
    "  $$ |  "
    "  $$ |  "
    "  $$ |  "
    "$$$$$$\\ "
    "\\______|"
    "        "
    "        "
    "        "],
   :i 41,
   :character "I",
   :width 8,
   :height 11},
  "J"
  {:bands
   ["   $$$$$\\ "
    "   \\__$$ |"
    "      $$ |"
    "      $$ |"
    "$$\\   $$ |"
    "$$ |  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 42,
   :character "J",
   :width 10,
   :height 11},
  "K"
  {:bands
   ["$$\\   $$\\ "
    "$$ | $$  |"
    "$$ |$$  / "
    "$$$$$  /  "
    "$$  $$<   "
    "$$ |\\$$\\  "
    "$$ | \\$$\\ "
    "\\__|  \\__|"
    "          "
    "          "
    "          "],
   :i 43,
   :character "K",
   :width 10,
   :height 11},
  "L"
  {:bands
   ["$$\\       "
    "$$ |      "
    "$$ |      "
    "$$ |      "
    "$$ |      "
    "$$ |      "
    "$$$$$$$$\\ "
    "\\________|"
    "          "
    "          "
    "          "],
   :i 44,
   :character "L",
   :width 10,
   :height 11},
  "M"
  {:bands
   ["$$\\      $$\\ "
    "$$$\\    $$$ |"
    "$$$$\\  $$$$ |"
    "$$\\$$\\$$ $$ |"
    "$$ \\$$$  $$ |"
    "$$ |\\$  /$$ |"
    "$$ | \\_/ $$ |"
    "\\__|     \\__|"
    "             "
    "             "
    "             "],
   :i 45,
   :character "M",
   :width 13,
   :height 11},
  "N"
  {:bands
   ["$$\\   $$\\ "
    "$$$\\  $$ |"
    "$$$$\\ $$ |"
    "$$ $$\\$$ |"
    "$$ \\$$$$ |"
    "$$ |\\$$$ |"
    "$$ | \\$$ |"
    "\\__|  \\__|"
    "          "
    "          "
    "          "],
   :i 46,
   :character "N",
   :width 10,
   :height 11},
  "O"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    " $$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 47,
   :character "O",
   :width 10,
   :height 11},
  "P"
  {:bands
   ["$$$$$$$\\  "
    "$$  __$$\\ "
    "$$ |  $$ |"
    "$$$$$$$  |"
    "$$  ____/ "
    "$$ |      "
    "$$ |      "
    "\\__|      "
    "          "
    "          "
    "          "],
   :i 48,
   :character "P",
   :width 10,
   :height 11},
  "Q"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ $$\\$$ |"
    "\\$$$$$$ / "
    " \\___$$$\\ "
    "     \\___|"
    "          "
    "          "],
   :i 49,
   :character "Q",
   :width 10,
   :height 11},
  "R"
  {:bands
   ["$$$$$$$\\  "
    "$$  __$$\\ "
    "$$ |  $$ |"
    "$$$$$$$  |"
    "$$  __$$< "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\__|  \\__|"
    "          "
    "          "
    "          "],
   :i 50,
   :character "R",
   :width 10,
   :height 11},
  "S"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  \\__|"
    "\\$$$$$$\\  "
    " \\____$$\\ "
    "$$\\   $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 51,
   :character "S",
   :width 10,
   :height 11},
  "T"
  {:bands
   ["$$$$$$$$\\ "
    "\\__$$  __|"
    "   $$ |   "
    "   $$ |   "
    "   $$ |   "
    "   $$ |   "
    "   $$ |   "
    "   \\__|   "
    "          "
    "          "
    "          "],
   :i 52,
   :character "T",
   :width 10,
   :height 11},
  "U"
  {:bands
   ["$$\\   $$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 53,
   :character "U",
   :width 10,
   :height 11},
  "V"
  {:bands
   ["$$\\    $$\\ "
    "$$ |   $$ |"
    "$$ |   $$ |"
    "\\$$\\  $$  |"
    " \\$$\\$$  / "
    "  \\$$$  /  "
    "   \\$  /   "
    "    \\_/    "
    "           "
    "           "
    "           "],
   :i 54,
   :character "V",
   :width 11,
   :height 11},
  "W"
  {:bands
   ["$$\\      $$\\ "
    "$$ | $\\  $$ |"
    "$$ |$$$\\ $$ |"
    "$$ $$ $$\\$$ |"
    "$$$$  _$$$$ |"
    "$$$  / \\$$$ |"
    "$$  /   \\$$ |"
    "\\__/     \\__|"
    "             "
    "             "
    "             "],
   :i 55,
   :character "W",
   :width 13,
   :height 11},
  "X"
  {:bands
   ["$$\\   $$\\ "
    "$$ |  $$ |"
    "\\$$\\ $$  |"
    " \\$$$$  / "
    " $$  $$<  "
    "$$  /\\$$\\ "
    "$$ /  $$ |"
    "\\__|  \\__|"
    "          "
    "          "
    "          "],
   :i 56,
   :character "X",
   :width 10,
   :height 11},
  "Y"
  {:bands
   ["$$\\     $$\\ "
    "\\$$\\   $$  |"
    " \\$$\\ $$  / "
    "  \\$$$$  /  "
    "   \\$$  /   "
    "    $$ |    "
    "    $$ |    "
    "    \\__|    "
    "            "
    "            "
    "            "],
   :i 57,
   :character "Y",
   :width 12,
   :height 11},
  "Z"
  {:bands
   ["$$$$$$$$\\ "
    "\\____$$  |"
    "    $$  / "
    "   $$  /  "
    "  $$  /   "
    " $$  /    "
    "$$$$$$$$\\ "
    "\\________|"
    "          "
    "          "
    "          "],
   :i 58,
   :character "Z",
   :width 10,
   :height 11},
  "["
  {:bands
   ["$$$$\\ "
    "$$  _|"
    "$$ |  "
    "$$ |  "
    "$$ |  "
    "$$ |  "
    "$$$$\\ "
    "\\____|"
    "      "
    "      "
    "      "],
   :i 59,
   :character "[",
   :width 6,
   :height 11},
  "\\"
  {:bands
   ["$$\\       "
    "\\$$\\      "
    " \\$$\\     "
    "  \\$$\\    "
    "   \\$$\\   "
    "    \\$$\\  "
    "     \\$$\\ "
    "      \\__|"
    "          "
    "          "
    "          "],
   :i 60,
   :character "\\",
   :width 10,
   :height 11},
  "]"
  {:bands
   ["$$$$\\ "
    "\\_$$ |"
    "  $$ |"
    "  $$ |"
    "  $$ |"
    "  $$ |"
    "$$$$ |"
    "\\____|"
    "      "
    "      "
    "      "],
   :i 61,
   :character "]",
   :width 6,
   :height 11},
  "^"
  {:bands
   ["   $\\    "
    "  $$$\\   "
    " $$ $$\\  "
    "$$  \\$$\\ "
    "\\__/ \\__|"
    "         "
    "         "
    "         "
    "         "
    "         "
    "         "],
   :i 62,
   :character "^",
   :width 9,
   :height 11},
  "_"
  {:bands
   ["        "
    "        "
    "        "
    "        "
    "        "
    "        "
    "        "
    "$$$$$$\\ "
    "\\______|"
    "        "
    "        "],
   :i 63,
   :character "_",
   :width 8,
   :height 11},
  "`"
  {:bands
   ["$$\\ "
    "\\$ |"
    " \\_|"
    "    "
    "    "
    "    "
    "    "
    "    "
    "    "
    "    "
    "    "],
   :i 64,
   :character "`",
   :width 4,
   :height 11},
  "a"
  {:bands
   ["          "
    "          "
    " $$$$$$\\  "
    " \\____$$\\ "
    " $$$$$$$ |"
    "$$  __$$ |"
    "\\$$$$$$$ |"
    " \\_______|"
    "          "
    "          "
    "          "],
   :i 65,
   :character "a",
   :width 10,
   :height 11},
  "b"
  {:bands
   ["$$\\       "
    "$$ |      "
    "$$$$$$$\\  "
    "$$  __$$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$$$$$$  |"
    "\\_______/ "
    "          "
    "          "
    "          "],
   :i 66,
   :character "b",
   :width 10,
   :height 11},
  "c"
  {:bands
   ["          "
    "          "
    " $$$$$$$\\ "
    "$$  _____|"
    "$$ /      "
    "$$ |      "
    "\\$$$$$$$\\ "
    " \\_______|"
    "          "
    "          "
    "          "],
   :i 67,
   :character "c",
   :width 10,
   :height 11},
  "d"
  {:bands
   ["      $$\\ "
    "      $$ |"
    " $$$$$$$ |"
    "$$  __$$ |"
    "$$ /  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$$ |"
    " \\_______|"
    "          "
    "          "
    "          "],
   :i 68,
   :character "d",
   :width 10,
   :height 11},
  "e"
  {:bands
   ["          "
    "          "
    " $$$$$$\\  "
    "$$  __$$\\ "
    "$$$$$$$$ |"
    "$$   ____|"
    "\\$$$$$$$\\ "
    " \\_______|"
    "          "
    "          "
    "          "],
   :i 69,
   :character "e",
   :width 10,
   :height 11},
  "f"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  \\__|"
    "$$$$\\     "
    "$$  _|    "
    "$$ |      "
    "$$ |      "
    "\\__|      "
    "          "
    "          "
    "          "],
   :i 70,
   :character "f",
   :width 10,
   :height 11},
  "g"
  {:bands
   ["          "
    "          "
    " $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$$ |"
    " \\____$$ |"
    "$$\\   $$ |"
    "\\$$$$$$  |"
    " \\______/ "],
   :i 71,
   :character "g",
   :width 10,
   :height 11},
  "h"
  {:bands
   ["$$\\       "
    "$$ |      "
    "$$$$$$$\\  "
    "$$  __$$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\__|  \\__|"
    "          "
    "          "
    "          "],
   :i 72,
   :character "h",
   :width 10,
   :height 11},
  "i"
  {:bands
   ["$$\\ "
    "\\__|"
    "$$\\ "
    "$$ |"
    "$$ |"
    "$$ |"
    "$$ |"
    "\\__|"
    "    "
    "    "
    "    "],
   :i 73,
   :character "i",
   :width 4,
   :height 11},
  "j"
  {:bands
   ["          "
    "          "
    "      $$\\ "
    "      \\__|"
    "      $$\\ "
    "      $$ |"
    "      $$ |"
    "      $$ |"
    "$$\\   $$ |"
    "\\$$$$$$  |"
    " \\______/ "],
   :i 74,
   :character "j",
   :width 10,
   :height 11},
  "k"
  {:bands
   ["$$\\       "
    "$$ |      "
    "$$ |  $$\\ "
    "$$ | $$  |"
    "$$$$$$  / "
    "$$  _$$<  "
    "$$ | \\$$\\ "
    "\\__|  \\__|"
    "          "
    "          "
    "          "],
   :i 75,
   :character "k",
   :width 10,
   :height 11},
  "l"
  {:bands
   ["$$\\ "
    "$$ |"
    "$$ |"
    "$$ |"
    "$$ |"
    "$$ |"
    "$$ |"
    "\\__|"
    "    "
    "    "
    "    "],
   :i 76,
   :character "l",
   :width 4,
   :height 11},
  "m"
  {:bands
   ["              "
    "              "
    "$$$$$$\\$$$$\\  "
    "$$  _$$  _$$\\ "
    "$$ / $$ / $$ |"
    "$$ | $$ | $$ |"
    "$$ | $$ | $$ |"
    "\\__| \\__| \\__|"
    "              "
    "              "
    "              "],
   :i 77,
   :character "m",
   :width 14,
   :height 11},
  "n"
  {:bands
   ["          "
    "          "
    "$$$$$$$\\  "
    "$$  __$$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\__|  \\__|"
    "          "
    "          "
    "          "],
   :i 78,
   :character "n",
   :width 10,
   :height 11},
  "o"
  {:bands
   ["          "
    "          "
    " $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 79,
   :character "o",
   :width 10,
   :height 11},
  "p"
  {:bands
   ["          "
    "          "
    " $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "$$ |  $$ |"
    "$$$$$$$  |"
    "$$  ____/ "
    "$$ |      "
    "$$ |      "
    "\\__|      "],
   :i 80,
   :character "p",
   :width 10,
   :height 11},
  "q"
  {:bands
   ["          "
    "          "
    " $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$$ |"
    " \\____$$ |"
    "      $$ |"
    "      $$ |"
    "      \\__|"],
   :i 81,
   :character "q",
   :width 10,
   :height 11},
  "r"
  {:bands
   ["          "
    "          "
    " $$$$$$\\  "
    "$$  __$$\\ "
    "$$ |  \\__|"
    "$$ |      "
    "$$ |      "
    "\\__|      "
    "          "
    "          "
    "          "],
   :i 82,
   :character "r",
   :width 10,
   :height 11},
  "s"
  {:bands
   ["          "
    "          "
    " $$$$$$$\\ "
    "$$  _____|"
    "\\$$$$$$\\  "
    " \\____$$\\ "
    "$$$$$$$  |"
    "\\_______/ "
    "          "
    "          "
    "          "],
   :i 83,
   :character "s",
   :width 10,
   :height 11},
  "t"
  {:bands
   ["  $$\\     "
    "  $$ |    "
    "$$$$$$\\   "
    "\\_$$  _|  "
    "  $$ |    "
    "  $$ |$$\\ "
    "  \\$$$$  |"
    "   \\____/ "
    "          "
    "          "
    "          "],
   :i 84,
   :character "t",
   :width 10,
   :height 11},
  "u"
  {:bands
   ["          "
    "          "
    "$$\\   $$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 85,
   :character "u",
   :width 10,
   :height 11},
  "v"
  {:bands
   ["           "
    "           "
    "$$\\    $$\\ "
    "\\$$\\  $$  |"
    " \\$$\\$$  / "
    "  \\$$$  /  "
    "   \\$  /   "
    "    \\_/    "
    "           "
    "           "
    "           "],
   :i 86,
   :character "v",
   :width 11,
   :height 11},
  "w"
  {:bands
   ["              "
    "              "
    "$$\\  $$\\  $$\\ "
    "$$ | $$ | $$ |"
    "$$ | $$ | $$ |"
    "$$ | $$ | $$ |"
    "\\$$$$$\\$$$$  |"
    " \\_____\\____/ "
    "              "
    "              "
    "              "],
   :i 87,
   :character "w",
   :width 14,
   :height 11},
  "x"
  {:bands
   ["          "
    "          "
    "$$\\   $$\\ "
    "\\$$\\ $$  |"
    " \\$$$$  / "
    " $$  $$<  "
    "$$  /\\$$\\ "
    "\\__/  \\__|"
    "          "
    "          "
    "          "],
   :i 88,
   :character "x",
   :width 10,
   :height 11},
  "y"
  {:bands
   ["          "
    "          "
    "$$\\   $$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$$ |"
    " \\____$$ |"
    "$$\\   $$ |"
    "\\$$$$$$  |"
    " \\______/ "],
   :i 89,
   :character "y",
   :width 10,
   :height 11},
  "z"
  {:bands
   ["          "
    "          "
    "$$$$$$$$\\ "
    "\\____$$  |"
    "  $$$$ _/ "
    " $$  _/   "
    "$$$$$$$$\\ "
    "\\________|"
    "          "
    "          "
    "          "],
   :i 90,
   :character "z",
   :width 10,
   :height 11},
  "{"
  {:bands
   ["  $$$\\ "
    " $$  _|"
    " $$ |  "
    "$$$ |  "
    "\\$$ |  "
    " $$ |  "
    " \\$$$\\ "
    "  \\___|"
    "       "
    "       "
    "       "],
   :i 91,
   :character "{",
   :width 7,
   :height 11},
  "|"
  {:bands
   ["$$\\ "
    "$$ |"
    "$$ |"
    "\\__|"
    "$$\\ "
    "$$ |"
    "$$ |"
    "\\__|"
    "    "
    "    "
    "    "],
   :i 92,
   :character "|",
   :width 4,
   :height 11},
  "}"
  {:bands
   ["$$$\\   "
    "\\_$$\\  "
    "  $$ | "
    "  $$$\\ "
    "  $$  |"
    "  $$ / "
    "$$$  | "
    "\\___/  "
    "       "
    "       "
    "       "],
   :i 93,
   :character "}",
   :width 7,
   :height 11},
  "~"
  {:bands
   [" $$$\\ $$\\ "
    "$$ $$\\$$ |"
    "$$ \\$$$  |"
    "\\__|\\___/ "
    "          "
    "          "
    "          "
    "          "
    "          "
    "          "
    "          "],
   :i 94,
   :character "~",
   :width 10,
   :height 11},
  "Ä"
  {:bands
   ["  $\\ $\\   "
    "  \\_|\\_|  "
    " $$$$$$\\  "
    " \\____$$\\ "
    " $$$$$$$ |"
    "$$  __$$ |"
    "\\$$$$$$$ |"
    " \\_______|"
    "          "
    "          "
    "          "],
   :i 95,
   :character "Ä",
   :width 10,
   :height 11},
  "Ö"
  {:bands
   ["  $\\ $\\   "
    "  \\_|\\_|  "
    " $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 96,
   :character "Ö",
   :width 10,
   :height 11},
  "Ü"
  {:bands
   ["  $\\ $\\   "
    "  \\_|\\_|  "
    "$$\\   $$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 97,
   :character "Ü",
   :width 10,
   :height 11},
  "ä"
  {:bands
   ["  $\\ $\\   "
    "  \\_|\\_|  "
    " $$$$$$\\  "
    " \\____$$\\ "
    " $$$$$$$ |"
    "$$  __$$ |"
    "\\$$$$$$$ |"
    " \\_______|"
    "          "
    "          "
    "          "],
   :i 98,
   :character "ä",
   :width 10,
   :height 11},
  "ö"
  {:bands
   ["  $\\ $\\   "
    "  \\_|\\_|  "
    " $$$$$$\\  "
    "$$  __$$\\ "
    "$$ /  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 99,
   :character "ö",
   :width 10,
   :height 11},
  "ü"
  {:bands
   ["  $\\ $\\   "
    "  \\_|\\_|  "
    "$$\\   $$\\ "
    "$$ |  $$ |"
    "$$ |  $$ |"
    "$$ |  $$ |"
    "\\$$$$$$  |"
    " \\______/ "
    "          "
    "          "
    "          "],
   :i 100,
   :character "ü",
   :width 10,
   :height 11},
  "ß"
  {:bands
   [" $$$$$$\\  "
    "$$  __$$\\ "
    "$$ |  $$ |"
    "$$ $$$$  |"
    "$$ \\__$$< "
    "$$ |  $$ |"
    "$$ $$$$  |"
    "$$ \\____/ "
    "$$ |      "
    "$$ |      "
    "\\__|      "],
   :i 101,
   :character "ß",
   :width 10,
   :height 11}}})