(ns bling.fonts.rounded)



;;   ______                            _             _
;;  (_____ \                          | |           | |
;;   _____) )  ___   _   _  ____    __| | _____   __| |
;;  |  __  /  / _ \ | | | ||  _ \  / _  || ___ | / _  |
;;  | |  \ \ | |_| || |_| || | | |( (_| || ____|( (_| |
;;  |_|   |_| \___/ |____/ |_| |_| \____||_____) \____|
;;  
;;   ______   _______  _     _  _______  ______   _______  ______
;;  (_____ \ (_______)(_)   (_)(_______)(______) (_______)(______)
;;   _____) ) _     _  _     _  _     _  _     _  _____    _     _
;;  |  __  / | |   | || |   | || |   | || |   | ||  ___)  | |   | |
;;  | |  \ \ | |___| || |___| || |   | || |__/ / | |_____ | |__/ /
;;  |_|   |_| \_____/  \_____/ |_|   |_||_____/  |_______)|_____/

(def rounded
'{:font-name "Rounded",
 :example
 [" ______                            _             _"
  "(_____ \\                          | |           | |"
  " _____) )  ___   _   _  ____    __| | _____   __| |"
  "|  __  /  / _ \\ | | | ||  _ \\  / _  || ___ | / _  |"
  "| |  \\ \\ | |_| || |_| || | | |( (_| || ____|( (_| |"
  "|_|   |_| \\___/ |____/ |_| |_| \\____||_____) \\____|"
  ""
  " ______   _______  _     _  _______  ______   _______  ______"
  "(_____ \\ (_______)(_)   (_)(_______)(______) (_______)(______)"
  " _____) ) _     _  _     _  _     _  _     _  _____    _     _"
  "|  __  / | |   | || |   | || |   | || |   | ||  ___)  | |   | |"
  "| |  \\ \\ | |___| || |___| || |   | || |__/ / | |_____ | |__/ /"
  "|_|   |_| \\_____/  \\_____/ |_|   |_||_____/  |_______)|_____/"],
 :desc
 "Rounded by Nick Miners N.M.Miners@durham.ac.uk\n        May 1994",
 :example-text "Rounded",
 :font-sym rounded,
 :widest-char "#",
 :char-height 7,
 :max-char-width 9,
 :missing-chars [],
 :chars-array-map
 {" "
  {:bands ["    " "    " "    " "    " "    " "    " "    "],
   :i 0,
   :character " ",
   :width 4,
   :height 7},
  "!"
  {:bands [" _ " "| |" "| |" "|_|" " _ " "|_|" "   "],
   :i 1,
   :character "!",
   :width 3,
   :height 7},
  "\""
  {:bands
   [" _  _ " "( )( )" "|/  \\|" "      " "      " "      " "      "],
   :i 2,
   :character "\"",
   :width 6,
   :height 7},
  "#"
  {:bands
   ["   _ _   "
    " _| U |_ "
    "(_     _)"
    " _| O |_ "
    "(_     _)"
    "  |_n_|  "
    "         "],
   :i 3,
   :character "#",
   :width 9,
   :height 7},
  "$"
  {:bands
   ["   _   "
    " _| |_ "
    "|  ___)"
    "|___  |"
    "(_   _|"
    "  |_|  "
    "       "],
   :i 4,
   :character "$",
   :width 7,
   :height 7},
  "%"
  {:bands
   [" _   _ "
    "(_) | |"
    "   / / "
    "  / /  "
    " / / _ "
    "|_| (_)"
    "       "],
   :i 5,
   :character "%",
   :width 7,
   :height 7},
  "&"
  {:bands
   ["  ___   "
    " / _ \\  "
    "( (_) ) "
    " ) _ (  "
    "( (/  \\ "
    " \\__/\\_)"
    "        "],
   :i 6,
   :character "&",
   :width 8,
   :height 7},
  "'"
  {:bands [" _ " "( )" "|/ " "   " "   " "   " "   "],
   :i 7,
   :character "'",
   :width 3,
   :height 7},
  "("
  {:bands ["  _ " " / )" "| | " "| | " "| | " " \\_)" "    "],
   :i 8,
   :character "(",
   :width 4,
   :height 7},
  ")"
  {:bands [" _  " "( \\ " " | |" " | |" " | |" "(_/ " "    "],
   :i 9,
   :character ")",
   :width 4,
   :height 7},
  "*"
  {:bands
   ["    _    "
    " _ | | _ "
    "( \\| |/ )"
    " )     ( "
    "(_/| |\\_)"
    "   |_|   "
    "         "],
   :i 10,
   :character "*",
   :width 9,
   :height 7},
  "+"
  {:bands
   ["       "
    "   _   "
    " _| |_ "
    "(_   _)"
    "  |_|  "
    "       "
    "       "],
   :i 11,
   :character "+",
   :width 7,
   :height 7},
  ","
  {:bands ["   " "   " "   " "   " " _ " "( )" "|/ "],
   :i 12,
   :character ",",
   :width 3,
   :height 7},
  "-"
  {:bands
   ["       "
    "       "
    " _____ "
    "(_____)"
    "       "
    "       "
    "       "],
   :i 13,
   :character "-",
   :width 7,
   :height 7},
  "."
  {:bands ["   " "   " "   " "   " " _ " "(_)" "   "],
   :i 14,
   :character ".",
   :width 3,
   :height 7},
  "/"
  {:bands
   ["     _ "
    "    | |"
    "   / / "
    "  / /  "
    " / /   "
    "|_|    "
    "       "],
   :i 15,
   :character "/",
   :width 7,
   :height 7},
  "0"
  {:bands
   ["  _____  "
    " (_____) "
    " _  __ _ "
    "| |/ /| |"
    "|   /_| |"
    " \\_____/ "
    "         "],
   :i 16,
   :character "0",
   :width 9,
   :height 7},
  "1"
  {:bands
   ["  ___   "
    " (___)  "
    "    _   "
    "   | |  "
    "  _| |_ "
    " (_____)"
    "        "],
   :i 17,
   :character "1",
   :width 8,
   :height 7},
  "2"
  {:bands
   [" ______  "
    "(_____ \\ "
    "  ____) )"
    " / ____/ "
    "| (_____ "
    "|_______)"
    "         "],
   :i 18,
   :character "2",
   :width 9,
   :height 7},
  "3"
  {:bands
   [" ______  "
    "(_____ \\ "
    " _____) )"
    "(_____ ( "
    " _____) )"
    "(______/ "
    "         "],
   :i 19,
   :character "3",
   :width 9,
   :height 7},
  "4"
  {:bands
   [" _     _ "
    "| |   (_)"
    "| |_____ "
    "|_____  |"
    "      | |"
    "      |_|"
    "         "],
   :i 20,
   :character "4",
   :width 9,
   :height 7},
  "5"
  {:bands
   [" _______ "
    "(_______)"
    " ______  "
    "(_____ \\ "
    " _____) )"
    "(______/ "
    "         "],
   :i 21,
   :character "5",
   :width 9,
   :height 7},
  "6"
  {:bands
   [" _______ "
    "(_______)"
    " ______  "
    "|  ___ \\ "
    "| |___) )"
    "|______/ "
    "         "],
   :i 22,
   :character "6",
   :width 9,
   :height 7},
  "7"
  {:bands
   [" _______ "
    "(_______)"
    "      _  "
    "     / ) "
    "    / /  "
    "   (_/   "
    "         "],
   :i 23,
   :character "7",
   :width 9,
   :height 7},
  "8"
  {:bands
   ["  _____  "
    " (_____) "
    "  _____  "
    " / ___ \\ "
    "( (___) )"
    " \\_____/ "
    "         "],
   :i 24,
   :character "8",
   :width 9,
   :height 7},
  "9"
  {:bands
   [" _______ "
    "(_______)"
    " _______ "
    "(_____  |"
    "      | |"
    "      |_|"
    "         "],
   :i 25,
   :character "9",
   :width 9,
   :height 7},
  ":"
  {:bands ["   " "   " " _ " "(_)" " _ " "(_)" "   "],
   :i 26,
   :character ":",
   :width 3,
   :height 7},
  ";"
  {:bands ["   " "   " " _ " "(_)" " _ " "( )" "|/ "],
   :i 27,
   :character ";",
   :width 3,
   :height 7},
  "<"
  {:bands ["    " "  _ " " / )" "( ( " " \\_)" "    " "    "],
   :i 28,
   :character "<",
   :width 4,
   :height 7},
  "="
  {:bands
   ["       "
    " _____ "
    "(_____)"
    " _____ "
    "(_____)"
    "       "
    "       "],
   :i 29,
   :character "=",
   :width 7,
   :height 7},
  ">"
  {:bands ["    " " _  " "( \\ " " ) )" "(_/ " "    " "    "],
   :i 30,
   :character ">",
   :width 4,
   :height 7},
  "?"
  {:bands
   ["  ___  "
    " / _ \\ "
    "(_( ) )"
    "   (_/ "
    "   _   "
    "  (_)  "
    "       "],
   :i 31,
   :character "?",
   :width 7,
   :height 7},
  "@"
  {:bands
   ["  _____  "
    " / __  \\ "
    "| | /   )"
    "| | \\__/ "
    "| |____  "
    " \\_____) "
    "         "],
   :i 32,
   :character "@",
   :width 9,
   :height 7},
  "A"
  {:bands
   [" _______ "
    "(_______)"
    " _______ "
    "|  ___  |"
    "| |   | |"
    "|_|   |_|"
    "         "],
   :i 33,
   :character "A",
   :width 9,
   :height 7},
  "B"
  {:bands
   [" ______  "
    "(____  \\ "
    " ____)  )"
    "|  __  ( "
    "| |__)  )"
    "|______/ "
    "         "],
   :i 34,
   :character "B",
   :width 9,
   :height 7},
  "C"
  {:bands
   [" _______ "
    "(_______)"
    " _       "
    "| |      "
    "| |_____ "
    " \\______)"
    "         "],
   :i 35,
   :character "C",
   :width 9,
   :height 7},
  "D"
  {:bands
   [" ______  "
    "(______) "
    " _     _ "
    "| |   | |"
    "| |__/ / "
    "|_____/  "
    "         "],
   :i 36,
   :character "D",
   :width 9,
   :height 7},
  "E"
  {:bands
   [" _______ "
    "(_______)"
    " _____   "
    "|  ___)  "
    "| |_____ "
    "|_______)"
    "         "],
   :i 37,
   :character "E",
   :width 9,
   :height 7},
  "F"
  {:bands
   [" _______ "
    "(_______)"
    " _____   "
    "|  ___)  "
    "| |      "
    "|_|      "
    "         "],
   :i 38,
   :character "F",
   :width 9,
   :height 7},
  "G"
  {:bands
   [" _______ "
    "(_______)"
    " _   ___ "
    "| | (_  |"
    "| |___) |"
    " \\_____/ "
    "         "],
   :i 39,
   :character "G",
   :width 9,
   :height 7},
  "H"
  {:bands
   [" _     _ "
    "(_)   (_)"
    " _______ "
    "|  ___  |"
    "| |   | |"
    "|_|   |_|"
    "         "],
   :i 40,
   :character "H",
   :width 9,
   :height 7},
  "I"
  {:bands [" _ " "| |" "| |" "| |" "| |" "|_|" "   "],
   :i 41,
   :character "I",
   :width 3,
   :height 7},
  "J"
  {:bands
   [" _______ "
    "(_______)"
    "     _   "
    " _  | |  "
    "| |_| |  "
    " \\___/   "
    "         "],
   :i 42,
   :character "J",
   :width 9,
   :height 7},
  "K"
  {:bands
   [" _     _ "
    "(_)   | |"
    " _____| |"
    "|  _   _)"
    "| |  \\ \\ "
    "|_|   \\_)"
    "         "],
   :i 43,
   :character "K",
   :width 9,
   :height 7},
  "L"
  {:bands
   [" _       "
    "(_)      "
    " _       "
    "| |      "
    "| |_____ "
    "|_______)"
    "         "],
   :i 44,
   :character "L",
   :width 9,
   :height 7},
  "M"
  {:bands
   [" _______ "
    "(_______)"
    " _  _  _ "
    "| ||_|| |"
    "| |   | |"
    "|_|   |_|"
    "         "],
   :i 45,
   :character "M",
   :width 9,
   :height 7},
  "N"
  {:bands
   [" _______ "
    "(_______)"
    " _     _ "
    "| |   | |"
    "| |   | |"
    "|_|   |_|"
    "         "],
   :i 46,
   :character "N",
   :width 9,
   :height 7},
  "O"
  {:bands
   [" _______ "
    "(_______)"
    " _     _ "
    "| |   | |"
    "| |___| |"
    " \\_____/ "
    "         "],
   :i 47,
   :character "O",
   :width 9,
   :height 7},
  "P"
  {:bands
   [" ______  "
    "(_____ \\ "
    " _____) )"
    "|  ____/ "
    "| |      "
    "|_|      "
    "         "],
   :i 48,
   :character "P",
   :width 9,
   :height 7},
  "Q"
  {:bands
   [" _______ "
    "(_______)"
    " _    _  "
    "| |  | | "
    "| |__| | "
    " \\______)"
    "         "],
   :i 49,
   :character "Q",
   :width 9,
   :height 7},
  "R"
  {:bands
   [" ______  "
    "(_____ \\ "
    " _____) )"
    "|  __  / "
    "| |  \\ \\ "
    "|_|   |_|"
    "         "],
   :i 50,
   :character "R",
   :width 9,
   :height 7},
  "S"
  {:bands
   ["  ______ "
    " / _____)"
    "( (____  "
    " \\____ \\ "
    " _____) )"
    "(______/ "
    "         "],
   :i 51,
   :character "S",
   :width 9,
   :height 7},
  "T"
  {:bands
   [" _______ "
    "(_______)"
    "    _    "
    "   | |   "
    "   | |   "
    "   |_|   "
    "         "],
   :i 52,
   :character "T",
   :width 9,
   :height 7},
  "U"
  {:bands
   [" _     _ "
    "(_)   (_)"
    " _     _ "
    "| |   | |"
    "| |___| |"
    " \\_____/ "
    "         "],
   :i 53,
   :character "U",
   :width 9,
   :height 7},
  "V"
  {:bands
   [" _     _ "
    "(_)   (_)"
    " _     _ "
    "| |   | |"
    " \\ \\ / / "
    "  \\___/  "
    "         "],
   :i 54,
   :character "V",
   :width 9,
   :height 7},
  "W"
  {:bands
   [" _  _  _ "
    "(_)(_)(_)"
    " _  _  _ "
    "| || || |"
    "| || || |"
    " \\_____/ "
    "         "],
   :i 55,
   :character "W",
   :width 9,
   :height 7},
  "X"
  {:bands
   [" _     _ "
    "(_)   (_)"
    "   ___   "
    "  |   |  "
    " / / \\ \\ "
    "|_|   |_|"
    "         "],
   :i 56,
   :character "X",
   :width 9,
   :height 7},
  "Y"
  {:bands
   [" _     _ "
    "| |   | |"
    "| |___| |"
    "|_____  |"
    " _____| |"
    "(_______|"
    "         "],
   :i 57,
   :character "Y",
   :width 9,
   :height 7},
  "Z"
  {:bands
   [" _______ "
    "(_______)"
    "   __    "
    "  / /    "
    " / /____ "
    "(_______)"
    "         "],
   :i 58,
   :character "Z",
   :width 9,
   :height 7},
  "["
  {:bands [" ___ " "|  _)" "| |  " "| |  " "| |_ " "|___)" "     "],
   :i 59,
   :character "[",
   :width 5,
   :height 7},
  "\\"
  {:bands
   [" _     "
    "| |    "
    " \\ \\   "
    "  \\ \\  "
    "   \\ \\ "
    "    |_|"
    "       "],
   :i 60,
   :character "\\",
   :width 7,
   :height 7},
  "]"
  {:bands [" ___ " "(_  |" "  | |" "  | |" " _| |" "(___|" "     "],
   :i 61,
   :character "]",
   :width 5,
   :height 7},
  "^"
  {:bands
   ["   __  "
    "  /  \\ "
    " (_/\\_)"
    "       "
    "       "
    "       "
    "       "],
   :i 62,
   :character "^",
   :width 7,
   :height 7},
  "_"
  {:bands
   ["         "
    "         "
    "         "
    "         "
    " _______ "
    "(_______)"
    "         "],
   :i 63,
   :character "_",
   :width 9,
   :height 7},
  "`"
  {:bands [" _ " "( )" " \\|" "   " "   " "   " "   "],
   :i 64,
   :character "`",
   :width 3,
   :height 7},
  "a"
  {:bands
   ["       "
    "       "
    " _____ "
    "(____ |"
    "/ ___ |"
    "\\_____|"
    "       "],
   :i 65,
   :character "a",
   :width 7,
   :height 7},
  "b"
  {:bands
   [" _     "
    "| |    "
    "| |__  "
    "|  _ \\ "
    "| |_) )"
    "|____/ "
    "       "],
   :i 66,
   :character "b",
   :width 7,
   :height 7},
  "c"
  {:bands
   ["       "
    "       "
    "  ____ "
    " / ___)"
    "( (___ "
    " \\____)"
    "       "],
   :i 67,
   :character "c",
   :width 7,
   :height 7},
  "d"
  {:bands
   ["     _ "
    "    | |"
    "  __| |"
    " / _  |"
    "( (_| |"
    " \\____|"
    "       "],
   :i 68,
   :character "d",
   :width 7,
   :height 7},
  "e"
  {:bands
   ["       "
    "       "
    " _____ "
    "| ___ |"
    "| ____|"
    "|_____)"
    "       "],
   :i 69,
   :character "e",
   :width 7,
   :height 7},
  "f"
  {:bands
   ["    ___ "
    "   / __)"
    " _| |__ "
    "(_   __)"
    "  | |   "
    "  |_|   "
    "        "],
   :i 70,
   :character "f",
   :width 8,
   :height 7},
  "g"
  {:bands
   ["       "
    "       "
    "  ____ "
    " / _  |"
    "( (_| |"
    " \\___ |"
    "(_____|"],
   :i 71,
   :character "g",
   :width 7,
   :height 7},
  "h"
  {:bands
   [" _     "
    "| |    "
    "| |__  "
    "|  _ \\ "
    "| | | |"
    "|_| |_|"
    "       "],
   :i 72,
   :character "h",
   :width 7,
   :height 7},
  "i"
  {:bands [" _ " "(_)" " _ " "| |" "| |" "|_|" "   "],
   :i 73,
   :character "i",
   :width 3,
   :height 7},
  "j"
  {:bands ["   _ " "  (_)" "   _ " "  | |" "  | |" " _| |" "(__/ "],
   :i 74,
   :character "j",
   :width 5,
   :height 7},
  "k"
  {:bands
   [" _     "
    "| |    "
    "| |  _ "
    "| |_/ )"
    "|  _ ( "
    "|_| \\_)"
    "       "],
   :i 75,
   :character "k",
   :width 7,
   :height 7},
  "l"
  {:bands [" _  " "| | " "| | " "| | " "| | " " \\_)" "    "],
   :i 76,
   :character "l",
   :width 4,
   :height 7},
  "m"
  {:bands
   ["       "
    "       "
    " ____  "
    "|    \\ "
    "| | | |"
    "|_|_|_|"
    "       "],
   :i 77,
   :character "m",
   :width 7,
   :height 7},
  "n"
  {:bands
   ["       "
    "       "
    " ____  "
    "|  _ \\ "
    "| | | |"
    "|_| |_|"
    "       "],
   :i 78,
   :character "n",
   :width 7,
   :height 7},
  "o"
  {:bands
   ["       "
    "       "
    "  ___  "
    " / _ \\ "
    "| |_| |"
    " \\___/ "
    "       "],
   :i 79,
   :character "o",
   :width 7,
   :height 7},
  "p"
  {:bands
   ["       "
    "       "
    " ____  "
    "|  _ \\ "
    "| |_| |"
    "|  __/ "
    "|_|    "],
   :i 80,
   :character "p",
   :width 7,
   :height 7},
  "q"
  {:bands
   ["       "
    "       "
    "  ____ "
    " / _  |"
    "| |_| |"
    " \\__  |"
    "    |_|"],
   :i 81,
   :character "q",
   :width 7,
   :height 7},
  "r"
  {:bands
   ["       "
    "       "
    "  ____ "
    " / ___)"
    "| |    "
    "|_|    "
    "       "],
   :i 82,
   :character "r",
   :width 7,
   :height 7},
  "s"
  {:bands
   ["      " "      " "  ___ " " /___)" "|___ |" "(___/ " "      "],
   :i 83,
   :character "s",
   :width 6,
   :height 7},
  "t"
  {:bands
   ["       "
    "   _   "
    " _| |_ "
    "(_   _)"
    "  | |_ "
    "   \\__)"
    "       "],
   :i 84,
   :character "t",
   :width 7,
   :height 7},
  "u"
  {:bands
   ["       "
    "       "
    " _   _ "
    "| | | |"
    "| |_| |"
    "|____/ "
    "       "],
   :i 85,
   :character "u",
   :width 7,
   :height 7},
  "v"
  {:bands
   ["       "
    "       "
    " _   _ "
    "| | | |"
    " \\ V / "
    "  \\_/  "
    "       "],
   :i 86,
   :character "v",
   :width 7,
   :height 7},
  "w"
  {:bands
   ["       "
    "       "
    " _ _ _ "
    "| | | |"
    "| | | |"
    " \\___/ "
    "       "],
   :i 87,
   :character "w",
   :width 7,
   :height 7},
  "x"
  {:bands
   ["       "
    "       "
    " _   _ "
    "( \\ / )"
    " ) X ( "
    "(_/ \\_)"
    "       "],
   :i 88,
   :character "x",
   :width 7,
   :height 7},
  "y"
  {:bands
   ["       "
    "       "
    " _   _ "
    "| | | |"
    "| |_| |"
    " \\__  |"
    "(____/ "],
   :i 89,
   :character "y",
   :width 7,
   :height 7},
  "z"
  {:bands
   ["       "
    "       "
    " _____ "
    "(___  )"
    " / __/ "
    "(_____)"
    "       "],
   :i 90,
   :character "z",
   :width 7,
   :height 7},
  "{"
  {:bands
   ["   __ " "  / _)" " | |  " "( (   " " | |_ " "  \\__)" "      "],
   :i 91,
   :character "{",
   :width 6,
   :height 7},
  "|"
  {:bands [" _ " "| |" "|_|" " _ " "| |" "|_|" "   "],
   :i 92,
   :character "|",
   :width 3,
   :height 7},
  "}"
  {:bands
   [" __   " "(_ \\  " "  | | " "   ) )" " _| | " "(__/  " "      "],
   :i 93,
   :character "}",
   :width 6,
   :height 7},
  "~"
  {:bands
   ["  __  _ "
    " /  \\/ )"
    "(_/\\__/ "
    "        "
    "        "
    "        "
    "        "],
   :i 94,
   :character "~",
   :width 8,
   :height 7},
  "Ä"
  {:bands
   [" _______ "
    "(_)___(_)"
    " _______ "
    "|  ___  |"
    "| |   | |"
    "|_|   |_|"
    "         "],
   :i 95,
   :character "Ä",
   :width 9,
   :height 7},
  "Ö"
  {:bands
   [" _______ "
    "(_)___(_)"
    " _     _ "
    "| |   | |"
    "| |___| |"
    " \\_____/ "
    "         "],
   :i 96,
   :character "Ö",
   :width 9,
   :height 7},
  "Ü"
  {:bands
   [" _     _ "
    "(_)   (_)"
    " _     _ "
    "| |   | |"
    "| |___| |"
    " \\_____/ "
    "         "],
   :i 97,
   :character "Ü",
   :width 9,
   :height 7},
  "ä"
  {:bands
   [" _   _ "
    "(_) (_)"
    " _____ "
    "(____ |"
    "/ ___ |"
    "\\_____|"
    "       "],
   :i 98,
   :character "ä",
   :width 7,
   :height 7},
  "ö"
  {:bands
   [" _   _ "
    "(_) (_)"
    "  ___  "
    " / _ \\ "
    "| |_| |"
    " \\___/ "
    "       "],
   :i 99,
   :character "ö",
   :width 7,
   :height 7},
  "ü"
  {:bands
   [" _   _ "
    "(_) (_)"
    " _   _ "
    "| | | |"
    "| |_| |"
    "|____/ "
    "       "],
   :i 100,
   :character "ü",
   :width 7,
   :height 7},
  "ß"
  {:bands
   ["  ___  "
    " / _ \\ "
    "| ( ) )"
    "| |( ( "
    "| | ) )"
    "|_|(_/ "
    "       "],
   :i 101,
   :character "ß",
   :width 7,
   :height 7}}})