(ns ^:no-doc noahtheduke.splint.rules.naming.conversion-functions
  (:require
    [noahtheduke.splint.rules :refer [defrule ->violation]]))

(defrule conversion-functions
  "Use `->` instead of `to` in the names of conversion functions.

  Examples:

  # bad
  (defn f-to-c ...)

  # good
  (defn f->c ...)
  "
  {:pattern '(defn ?f-name &&. args)
   :message "Use `->` instead of `to` in the names of conversion functions."
   :on-match (fn [rule form {:syms [?f-name]}]
               (let [new-form '()]
                 (->violation rule form {:replace-form new-form})))})
