//"markdown-it-internal-link": "1.0.4",

//
function wikiLinkPlugin(md, opts) {
  const parser = (state, silent) => {
    let regexp = /\[\[([^|\]\n]+)(\|([^\]\n]+))?\]\]/
    let match = regexp.exec(state.src.slice(state.pos))
    if (!match) return false
    state.pos += match[0].length
    let token = state.push("wikilink", '', 0)
    token.meta = {match: match}
    return true
  }
  md.inline.ruler.push("wikilink", parser)
}



// inspired by both:
// * https://github.com/rlidwka/markdown-it-regexp
// * https://gitlab.com/charlyisidore/markdown-it-internal-link
const internalLinkRegexp = /^\[\[([^\]\n]+)\]\]/
function internalLinkPlugin(md, opts) {
  const parser = (state, silent) => {
    if (silent) return true
    let match = internalLinkRegexp.exec(state.src.slice(state.pos))
    if (!match) return false
    const start = state.pos
    const max = state.posMax

    state.pos = start + 2
    state.posMax = state.pos + match[1].length

    let token = state.push("internal_link", '', 0)
    token.content = match[1]

    state.pos = start + match[0].length
    state.posMax = max
    return true
  }
  md.inline.ruler.push('internal-link-rule', parser)
}
MD.use(internalLinkPlugin)
