(ns plotly-pyclj.traces
  (:require
   #?(:cljs [plotly-pyclj.utils :refer-macros [reg-paths]]
      :clj  [plotly-pyclj.utils :refer (reg-paths)])
   [plotly-pyclj.schema :as schema]
   [clojure.string :as str]))

;; trace-attributes
(def subtree (schema/api-subtree (:traces schema/paths)))
(def symbol+paths
  (let [clean-fn-name
        #(-> % str (str/replace #"-attributes-|-layoutAttributes-" "-") symbol)]
    (->> (:traces schema/paths)
         schema/api-paths
         (filter #(or (= 1 (count %)) (some #{:attributes :layoutAttributes} %)))
         (schema/paths->symbol+paths [:traces])
         (reduce-kv (fn [m k v] (assoc m (clean-fn-name k) v)) (sorted-map)))))
(def help-path (schema/api-help subtree))
(defn help [f & ks] (apply help-path (drop 1 (f)) ks))

;; automatically generated by
;; (doseq [x (reg-paths (into (sorted-map) symbol+paths))]
;;   (println x))
