(ns missinterpret.storage.store.spec-runtime
  (:require [malli.generator :as mg]
            [missinterpret.storage.protocols.store :as prot.store]
            [missinterpret.storage.store.spec :as spec.store]
            [missinterpret.storage.store.spec-stores :as spec.stores]
            [missinterpret.storage.store.predicate-runtime :as pred.store-rt]))

;; Runtime Element ------------------------------------------------

(defn store [kind]
  ;; NOTE: Returns an id and info with passed kind which is sufficient for schema check
  (reify
    prot.store/Store
    (id [_] (mg/generate spec.stores/StoreId))
    (info [_] #:store.info{:version "0" :kind kind})
    (query [_ _] nil)
    (add! [_ _] nil)
    (remove! [_ _] nil)
    (availability! [_ _] nil)))

(def Store
  [:fn {:gen/return (store :general)} pred.store-rt/store?])

(def FlowStore
  [:fn {:gen/return (store :store.kind/flow)} pred.store-rt/flow-store?])

(def SyncStore
  [:fn {:gen/return (store :store.kind/synchronous)} pred.store-rt/sync-store?])

(def Element
  [:fn {:gen/return (mg/generate spec.store/Element)} pred.store-rt/element?])

