(ns missinterpret.storage.protocols.store)

(defprotocol Store

  (id [this]
   "Returns the id that was used to start the store instance")

  (info [this]
    "Returns the current configuration information of the store which
     control the behaviour of the implementation.")

  (query [this arguments]
    "Returns the requested items from the requested index.

     The default implementation returns a manifold stream of objects which match the
     request and conform to the appropriate protocol.")

  (add! [this arguments]
    "Adds items (content, storage block or both) to the store.")

  (remove! [this arguments]
    "Removes the items (content, storage block or both) from the store.")

  (availability! [this arguments]
    "Sets the availability of the content, storage block or both to the requested availability.

     Throws an anomaly if the requested availability is unsupported
     or fails to execute.

    The implementation may or may not support the optional argument `storage.store/query`"))

