(ns missinterpret.storage.protocols.provider)

(defprotocol ContentProvider

  (info [this]
    "General information about this content provider. Enumerates the potential
     accessibility or storage actions for the underlying storage block")

  (block [this]
    "Returns the storage block referencing the content")

  (available-sources [this]
    "The sources which are available to deliver content from this provider.")

  (content [this context]
    "Retrieves the content throwing an anomaly if not supported for a given storage block"))
