(ns missinterpret.storage.store.block.core
  (:require [clojure.pprint :refer [pprint]]
            [missinterpret.anomalies.anomaly :refer [throw+]]))

(defn valid-query-fn?
  "Throws an exception if the passed query function
   is not arity-1 and does not return a collection.

   Query functions take a coll and return a coll."
  [query-fn]
  (if (some? query-fn)
    (if (and (fn? query-fn) (coll? (query-fn [])))
      true
      (throw+
        {:from     ::valid-query-fn?
         :category :anomaly.category/error
         :message  {:readable "The query function is incorrect arity or does not return a collection."
                    :reasons  [:error/query-fn]
                    :data     {:arg1 query-fn}}}))
    false))






