(ns missinterpret.storage.block.spec
  (:require [missinterpret.storage.address.spec :refer [Address]]
            [missinterpret.storage.source.spec :refer [Source]]
            [missinterpret.storage.utils.file :as utils.file]))

(def BlockId
  [:map
   [:block.id/address   Address]
   [:block.id/arguments map?]])

(def BlockInfo
  [:map
   [:block.info/kind    keyword?]
   [:block.info/version string?]
   [:block.info/hash    keyword?]])

(def BlockData
  [:map {:closed true}
   [:block/metadata map?]
   [:block/content
    [:map
     [:content/address Address]
     [:content/sources [:set Source]]]]])


(def MemoryArgs
  [:map
   [:name                           some?]
   [:data                           some?]
   [:format                         keyword?]
   [:content-type  {:optional true} string?]
   [:ext           {:optional true} string?]
   [:metadata      {:optional true} map?]])

(def MemoryId
  [:map
   [:block.id/address   Address]
   [:block.id/arguments MemoryArgs]])


(def FileArgs
  [:map
   [:file                                    [:fn utils.file/exists?]]
   [:validate-path-address? {:optional true} boolean?]
   [:use-path-address?      {:optional true} boolean?]
   [:name                   {:optional true} some?]
   [:content-type           {:optional true} string?]
   [:metadata               {:optional true} map?]])

(def FileId
  [:map
   [:block.id/address   Address]
   [:block.id/arguments FileArgs]])


(def S3Args
  [:map
   [:bucket                                 string?]
   [:key                                    string?]
   [:client-configuration  {:optional true} map?]
   [:use-key-address?      {:optional true} boolean?]
   [:validate-key-address? {:optional true} boolean?]])

(def S3Id
  [:map
   [:block.id/address   Address]
   [:block.id/arguments S3Args]])

