(ns missinterpret.storage.provider.spec
  (:require [missinterpret.storage.utils.core :as core.utils]
            [missinterpret.storage.source.spec :as spec.source]
            [missinterpret.storage.block.predicate :as pred.block]))

(def ProviderArgs
  [:map
   [:storage/block                           [:fn pred.block/block?]]
   [:source/name            {:optional true} some?]
   [:throw-when-no-sources? {:optional true} boolean?]])

(def ProviderInfo
  [:map
   [:provider.info/kind some?]
   [:provider.info/version some?]])


(def ContentArgs
  [:map
   [:storage/source     {:optional true} spec.source/Source]
   [:source/name        {:optional true} some?]
   [:source.range/start {:optional true} integer?]
   [:source.range/end   {:optional true} integer?]])


(def Content
  [:map {:closed true}
   [:storage/source                         spec.source/Source]
   [:storage/input-stream {:optional true} [:fn core.utils/input-stream?]]
   [:storage/data         {:optional true} some?]])

