(ns missinterpret.storage.block.predicate
  (:require [clojure.pprint :refer [pprint]]
            [malli.core :as m]
            [clojure.string :as st]
            [missinterpret.storage.block.spec :as spec]
            [missinterpret.storage.utils.file :as utils.file]
            [missinterpret.storage.protocols.block :as prot.block]
            [missinterpret.storage.address.predicate :as pred.address]))

(defn id? [id]
  (m/validate spec/BlockId id))

(defn info? [info]
  (m/validate spec/BlockInfo info))

(defn data? [data]
  (m/validate spec/BlockData data))

(defn metadata? [metadata]
  (map? metadata))

(defn block? [blk]
  (try
    (if (nil? blk)
      false
      (let [b (if (and (map? blk) (contains? blk :storage/block))
                (:storage/block blk)
                blk)]
        (-> b prot.block/info info?)))
    (catch Exception _ false)))


;; Block Implementations ------------------------------------

(defn memory-args? [args]
  (m/validate spec/MemoryArgs args))

(defn memory-id? [id]
  (m/validate spec/MemoryId id))

(defn fs-args? [{:keys [file use-path-address?] :as args}]
  (and (m/validate spec/FileArgs args)
       (if (true? use-path-address?)
         (pred.address/valid-address-id? (utils.file/filename file))
         true)))

(defn fs-id? [id]
  (m/validate spec/FileId id))

(defn s3-args? [{:keys [key use-key-address?] :as args}]
  (and (m/validate spec/S3Args args)
       (if (true? use-key-address?)
         (pred.address/valid-address-id? (-> key (st/split #"\.") first))
         true)))

(defn s3-id? [id]
  (m/validate spec/S3Id id))

