(ns missinterpret.storage.store.predicate-runtime
  (:require [clojure.pprint :refer [pprint]]
            [malli.core :as m]
            [missinterpret.storage.store.spec-runtime :as spec.rt]
            [missinterpret.storage.protocols.store :as prot.store]))

;; Runtime ------------------------------------------------

(defn store-id? [id]
  (m/validate spec.rt/StoreId id))

(defn store? [store]
  (try
    (let [id (prot.store/id store)]
      (store-id? id))
    (catch Exception _ false)))

