(ns missinterpret.storage.source.predicate
  (:require [clojure.pprint :refer [pprint]]
            [malli.core :as m]
            [missinterpret.storage.utils.core :refer [uri?]]
            [missinterpret.storage.source.spec :refer [Source Memory]]))

(defn source? [source]
  (and (m/validate Source source)
       (or (uri? (:source/uri source))
           (some? (:source/context source)))
       (if (= :storage.provider.kind/memory (:source/kind source))
         (m/validate Memory (:source/context source))
         true)))

(defn are-sources? [sources]
  (every? (fn [s] (source? s)) sources))

