(ns missinterpret.mount-configuration.resource
  "Provides data by loading resource-config.edn from the resources of the runtime context"
  (:require [missinterpret.anomalies.anomaly :as anom]
            [mount.core :refer [defstate]]
            [missinterpret.edn-io.data-readers :as data-readers] ;; Required for tag literals during write
            [missinterpret.edn-io.edn :as edn]
            [missinterpret.mount-configuration.env :refer [env-config]]
            [clojure.java.io :as io]
            [mount.core :refer [defstate] :as mount]
            [clojure.pprint :refer [pprint]]))

;; Mount ----------------------------------------------------------
;;

(defn start [{:mount-configuration.resource/keys [path throw-if-missing] :as args}]
  (println "resource/start> args: " args)
  (let [rsrc (when (some? path) (io/resource path))]
    (cond
      (and (nil? rsrc) (true? throw-if-missing))
      (anom/throw+
        {:from     ::start
         :category :anomaly.category/fault
         :message  {:readable (str path " missing")
                    :data     {:path path}}})

      (nil? rsrc)
      {}

      :else
      (edn/read rsrc :throw-on-error true))))


(defstate resource-config
          :start (start (mount/args)))

