(ns missinterpret.flows.system.constructors
  "Constructors for entities. These only match schemas, the
  system namespaces are user-facing and perform more extensive runtime
  validation."
  (:require [missinterpret.anomalies.anomaly :refer [throw+]]
            [missinterpret.flows.predicates :refer []]
            [missinterpret.flows.utils :refer [either]]))

(defn flows-definition
  ([]
   (flows-definition #{}))
  ([wf-definitions]
   (flows-definition wf-definitions #{}))
  ([wf-definitions flow-definitions]
   (flows-definition wf-definitions flow-definitions {}))
  ([wf-definitions flow-definitions args]
   (flows-definition wf-definitions flow-definitions args #{}))
  ([wf-definitions flow-definitions args routes]
   {:flows.flow.catalog/definitions (either flow-definitions #{})
    :flows.workflow.catalog/definitions (either wf-definitions #{})
    :flows.workflow.catalog/args (either args {})
    :flows.pedestal/routes (either routes #{})}))

