(ns missinterpret.flows.system.catalog.schema
  (:require [clojure.pprint :refer [pprint]]
            [missinterpret.flows.macros :refer [defn*]]
            [missinterpret.flows.predicates :as pred.flows]
            [missinterpret.flows.schema :as schema.flows]
            [missinterpret.flows.system.catalog.core :as core.catalog]))

(defn* lookup-io
  ([id]
   (lookup-io id nil))
  ([id n]
   "Returns the io schema of a flow entity in the catalogs.
    nil if there is no match by id or the entity does not have
    an io schema.

    When n is > 0, and the entity is a workflow, it returns
    the io schema of the nth entity in its definition."
   (let [entity (core.catalog/lookup id)]
     (when (some? entity)
       (if (or (pred.flows/flow? entity)
               (and (pred.flows/workflow? entity) (nil? n)))
         (schema.flows/io entity)
         (-> (nth (:workflow/definition entity) n)
             schema.flows/io))))))

(defn* wf-integrity
  [id]
  (let [entity (core.catalog/lookup id)]
    (when (pred.flows/workflow? entity)
      (schema.flows/extract-integrity entity))))



