(ns missinterpret.flows.system.catalog.core
  (:require [clojure.pprint :refer [pprint]]
            [missinterpret.anomalies.anomaly :refer [throw+]]
            [missinterpret.flows.predicates :as pred.flows]
            [missinterpret.flows.system.catalog.flow :as catalog.flow]
            [missinterpret.flows.system.catalog.workflow :as catalog.workflow]
            [missinterpret.flows.utils :refer [opts]]))

(defn catalog []
  (merge (catalog.flow/catalog)
         (catalog.workflow/catalog)))

(defn ids []
  (clojure.set/union (catalog.flow/ids) (catalog.workflow/ids)))

(defn lookup [id & {:keys [throw-missing] :as op}]
  (let [f (catalog.flow/lookup id)
        wf (catalog.workflow/lookup id)]
    (if (and (nil? f) (nil? wf) (-> (opts op) :throw-missing true?))
      (throw+
        {:from     ::lookup
         :category :anomaly.category/invalid
         :message  {:readable (str id  " not in catalog")
                    :reasons  [:invalid/id]
                    :data     {:id id :opts op}}})
      (or f wf))))

(defn lookup-in [id path & {:keys [throw-missing] :as op}]
  (let [f (catalog.flow/lookup-in id path)
        wf (catalog.workflow/lookup-in id path)]
    (if (and (nil? f) (nil? wf) (-> (opts op) :throw-missing true?))
      (throw+
        {:from     ::lookup-in
         :category :anomaly.category/invalid
         :message  {:readable (str id  " not in catalog")
                    :reasons  [:invalid/id]
                    :data     {:id id :path path :opts op}}})
      (or f wf))))

(defn add! [entity & {:keys [insert] :as op}]
  (or (when (pred.flows/flow? entity) (catalog.flow/add! entity op))
      (when (pred.flows/workflow? entity) (catalog.workflow/add! entity op))))

(defn remove! [id]
  (or (catalog.flow/remove! id))
      (catalog.workflow/remove! id))




