(ns missinterpret.flows.spec
  (:require [manifold.stream :as s]
            [malli.core :as m]
            [malli.util :as mu]))

;; Utils ---------------------------------------------------------

(def Options
  [:*
   [:catn [:prop keyword?] [:value any?]]])


;; Core Entities -------------------------------------------------

(def FlowBase
  [:map
   [:flow/id keyword?]
   [:flow/fn fn?]])

(def FlowOpts
  [:map
   [:flow/default-fn {:optional true} fn?]
   [:flow/leave-fn   {:optional true} fn?]])

(def Flow
  (mu/union
    (mu/required-keys FlowBase)
    (mu/optional-keys FlowOpts)))

(def WorkflowBase
  [:map
   [:workflow/id          keyword?]
   [:workflow/definition  sequential?]])

(def WorkflowOpts
  [:map
   [:workflow/return-n       integer?]
   [:workflow/put-timeout    integer?]
   [:workflow/take-timeout   integer?]
   [:workflow/return-error   boolean?]
   [:workflow/args           map?]
   [:workflow/default-fn     fn?]
   [:workflow/order          keyword?]
   [:workflow/expand         boolean?]
   [:workflow/repeat         boolean?]
   [:workflow/defer-load     boolean?]
   [:workflow/lazy-load      boolean?]
   [:workflow/new            boolean?]
   [:workflow/force          boolean?]
   [:workflow/source         [:fn s/stream?]]
   [:workflow/sink           [:fn s/stream?]]
   [:workflow/invalid        [:sequential keyword?]]])


(def Workflow
  (mu/union
    (mu/required-keys
      WorkflowBase)
    (mu/optional-keys
      WorkflowOpts)))


(def Workflow-Factory-Success
  [:map
   [:workflow/source [:fn s/stream?]]
   [:workflow/sink   [:fn s/stream?]]])

(def Workflow-Factory-Failed
  [:map
   [:workflow/invalid [:sequential any?]]])


;; Flows Entities -------------------------------------------------

(def FlowDefinitions [:set Flow])
(def WorkflowDefinitions [:set Workflow])

(def FlowsDefinition
  [:map
   [:flows.flow.catalog/definitions     FlowDefinitions]
   [:flows.workflow.catalog/definitions WorkflowDefinitions]
   [:flows.workflow.catalog/args        {:optional true} map?]
   [:flows.pedestal/routes              {:optional true} [:set fn?]]])


(def FlowCatalog
  [:map-of :keyword Flow])
(def WorkflowCatalog
  [:map-of :keyword Workflow])

(def SystemCatalog
  [:map
   [:flow.catalog/loaded     FlowCatalog]
   [:workflow.catalog/loaded WorkflowCatalog]])


