(ns missinterpret.flows.predicates
  (:require [manifold.stream :as s]
            [malli.core :as m]
            [missinterpret.flows.spec :as spec]
            [missinterpret.flows.utils :refer [extract]]))

;; Flow ----------------------------------------------------

(defn flow? [arg]
  (m/validate spec/Flow arg))

(defn flow= [f1 f2]
  (= (extract f1 spec/Flow)
     (extract f2 spec/Flow)))

(defn flow-fn?
  "Does this flow's fn return a sink when passed the arguments?"
  [{:keys [:flow/fn] :as flow} args]
  (try
    (let [flow-fn (:flow/fn flow)
          sink (flow-fn args (s/stream))]
      (and (some? sink) (s/stream? sink) (s/sink? sink)))
    (catch Exception _ false)))


;; Workflow -----------------------------------------------

(defn factory-result? [wf]
  (or (m/validate spec/Workflow-Factory-Success wf)
      (m/validate spec/Workflow-Factory-Failed wf)))

(defn workflow-loaded? [wf]
  (m/validate spec/Workflow-Factory-Success wf))

(defn workflow-unloaded? [wf]
  (not (workflow-loaded? wf)))

(defn workflow-factory-failed? [wf]
  (m/validate spec/Workflow-Factory-Failed wf))


(defn workflow? [wf]
  (m/validate spec/Workflow wf))

(defn workflow= [wf1 wf2]
  (= (extract wf1 spec/Workflow)
     (extract wf2 spec/Workflow)))


;; Catalogs & Definitions -------------------------------------

(defn flow-catalog? [c]
  (m/validate spec/FlowCatalog c))

(defn workflow-catalog? [c]
  (m/validate spec/WorkflowCatalog c))

(defn flows-definition? [c]
  (m/validate spec/FlowsDefinition c))

(defn system-catalog? [c]
  (m/validate spec/SystemCatalog c))

