(ns missinterpret.edn-io.data-readers
  (:require [clojure.java.io :as io]
            [time-literals.read-write :as literals])
  (:import (java.io Writer File)
           (java.net URI URL)))

;; Write ---------------------------------------------------

(defn- print-to-string [t o]
  (str "#" t " \"" (str o) "\""))

(def print-file (partial print-to-string "file"))
(def print-uri (partial print-to-string "uri"))
(def print-url (partial print-to-string "url"))

(defmethod print-method File [c ^Writer w] (.write w ^String (print-file c)))
(defmethod print-method URI [c ^Writer w] (.write w ^String (print-uri c)))
(defmethod print-method URL [c ^Writer w] (.write w ^String (print-url c)))

;; Reader -------------------------------------------------

(defn tag-file [p] (io/file p))
(defn tag-uri [u] (URI. u))
(defn tag-url [u] (URL. u))

(def tags
  (merge
    literals/tags
    {'file tag-file
     'uri tag-uri
     'url tag-url}))

