(ns representations.validate
  (:require
   [clj-yaml.core :as yaml]
   [clojure.string :as str]
   [representations.read :as read]))

(defn normalize-keys
  [m]
  (cond
    (map? m)
    (into {} (map (fn [[k v]]
                    [(if (keyword? k)
                       (keyword (str/lower-case (name k)))
                       k)
                     (normalize-keys v)])
                  m))

    (sequential? m)
    (mapv normalize-keys m)

    :else m))

(defn validate-file
  [path]
  (let [content (slurp path)
        data (-> content yaml/parse-string normalize-keys)
        result (read/parse data)]
    {:valid? true
     :path path
     :data result}))

(defn validate-files
  [paths]
  (doseq [path paths]
    (try
      (validate-file path)
      (println "✓" path)
      (catch Exception e
        (println "✗" path)
        (println "  Error:" (ex-message e))
        (when-let [data (ex-data e)]
          (println "  Details:" (pr-str data)))))))
