(ns representations.schema.v0.transform
  (:require
   [representations.read.impl :as read-impl]
   [representations.util.malli.registry :as mr]
   [representations.util.malli.common :as mc]
   [representations.schema.representation :as representation]
   [representations.schema.v0.common :as common]))

(mr/def ::target-table
  [:and
   {:description "Name of the destination table"}
   ::mc/non-blank-string])

(mr/def ::target-schema
  [:and
   {:description "Database schema for the target table (e.g., 'public', 'reporting')"}
   ::mc/non-blank-string])

(mr/def ::tags
  [:sequential
   {:description "Optional tags for categorizing and organizing transforms"}
   ::mc/non-blank-string])

(mr/def ::source
  [:map
   {:closed true
    :description "Source for the transform - either a SQL query or MBQL query"}
   [:query {:optional true} ::common/query]])

(mr/def ::target
  [:map
   {:closed true
    :description "Target table configuration for the transform output"}
   [:table ::target-table]
   [:schema {:optional true} ::target-schema]])

(mr/def ::transform
  [:and
   [:merge
    ::representation/representation
    [:map
     {:closed true
      :description "v0 schema for human-writable transform representation"}
     [:display_name {:optional true} ::common/display-name]
     [:description {:optional true} ::common/description]
     [:database ::common/database]
     [:source {:optional true} ::source]
     [:target {:optional true} ::target]
     [:target_table {:optional true} ::target]
     [:query ::common/query]
     [:tags {:optional true} ::tags]]]])

(defmethod read-impl/representation->schema [:v0 :transform] [_] ::transform)
