(ns representations.schema.v0.timeline-event
  (:require
   [representations.util.malli.common :as mc]
   [representations.util.malli.registry :as mr]))

(mr/def ::name
  [:and
   {:description "Name of the timeline event"}
   ::mc/non-blank-string])

(mr/def ::description
  [:and
   {:description "Optional description of the timeline event"}
   [:or :nil :string]])

(mr/def ::timestamp
  [:and
   {:description "Timestamp when the event occurs"}
   :string])

(mr/def ::time-matters
  [:and
   {:description "Whether the specific time is important (true) or just the date (false)"}
   :boolean])

(mr/def ::timezone
  [:and
   {:description "Timezone for the event timestamp"}
   ::mc/non-blank-string])

(mr/def ::icon
  [:and
   {:description "Icon identifier for the event"}
   ::mc/non-blank-string])

(mr/def ::archived
  [:and
   {:description "Whether the event is archived"}
   :boolean])

(mr/def ::timeline-event
  [:map
   {:closed true
    :description "v0 schema for timeline event"}
   [:name ::name]
   [:description {:optional true} ::description]
   [:timestamp ::timestamp]
   [:time_matters ::time-matters]
   [:timezone ::timezone]
   [:icon ::icon]
   [:archived {:optional true} ::archived]])
