(ns representations.schema.v0.timeline
  (:require
   [representations.read.impl :as read-impl]
   [representations.schema.representation :as representation]
   [representations.schema.v0.timeline-event :as timeline-event]
   [representations.util.malli.common :as mc]
   [representations.util.malli.registry :as mr]))

(mr/def ::display-name
  [:and
   {:description "Human-readable name for the timeline"}
   ::mc/non-blank-string])

(mr/def ::description
  [:and
   {:description "Optional description of the timeline"}
   [:or :nil :string]])

(mr/def ::icon
  [:and
   {:description "Icon identifier for the timeline"}
   ::mc/non-blank-string])

(mr/def ::default
  [:and
   {:description "Whether this is a default timeline"}
   :boolean])

(mr/def ::archived
  [:and
   {:description "Whether the timeline is archived"}
   :boolean])

(mr/def ::events
  [:and
   {:description "Timeline events associated with this timeline"}
   [:sequential ::timeline-event/timeline-event]])

(mr/def ::timeline
  [:and
   [:merge
    ::representation/representation
    [:map
     {:closed true
      :description "v0 schema for human-writable timeline representation"}
     [:display_name ::display-name]
     [:description {:optional true} ::description]
     [:icon ::icon]
     [:default {:optional true} ::default]
     [:archived {:optional true} ::archived]
     [:events {:optional true} ::events]]]])

(defmethod read-impl/representation->schema [:v0 :timeline] [_] ::timeline)
