(ns representations.read
  (:require
   [representations.read.impl :as read-impl]
   [representations.schema.representation :as representation]
   [representations.util.malli :as mu]
   [representations.v0.init]))

(defn- mark-parsed
  [m]
  (with-meta m {::is-parsed true}))

(defn parsed?
  [m]
  (-> m meta ::is-parsed))

(defn parse
  "Ensures type is set correctly and de-encodes base64 if necessary."
  [representation]
  (let [coerced (mu/coerce ::representation/representation representation)
        schema (read-impl/representation->schema coerced)]
    (mark-parsed
     (mu/coerce schema coerced))))
