package intoclj;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;

import java.util.HashMap;
import java.util.Stack;
import java.util.stream.Collectors;

public class JavaFileReader {
    public static HashMap<String, TypeDeclaration> getDeclarationsInSource(String code) {
        var result = new HashMap<String, TypeDeclaration>();
        var parseResult = new JavaParser(new ParserConfiguration())
          .parse(code).getResult().orElseThrow();
        var classStack = new Stack<TypeDeclaration>();
        new VoidVisitorAdapter<>() {
            @Override
            public void visit(AnnotationDeclaration n, Object arg) {
                visitType(n);
                super.visit(n, arg);
                classStack.pop();
            }
            @Override
            public void visit(EnumDeclaration n, Object arg) {
                visitType(n);
                super.visit(n, arg);
                classStack.pop();
            }
            @Override
            public void visit(ClassOrInterfaceDeclaration n, Object arg) {
                visitType(n);
                super.visit(n, arg);
                classStack.pop();
            }
            private void visitType(TypeDeclaration t) {
                classStack.push(t);
                var className = classStack.stream()
                  .map(c -> c.getName().toString())
                  .collect(Collectors.joining("$"));
                result.put(className, t);
            }
        }.visit(parseResult, null);
        return result;
    }
}
