(clojure.core/ns intoclj.interop.java)

(clojure.core/defn
 File:createTempFile
 "-- (String prefix, String suffix) -> File\nCreates an empty file in the default temporary-file directory, using the given prefix and suffix to generate its name. Invoking this method is equivalent to invoking {@link #createTempFile(java.lang.String, java.lang.String, java.io.File) createTempFile(prefix,&nbsp;suffix,&nbsp;null)} .  <p> The {@link java.nio.file.Files#createTempFile(String,String,java.nio.file.attribute.FileAttribute[]) Files.createTempFile} method provides an alternative method to create an empty file in the temporary-file directory. Files created by that method may have more restrictive access permissions to files created by this method and so may be more suited to security-sensitive applications.\n- param prefix: The prefix string to be used in generating the file's name; must be at least three characters long\n- param suffix: The suffix string to be used in generating the file's name; may be {@code null} , in which case the suffix {@code \".tmp\"} will be used\n- return: An abstract pathname denoting a newly-created empty file\n- throws IllegalArgumentException: If the {@code prefix} argument contains fewer than three characters\n- throws IOException: If a file could not be created\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method does not allow a file to be created\n- since: 1.2\n- see: java.nio.file.Files#createTempDirectory(String,FileAttribute[])\n-- (String prefix, String suffix, File directory) -> File\n<p> Creates a new empty file in the specified directory, using the given prefix and suffix strings to generate its name.  If this method returns successfully then it is guaranteed that:  <ol> <li> The file denoted by the returned abstract pathname did not exist before this method was invoked, and <li> Neither this method nor any of its variants will return the same abstract pathname again in the current invocation of the virtual machine. </ol>  This method provides only part of a temporary-file facility.  To arrange for a file created by this method to be deleted automatically, use the {@link #deleteOnExit} method.  <p> The {@code prefix} argument must be at least three characters long.  It is recommended that the prefix be a short, meaningful string such as {@code \"hjb\"} or {@code \"mail\"} .  The {@code suffix} argument may be {@code null} , in which case the suffix {@code \".tmp\"} will be used.  <p> To create the new file, the prefix and the suffix may first be adjusted to fit the limitations of the underlying platform.  If the prefix is too long then it will be truncated, but its first three characters will always be preserved.  If the suffix is too long then it too will be truncated, but if it begins with a period character ( {@code '.'} ) then the period and the first three characters following it will always be preserved.  Once these adjustments have been made the name of the new file will be generated by concatenating the prefix, five or more internally-generated characters, and the suffix.  <p> If the {@code directory} argument is {@code null} then the system-dependent default temporary-file directory will be used.  The default temporary-file directory is specified by the system property {@code java.io.tmpdir} .  On UNIX systems the default value of this property is typically {@code \"/tmp\"} or {@code \"/var/tmp\"} ; on Microsoft Windows systems it is typically {@code \"C:\\\\WINNT\\\\TEMP\"} .  A different value may be given to this system property when the Java virtual machine is invoked, but programmatic changes to this property are not guaranteed to have any effect upon the temporary directory used by this method.\n- param prefix: The prefix string to be used in generating the file's name; must be at least three characters long\n- param suffix: The suffix string to be used in generating the file's name; may be {@code null} , in which case the suffix {@code \".tmp\"} will be used\n- param directory: The directory in which the file is to be created, or  {@code null} if the default temporary-file directory is to be used\n- return: An abstract pathname denoting a newly-created empty file\n- throws IllegalArgumentException: If the {@code prefix} argument contains fewer than three characters\n- throws IOException: If a file could not be created\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method does not allow a file to be created\n- since: 1.2"
 ([prefix suffix]
  (java.io.File/createTempFile
   ^"java.lang.String" prefix
   ^"java.lang.String" suffix))
 ([prefix suffix directory]
  (java.io.File/createTempFile
   ^"java.lang.String" prefix
   ^"java.lang.String" suffix
   ^"java.io.File" directory)))

(clojure.core/defn
 File:lastModified
 "-- () -> long\nReturns the time that the file denoted by this abstract pathname was last modified.\n- apiNote: While the unit of time of the return value is milliseconds, the granularity of the value depends on the underlying file system and may be larger.  For example, some file systems use time stamps in units of seconds.  <p> Where it is required to distinguish an I/O exception from the case where {@code 0L} is returned, or where several attributes of the same file are required at the same time, or where the time of last access or the creation time are required, then the {@link java.nio.file.Files#readAttributes(Path,Class,LinkOption[]) Files.readAttributes} method may be used.  If however only the time of last modification is required, then the {@link java.nio.file.Files#getLastModifiedTime(Path,LinkOption[]) Files.getLastModifiedTime} method may be used instead.\n- return: A {@code long} value representing the time the file was last modified, measured in milliseconds since the epoch (00:00:00 GMT, January 1, 1970), or {@code 0L} if the file does not exist or if an I/O error occurs.  The value may be negative indicating the number of milliseconds before the epoch\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkRead(java.lang.String)}  method denies read access to the file"
 ([this] (.lastModified ^"java.io.File" this)))

(clojure.core/defn
 File:isFile
 "-- () -> boolean\nTests whether the file denoted by this abstract pathname is a normal file.  A file is <em>normal</em> if it is not a directory and, in addition, satisfies other system-dependent criteria.  Any non-directory file created by a Java application is guaranteed to be a normal file.  <p> Where it is required to distinguish an I/O exception from the case that the file is not a normal file, or where several attributes of the same file are required at the same time, then the {@link java.nio.file.Files#readAttributes(Path,Class,LinkOption[]) Files.readAttributes} method may be used.\n- return: {@code true} if and only if the file denoted by this abstract pathname exists <em>and</em> is a normal file;  {@code false} otherwise\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkRead(java.lang.String)}  method denies read access to the file"
 ([this] (.isFile ^"java.io.File" this)))

(clojure.core/defn
 File:setReadOnly
 "-- () -> boolean\nMarks the file or directory named by this abstract pathname so that only read operations are allowed. After invoking this method the file or directory will not change until it is either deleted or marked to allow write access. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to modify files that are marked read-only. Whether or not a read-only file or directory may be deleted depends upon the underlying system.\n- return: {@code true} if and only if the operation succeeded;  {@code false} otherwise\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the named file\n- since: 1.2"
 ([this] (.setReadOnly ^"java.io.File" this)))

(clojure.core/defn
 File:list
 "-- () -> String[]\nReturns an array of strings naming the files and directories in the directory denoted by this abstract pathname.  <p> If this abstract pathname does not denote a directory, then this method returns {@code null} .  Otherwise an array of strings is returned, one for each file or directory in the directory.  Names denoting the directory itself and the directory's parent directory are not included in the result.  Each string is a file name rather than a complete path.  <p> There is no guarantee that the name strings in the resulting array will appear in any specific order; they are not, in particular, guaranteed to appear in alphabetical order.  <p> Note that the {@link java.nio.file.Files} class defines the {@link java.nio.file.Files#newDirectoryStream(Path) newDirectoryStream} method to open a directory and iterate over the names of the files in the directory. This may use less resources when working with very large directories, and may be more responsive when working with remote directories.\n- return: An array of strings naming the files and directories in the directory denoted by this abstract pathname.  The array will be empty if the directory is empty.  Returns {@code null} if this abstract pathname does not denote a directory, or if an I/O error occurs.\n- throws SecurityException: If a security manager exists and its {@link SecurityManager#checkRead(String)} method denies read access to the directory\n-- (FilenameFilter filter) -> String[]\nReturns an array of strings naming the files and directories in the directory denoted by this abstract pathname that satisfy the specified filter.  The behavior of this method is the same as that of the {@link #list()} method, except that the strings in the returned array must satisfy the filter.  If the given {@code filter} is {@code null}  then all names are accepted.  Otherwise, a name satisfies the filter if and only if the value {@code true} results when the {@link FilenameFilter#accept FilenameFilter.accept(File,&nbsp;String)} method of the filter is invoked on this abstract pathname and the name of a file or directory in the directory that it denotes.\n- param filter: A filename filter\n- return: An array of strings naming the files and directories in the directory denoted by this abstract pathname that were accepted by the given {@code filter} .  The array will be empty if the directory is empty or if no names were accepted by the filter. Returns {@code null} if this abstract pathname does not denote a directory, or if an I/O error occurs.\n- throws SecurityException: If a security manager exists and its {@link SecurityManager#checkRead(String)} method denies read access to the directory\n- see: java.nio.file.Files#newDirectoryStream(Path,String)"
 ([this] (.list ^"java.io.File" this))
 ([this filter]
  (.list ^"java.io.File" this ^"java.io.FilenameFilter" filter)))

(clojure.core/defn
 File:delete
 "-- () -> boolean\nDeletes the file or directory denoted by this abstract pathname.  If this pathname denotes a directory, then the directory must be empty in order to be deleted.  <p> Note that the {@link java.nio.file.Files} class defines the {@link java.nio.file.Files#delete(Path) delete} method to throw an {@link IOException}  when a file cannot be deleted. This is useful for error reporting and to diagnose why a file cannot be deleted.\n- return: {@code true} if and only if the file or directory is successfully deleted; {@code false} otherwise\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkDelete} method denies delete access to the file"
 ([this] (.delete ^"java.io.File" this)))

(clojure.core/defn
 File:deleteOnExit
 "-- () -> void\nRequests that the file or directory denoted by this abstract pathname be deleted when the virtual machine terminates. Files (or directories) are deleted in the reverse order that they are registered. Invoking this method to delete a file or directory that is already registered for deletion has no effect. Deletion will be attempted only for normal termination of the virtual machine, as defined by the Java Language Specification.  <p> Once deletion has been requested, it is not possible to cancel the request.  This method should therefore be used with care.  <P> Note: this method should <i>not</i> be used for file-locking, as the resulting protocol cannot be made to work reliably. The {@link java.nio.channels.FileLock FileLock}  facility should be used instead.\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkDelete} method denies delete access to the file\n- see: #delete\n- since: 1.2"
 ([this] (.deleteOnExit ^"java.io.File" this)))

(clojure.core/defn
 File:toURI
 "-- () -> URI\nConstructs a {@code file:} URI that represents this abstract pathname.  <p> The exact form of the URI is system-dependent.  If it can be determined that the file denoted by this abstract pathname is a directory, then the resulting URI will end with a slash.  <p> For a given abstract pathname <i>f</i>, it is guaranteed that  <blockquote><code> new {@link #File(java.net.URI) File} (</code><i>&nbsp;f</i><code>.toURI()).equals( </code><i>&nbsp;f</i><code>. {@link #getAbsoluteFile() getAbsoluteFile} ()) </code></blockquote>  so long as the original abstract pathname, the URI, and the new abstract pathname are all created in (possibly different invocations of) the same Java virtual machine.  Due to the system-dependent nature of abstract pathnames, however, this relationship typically does not hold when a {@code file:} URI that is created in a virtual machine on one operating system is converted into an abstract pathname in a virtual machine on a different operating system.  <p> Note that when this abstract pathname represents a UNC pathname then all components of the UNC (including the server name component) are encoded in the {@code URI} path. The authority component is undefined, meaning that it is represented as {@code null} . The {@link Path} class defines the {@link Path#toUri toUri} method to encode the server name in the authority component of the resulting {@code URI} . The {@link #toPath toPath} method may be used to obtain a {@code Path} representing this abstract pathname.\n- return: An absolute, hierarchical URI with a scheme equal to  {@code \"file\"} , a path representing this abstract pathname, and undefined authority, query, and fragment components\n- throws SecurityException: If a required system property value cannot be accessed.\n- see: #File(java.net.URI)\n- see: java.net.URI\n- see: java.net.URI#toURL()\n- since: 1.4"
 ([this] (.toURI ^"java.io.File" this)))

(clojure.core/defn
 File:mkdirs
 "-- () -> boolean\nCreates the directory named by this abstract pathname, including any necessary but nonexistent parent directories.  Note that if this operation fails it may have succeeded in creating some of the necessary parent directories.\n- return: {@code true} if and only if the directory was created, along with all necessary parent directories; {@code false}  otherwise\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkRead(java.lang.String)}  method does not permit verification of the existence of the named directory and all necessary parent directories; or if the {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method does not permit the named directory and all necessary parent directories to be created"
 ([this] (.mkdirs ^"java.io.File" this)))

(clojure.core/defn
 File:getCanonicalPath
 "-- () -> String\nReturns the canonical pathname string of this abstract pathname.  <p> A canonical pathname is both absolute and unique.  The precise definition of canonical form is system-dependent.  This method first converts this pathname to absolute form if necessary, as if by invoking the {@link #getAbsolutePath} method, and then maps it to its unique form in a system-dependent way.  This typically involves removing redundant names such as {@code \".\"} and {@code \"..\"} from the pathname, resolving symbolic links (on UNIX platforms), and converting drive letters to a standard case (on Microsoft Windows platforms).  <p> Every pathname that denotes an existing file or directory has a unique canonical form.  Every pathname that denotes a nonexistent file or directory also has a unique canonical form.  The canonical form of the pathname of a nonexistent file or directory may be different from the canonical form of the same pathname after the file or directory is created.  Similarly, the canonical form of the pathname of an existing file or directory may be different from the canonical form of the same pathname after the file or directory is deleted.\n- return: The canonical pathname string denoting the same file or directory as this abstract pathname\n- throws IOException: If an I/O error occurs, which is possible because the construction of the canonical pathname may require filesystem queries\n- throws SecurityException: If a required system property value cannot be accessed, or if a security manager exists and its {@link java.lang.SecurityManager#checkRead} method denies read access to the file\n- since: 1.1\n- see: Path#toRealPath"
 ([this] (.getCanonicalPath ^"java.io.File" this)))

(clojure.core/defn
 File:toString
 "-- () -> String\nReturns the pathname string of this abstract pathname.  This is just the string returned by the {@link #getPath} method.\n- return: The string form of this abstract pathname"
 ([this] (.toString ^"java.io.File" this)))

(clojure.core/defn
 File:getPath
 "-- () -> String\nConverts this abstract pathname into a pathname string.  The resulting string uses the {@link #separator default name-separator character} to separate the names in the name sequence.\n- return: The string form of this abstract pathname"
 ([this] (.getPath ^"java.io.File" this)))

(clojure.core/defn
 File:getFreeSpace
 "-- () -> long\nReturns the number of unallocated bytes in the partition <a href=\"#partName\">named</a> by this abstract path name.  If the number of unallocated bytes in the partition is greater than {@link Long#MAX_VALUE} , then {@code Long.MAX_VALUE} will be returned.  <p> The returned number of unallocated bytes is a hint, but not a guarantee, that it is possible to use most or any of these bytes.  The number of unallocated bytes is most likely to be accurate immediately after this call.  It is likely to be made inaccurate by any external I/O operations including those made on the system outside of this virtual machine.  This method makes no guarantee that write operations to this file system will succeed.\n- return: The number of unallocated bytes on the partition or {@code 0L}  if the abstract pathname does not name a partition or if this number cannot be obtained.  This value will be less than or equal to the total file system size returned by  {@link #getTotalSpace} .\n- throws SecurityException: If a security manager has been installed and it denies  {@link RuntimePermission} {@code (\"getFileSystemAttributes\")}  or its {@link SecurityManager#checkRead(String)} method denies read access to the file named by this abstract pathname\n- since: 1.6\n- see: FileStore#getUnallocatedSpace"
 ([this] (.getFreeSpace ^"java.io.File" this)))

(clojure.core/defn
 File:getTotalSpace
 "-- () -> long\nReturns the size of the partition <a href=\"#partName\">named</a> by this abstract pathname. If the total number of bytes in the partition is greater than {@link Long#MAX_VALUE} , then {@code Long.MAX_VALUE} will be returned.\n- return: The size, in bytes, of the partition or {@code 0L} if this abstract pathname does not name a partition or if the size cannot be obtained\n- throws SecurityException: If a security manager has been installed and it denies  {@link RuntimePermission} {@code (\"getFileSystemAttributes\")}  or its {@link SecurityManager#checkRead(String)} method denies read access to the file named by this abstract pathname\n- since: 1.6\n- see: FileStore#getTotalSpace"
 ([this] (.getTotalSpace ^"java.io.File" this)))

(clojure.core/defn
 File:getName
 "-- () -> String\nReturns the name of the file or directory denoted by this abstract pathname.  This is just the last name in the pathname's name sequence.  If the pathname's name sequence is empty, then the empty string is returned.\n- return: The name of the file or directory denoted by this abstract pathname, or the empty string if this pathname's name sequence is empty"
 ([this] (.getName ^"java.io.File" this)))

(clojure.core/defn
 File:renameTo
 "-- (File dest) -> boolean\nRenames the file denoted by this abstract pathname.  <p> Many aspects of the behavior of this method are inherently platform-dependent: The rename operation might not be able to move a file from one filesystem to another, it might not be atomic, and it might not succeed if a file with the destination abstract pathname already exists.  The return value should always be checked to make sure that the rename operation was successful.  <p> Note that the {@link java.nio.file.Files} class defines the {@link java.nio.file.Files#move move} method to move or rename a file in a platform independent manner.\n- param dest: The new abstract pathname for the named file\n- return: {@code true} if and only if the renaming succeeded;  {@code false} otherwise\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to either the old or new pathnames\n- throws NullPointerException: If parameter {@code dest} is {@code null}"
 ([this dest] (.renameTo ^"java.io.File" this ^"java.io.File" dest)))

(clojure.core/defn
 File:canRead
 "-- () -> boolean\nTests whether the application can read the file denoted by this abstract pathname. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to read files that are marked as unreadable. Consequently this method may return {@code true} even though the file does not have read permissions.\n- return: {@code true} if and only if the file specified by this abstract pathname exists <em>and</em> can be read by the application; {@code false} otherwise\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkRead(java.lang.String)}  method denies read access to the file"
 ([this] (.canRead ^"java.io.File" this)))

(clojure.core/defn
 File:isDirectory
 "-- () -> boolean\nTests whether the file denoted by this abstract pathname is a directory.  <p> Where it is required to distinguish an I/O exception from the case that the file is not a directory, or where several attributes of the same file are required at the same time, then the {@link java.nio.file.Files#readAttributes(Path,Class,LinkOption[]) Files.readAttributes} method may be used.\n- return: {@code true} if and only if the file denoted by this abstract pathname exists <em>and</em> is a directory;  {@code false} otherwise\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkRead(java.lang.String)}  method denies read access to the file"
 ([this] (.isDirectory ^"java.io.File" this)))

(clojure.core/defn
 ->File
 "-- (String pathname)\nCreates a new {@code File} instance by converting the given pathname string into an abstract pathname.  If the given string is the empty string, then the result is the empty abstract pathname.\n- param pathname: A pathname string\n- throws NullPointerException: If the {@code pathname} argument is {@code null}\n-- (URI uri)\nCreates a new {@code File} instance by converting the given {@code file:} URI into an abstract pathname.  <p> The exact form of a {@code file:} URI is system-dependent, hence the transformation performed by this constructor is also system-dependent.  <p> For a given abstract pathname <i>f</i> it is guaranteed that  <blockquote><code> new File(</code><i>&nbsp;f</i><code>. {@link #toURI() toURI} ()).equals(</code><i>&nbsp;f</i><code>. {@link #getAbsoluteFile() getAbsoluteFile} ()) </code></blockquote>  so long as the original abstract pathname, the URI, and the new abstract pathname are all created in (possibly different invocations of) the same Java virtual machine.  This relationship typically does not hold, however, when a {@code file:} URI that is created in a virtual machine on one operating system is converted into an abstract pathname in a virtual machine on a different operating system.\n- param uri: An absolute, hierarchical URI with a scheme equal to  {@code \"file\"} , a non-empty path component, and undefined authority, query, and fragment components\n- throws NullPointerException: If {@code uri} is {@code null}\n- throws IllegalArgumentException: If the preconditions on the parameter do not hold\n- see: #toURI()\n- see: java.net.URI\n- since: 1.4\n-- (String pathname, int prefixLength)\nInternal constructor for already-normalized pathname strings.\n-- (String child, File parent)\nInternal constructor for already-normalized pathname strings. The parameter order is used to disambiguate this method from the public(File, String) constructor.\n-- (String parent, String child)\nCreates a new {@code File} instance from a parent pathname string and a child pathname string.  <p> If {@code parent} is {@code null} then the new {@code File} instance is created as if by invoking the single-argument {@code File} constructor on the given {@code child} pathname string.  <p> Otherwise the {@code parent} pathname string is taken to denote a directory, and the {@code child} pathname string is taken to denote either a directory or a file.  If the {@code child} pathname string is absolute then it is converted into a relative pathname in a system-dependent way.  If {@code parent} is the empty string then the new {@code File} instance is created by converting {@code child} into an abstract pathname and resolving the result against a system-dependent default directory.  Otherwise each pathname string is converted into an abstract pathname and the child abstract pathname is resolved against the parent.\n- param parent: The parent pathname string\n- param child: The child pathname string\n- throws NullPointerException: If {@code child} is {@code null}\n-- (File parent, String child)\nCreates a new {@code File} instance from a parent abstract pathname and a child pathname string.  <p> If {@code parent} is {@code null} then the new {@code File} instance is created as if by invoking the single-argument {@code File} constructor on the given {@code child} pathname string.  <p> Otherwise the {@code parent} abstract pathname is taken to denote a directory, and the {@code child} pathname string is taken to denote either a directory or a file.  If the {@code child}  pathname string is absolute then it is converted into a relative pathname in a system-dependent way.  If {@code parent} is the empty abstract pathname then the new {@code File} instance is created by converting {@code child} into an abstract pathname and resolving the result against a system-dependent default directory.  Otherwise each pathname string is converted into an abstract pathname and the child abstract pathname is resolved against the parent.\n- param parent: The parent abstract pathname\n- param child: The child pathname string\n- throws NullPointerException: If {@code child} is {@code null}"
 ([pathname|uri]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String pathname|uri)
   (java.io.File. ^"java.lang.String" pathname|uri)
   (clojure.core/instance? java.net.URI pathname|uri)
   (java.io.File. ^"java.net.URI" pathname|uri)))
 ([parent child]
  (clojure.core/cond
   (clojure.core/instance? java.io.File parent)
   (java.io.File. ^"java.io.File" parent ^"java.lang.String" child)
   (clojure.core/instance? java.lang.String parent)
   (java.io.File.
    ^"java.lang.String" parent
    ^"java.lang.String" child))))

(clojure.core/defn
 File:getParent
 "-- () -> String\nReturns the pathname string of this abstract pathname's parent, or {@code null} if this pathname does not name a parent directory.  <p> The <em>parent</em> of an abstract pathname consists of the pathname's prefix, if any, and each name in the pathname's name sequence except for the last.  If the name sequence is empty then the pathname does not name a parent directory.\n- return: The pathname string of the parent directory named by this abstract pathname, or {@code null} if this pathname does not name a parent"
 ([this] (.getParent ^"java.io.File" this)))

(clojure.core/defn
 File:isHidden
 "-- () -> boolean\nTests whether the file named by this abstract pathname is a hidden file.  The exact definition of <em>hidden</em> is system-dependent.  On UNIX systems, a file is considered to be hidden if its name begins with a period character ( {@code '.'} ).  On Microsoft Windows systems, a file is considered to be hidden if it has been marked as such in the filesystem.\n- return: {@code true} if and only if the file denoted by this abstract pathname is hidden according to the conventions of the underlying platform\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkRead(java.lang.String)}  method denies read access to the file\n- since: 1.2"
 ([this] (.isHidden ^"java.io.File" this)))

(clojure.core/defn
 File:setLastModified
 "-- (long time) -> boolean\nSets the last-modified time of the file or directory named by this abstract pathname.  <p> All platforms support file-modification times to the nearest second, but some provide more precision.  The argument will be truncated to fit the supported precision.  If the operation succeeds and no intervening operations on the file take place, then the next invocation of the {@link #lastModified} method will return the (possibly truncated) {@code time} argument that was passed to this method.\n- param time: The new last-modified time, measured in milliseconds since the epoch (00:00:00 GMT, January 1, 1970)\n- return: {@code true} if and only if the operation succeeded;  {@code false} otherwise\n- throws IllegalArgumentException: If the argument is negative\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the named file\n- since: 1.2"
 ([this time] (.setLastModified ^"java.io.File" this ^"long" time)))

(clojure.core/defn
 File:getUsableSpace
 "-- () -> long\nReturns the number of bytes available to this virtual machine on the partition <a href=\"#partName\">named</a> by this abstract pathname.  If the number of available bytes in the partition is greater than {@link Long#MAX_VALUE} , then {@code Long.MAX_VALUE} will be returned. When possible, this method checks for write permissions and other operating system restrictions and will therefore usually provide a more accurate estimate of how much new data can actually be written than {@link #getFreeSpace} .  <p> The returned number of available bytes is a hint, but not a guarantee, that it is possible to use most or any of these bytes.  The number of available bytes is most likely to be accurate immediately after this call.  It is likely to be made inaccurate by any external I/O operations including those made on the system outside of this virtual machine.  This method makes no guarantee that write operations to this file system will succeed.\n- return: The number of available bytes on the partition or {@code 0L}  if the abstract pathname does not name a partition or if this number cannot be obtained.  On systems where this information is not available, this method will be equivalent to a call to  {@link #getFreeSpace} .\n- throws SecurityException: If a security manager has been installed and it denies  {@link RuntimePermission} {@code (\"getFileSystemAttributes\")}  or its {@link SecurityManager#checkRead(String)} method denies read access to the file named by this abstract pathname\n- since: 1.6\n- see: FileStore#getUsableSpace"
 ([this] (.getUsableSpace ^"java.io.File" this)))

(clojure.core/defn
 File:length
 "-- () -> long\nReturns the length of the file denoted by this abstract pathname. The return value is unspecified if this pathname denotes a directory.  <p> Where it is required to distinguish an I/O exception from the case that {@code 0L} is returned, or where several attributes of the same file are required at the same time, then the {@link java.nio.file.Files#readAttributes(Path,Class,LinkOption[]) Files.readAttributes} method may be used.\n- return: The length, in bytes, of the file denoted by this abstract pathname, or {@code 0L} if the file does not exist.  Some operating systems may return {@code 0L} for pathnames denoting system-dependent entities such as devices or pipes.\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkRead(java.lang.String)}  method denies read access to the file"
 ([this] (.length ^"java.io.File" this)))

(clojure.core/defn
 File:setReadable
 "-- (boolean readable) -> boolean\nA convenience method to set the owner's read permission for this abstract pathname. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to read files that are marked as unreadable.  <p>An invocation of this method of the form {@code file.setReadable(arg)}  behaves in exactly the same way as the invocation  <pre> {@code file.setReadable(arg, true) } </pre>\n- param readable: If {@code true} , sets the access permission to allow read operations; if {@code false} to disallow read operations\n- return: {@code true} if and only if the operation succeeded.  The operation will fail if the user does not have permission to change the access permissions of this abstract pathname.  If  {@code readable} is {@code false} and the underlying file system does not implement a read permission, then the operation will fail.\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the file\n- since: 1.6\n-- (boolean readable, boolean ownerOnly) -> boolean\nSets the owner's or everybody's read permission for this abstract pathname. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to read files that are marked as unreadable.  <p> The {@link java.nio.file.Files} class defines methods that operate on file attributes including file permissions. This may be used when finer manipulation of file permissions is required.\n- param readable: If {@code true} , sets the access permission to allow read operations; if {@code false} to disallow read operations\n- param ownerOnly: If {@code true} , the read permission applies only to the owner's read permission; otherwise, it applies to everybody.  If the underlying file system can not distinguish the owner's read permission from that of others, then the permission will apply to everybody, regardless of this value.\n- return: {@code true} if and only if the operation succeeded.  The operation will fail if the user does not have permission to change the access permissions of this abstract pathname.  If  {@code readable} is {@code false} and the underlying file system does not implement a read permission, then the operation will fail.\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the file\n- since: 1.6"
 ([this readable]
  (.setReadable ^"java.io.File" this ^"boolean" readable))
 ([this readable ownerOnly]
  (.setReadable
   ^"java.io.File" this
   ^"boolean" readable
   ^"boolean" ownerOnly)))

(clojure.core/defn
 File:listFiles
 "-- () -> File[]\nReturns an array of abstract pathnames denoting the files in the directory denoted by this abstract pathname.  <p> If this abstract pathname does not denote a directory, then this method returns {@code null} .  Otherwise an array of {@code File} objects is returned, one for each file or directory in the directory.  Pathnames denoting the directory itself and the directory's parent directory are not included in the result.  Each resulting abstract pathname is constructed from this abstract pathname using the {@link #File(File, String) File(File,&nbsp;String)} constructor.  Therefore if this pathname is absolute then each resulting pathname is absolute; if this pathname is relative then each resulting pathname will be relative to the same directory.  <p> There is no guarantee that the name strings in the resulting array will appear in any specific order; they are not, in particular, guaranteed to appear in alphabetical order.  <p> Note that the {@link java.nio.file.Files} class defines the {@link java.nio.file.Files#newDirectoryStream(Path) newDirectoryStream} method to open a directory and iterate over the names of the files in the directory. This may use less resources when working with very large directories.\n- return: An array of abstract pathnames denoting the files and directories in the directory denoted by this abstract pathname. The array will be empty if the directory is empty.  Returns  {@code null} if this abstract pathname does not denote a directory, or if an I/O error occurs.\n- throws SecurityException: If a security manager exists and its {@link SecurityManager#checkRead(String)} method denies read access to the directory\n- since: 1.2\n-- (FilenameFilter filter) -> File[]\nReturns an array of abstract pathnames denoting the files and directories in the directory denoted by this abstract pathname that satisfy the specified filter.  The behavior of this method is the same as that of the {@link #listFiles()} method, except that the pathnames in the returned array must satisfy the filter.  If the given {@code filter}  is {@code null} then all pathnames are accepted.  Otherwise, a pathname satisfies the filter if and only if the value {@code true} results when the {@link FilenameFilter#accept FilenameFilter.accept(File,&nbsp;String)} method of the filter is invoked on this abstract pathname and the name of a file or directory in the directory that it denotes.\n- param filter: A filename filter\n- return: An array of abstract pathnames denoting the files and directories in the directory denoted by this abstract pathname. The array will be empty if the directory is empty.  Returns  {@code null} if this abstract pathname does not denote a directory, or if an I/O error occurs.\n- throws SecurityException: If a security manager exists and its {@link SecurityManager#checkRead(String)} method denies read access to the directory\n- since: 1.2\n- see: java.nio.file.Files#newDirectoryStream(Path,String)\n-- (FileFilter filter) -> File[]\nReturns an array of abstract pathnames denoting the files and directories in the directory denoted by this abstract pathname that satisfy the specified filter.  The behavior of this method is the same as that of the {@link #listFiles()} method, except that the pathnames in the returned array must satisfy the filter.  If the given {@code filter}  is {@code null} then all pathnames are accepted.  Otherwise, a pathname satisfies the filter if and only if the value {@code true} results when the {@link FileFilter#accept FileFilter.accept(File)} method of the filter is invoked on the pathname.\n- param filter: A file filter\n- return: An array of abstract pathnames denoting the files and directories in the directory denoted by this abstract pathname. The array will be empty if the directory is empty.  Returns  {@code null} if this abstract pathname does not denote a directory, or if an I/O error occurs.\n- throws SecurityException: If a security manager exists and its {@link SecurityManager#checkRead(String)} method denies read access to the directory\n- since: 1.2\n- see: java.nio.file.Files#newDirectoryStream(Path,java.nio.file.DirectoryStream.Filter)"
 ([this] (.listFiles ^"java.io.File" this))
 ([this filter]
  (clojure.core/cond
   (clojure.core/instance? java.io.FilenameFilter filter)
   (.listFiles ^"java.io.File" this ^"java.io.FilenameFilter" filter)
   (clojure.core/instance? java.io.FileFilter filter)
   (.listFiles ^"java.io.File" this ^"java.io.FileFilter" filter))))

(clojure.core/defn
 File:toPath
 "-- () -> Path\nReturns a {@link Path java.nio.file.Path} object constructed from this abstract path. The resulting {@code Path} is associated with the {@link java.nio.file.FileSystems#getDefault default-filesystem} .  <p> The first invocation of this method works as if invoking it were equivalent to evaluating the expression: <blockquote><pre> {@link java.nio.file.FileSystems#getDefault FileSystems.getDefault} (). {@link java.nio.file.FileSystem#getPath getPath} (this. {@link #getPath getPath} ()); </pre></blockquote> Subsequent invocations of this method return the same {@code Path} .  <p> If this abstract pathname is the empty abstract pathname then this method returns a {@code Path} that may be used to access the current user directory.\n- return: a {@code Path} constructed from this abstract path\n- throws java.nio.file.InvalidPathException: if a {@code Path} object cannot be constructed from the abstract path (see {@link java.nio.file.FileSystem#getPath FileSystem.getPath} )\n- since: 1.7\n- see: Path#toFile"
 ([this] (.toPath ^"java.io.File" this)))

(clojure.core/defn
 File:setWritable
 "-- (boolean writable) -> boolean\nA convenience method to set the owner's write permission for this abstract pathname. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to modify files that disallow write operations.  <p> An invocation of this method of the form {@code file.setWritable(arg)}  behaves in exactly the same way as the invocation  <pre> {@code file.setWritable(arg, true) } </pre>\n- param writable: If {@code true} , sets the access permission to allow write operations; if {@code false} to disallow write operations\n- return: {@code true} if and only if the operation succeeded.  The operation will fail if the user does not have permission to change the access permissions of this abstract pathname.\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the file\n- since: 1.6\n-- (boolean writable, boolean ownerOnly) -> boolean\nSets the owner's or everybody's write permission for this abstract pathname. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to modify files that disallow write operations.  <p> The {@link java.nio.file.Files} class defines methods that operate on file attributes including file permissions. This may be used when finer manipulation of file permissions is required.\n- param writable: If {@code true} , sets the access permission to allow write operations; if {@code false} to disallow write operations\n- param ownerOnly: If {@code true} , the write permission applies only to the owner's write permission; otherwise, it applies to everybody.  If the underlying file system can not distinguish the owner's write permission from that of others, then the permission will apply to everybody, regardless of this value.\n- return: {@code true} if and only if the operation succeeded. The operation will fail if the user does not have permission to change the access permissions of this abstract pathname.\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the named file\n- since: 1.6"
 ([this writable]
  (.setWritable ^"java.io.File" this ^"boolean" writable))
 ([this writable ownerOnly]
  (.setWritable
   ^"java.io.File" this
   ^"boolean" writable
   ^"boolean" ownerOnly)))

(clojure.core/defn
 File:canExecute
 "-- () -> boolean\nTests whether the application can execute the file denoted by this abstract pathname. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to execute files that are not marked executable. Consequently this method may return {@code true} even though the file does not have execute permissions.\n- return: {@code true} if and only if the abstract pathname exists <em>and</em> the application is allowed to execute the file\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkExec(java.lang.String)}  method denies execute access to the file\n- since: 1.6"
 ([this] (.canExecute ^"java.io.File" this)))

(clojure.core/defn
 File:createNewFile
 "-- () -> boolean\nAtomically creates a new, empty file named by this abstract pathname if and only if a file with this name does not yet exist.  The check for the existence of the file and the creation of the file if it does not exist are a single operation that is atomic with respect to all other filesystem activities that might affect the file. <P> Note: this method should <i>not</i> be used for file-locking, as the resulting protocol cannot be made to work reliably. The {@link java.nio.channels.FileLock FileLock}  facility should be used instead.\n- return: {@code true} if the named file does not exist and was successfully created; {@code false} if the named file already exists\n- throws IOException: If an I/O error occurred\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the file\n- since: 1.2"
 ([this] (.createNewFile ^"java.io.File" this)))

(clojure.core/defn
 File:hashCode
 "-- () -> int\nComputes a hash code for this abstract pathname.  Because equality of abstract pathnames is inherently system-dependent, so is the computation of their hash codes.  On UNIX systems, the hash code of an abstract pathname is equal to the exclusive <em>or</em> of the hash code of its pathname string and the decimal value {@code 1234321} .  On Microsoft Windows systems, the hash code is equal to the exclusive <em>or</em> of the hash code of its pathname string converted to lower case and the decimal value {@code 1234321} .  Locale is not taken into account on lowercasing the pathname string.\n- return: A hash code for this abstract pathname"
 ([this] (.hashCode ^"java.io.File" this)))

(clojure.core/defn
 File:canWrite
 "-- () -> boolean\nTests whether the application can modify the file denoted by this abstract pathname. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to modify files that are marked read-only. Consequently this method may return {@code true} even though the file is marked read-only.\n- return: {@code true} if and only if the file system actually contains a file denoted by this abstract pathname <em>and</em> the application is allowed to write to the file;  {@code false} otherwise.\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the file"
 ([this] (.canWrite ^"java.io.File" this)))

(clojure.core/defn
 File:exists
 "-- () -> boolean\nTests whether the file or directory denoted by this abstract pathname exists.\n- return: {@code true} if and only if the file or directory denoted by this abstract pathname exists; {@code false} otherwise\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkRead(java.lang.String)}  method denies read access to the file or directory"
 ([this] (.exists ^"java.io.File" this)))

(clojure.core/defn
 File:getParentFile
 "-- () -> File\nReturns the abstract pathname of this abstract pathname's parent, or {@code null} if this pathname does not name a parent directory.  <p> The <em>parent</em> of an abstract pathname consists of the pathname's prefix, if any, and each name in the pathname's name sequence except for the last.  If the name sequence is empty then the pathname does not name a parent directory.\n- return: The abstract pathname of the parent directory named by this abstract pathname, or {@code null} if this pathname does not name a parent\n- since: 1.2"
 ([this] (.getParentFile ^"java.io.File" this)))

(clojure.core/defn
 File:compareTo
 "-- (File pathname) -> int\nCompares two abstract pathnames lexicographically.  The ordering defined by this method depends upon the underlying system.  On UNIX systems, alphabetic case is significant in comparing pathnames; on Microsoft Windows systems it is not.\n- param pathname: The abstract pathname to be compared to this abstract pathname\n- return: Zero if the argument is equal to this abstract pathname, a value less than zero if this abstract pathname is lexicographically less than the argument, or a value greater than zero if this abstract pathname is lexicographically greater than the argument\n- since: 1.2"
 ([this pathname]
  (clojure.core/cond
   (clojure.core/instance? java.io.File pathname)
   (.compareTo ^"java.io.File" this ^"java.io.File" pathname)
   (clojure.core/instance? java.lang.Object pathname)
   (.compareTo ^"java.io.File" this ^"java.lang.Object" pathname))))

(clojure.core/defn
 File:setExecutable
 "-- (boolean executable) -> boolean\nA convenience method to set the owner's execute permission for this abstract pathname. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to execute files that are not marked executable.  <p>An invocation of this method of the form {@code file.setExcutable(arg)}  behaves in exactly the same way as the invocation  <pre> {@code file.setExecutable(arg, true) } </pre>\n- param executable: If {@code true} , sets the access permission to allow execute operations; if {@code false} to disallow execute operations\n- return: {@code true} if and only if the operation succeeded.  The operation will fail if the user does not have permission to change the access permissions of this abstract pathname.  If  {@code executable} is {@code false} and the underlying file system does not implement an execute permission, then the operation will fail.\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the file\n- since: 1.6\n-- (boolean executable, boolean ownerOnly) -> boolean\nSets the owner's or everybody's execute permission for this abstract pathname. On some platforms it may be possible to start the Java virtual machine with special privileges that allow it to execute files that are not marked executable.  <p> The {@link java.nio.file.Files} class defines methods that operate on file attributes including file permissions. This may be used when finer manipulation of file permissions is required.\n- param executable: If {@code true} , sets the access permission to allow execute operations; if {@code false} to disallow execute operations\n- param ownerOnly: If {@code true} , the execute permission applies only to the owner's execute permission; otherwise, it applies to everybody. If the underlying file system can not distinguish the owner's execute permission from that of others, then the permission will apply to everybody, regardless of this value.\n- return: {@code true} if and only if the operation succeeded.  The operation will fail if the user does not have permission to change the access permissions of this abstract pathname.  If  {@code executable} is {@code false} and the underlying file system does not implement an execute permission, then the operation will fail.\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method denies write access to the file\n- since: 1.6"
 ([this executable]
  (.setExecutable ^"java.io.File" this ^"boolean" executable))
 ([this executable ownerOnly]
  (.setExecutable
   ^"java.io.File" this
   ^"boolean" executable
   ^"boolean" ownerOnly)))

(clojure.core/defn
 File:getAbsolutePath
 "-- () -> String\nReturns the absolute pathname string of this abstract pathname.  <p> If this abstract pathname is already absolute, then the pathname string is simply returned as if by the {@link #getPath}  method.  If this abstract pathname is the empty abstract pathname then the pathname string of the current user directory, which is named by the system property {@code user.dir} , is returned.  Otherwise this pathname is resolved in a system-dependent way.  On UNIX systems, a relative pathname is made absolute by resolving it against the current user directory.  On Microsoft Windows systems, a relative pathname is made absolute by resolving it against the current directory of the drive named by the pathname, if any; if not, it is resolved against the current user directory.\n- return: The absolute pathname string denoting the same file or directory as this abstract pathname\n- throws SecurityException: If a required system property value cannot be accessed.\n- see: java.io.File#isAbsolute()"
 ([this] (.getAbsolutePath ^"java.io.File" this)))

(clojure.core/defn
 File:getAbsoluteFile
 "-- () -> File\nReturns the absolute form of this abstract pathname.  Equivalent to <code>new&nbsp;File(this. {@link #getAbsolutePath} )</code>.\n- return: The absolute abstract pathname denoting the same file or directory as this abstract pathname\n- throws SecurityException: If a required system property value cannot be accessed.\n- since: 1.2"
 ([this] (.getAbsoluteFile ^"java.io.File" this)))

(clojure.core/defn
 File:equals
 "-- (Object obj) -> boolean\nTests this abstract pathname for equality with the given object. Returns {@code true} if and only if the argument is not {@code null} and is an abstract pathname that denotes the same file or directory as this abstract pathname.  Whether or not two abstract pathnames are equal depends upon the underlying system.  On UNIX systems, alphabetic case is significant in comparing pathnames; on Microsoft Windows systems it is not.\n- param obj: The object to be compared with this abstract pathname\n- return: {@code true} if and only if the objects are the same;  {@code false} otherwise"
 ([this obj] (.equals ^"java.io.File" this ^"java.lang.Object" obj)))

(clojure.core/defn
 File:toURL
 "-- () -> URL\nConverts this abstract pathname into a {@code file:} URL.  The exact form of the URL is system-dependent.  If it can be determined that the file denoted by this abstract pathname is a directory, then the resulting URL will end with a slash.\n- return: A URL object representing the equivalent file URL\n- throws MalformedURLException: If the path cannot be parsed as a URL\n- see: #toURI()\n- see: java.net.URI\n- see: java.net.URI#toURL()\n- see: java.net.URL\n- since: 1.2\n- deprecated: This method does not automatically escape characters that are illegal in URLs.  It is recommended that new code convert an abstract pathname into a URL by first converting it into a URI, via the {@link #toURI() toURI} method, and then converting the URI into a URL via the {@link java.net.URI#toURL() URI.toURL} method."
 ([this] (.toURL ^"java.io.File" this)))

(clojure.core/defn
 File:isAbsolute
 "-- () -> boolean\nTests whether this abstract pathname is absolute.  The definition of absolute pathname is system dependent.  On UNIX systems, a pathname is absolute if its prefix is {@code \"/\"} .  On Microsoft Windows systems, a pathname is absolute if its prefix is a drive specifier followed by {@code \"\\\\\"} , or if its prefix is {@code \"\\\\\\\\\"} .\n- return: {@code true} if this abstract pathname is absolute,  {@code false} otherwise"
 ([this] (.isAbsolute ^"java.io.File" this)))

(clojure.core/defn
 File:mkdir
 "-- () -> boolean\nCreates the directory named by this abstract pathname.\n- return: {@code true} if and only if the directory was created; {@code false} otherwise\n- throws SecurityException: If a security manager exists and its {@link java.lang.SecurityManager#checkWrite(java.lang.String)}  method does not permit the named directory to be created"
 ([this] (.mkdir ^"java.io.File" this)))

(clojure.core/defn
 File:listRoots
 "-- () -> File[]\nList the available filesystem roots.  <p> A particular Java platform may support zero or more hierarchically-organized file systems.  Each file system has a {@code root} directory from which all other files in that file system can be reached.  Windows platforms, for example, have a root directory for each active drive; UNIX platforms have a single root directory, namely {@code \"/\"} .  The set of available filesystem roots is affected by various system-level operations such as the insertion or ejection of removable media and the disconnecting or unmounting of physical or virtual disk drives.  <p> This method returns an array of {@code File} objects that denote the root directories of the available filesystem roots.  It is guaranteed that the canonical pathname of any file physically present on the local machine will begin with one of the roots returned by this method.  <p> The canonical pathname of a file that resides on some other machine and is accessed via a remote-filesystem protocol such as SMB or NFS may or may not begin with one of the roots returned by this method.  If the pathname of a remote file is syntactically indistinguishable from the pathname of a local file then it will begin with one of the roots returned by this method.  Thus, for example, {@code File} objects denoting the root directories of the mapped network drives of a Windows platform will be returned by this method, while {@code File} objects containing UNC pathnames will not be returned by this method.  <p> Unlike most methods in this class, this method does not throw security exceptions.  If a security manager exists and its {@link SecurityManager#checkRead(String)} method denies read access to a particular root directory, then that directory will not appear in the result.\n- return: An array of {@code File} objects denoting the available filesystem roots, or {@code null} if the set of roots could not be determined.  The array will be empty if there are no filesystem roots.\n- since: 1.2\n- see: java.nio.file.FileStore"
 ([] (java.io.File/listRoots)))

(clojure.core/defn
 File:getCanonicalFile
 "-- () -> File\nReturns the canonical form of this abstract pathname.  Equivalent to <code>new&nbsp;File(this. {@link #getCanonicalPath} )</code>.\n- return: The canonical pathname string denoting the same file or directory as this abstract pathname\n- throws IOException: If an I/O error occurs, which is possible because the construction of the canonical pathname may require filesystem queries\n- throws SecurityException: If a required system property value cannot be accessed, or if a security manager exists and its {@link java.lang.SecurityManager#checkRead} method denies read access to the file\n- since: 1.2\n- see: Path#toRealPath"
 ([this] (.getCanonicalFile ^"java.io.File" this)))

(def
 ^"char" File:separatorChar
 "Type: char"
 java.io.File/separatorChar)

(def
 ^"java.lang.String" File:separator
 "Type: java.lang.String"
 java.io.File/separator)

(def
 ^"char" File:pathSeparatorChar
 "Type: char"
 java.io.File/pathSeparatorChar)

(def
 ^"java.lang.String" File:pathSeparator
 "Type: java.lang.String"
 java.io.File/pathSeparator)

(def File:class java.io.File)

(clojure.core/defn
 File?
 "Checks if x is an instance of java.io.File."
 [x]
 (clojure.core/instance? java.io.File x))

(clojure.core/defn
 BufferedReader:skip
 "-- (long n) -> long\nSkips characters.\n- param n: The number of characters to skip\n- return: The number of characters actually skipped\n- throws IllegalArgumentException: If {@code n} is negative.\n- throws IOException: If an I/O error occurs"
 ([this n] (.skip ^"java.io.BufferedReader" this ^"long" n)))

(clojure.core/defn
 BufferedReader:ready
 "-- () -> boolean\nTells whether this stream is ready to be read.  A buffered character stream is ready if the buffer is not empty, or if the underlying character stream is ready.\n- throws IOException: If an I/O error occurs"
 ([this] (.ready ^"java.io.BufferedReader" this)))

(clojure.core/defn
 BufferedReader:lines
 "-- () -> Stream<String>\nReturns a {@code Stream} , the elements of which are lines read from this {@code BufferedReader} .  The {@link Stream} is lazily populated, i.e., read only occurs during the <a href=\"../util/stream/package-summary.html#StreamOps\">terminal stream operation</a>.  <p> The reader must not be operated on during the execution of the terminal stream operation. Otherwise, the result of the terminal stream operation is undefined.  <p> After execution of the terminal stream operation there are no guarantees that the reader will be at a specific position from which to read the next character or line.  <p> If an {@link IOException} is thrown when accessing the underlying {@code BufferedReader} , it is wrapped in an {@link UncheckedIOException} which will be thrown from the {@code Stream}  method that caused the read to take place. This method will return a Stream if invoked on a BufferedReader that is closed. Any operation on that stream that requires reading from the BufferedReader after it is closed, will cause an UncheckedIOException to be thrown.\n- return: a {@code Stream<String>} providing the lines of text described by this {@code BufferedReader}\n- since: 1.8"
 ([this] (.lines ^"java.io.BufferedReader" this)))

(clojure.core/defn
 BufferedReader:read
 "-- () -> int\nReads a single character.\n- return: The character read, as an integer in the range 0 to 65535 ( {@code 0x00-0xffff} ), or -1 if the end of the stream has been reached\n- throws IOException: If an I/O error occurs\n-- (char[] cbuf, int off, int len) -> int\nReads characters into a portion of an array.  <p> This method implements the general contract of the corresponding {@link Reader#read(char[], int, int) read} method of the {@link Reader} class.  As an additional convenience, it attempts to read as many characters as possible by repeatedly invoking the {@code read} method of the underlying stream.  This iterated {@code read} continues until one of the following conditions becomes true: <ul>  <li> The specified number of characters have been read,  <li> The {@code read} method of the underlying stream returns  {@code -1} , indicating end-of-file, or  <li> The {@code ready} method of the underlying stream returns {@code false} , indicating that further input requests would block.  </ul> If the first {@code read} on the underlying stream returns {@code -1} to indicate end-of-file then this method returns {@code -1} .  Otherwise this method returns the number of characters actually read.  <p> Subclasses of this class are encouraged, but not required, to attempt to read as many characters as possible in the same fashion.  <p> Ordinarily this method takes characters from this stream's character buffer, filling it from the underlying stream as necessary.  If, however, the buffer is empty, the mark is not valid, and the requested length is at least as large as the buffer, then this method will read characters directly from the underlying stream into the given array. Thus redundant {@code BufferedReader} s will not copy data unnecessarily.\n- param cbuf: Destination buffer\n- param off: Offset at which to start storing characters\n- param len: Maximum number of characters to read\n- return: The number of characters read, or -1 if the end of the stream has been reached\n- throws IOException: If an I/O error occurs\n- throws IndexOutOfBoundsException: {@inheritDoc}"
 ([this] (.read ^"java.io.BufferedReader" this))
 ([this cbuf off len]
  (.read
   ^"java.io.BufferedReader" this
   ^"[C" cbuf
   ^"int" off
   ^"int" len)))

(clojure.core/defn
 BufferedReader:reset
 "-- () -> void\nResets the stream to the most recent mark.\n- throws IOException: If the stream has never been marked, or if the mark has been invalidated"
 ([this] (.reset ^"java.io.BufferedReader" this)))

(clojure.core/defn
 BufferedReader:markSupported
 "-- () -> boolean\nTells whether this stream supports the mark() operation, which it does."
 ([this] (.markSupported ^"java.io.BufferedReader" this)))

(clojure.core/defn
 ->BufferedReader
 "-- (Reader in)\nCreates a buffering character-input stream that uses a default-sized input buffer.\n- param in: A Reader\n-- (Reader in, int sz)\nCreates a buffering character-input stream that uses an input buffer of the specified size.\n- param in: A Reader\n- param sz: Input-buffer size\n- throws IllegalArgumentException: If {@code sz <= 0}"
 ([in] (java.io.BufferedReader. ^"java.io.Reader" in))
 ([in sz] (java.io.BufferedReader. ^"java.io.Reader" in ^"int" sz)))

(clojure.core/defn
 BufferedReader:close
 "-- () -> void"
 ([this] (.close ^"java.io.BufferedReader" this)))

(clojure.core/defn
 BufferedReader:mark
 "-- (int readAheadLimit) -> void\nMarks the present position in the stream.  Subsequent calls to reset() will attempt to reposition the stream to this point.\n- param readAheadLimit: Limit on the number of characters that may be read while still preserving the mark. An attempt to reset the stream after reading characters up to this limit or beyond may fail. A limit value larger than the size of the input buffer will cause a new buffer to be allocated whose size is no smaller than limit. Therefore large values should be used with care.\n- throws IllegalArgumentException: If {@code readAheadLimit < 0}\n- throws IOException: If an I/O error occurs"
 ([this readAheadLimit]
  (.mark ^"java.io.BufferedReader" this ^"int" readAheadLimit)))

(clojure.core/defn
 BufferedReader:readLine
 "-- () -> String\nReads a line of text.  A line is considered to be terminated by any one of a line feed ('\\n'), a carriage return ('\\r'), a carriage return followed immediately by a line feed, or by reaching the end-of-file (EOF).\n- return: A String containing the contents of the line, not including any line-termination characters, or null if the end of the stream has been reached without reading any characters\n- throws IOException: If an I/O error occurs\n- see: java.nio.file.Files#readAllLines\n-- (boolean ignoreLF, boolean[] term) -> String\nReads a line of text.  A line is considered to be terminated by any one of a line feed ('\\n'), a carriage return ('\\r'), a carriage return followed immediately by a line feed, or by reaching the end-of-file (EOF).\n- param ignoreLF: If true, the next '\\n' will be skipped\n- param term: Output: Whether a line terminator was encountered while reading the line; may be {@code null} .\n- return: A String containing the contents of the line, not including any line-termination characters, or null if the end of the stream has been reached without reading any characters\n- see: java.io.LineNumberReader#readLine()\n- throws IOException: If an I/O error occurs"
 ([this] (.readLine ^"java.io.BufferedReader" this)))

(def BufferedReader:class java.io.BufferedReader)

(clojure.core/defn
 BufferedReader?
 "Checks if x is an instance of java.io.BufferedReader."
 [x]
 (clojure.core/instance? java.io.BufferedReader x))

(clojure.core/defn
 Optional:map
 "-- (Function<? super T, ? extends U> mapper) -> Optional<U>\nIf a value is present, returns an {@code Optional} describing (as if by {@link #ofNullable} ) the result of applying the given mapping function to the value, otherwise returns an empty {@code Optional} .  <p>If the mapping function returns a {@code null} result then this method returns an empty {@code Optional} .\n- apiNote: This method supports post-processing on {@code Optional} values, without the need to explicitly check for a return status.  For example, the following code traverses a stream of URIs, selects one that has not yet been processed, and creates a path from that URI, returning an {@code Optional<Path>} :  <pre> {@code Optional<Path> p = uris.stream().filter(uri -> !isProcessedYet(uri)) .findFirst() .map(Paths::get); } </pre>  Here, {@code findFirst} returns an {@code Optional<URI>} , and then {@code map} returns an {@code Optional<Path>} for the desired URI if one exists.\n- param mapper: the mapping function to apply to a value, if present\n- param <U>: The type of the value returned from the mapping function\n- return: an {@code Optional} describing the result of applying a mapping function to the value of this {@code Optional} , if a value is present, otherwise an empty {@code Optional}\n- throws NullPointerException: if the mapping function is {@code null}"
 ([this mapper]
  (.map
   ^"java.util.Optional" this
   ^"java.util.function.Function" mapper)))

(clojure.core/defn
 Optional:stream
 "-- () -> Stream<T>\nIf a value is present, returns a sequential {@link Stream} containing only that value, otherwise returns an empty {@code Stream} .\n- apiNote: This method can be used to transform a {@code Stream} of optional elements to a {@code Stream} of present value elements: <pre> {@code Stream<Optional<T>> os = .. Stream<T> s = os.flatMap(Optional::stream) } </pre>\n- return: the optional value as a {@code Stream}\n- since: 9"
 ([this] (.stream ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:of
 "-- (T value) -> Optional<T>\nReturns an {@code Optional} describing the given non- {@code null}  value.\n- param value: the value to describe, which must be non- {@code null}\n- param <T>: the type of the value\n- return: an {@code Optional} with the value present\n- throws NullPointerException: if value is {@code null}"
 ([value] (java.util.Optional/of ^"java.lang.Object" value)))

(clojure.core/defn
 Optional:orElseThrow
 "-- () -> T\nIf a value is present, returns the value, otherwise throws {@code NoSuchElementException} .\n- return: the non- {@code null} value described by this {@code Optional}\n- throws NoSuchElementException: if no value is present\n- since: 10\n-- (Supplier<? extends X> exceptionSupplier) -> T\nIf a value is present, returns the value, otherwise throws an exception produced by the exception supplying function.\n- apiNote: A method reference to the exception constructor with an empty argument list can be used as the supplier. For example, {@code IllegalStateException::new}\n- param <X>: Type of the exception to be thrown\n- param exceptionSupplier: the supplying function that produces an exception to be thrown\n- return: the value, if present\n- throws X: if no value is present\n- throws NullPointerException: if no value is present and the exception supplying function is {@code null}"
 ([this] (.orElseThrow ^"java.util.Optional" this))
 ([this exceptionSupplier]
  (.orElseThrow
   ^"java.util.Optional" this
   ^"java.util.function.Supplier" exceptionSupplier)))

(clojure.core/defn
 Optional:isPresent
 "-- () -> boolean\nIf a value is present, returns {@code true} , otherwise {@code false} .\n- return: {@code true} if a value is present, otherwise {@code false}"
 ([this] (.isPresent ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:toString
 "-- () -> String\nReturns a non-empty string representation of this {@code Optional}  suitable for debugging.  The exact presentation format is unspecified and may vary between implementations and versions.\n- implSpec: If a value is present the result must include its string representation in the result.  Empty and present {@code Optional} s must be unambiguously differentiable.\n- return: the string representation of this instance"
 ([this] (.toString ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:flatMap
 "-- (Function<? super T, ? extends Optional<? extends U>> mapper) -> Optional<U>\nIf a value is present, returns the result of applying the given {@code Optional} -bearing mapping function to the value, otherwise returns an empty {@code Optional} .  <p>This method is similar to {@link #map(Function)} , but the mapping function is one whose result is already an {@code Optional} , and if invoked, {@code flatMap} does not wrap it within an additional {@code Optional} .\n- param <U>: The type of value of the {@code Optional} returned by the mapping function\n- param mapper: the mapping function to apply to a value, if present\n- return: the result of applying an {@code Optional} -bearing mapping function to the value of this {@code Optional} , if a value is present, otherwise an empty {@code Optional}\n- throws NullPointerException: if the mapping function is {@code null} or returns a {@code null} result"
 ([this mapper]
  (.flatMap
   ^"java.util.Optional" this
   ^"java.util.function.Function" mapper)))

(clojure.core/defn
 Optional:orElseGet
 "-- (Supplier<? extends T> supplier) -> T\nIf a value is present, returns the value, otherwise returns the result produced by the supplying function.\n- param supplier: the supplying function that produces a value to be returned\n- return: the value, if present, otherwise the result produced by the supplying function\n- throws NullPointerException: if no value is present and the supplying function is {@code null}"
 ([this supplier]
  (.orElseGet
   ^"java.util.Optional" this
   ^"java.util.function.Supplier" supplier)))

(clojure.core/defn
 Optional:ofNullable
 "-- (T value) -> Optional<T>\nReturns an {@code Optional} describing the given value, if non- {@code null} , otherwise returns an empty {@code Optional} .\n- param value: the possibly- {@code null} value to describe\n- param <T>: the type of the value\n- return: an {@code Optional} with a present value if the specified value is non- {@code null} , otherwise an empty {@code Optional}"
 ([value] (java.util.Optional/ofNullable ^"java.lang.Object" value)))

(clojure.core/defn
 Optional:or
 "-- (Supplier<? extends Optional<? extends T>> supplier) -> Optional<T>\nIf a value is present, returns an {@code Optional} describing the value, otherwise returns an {@code Optional} produced by the supplying function.\n- param supplier: the supplying function that produces an {@code Optional}  to be returned\n- return: returns an {@code Optional} describing the value of this  {@code Optional} , if a value is present, otherwise an  {@code Optional} produced by the supplying function.\n- throws NullPointerException: if the supplying function is {@code null} or produces a {@code null} result\n- since: 9"
 ([this supplier]
  (.or
   ^"java.util.Optional" this
   ^"java.util.function.Supplier" supplier)))

(clojure.core/defn
 Optional:filter
 "-- (Predicate<? super T> predicate) -> Optional<T>\nIf a value is present, and the value matches the given predicate, returns an {@code Optional} describing the value, otherwise returns an empty {@code Optional} .\n- param predicate: the predicate to apply to a value, if present\n- return: an {@code Optional} describing the value of this  {@code Optional} , if a value is present and the value matches the given predicate, otherwise an empty {@code Optional}\n- throws NullPointerException: if the predicate is {@code null}"
 ([this predicate]
  (.filter
   ^"java.util.Optional" this
   ^"java.util.function.Predicate" predicate)))

(clojure.core/defn
 Optional:empty
 "-- () -> Optional<T>\nReturns an empty {@code Optional} instance.  No value is present for this {@code Optional} .\n- apiNote: Though it may be tempting to do so, avoid testing if an object is empty by comparing with {@code ==} or {@code !=} against instances returned by {@code Optional.empty()} .  There is no guarantee that it is a singleton. Instead, use {@link #isEmpty()} or {@link #isPresent()} .\n- param <T>: The type of the non-existent value\n- return: an empty {@code Optional}"
 ([] (java.util.Optional/empty)))

(clojure.core/defn
 Optional:ifPresent
 "-- (Consumer<? super T> action) -> void\nIf a value is present, performs the given action with the value, otherwise does nothing.\n- param action: the action to be performed, if a value is present\n- throws NullPointerException: if value is present and the given action is  {@code null}"
 ([this action]
  (.ifPresent
   ^"java.util.Optional" this
   ^"java.util.function.Consumer" action)))

(clojure.core/defn
 Optional:hashCode
 "-- () -> int\nReturns the hash code of the value, if present, otherwise {@code 0}  (zero) if no value is present.\n- return: hash code value of the present value or {@code 0} if no value is present"
 ([this] (.hashCode ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:orElse
 "-- (T other) -> T\nIf a value is present, returns the value, otherwise returns {@code other} .\n- param other: the value to be returned, if no value is present. May be {@code null} .\n- return: the value, if present, otherwise {@code other}"
 ([this other]
  (.orElse ^"java.util.Optional" this ^"java.lang.Object" other)))

(clojure.core/defn
 Optional:isEmpty
 "-- () -> boolean\nIf a value is  not present, returns {@code true} , otherwise {@code false} .\n- return: {@code true} if a value is not present, otherwise {@code false}\n- since: 11"
 ([this] (.isEmpty ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:get
 "-- () -> T\nIf a value is present, returns the value, otherwise throws {@code NoSuchElementException} .\n- apiNote: The preferred alternative to this method is {@link #orElseThrow()} .\n- return: the non- {@code null} value described by this {@code Optional}\n- throws NoSuchElementException: if no value is present"
 ([this] (.get ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:equals
 "-- (Object obj) -> boolean\nIndicates whether some other object is \"equal to\" this {@code Optional} . The other object is considered equal if: <ul> <li>it is also an {@code Optional} and; <li>both instances have no value present or; <li>the present values are \"equal to\" each other via {@code equals()} . </ul>\n- param obj: an object to be tested for equality\n- return: {@code true} if the other object is \"equal to\" this object otherwise {@code false}"
 ([this obj]
  (.equals ^"java.util.Optional" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Optional:ifPresentOrElse
 "-- (Consumer<? super T> action, Runnable emptyAction) -> void\nIf a value is present, performs the given action with the value, otherwise performs the given empty-based action.\n- param action: the action to be performed, if a value is present\n- param emptyAction: the empty-based action to be performed, if no value is present\n- throws NullPointerException: if a value is present and the given action is {@code null} , or no value is present and the given empty-based action is {@code null} .\n- since: 9"
 ([this action emptyAction]
  (.ifPresentOrElse
   ^"java.util.Optional" this
   ^"java.util.function.Consumer" action
   ^"java.lang.Runnable" emptyAction)))

(def
 Optional:class
 "A container object which may or may not contain a non- {@code null} value. If a value is present, {@code isPresent()} returns {@code true} . If no value is present, the object is considered <i>empty</i> and {@code isPresent()} returns {@code false} .  <p>Additional methods that depend on the presence or absence of a contained value are provided, such as {@link #orElse(Object) orElse()}  (returns a default value if no value is present) and {@link #ifPresent(Consumer) ifPresent()} (performs an action if a value is present).  <p>This is a <a href=\" {@docRoot} /java.base/java/lang/doc-files/ValueBased.html\">value-based</a> class; programmers should treat instances that are {@linkplain #equals(Object) equal} as interchangeable and should not use instances for synchronization, or unpredictable behavior may occur. For example, in a future release, synchronization may fail.\n- apiNote: {@code Optional} is primarily intended for use as a method return type where there is a clear need to represent \"no result,\" and where using {@code null}  is likely to cause errors. A variable whose type is {@code Optional} should never itself be {@code null} ; it should always point to an {@code Optional}  instance.\n- param <T>: the type of value\n- since: 1.8"
 java.util.Optional)

(clojure.core/defn
 Optional?
 "Checks if x is an instance of java.util.Optional."
 [x]
 (clojure.core/instance? java.util.Optional x))

(clojure.core/defn
 Class:getDeclaredField
 "-- (String name) -> Field\nReturns a {@code Field} object that reflects the specified declared field of the class or interface represented by this {@code Class}  object. The {@code name} parameter is a {@code String} that specifies the simple name of the desired field.  <p> If this {@code Class} object represents an array type, then this method does not find the {@code length} field of the array type.\n- param name: the name of the field\n- return: the {@code Field} object for the specified field in this class\n- throws NoSuchFieldException: if a field with the specified name is not found.\n- throws NullPointerException: if {@code name} is {@code null}\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of this class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the declared field  <li> the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class  </ul>\n- since: 1.1\n- jls: 8.2 Class Members\n- jls: 8.3 Field Declarations"
 ([this name]
  (.getDeclaredField
   ^"java.lang.Class" this
   ^"java.lang.String" name)))

(clojure.core/defn
 Class:isAnnotation
 "-- () -> boolean\nReturns true if this {@code Class} object represents an annotation interface.  Note that if this method returns true, {@link #isInterface()}  would also return true, as all annotation interfaces are also interfaces.\n- return: {@code true} if this {@code Class} object represents an annotation interface; {@code false} otherwise\n- since: 1.5"
 ([this] (.isAnnotation ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getGenericInterfaces
 "-- () -> Type[]\nReturns the {@code Type} s representing the interfaces directly implemented by the class or interface represented by this {@code Class} object.  <p>If a superinterface is a parameterized type, the {@code Type} object returned for it must accurately reflect the actual type arguments used in the source code. The parameterized type representing each superinterface is created if it had not been created before. See the declaration of {@link java.lang.reflect.ParameterizedType ParameterizedType}  for the semantics of the creation process for parameterized types.  <p>If this {@code Class} object represents a class, the return value is an array containing objects representing all interfaces directly implemented by the class.  The order of the interface objects in the array corresponds to the order of the interface names in the {@code implements} clause of the declaration of the class represented by this {@code Class} object.  <p>If this {@code Class} object represents an interface, the array contains objects representing all interfaces directly extended by the interface.  The order of the interface objects in the array corresponds to the order of the interface names in the {@code extends} clause of the declaration of the interface represented by this {@code Class} object.  <p>If this {@code Class} object represents a class or interface that implements no interfaces, the method returns an array of length 0.  <p>If this {@code Class} object represents a primitive type or void, the method returns an array of length 0.  <p>If this {@code Class} object represents an array type, the interfaces {@code Cloneable} and {@code java.io.Serializable} are returned in that order.\n- throws java.lang.reflect.GenericSignatureFormatError: if the generic class signature does not conform to the format specified in section {@jvms 4.7.9} of <cite>The Java Virtual Machine Specification</cite>\n- throws TypeNotPresentException: if any of the generic superinterfaces refers to a non-existent type declaration\n- throws java.lang.reflect.MalformedParameterizedTypeException: if any of the generic superinterfaces refer to a parameterized type that cannot be instantiated for any reason\n- return: an array of interfaces directly implemented by this class\n- since: 1.5"
 ([this] (.getGenericInterfaces ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredAnnotation
 "-- (Class<A> annotationClass) -> A\n{@inheritDoc}  <p>Note that any annotation returned by this method is a declaration annotation.\n- throws NullPointerException: {@inheritDoc}\n- since: 1.8"
 ([this annotationClass]
  (.getDeclaredAnnotation
   ^"java.lang.Class" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Class:getDeclaredAnnotationsByType
 "-- (Class<A> annotationClass) -> A[]\n{@inheritDoc}  <p>Note that any annotations returned by this method are declaration annotations.\n- throws NullPointerException: {@inheritDoc}\n- since: 1.8"
 ([this annotationClass]
  (.getDeclaredAnnotationsByType
   ^"java.lang.Class" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Class:getNestHost
 "-- () -> Class<?>\nReturns the nest host of the <a href=#nest>nest</a> to which the class or interface represented by this {@code Class} object belongs. Every class and interface belongs to exactly one nest.  If the nest host of this class or interface has previously been determined, then this method returns the nest host. If the nest host of this class or interface has not previously been determined, then this method determines the nest host using the algorithm of JVMS 5.4.4, and returns it.  Often, a class or interface belongs to a nest consisting only of itself, in which case this method returns {@code this} to indicate that the class or interface is the nest host.  <p>If this {@code Class} object represents a primitive type, an array type, or {@code void} , then this method returns {@code this} , indicating that the represented entity belongs to the nest consisting only of itself, and is the nest host.\n- return: the nest host of this class or interface\n- throws SecurityException: If the returned class is not the current class, and if a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the returned class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()}  denies access to the package of the returned class\n- since: 11\n- jvms: 4.7.28 The {@code NestHost} Attribute\n- jvms: 4.7.29 The {@code NestMembers} Attribute\n- jvms: 5.4.4 Access Control"
 ([this] (.getNestHost ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getPackageName
 "-- () -> String\nReturns the fully qualified package name.  <p> If this class is a top level class, then this method returns the fully qualified name of the package that the class is a member of, or the empty string if the class is in an unnamed package.  <p> If this class is a member class, then this method is equivalent to invoking {@code getPackageName()} on the {@linkplain #getEnclosingClass enclosing class} .  <p> If this class is a {@linkplain #isLocalClass local class} or an {@linkplain #isAnonymousClass() anonymous class} , then this method is equivalent to invoking {@code getPackageName()} on the {@linkplain #getDeclaringClass declaring class} of the {@linkplain #getEnclosingMethod enclosing method} or {@linkplain #getEnclosingConstructor enclosing constructor} .  <p> If this class represents an array type then this method returns the package name of the element type. If this class represents a primitive type or void then the package name \" {@code java.lang} \" is returned.\n- return: the fully qualified package name\n- since: 9\n- jls: 6.7 Fully Qualified Names"
 ([this] (.getPackageName ^"java.lang.Class" this)))

(clojure.core/defn
 Class:newInstance
 "-- () -> T\nCreates a new instance of the class represented by this {@code Class}  object.  The class is instantiated as if by a {@code new}  expression with an empty argument list.  The class is initialized if it has not already been initialized.\n- deprecated: This method propagates any exception thrown by the nullary constructor, including a checked exception.  Use of this method effectively bypasses the compile-time exception checking that would otherwise be performed by the compiler. The {@link java.lang.reflect.Constructor#newInstance(java.lang.Object...) Constructor.newInstance} method avoids this problem by wrapping any exception thrown by the constructor in a (checked) {@link java.lang.reflect.InvocationTargetException} .  <p>The call  <pre> {@code clazz.newInstance() } </pre>  can be replaced by  <pre> {@code clazz.getDeclaredConstructor().newInstance() } </pre>  The latter sequence of calls is inferred to be able to throw the additional exception types {@link InvocationTargetException} and {@link NoSuchMethodException} . Both of these exception types are subclasses of {@link ReflectiveOperationException} .\n- return: a newly allocated instance of the class represented by this object.\n- throws IllegalAccessException: if the class or its nullary constructor is not accessible.\n- throws InstantiationException: if this {@code Class} represents an abstract class, an interface, an array class, a primitive type, or void; or if the class has no nullary constructor; or if the instantiation fails for some other reason.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class."
 ([this] (.newInstance ^"java.lang.Class" this)))

(clojure.core/defn
 Class:cast
 "-- (Object obj) -> T\nCasts an object to the class or interface represented by this {@code Class} object.\n- param obj: the object to be cast\n- return: the object after casting, or null if obj is null\n- throws ClassCastException: if the object is not null and is not assignable to the type T.\n- since: 1.5"
 ([this obj] (.cast ^"java.lang.Class" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Class:getResource
 "-- (String name) -> URL\nFinds a resource with a given name.  <p> If this class is in a named {@link Module Module} then this method will attempt to find the resource in the module. This is done by delegating to the module's class loader {@link ClassLoader#findResource(String,String) findResource(String,String)}  method, invoking it with the module name and the absolute name of the resource. Resources in named modules are subject to the rules for encapsulation specified in the {@code Module}  {@link Module#getResourceAsStream getResourceAsStream} method and so this method returns {@code null} when the resource is a non-\" {@code .class} \" resource in a package that is not open to the caller's module.  <p> Otherwise, if this class is not in a named module then the rules for searching resources associated with a given class are implemented by the defining {@linkplain ClassLoader class loader} of the class.  This method delegates to this {@code Class} object's class loader. If this {@code Class} object was loaded by the bootstrap class loader, the method delegates to {@link ClassLoader#getSystemResource} .  <p> Before delegation, an absolute resource name is constructed from the given resource name using this algorithm:  <ul>  <li> If the {@code name} begins with a {@code '/'}  (<code>'&#92;u002f'</code>), then the absolute name of the resource is the portion of the {@code name} following the {@code '/'} .  <li> Otherwise, the absolute name is of the following form:  <blockquote>  {@code modified_package_name/name}  </blockquote>  <p> Where the {@code modified_package_name} is the package name of this object with {@code '/'} substituted for {@code '.'}  (<code>'&#92;u002e'</code>).  </ul>\n- param name: name of the desired resource\n- return: A {@link java.net.URL} object; {@code null} if no resource with this name is found, the resource cannot be located by a URL, the resource is in a package that is not  {@linkplain Module#isOpen(String, Module) open} to at least the caller module, or access to the resource is denied by the security manager.\n- throws NullPointerException: If {@code name} is {@code null}\n- since: 1.1\n- revised: 9"
 ([this name]
  (.getResource ^"java.lang.Class" this ^"java.lang.String" name)))

(clojure.core/defn
 Class:isArray
 "-- () -> boolean\nDetermines if this {@code Class} object represents an array class.\n- return: {@code true} if this {@code Class} object represents an array class;  {@code false} otherwise.\n- since: 1.1"
 ([this] (.isArray ^"java.lang.Class" this)))

(clojure.core/defn
 Class:forName
 "-- (String className) -> Class<?>\nReturns the {@code Class} object associated with the class or interface with the given string name.  Invoking this method is equivalent to:  <blockquote>  {@code Class.forName(className, true, currentLoader)}  </blockquote>  where {@code currentLoader} denotes the defining class loader of the current class.  <p> For example, the following code fragment returns the runtime {@code Class} descriptor for the class named {@code java.lang.Thread} :  <blockquote>  {@code Class t = Class.forName(\"java.lang.Thread\")}  </blockquote> <p> A call to {@code forName(\"X\")} causes the class named {@code X} to be initialized.\n- param className: the fully qualified name of the desired class.\n- return: the {@code Class} object for the class with the specified name.\n- throws LinkageError: if the linkage fails\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails\n- throws ClassNotFoundException: if the class cannot be located\n- jls: 12.2 Loading of Classes and Interfaces\n- jls: 12.3 Linking of Classes and Interfaces\n- jls: 12.4 Initialization of Classes and Interfaces\n-- (Module module, String name) -> Class<?>\nReturns the {@code Class} with the given <a href=\"ClassLoader.html#binary-name\"> binary name</a> in the given module.  <p> This method attempts to locate and load the class or interface. It does not link the class, and does not run the class initializer. If the class is not found, this method returns {@code null} . </p>  <p> If the class loader of the given module defines other modules and the given name is a class defined in a different module, this method returns {@code null} after the class is loaded. </p>  <p> This method does not check whether the requested class is accessible to its caller. </p>\n- apiNote: This method returns {@code null} on failure rather than throwing a {@link ClassNotFoundException} , as is done by the {@link #forName(String, boolean, ClassLoader)} method. The security check is a stack-based permission check if the caller loads a class in another module.\n- param module: A module\n- param name: The <a href=\"ClassLoader.html#binary-name\">binary name</a> of the class\n- return: {@code Class} object of the given name defined in the given module;  {@code null} if not found.\n- throws NullPointerException: if the given module or name is {@code null}\n- throws LinkageError: if the linkage fails\n- throws SecurityException: <ul> <li> if the caller is not the specified module and  {@code RuntimePermission(\"getClassLoader\")} permission is denied; or</li> <li> access to the module content is denied. For example, permission check will be performed when a class loader calls  {@link ModuleReader#open(String)} to read the bytes of a class file in a module.</li> </ul>\n- jls: 12.2 Loading of Classes and Interfaces\n- jls: 12.3 Linking of Classes and Interfaces\n- since: 9\n-- (String name, boolean initialize, ClassLoader loader) -> Class<?>\nReturns the {@code Class} object associated with the class or interface with the given string name, using the given class loader. Given the fully qualified name for a class or interface (in the same format returned by {@code getName} ) this method attempts to locate and load the class or interface.  The specified class loader is used to load the class or interface.  If the parameter {@code loader} is null, the class is loaded through the bootstrap class loader.  The class is initialized only if the {@code initialize} parameter is {@code true} and if it has not been initialized earlier.  <p> If {@code name} denotes a primitive type or void, an attempt will be made to locate a user-defined class in the unnamed package whose name is {@code name} . Therefore, this method cannot be used to obtain any of the {@code Class} objects representing primitive types or void.  <p> If {@code name} denotes an array class, the component type of the array class is loaded but not initialized.  <p> For example, in an instance method the expression:  <blockquote>  {@code Class.forName(\"Foo\")}  </blockquote>  is equivalent to:  <blockquote>  {@code Class.forName(\"Foo\", true, this.getClass().getClassLoader())}  </blockquote>  Note that this method throws errors related to loading, linking or initializing as specified in Sections {@jls 12.2} , {@jls 12.3} , and {@jls 12.4} of <cite>The Java Language Specification</cite>. Note that this method does not check whether the requested class is accessible to its caller.\n- param name: fully qualified name of the desired class\n- param initialize: if {@code true} the class will be initialized (which implies linking). See Section {@jls 12.4} of <cite>The Java Language Specification</cite>.\n- param loader: class loader from which the class must be loaded\n- return: class object representing the desired class\n- throws LinkageError: if the linkage fails\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails\n- throws ClassNotFoundException: if the class cannot be located by the specified class loader\n- throws SecurityException: if a security manager is present, and the {@code loader} is  {@code null} , and the caller's class loader is not  {@code null} , and the caller does not have the  {@link RuntimePermission} {@code (\"getClassLoader\")}\n- see: java.lang.Class#forName(String)\n- see: java.lang.ClassLoader\n- jls: 12.2 Loading of Classes and Interfaces\n- jls: 12.3 Linking of Classes and Interfaces\n- jls: 12.4 Initialization of Classes and Interfaces\n- since: 1.2"
 ([className] (java.lang.Class/forName ^"java.lang.String" className))
 ([module name]
  (java.lang.Class/forName
   ^"java.lang.Module" module
   ^"java.lang.String" name))
 ([name initialize loader]
  (java.lang.Class/forName
   ^"java.lang.String" name
   ^"boolean" initialize
   ^"java.lang.ClassLoader" loader)))

(clojure.core/defn
 Class:getProtectionDomain
 "-- () -> java.security.ProtectionDomain\nReturns the {@code ProtectionDomain} of this class.  If there is a security manager installed, this method first calls the security manager's {@code checkPermission} method with a {@code RuntimePermission(\"getProtectionDomain\")} permission to ensure it's ok to get the {@code ProtectionDomain} .\n- return: the ProtectionDomain of this class\n- throws SecurityException: if a security manager exists and its  {@code checkPermission} method doesn't allow getting the ProtectionDomain.\n- see: java.security.ProtectionDomain\n- see: SecurityManager#checkPermission\n- see: java.lang.RuntimePermission\n- since: 1.2"
 ([this] (.getProtectionDomain ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getSuperclass
 "-- () -> Class<? super T>\nReturns the {@code Class} representing the direct superclass of the entity (class, interface, primitive type or void) represented by this {@code Class} .  If this {@code Class} represents either the {@code Object} class, an interface, a primitive type, or void, then null is returned.  If this {@code Class} object represents an array class then the {@code Class} object representing the {@code Object} class is returned.\n- return: the direct superclass of the class represented by this {@code Class} object"
 ([this] (.getSuperclass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:toGenericString
 "-- () -> String\nReturns a string describing this {@code Class} , including information about modifiers and type parameters.  The string is formatted as a list of type modifiers, if any, followed by the kind of type (empty string for primitive types and {@code class} , {@code enum} , {@code interface} , {@code @interface} , or {@code record} as appropriate), followed by the type's name, followed by an angle-bracketed comma-separated list of the type's type parameters, if any, including informative bounds on the type parameters, if any.  A space is used to separate modifiers from one another and to separate any modifiers from the kind of type. The modifiers occur in canonical order. If there are no type parameters, the type parameter list is elided.  For an array type, the string starts with the type name, followed by an angle-bracketed comma-separated list of the type's type parameters, if any, followed by a sequence of {@code []} characters, one set of brackets per dimension of the array.  <p>Note that since information about the runtime representation of a type is being generated, modifiers not present on the originating source code or illegal on the originating source code may be present.\n- return: a string describing this {@code Class} , including information about modifiers and type parameters\n- since: 1.8"
 ([this] (.toGenericString ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredConstructors
 "-- () -> Constructor<?>[]\nReturns an array of {@code Constructor} objects reflecting all the constructors declared by the class represented by this {@code Class} object. These are public, protected, default (package) access, and private constructors.  The elements in the array returned are not sorted and are not in any particular order.  If the class has a default constructor, it is included in the returned array. This method returns an array of length 0 if this {@code Class}  object represents an interface, a primitive type, an array class, or void.  <p> See <cite>The Java Language Specification</cite>, section {@jls 8.2} .\n- return: the array of {@code Constructor} objects representing all the declared constructors of this class\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of this class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the declared constructors within this class  <li> the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class  </ul>\n- since: 1.1"
 ([this] (.getDeclaredConstructors ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getModifiers
 "-- () -> int\nReturns the Java language modifiers for this class or interface, encoded in an integer. The modifiers consist of the Java Virtual Machine's constants for {@code public} , {@code protected} , {@code private} , {@code final} , {@code static} , {@code abstract} and {@code interface} ; they should be decoded using the methods of class {@code Modifier} .  <p> If the underlying class is an array class, then its {@code public} , {@code private} and {@code protected}  modifiers are the same as those of its component type.  If this {@code Class} object represents a primitive type or void, its {@code public} modifier is always {@code true} , and its {@code protected} and {@code private} modifiers are always {@code false} . If this {@code Class} object represents an array class, a primitive type or void, then its {@code final} modifier is always {@code true} and its interface modifier is always {@code false} . The values of its other modifiers are not determined by this specification.  <p> The modifier encodings are defined in section {@jvms 4.1}  of <cite>The Java Virtual Machine Specification</cite>.\n- return: the {@code int} representing the modifiers for this class\n- see: java.lang.reflect.Modifier\n- since: 1.1"
 ([this] (.getModifiers ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getResourceAsStream
 "-- (String name) -> InputStream\nFinds a resource with a given name.  <p> If this class is in a named {@link Module Module} then this method will attempt to find the resource in the module. This is done by delegating to the module's class loader {@link ClassLoader#findResource(String,String) findResource(String,String)}  method, invoking it with the module name and the absolute name of the resource. Resources in named modules are subject to the rules for encapsulation specified in the {@code Module}  {@link Module#getResourceAsStream getResourceAsStream} method and so this method returns {@code null} when the resource is a non-\" {@code .class} \" resource in a package that is not open to the caller's module.  <p> Otherwise, if this class is not in a named module then the rules for searching resources associated with a given class are implemented by the defining {@linkplain ClassLoader class loader} of the class.  This method delegates to this {@code Class} object's class loader. If this {@code Class} object was loaded by the bootstrap class loader, the method delegates to {@link ClassLoader#getSystemResourceAsStream} .  <p> Before delegation, an absolute resource name is constructed from the given resource name using this algorithm:  <ul>  <li> If the {@code name} begins with a {@code '/'}  (<code>'&#92;u002f'</code>), then the absolute name of the resource is the portion of the {@code name} following the {@code '/'} .  <li> Otherwise, the absolute name is of the following form:  <blockquote>  {@code modified_package_name/name}  </blockquote>  <p> Where the {@code modified_package_name} is the package name of this object with {@code '/'} substituted for {@code '.'}  (<code>'&#92;u002e'</code>).  </ul>\n- param name: name of the desired resource\n- return: A {@link java.io.InputStream} object; {@code null} if no resource with this name is found, the resource is in a package that is not {@linkplain Module#isOpen(String, Module) open} to at least the caller module, or access to the resource is denied by the security manager.\n- throws NullPointerException: If {@code name} is {@code null}\n- see: Module#getResourceAsStream(String)\n- since: 1.1\n- revised: 9"
 ([this name]
  (.getResourceAsStream
   ^"java.lang.Class" this
   ^"java.lang.String" name)))

(clojure.core/defn
 Class:arrayType
 "-- () -> Class<?>\nReturns a {@code Class} for an array type whose component type is described by this {@linkplain Class} .\n- return: a {@code Class} describing the array type\n- since: 12"
 ([this] (.arrayType ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getEnumConstants
 "-- () -> T[]\nReturns the elements of this enum class or null if this Class object does not represent an enum class.\n- return: an array containing the values comprising the enum class represented by this {@code Class} object in the order they're declared, or null if this {@code Class} object does not represent an enum class\n- since: 1.5"
 ([this] (.getEnumConstants ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotatedSuperclass
 "-- () -> AnnotatedType\nReturns an {@code AnnotatedType} object that represents the use of a type to specify the superclass of the entity represented by this {@code Class} object. (The <em>use</em> of type Foo to specify the superclass in '...  extends Foo' is distinct from the <em>declaration</em> of class Foo.)  <p> If this {@code Class} object represents a class whose declaration does not explicitly indicate an annotated superclass, then the return value is an {@code AnnotatedType} object representing an element with no annotations.  <p> If this {@code Class} represents either the {@code Object} class, an interface type, an array type, a primitive type, or void, the return value is {@code null} .\n- return: an object representing the superclass\n- since: 1.8"
 ([this] (.getAnnotatedSuperclass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isSynthetic
 "-- () -> boolean\nReturns {@code true} if and only if this class has the synthetic modifier bit set.\n- return: {@code true} if and only if this class has the synthetic modifier bit set\n- jls: 13.1 The Form of a Binary\n- jvms: 4.1 The {@code ClassFile} Structure\n- since: 1.5"
 ([this] (.isSynthetic ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getInterfaces
 "-- () -> Class<?>[]\nReturns the interfaces directly implemented by the class or interface represented by this {@code Class} object.  <p>If this {@code Class} object represents a class, the return value is an array containing objects representing all interfaces directly implemented by the class.  The order of the interface objects in the array corresponds to the order of the interface names in the {@code implements} clause of the declaration of the class represented by this {@code Class} object.  For example, given the declaration: <blockquote> {@code class Shimmer implements FloorWax, DessertTopping { ... } } </blockquote> suppose the value of {@code s} is an instance of {@code Shimmer} ; the value of the expression: <blockquote> {@code s.getClass().getInterfaces()[0]}  </blockquote> is the {@code Class} object that represents interface {@code FloorWax} ; and the value of: <blockquote> {@code s.getClass().getInterfaces()[1]}  </blockquote> is the {@code Class} object that represents interface {@code DessertTopping} .  <p>If this {@code Class} object represents an interface, the array contains objects representing all interfaces directly extended by the interface.  The order of the interface objects in the array corresponds to the order of the interface names in the {@code extends} clause of the declaration of the interface represented by this {@code Class} object.  <p>If this {@code Class} object represents a class or interface that implements no interfaces, the method returns an array of length 0.  <p>If this {@code Class} object represents a primitive type or void, the method returns an array of length 0.  <p>If this {@code Class} object represents an array type, the interfaces {@code Cloneable} and {@code java.io.Serializable} are returned in that order.\n- return: an array of interfaces directly implemented by this class\n-- (boolean cloneArray) -> Class<?>[]"
 ([this] (.getInterfaces ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getCanonicalName
 "-- () -> String\nReturns the canonical name of the underlying class as defined by <cite>The Java Language Specification</cite>. Returns {@code null} if the underlying class does not have a canonical name. Classes without canonical names include: <ul> <li>a {@linkplain #isLocalClass() local class}  <li>a {@linkplain #isAnonymousClass() anonymous class}  <li>a {@linkplain #isHidden() hidden class}  <li>an array whose component type does not have a canonical name</li> </ul>\n- return: the canonical name of the underlying class if it exists, and {@code null} otherwise.\n- since: 1.5"
 ([this] (.getCanonicalName ^"java.lang.Class" this)))

(clojure.core/defn
 Class:toString
 "-- () -> String\nConverts the object to a string. The string representation is the string \"class\" or \"interface\", followed by a space, and then by the name of the class in the format returned by {@code getName} . If this {@code Class} object represents a primitive type, this method returns the name of the primitive type.  If this {@code Class} object represents void this method returns \"void\". If this {@code Class} object represents an array type, this method returns \"class \" followed by {@code getName} .\n- return: a string representation of this {@code Class} object."
 ([this] (.toString ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotation
 "-- (Class<A> annotationClass) -> A\n{@inheritDoc}  <p>Note that any annotation returned by this method is a declaration annotation.\n- throws NullPointerException: {@inheritDoc}\n- since: 1.5"
 ([this annotationClass]
  (.getAnnotation
   ^"java.lang.Class" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Class:isAssignableFrom
 "-- (Class<?> cls) -> boolean\nDetermines if the class or interface represented by this {@code Class} object is either the same as, or is a superclass or superinterface of, the class or interface represented by the specified {@code Class} parameter. It returns {@code true} if so; otherwise it returns {@code false} . If this {@code Class}  object represents a primitive type, this method returns {@code true} if the specified {@code Class} parameter is exactly this {@code Class} object; otherwise it returns {@code false} .  <p> Specifically, this method tests whether the type represented by the specified {@code Class} parameter can be converted to the type represented by this {@code Class} object via an identity conversion or via a widening reference conversion. See <cite>The Java Language Specification</cite>, sections {@jls 5.1.1} and {@jls 5.1.4} , for details.\n- param cls: the {@code Class} object to be checked\n- return: the {@code boolean} value indicating whether objects of the type {@code cls} can be assigned to objects of this class\n- throws NullPointerException: if the specified Class parameter is null.\n- since: 1.1"
 ([this cls]
  (.isAssignableFrom ^"java.lang.Class" this ^"java.lang.Class" cls)))

(clojure.core/defn
 Class:isInterface
 "-- () -> boolean\nDetermines if this {@code Class} object represents an interface type.\n- return: {@code true} if this {@code Class} object represents an interface;  {@code false} otherwise."
 ([this] (.isInterface ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isPrimitive
 "-- () -> boolean\nDetermines if the specified {@code Class} object represents a primitive type.  <p> There are nine predefined {@code Class} objects to represent the eight primitive types and void.  These are created by the Java Virtual Machine, and have the same names as the primitive types that they represent, namely {@code boolean} , {@code byte} , {@code char} , {@code short} , {@code int} , {@code long} , {@code float} , and {@code double} .  <p> These objects may only be accessed via the following public static final variables, and are the only {@code Class} objects for which this method returns {@code true} .\n- return: true if and only if this class represents a primitive type\n- see: java.lang.Boolean#TYPE\n- see: java.lang.Character#TYPE\n- see: java.lang.Byte#TYPE\n- see: java.lang.Short#TYPE\n- see: java.lang.Integer#TYPE\n- see: java.lang.Long#TYPE\n- see: java.lang.Float#TYPE\n- see: java.lang.Double#TYPE\n- see: java.lang.Void#TYPE\n- since: 1.1"
 ([this] (.isPrimitive ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getClasses
 "-- () -> Class<?>[]\nReturns an array containing {@code Class} objects representing all the public classes and interfaces that are members of the class represented by this {@code Class} object.  This includes public class and interface members inherited from superclasses and public class and interface members declared by the class.  This method returns an array of length 0 if this {@code Class} object has no public member classes or interfaces.  This method also returns an array of length 0 if this {@code Class} object represents a primitive type, an array class, or void.\n- return: the array of {@code Class} objects representing the public members of this class\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class.\n- since: 1.1"
 ([this] (.getClasses ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredAnnotations
 "-- () -> Annotation[]\n{@inheritDoc}  <p>Note that any annotations returned by this method are declaration annotations.\n- since: 1.5"
 ([this] (.getDeclaredAnnotations ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getName
 "-- () -> String\nReturns the  name of the entity (class, interface, array class, primitive type, or void) represented by this {@code Class} object.  <p> If this {@code Class} object represents a class or interface, not an array class, then: <ul> <li> If the class or interface is not {@linkplain #isHidden() hidden} , then the <a href=\"ClassLoader.html#binary-name\">binary name</a> of the class or interface is returned. <li> If the class or interface is hidden, then the result is a string of the form: {@code N + '/' + <suffix>}  where {@code N} is the <a href=\"ClassLoader.html#binary-name\">binary name</a> indicated by the {@code class} file passed to  {@link java.lang.invoke.MethodHandles.Lookup#defineHiddenClass(byte[], boolean, MethodHandles.Lookup.ClassOption...) Lookup::defineHiddenClass} , and {@code <suffix>} is an unqualified name. </ul>  <p> If this {@code Class} object represents an array class, then the result is a string consisting of one or more ' {@code [} ' characters representing the depth of the array nesting, followed by the element type as encoded using the following table:  <blockquote><table class=\"striped\"> <caption style=\"display:none\">Element types and encodings</caption> <thead> <tr><th scope=\"col\"> Element Type <th scope=\"col\"> Encoding </thead> <tbody style=\"text-align:left\"> <tr><th scope=\"row\"> {@code boolean} <td style=\"text-align:center\"> {@code Z}  <tr><th scope=\"row\"> {@code byte} <td style=\"text-align:center\"> {@code B}  <tr><th scope=\"row\"> {@code char} <td style=\"text-align:center\"> {@code C}  <tr><th scope=\"row\"> class or interface with <a href=\"ClassLoader.html#binary-name\">binary name</a> <i>N</i> <td style=\"text-align:center\"> {@code L} <em>N</em> {@code ;}  <tr><th scope=\"row\"> {@code double} <td style=\"text-align:center\"> {@code D}  <tr><th scope=\"row\"> {@code float} <td style=\"text-align:center\"> {@code F}  <tr><th scope=\"row\"> {@code int} <td style=\"text-align:center\"> {@code I}  <tr><th scope=\"row\"> {@code long} <td style=\"text-align:center\"> {@code J}  <tr><th scope=\"row\"> {@code short} <td style=\"text-align:center\"> {@code S}  </tbody> </table></blockquote>  <p> If this {@code Class} object represents a primitive type or {@code void} , then the result is a string with the same spelling as the Java language keyword which corresponds to the primitive type or {@code void} .  <p> Examples: <blockquote><pre> String.class.getName() returns \"java.lang.String\" byte.class.getName() returns \"byte\" (new Object[3]).getClass().getName() returns \"[Ljava.lang.Object;\" (new int[3][4][5][6][7][8][9]).getClass().getName() returns \"[[[[[[[I\" </pre></blockquote>\n- return: the name of the class, interface, or other entity represented by this {@code Class} object.\n- jls: 13.1 The Form of a Binary"
 ([this] (.getName ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isAnonymousClass
 "-- () -> boolean\nReturns {@code true} if and only if the underlying class is an anonymous class.\n- apiNote: An anonymous class is not a {@linkplain #isHidden() hidden class} .\n- return: {@code true} if and only if this class is an anonymous class.\n- since: 1.5"
 ([this] (.isAnonymousClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getEnclosingConstructor
 "-- () -> Constructor<?>\nIf this {@code Class} object represents a local or anonymous class within a constructor, returns a {@link java.lang.reflect.Constructor Constructor} object representing the immediately enclosing constructor of the underlying class. Returns {@code null} otherwise.  In particular, this method returns {@code null} if the underlying class is a local or anonymous class immediately enclosed by a class or interface declaration, instance initializer or static initializer.\n- return: the immediately enclosing constructor of the underlying class, if that class is a local or anonymous class; otherwise {@code null} .\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of the enclosing class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the constructors within the enclosing class  <li> the caller's class loader is not the same as or an ancestor of the class loader for the enclosing class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of the enclosing class  </ul>\n- since: 1.5"
 ([this] (.getEnclosingConstructor ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotations
 "-- () -> Annotation[]\n{@inheritDoc}  <p>Note that any annotations returned by this method are declaration annotations.\n- since: 1.5"
 ([this] (.getAnnotations ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getModule
 "-- () -> Module\nReturns the module that this class or interface is a member of.  If this class represents an array type then this method returns the {@code Module} for the element type. If this class represents a primitive type or void, then the {@code Module} object for the {@code java.base} module is returned.  If this class is in an unnamed module then the {@linkplain ClassLoader#getUnnamedModule() unnamed}  {@code Module} of the class loader for this class is returned.\n- return: the module that this class or interface is a member of\n- since: 9"
 ([this] (.getModule ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotatedInterfaces
 "-- () -> AnnotatedType[]\nReturns an array of {@code AnnotatedType} objects that represent the use of types to specify superinterfaces of the entity represented by this {@code Class} object. (The <em>use</em> of type Foo to specify a superinterface in '... implements Foo' is distinct from the <em>declaration</em> of interface Foo.)  <p> If this {@code Class} object represents a class, the return value is an array containing objects representing the uses of interface types to specify interfaces implemented by the class. The order of the objects in the array corresponds to the order of the interface types used in the 'implements' clause of the declaration of this {@code Class} object.  <p> If this {@code Class} object represents an interface, the return value is an array containing objects representing the uses of interface types to specify interfaces directly extended by the interface. The order of the objects in the array corresponds to the order of the interface types used in the 'extends' clause of the declaration of this {@code Class} object.  <p> If this {@code Class} object represents a class or interface whose declaration does not explicitly indicate any annotated superinterfaces, the return value is an array of length 0.  <p> If this {@code Class} object represents either the {@code Object}  class, an array type, a primitive type, or void, the return value is an array of length 0.\n- return: an array representing the superinterfaces\n- since: 1.8"
 ([this] (.getAnnotatedInterfaces ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getTypeParameters
 "-- () -> TypeVariable<Class<T>>[]\nReturns an array of {@code TypeVariable} objects that represent the type variables declared by the generic declaration represented by this {@code GenericDeclaration} object, in declaration order.  Returns an array of length 0 if the underlying generic declaration declares no type variables.\n- return: an array of {@code TypeVariable} objects that represent the type variables declared by this generic declaration\n- throws java.lang.reflect.GenericSignatureFormatError: if the generic signature of this generic declaration does not conform to the format specified in section {@jvms 4.7.9} of <cite>The Java Virtual Machine Specification</cite>\n- since: 1.5"
 ([this] (.getTypeParameters ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getPermittedSubclasses
 "-- () -> Class<?>[]\n{@preview Associated with sealed classes, a preview feature of the Java language.  This method is associated with <i>sealed classes</i>, a preview feature of the Java language. Preview features may be removed in a future release, or upgraded to permanent features of the Java language.}   Returns an array containing {@code Class} objects representing the direct subinterfaces or subclasses permitted to extend or implement this class or interface if it is sealed.  The order of such elements is unspecified. The array is empty if this sealed class or interface has no permitted subclass. If this {@code Class} object represents a primitive type, {@code void} , an array type, or a class or interface that is not sealed, that is {@link #isSealed()} returns {@code false} , then this method returns {@code null} . Conversely, if {@link #isSealed()} returns {@code true} , then this method returns a non-null value.  For each class or interface {@code C} which is recorded as a permitted direct subinterface or subclass of this class or interface, this method attempts to obtain the {@code Class}  object for {@code C} (using {@linkplain #getClassLoader() the defining class loader} of the current {@code Class} object). The {@code Class} objects which can be obtained and which are direct subinterfaces or subclasses of this class or interface, are indicated by elements of the returned array. If a {@code Class} object cannot be obtained, it is silently ignored, and not included in the result array.\n- return: an array of {@code Class} objects of the permitted subclasses of this class or interface, or {@code null} if this class or interface is not sealed.\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for that returned class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()}  denies access to the package of any class in the returned array.\n- jls: 8.1 Class Declarations\n- jls: 9.1 Interface Declarations\n- since: 15"
 ([this] (.getPermittedSubclasses ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getClassLoader
 "-- () -> ClassLoader\nReturns the class loader for the class.  Some implementations may use null to represent the bootstrap class loader. This method will return null in such implementations if this class was loaded by the bootstrap class loader.  <p>If this {@code Class} object represents a primitive type or void, null is returned.\n- return: the class loader that loaded the class or interface represented by this {@code Class} object.\n- throws SecurityException: if a security manager is present, and the caller's class loader is not {@code null} and is not the same as or an ancestor of the class loader for the class whose class loader is requested, and the caller does not have the  {@link RuntimePermission} {@code (\"getClassLoader\")}\n- see: java.lang.ClassLoader\n- see: SecurityManager#checkPermission\n- see: java.lang.RuntimePermission"
 ([this] (.getClassLoader ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getField
 "-- (String name) -> Field\nReturns a {@code Field} object that reflects the specified public member field of the class or interface represented by this {@code Class}  object. The {@code name} parameter is a {@code String} specifying the simple name of the desired field.  <p> The field to be reflected is determined by the algorithm that follows.  Let C be the class or interface represented by this {@code Class} object:  <OL> <LI> If C declares a public field with the name specified, that is the field to be reflected.</LI> <LI> If no field was found in step 1 above, this algorithm is applied recursively to each direct superinterface of C. The direct superinterfaces are searched in the order they were declared.</LI> <LI> If no field was found in steps 1 and 2 above, and C has a superclass S, then this algorithm is invoked recursively upon S. If C has no superclass, then a {@code NoSuchFieldException}  is thrown.</LI> </OL>  <p> If this {@code Class} object represents an array type, then this method does not find the {@code length} field of the array type.\n- param name: the field name\n- return: the {@code Field} object of this class specified by  {@code name}\n- throws NoSuchFieldException: if a field with the specified name is not found.\n- throws NullPointerException: if {@code name} is {@code null}\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class.\n- since: 1.1\n- jls: 8.2 Class Members\n- jls: 8.3 Field Declarations"
 ([this name]
  (.getField ^"java.lang.Class" this ^"java.lang.String" name)))

(clojure.core/defn
 Class:isRecord
 "-- () -> boolean\nReturns {@code true} if and only if this class is a record class.  <p> The {@linkplain #getSuperclass() direct superclass} of a record class is {@code java.lang.Record} . A record class is {@linkplain Modifier#FINAL final} . A record class has (possibly zero) record components; {@link #getRecordComponents()} returns a non-null but possibly empty value for a record.  <p> Note that class {@link Record} is not a record class and thus invoking this method on class {@code Record} returns {@code false} .\n- return: true if and only if this class is a record class, otherwise false\n- jls: 8.10 Record Classes\n- since: 16"
 ([this] (.isRecord ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getNestMembers
 "-- () -> Class<?>[]\nReturns an array containing {@code Class} objects representing all the classes and interfaces that are members of the nest to which the class or interface represented by this {@code Class} object belongs.  First, this method obtains the {@linkplain #getNestHost() nest host} , {@code H} , of the nest to which the class or interface represented by this {@code Class} object belongs. The zeroth element of the returned array is {@code H} .  Then, for each class or interface {@code C} which is recorded by {@code H}  as being a member of its nest, this method attempts to obtain the {@code Class}  object for {@code C} (using {@linkplain #getClassLoader() the defining class loader} of the current {@code Class} object), and then obtains the {@linkplain #getNestHost() nest host} of the nest to which {@code C} belongs. The classes and interfaces which are recorded by {@code H} as being members of its nest, and for which {@code H} can be determined as their nest host, are indicated by subsequent elements of the returned array. The order of such elements is unspecified. Duplicates are permitted.  <p>If this {@code Class} object represents a primitive type, an array type, or {@code void} , then this method returns a single-element array containing {@code this} .\n- apiNote: The returned array includes only the nest members recorded in the {@code NestMembers}  attribute, and not any hidden classes that were added to the nest via {@link MethodHandles.Lookup#defineHiddenClass(byte[], boolean, MethodHandles.Lookup.ClassOption...) Lookup::defineHiddenClass} .\n- return: an array of all classes and interfaces in the same nest as this class or interface\n- throws SecurityException: If any returned class is not the current class, and if a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for that returned class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()}  denies access to the package of that returned class\n- since: 11\n- see: #getNestHost()\n- jvms: 4.7.28 The {@code NestHost} Attribute\n- jvms: 4.7.29 The {@code NestMembers} Attribute"
 ([this] (.getNestMembers ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getEnclosingMethod
 "-- () -> Method\nIf this {@code Class} object represents a local or anonymous class within a method, returns a {@link java.lang.reflect.Method Method} object representing the immediately enclosing method of the underlying class. Returns {@code null} otherwise.  In particular, this method returns {@code null} if the underlying class is a local or anonymous class immediately enclosed by a class or interface declaration, instance initializer or static initializer.\n- return: the immediately enclosing method of the underlying class, if that class is a local or anonymous class; otherwise {@code null} .\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of the enclosing class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the methods within the enclosing class  <li> the caller's class loader is not the same as or an ancestor of the class loader for the enclosing class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of the enclosing class  </ul>\n- since: 1.5"
 ([this] (.getEnclosingMethod ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isHidden
 "-- () -> boolean\nReturns {@code true} if and only if the underlying class is a hidden class.\n- return: {@code true} if and only if this class is a hidden class.\n- since: 15\n- see: MethodHandles.Lookup#defineHiddenClass"
 ([this] (.isHidden ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getGenericSuperclass
 "-- () -> Type\nReturns the {@code Type} representing the direct superclass of the entity (class, interface, primitive type or void) represented by this {@code Class} object.  <p>If the superclass is a parameterized type, the {@code Type}  object returned must accurately reflect the actual type arguments used in the source code. The parameterized type representing the superclass is created if it had not been created before. See the declaration of {@link java.lang.reflect.ParameterizedType ParameterizedType} for the semantics of the creation process for parameterized types.  If this {@code Class} object represents either the {@code Object}  class, an interface, a primitive type, or void, then null is returned.  If this {@code Class} object represents an array class then the {@code Class} object representing the {@code Object} class is returned.\n- throws java.lang.reflect.GenericSignatureFormatError: if the generic class signature does not conform to the format specified in section {@jvms 4.7.9} of <cite>The Java Virtual Machine Specification</cite>\n- throws TypeNotPresentException: if the generic superclass refers to a non-existent type declaration\n- throws java.lang.reflect.MalformedParameterizedTypeException: if the generic superclass refers to a parameterized type that cannot be instantiated  for any reason\n- return: the direct superclass of the class represented by this {@code Class} object\n- since: 1.5"
 ([this] (.getGenericSuperclass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isInstance
 "-- (Object obj) -> boolean\nDetermines if the specified {@code Object} is assignment-compatible with the object represented by this {@code Class} .  This method is the dynamic equivalent of the Java language {@code instanceof}  operator. The method returns {@code true} if the specified {@code Object} argument is non-null and can be cast to the reference type represented by this {@code Class} object without raising a {@code ClassCastException.} It returns {@code false}  otherwise.  <p> Specifically, if this {@code Class} object represents a declared class, this method returns {@code true} if the specified {@code Object} argument is an instance of the represented class (or of any of its subclasses); it returns {@code false} otherwise. If this {@code Class} object represents an array class, this method returns {@code true} if the specified {@code Object} argument can be converted to an object of the array class by an identity conversion or by a widening reference conversion; it returns {@code false} otherwise. If this {@code Class} object represents an interface, this method returns {@code true} if the class or any superclass of the specified {@code Object} argument implements this interface; it returns {@code false} otherwise. If this {@code Class} object represents a primitive type, this method returns {@code false} .\n- param obj: the object to check\n- return: true if {@code obj} is an instance of this class\n- since: 1.1"
 ([this obj]
  (.isInstance ^"java.lang.Class" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Class:componentType
 "-- () -> Class<?>\nReturns the component type of this {@code Class} , if it describes an array type, or {@code null} otherwise.\n- implSpec: Equivalent to {@link Class#getComponentType()} .\n- return: a {@code Class} describing the component type, or {@code null}  if this {@code Class} does not describe an array type\n- since: 12"
 ([this] (.componentType ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getConstructor
 "-- (Class<?> parameterTypes) -> Constructor<T>\nReturns a {@code Constructor} object that reflects the specified public constructor of the class represented by this {@code Class}  object. The {@code parameterTypes} parameter is an array of {@code Class} objects that identify the constructor's formal parameter types, in declared order.  If this {@code Class} object represents an inner class declared in a non-static context, the formal parameter types include the explicit enclosing instance as the first parameter.  <p> The constructor to reflect is the public constructor of the class represented by this {@code Class} object whose formal parameter types match those specified by {@code parameterTypes} .\n- param parameterTypes: the parameter array\n- return: the {@code Constructor} object of the public constructor that matches the specified {@code parameterTypes}\n- throws NoSuchMethodException: if a matching method is not found.\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class.\n- since: 1.1"
 ([this parameterTypes]
  (.getConstructor
   ^"java.lang.Class" this
   ^"[Ljava.lang.Class;" parameterTypes)))

(clojure.core/defn
 Class:getMethods
 "-- () -> Method[]\nReturns an array containing {@code Method} objects reflecting all the public methods of the class or interface represented by this {@code Class} object, including those declared by the class or interface and those inherited from superclasses and superinterfaces.  <p> If this {@code Class} object represents an array type, then the returned array has a {@code Method} object for each of the public methods inherited by the array type from {@code Object} . It does not contain a {@code Method} object for {@code clone()} .  <p> If this {@code Class} object represents an interface then the returned array does not contain any implicitly declared methods from {@code Object} . Therefore, if no methods are explicitly declared in this interface or any of its superinterfaces then the returned array has length 0. (Note that a {@code Class} object which represents a class always has public methods, inherited from {@code Object} .)  <p> The returned array never contains methods with names \" {@code <init>} \" or \" {@code <clinit>} \".  <p> The elements in the returned array are not sorted and are not in any particular order.  <p> Generally, the result is computed as with the following 4 step algorithm. Let C be the class or interface represented by this {@code Class} object: <ol> <li> A union of methods is composed of: <ol type=\"a\"> <li> C's declared public instance and static methods as returned by  {@link #getDeclaredMethods()} and filtered to include only public methods.</li> <li> If C is a class other than {@code Object} , then include the result of invoking this algorithm recursively on the superclass of C.</li> <li> Include the results of invoking this algorithm recursively on all direct superinterfaces of C, but include only instance methods.</li> </ol></li> <li> Union from step 1 is partitioned into subsets of methods with same signature (name, parameter types) and return type.</li> <li> Within each such subset only the most specific methods are selected. Let method M be a method from a set of methods with same signature and return type. M is most specific if there is no such method N != M from the same set, such that N is more specific than M. N is more specific than M if: <ol type=\"a\"> <li> N is declared by a class and M is declared by an interface; or</li> <li> N and M are both declared by classes or both by interfaces and N's declaring type is the same as or a subtype of M's declaring type (clearly, if M's and N's declaring types are the same type, then M and N are the same method).</li> </ol></li> <li> The result of this algorithm is the union of all selected methods from step 3.</li> </ol>\n- apiNote: There may be more than one method with a particular name and parameter types in a class because while the Java language forbids a class to declare multiple methods with the same signature but different return types, the Java virtual machine does not.  This increased flexibility in the virtual machine can be used to implement various language features.  For example, covariant returns can be implemented with {@linkplain java.lang.reflect.Method#isBridge bridge methods} ; the bridge method and the overriding method would have the same signature but different return types.\n- return: the array of {@code Method} objects representing the public methods of this class\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class.\n- jls: 8.2 Class Members\n- jls: 8.4 Method Declarations\n- since: 1.1"
 ([this] (.getMethods ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isLocalClass
 "-- () -> boolean\nReturns {@code true} if and only if the underlying class is a local class.\n- return: {@code true} if and only if this class is a local class.\n- since: 1.5"
 ([this] (.isLocalClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotationsByType
 "-- (Class<A> annotationClass) -> A[]\n{@inheritDoc}  <p>Note that any annotations returned by this method are declaration annotations.\n- throws NullPointerException: {@inheritDoc}\n- since: 1.8"
 ([this annotationClass]
  (.getAnnotationsByType
   ^"java.lang.Class" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Class:isNestmateOf
 "-- (Class<?> c) -> boolean\nDetermines if the given {@code Class} is a nestmate of the class or interface represented by this {@code Class} object. Two classes or interfaces are nestmates if they have the same {@linkplain #getNestHost() nest host} .\n- param c: the class to check\n- return: {@code true} if this class and {@code c} are members of the same nest; and {@code false} otherwise.\n- since: 11"
 ([this c]
  (.isNestmateOf ^"java.lang.Class" this ^"java.lang.Class" c)))

(clojure.core/defn
 Class:getDeclaringClass
 "-- () -> Class<?>\nIf the class or interface represented by this {@code Class} object is a member of another class, returns the {@code Class} object representing the class in which it was declared.  This method returns null if this class or interface is not a member of any other class.  If this {@code Class} object represents an array class, a primitive type, or void,then this method returns null.\n- return: the declaring class for this class\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the declaring class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()}  denies access to the package of the declaring class\n- since: 1.1"
 ([this] (.getDeclaringClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredConstructor
 "-- (Class<?> parameterTypes) -> Constructor<T>\nReturns a {@code Constructor} object that reflects the specified constructor of the class or interface represented by this {@code Class} object.  The {@code parameterTypes} parameter is an array of {@code Class} objects that identify the constructor's formal parameter types, in declared order.  If this {@code Class} object represents an inner class declared in a non-static context, the formal parameter types include the explicit enclosing instance as the first parameter.\n- param parameterTypes: the parameter array\n- return: The {@code Constructor} object for the constructor with the specified parameter list\n- throws NoSuchMethodException: if a matching method is not found.\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of this class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the declared constructor  <li> the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class  </ul>\n- since: 1.1"
 ([this parameterTypes]
  (.getDeclaredConstructor
   ^"java.lang.Class" this
   ^"[Ljava.lang.Class;" parameterTypes)))

(clojure.core/defn
 Class:isSealed
 "-- () -> boolean\n{@preview Associated with sealed classes, a preview feature of the Java language.  This method is associated with <i>sealed classes</i>, a preview feature of the Java language. Preview features may be removed in a future release, or upgraded to permanent features of the Java language.}   Returns {@code true} if and only if this {@code Class} object represents a sealed class or interface. If this {@code Class} object represents a primitive type, {@code void} , or an array type, this method returns {@code false} . A sealed class or interface has (possibly zero) permitted subclasses; {@link #getPermittedSubclasses()} returns a non-null but possibly empty value for a sealed class or interface.\n- return: {@code true} if and only if this {@code Class} object represents a sealed class or interface.\n- jls: 8.1 Class Declarations\n- jls: 9.1 Interface Declarations\n- since: 15"
 ([this] (.isSealed ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getPackage
 "-- () -> Package\nGets the package of this class.  <p>If this class represents an array type, a primitive type or void, this method returns {@code null} .\n- return: the package of this class.\n- revised: 9"
 ([this] (.getPackage ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isMemberClass
 "-- () -> boolean\nReturns {@code true} if and only if the underlying class is a member class.\n- return: {@code true} if and only if this class is a member class.\n- since: 1.5"
 ([this] (.isMemberClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getMethod
 "-- (String name, Class<?> parameterTypes) -> Method\nReturns a {@code Method} object that reflects the specified public member method of the class or interface represented by this {@code Class} object. The {@code name} parameter is a {@code String} specifying the simple name of the desired method. The {@code parameterTypes} parameter is an array of {@code Class}  objects that identify the method's formal parameter types, in declared order. If {@code parameterTypes} is {@code null} , it is treated as if it were an empty array.  <p> If this {@code Class} object represents an array type, then this method finds any public method inherited by the array type from {@code Object} except method {@code clone()} .  <p> If this {@code Class} object represents an interface then this method does not find any implicitly declared method from {@code Object} . Therefore, if no methods are explicitly declared in this interface or any of its superinterfaces, then this method does not find any method.  <p> This method does not find any method with name \" {@code <init>} \" or \" {@code <clinit>} \".  <p> Generally, the method to be reflected is determined by the 4 step algorithm that follows. Let C be the class or interface represented by this {@code Class} object: <ol> <li> A union of methods is composed of: <ol type=\"a\"> <li> C's declared public instance and static methods as returned by  {@link #getDeclaredMethods()} and filtered to include only public methods that match given {@code name} and {@code parameterTypes} </li> <li> If C is a class other than {@code Object} , then include the result of invoking this algorithm recursively on the superclass of C.</li> <li> Include the results of invoking this algorithm recursively on all direct superinterfaces of C, but include only instance methods.</li> </ol></li> <li> This union is partitioned into subsets of methods with same return type (the selection of methods from step 1 also guarantees that they have the same method name and parameter types).</li> <li> Within each such subset only the most specific methods are selected. Let method M be a method from a set of methods with same VM signature (return type, name, parameter types). M is most specific if there is no such method N != M from the same set, such that N is more specific than M. N is more specific than M if: <ol type=\"a\"> <li> N is declared by a class and M is declared by an interface; or</li> <li> N and M are both declared by classes or both by interfaces and N's declaring type is the same as or a subtype of M's declaring type (clearly, if M's and N's declaring types are the same type, then M and N are the same method).</li> </ol></li> <li> The result of this algorithm is chosen arbitrarily from the methods with most specific return type among all selected methods from step 3. Let R be a return type of a method M from the set of all selected methods from step 3. M is a method with most specific return type if there is no such method N != M from the same set, having return type S != R, such that S is a subtype of R as determined by R.class. {@link #isAssignableFrom} (S.class). </ol>\n- apiNote: There may be more than one method with matching name and parameter types in a class because while the Java language forbids a class to declare multiple methods with the same signature but different return types, the Java virtual machine does not.  This increased flexibility in the virtual machine can be used to implement various language features.  For example, covariant returns can be implemented with {@linkplain java.lang.reflect.Method#isBridge bridge methods} ; the bridge method and the overriding method would have the same signature but different return types. This method would return the overriding method as it would have a more specific return type.\n- param name: the name of the method\n- param parameterTypes: the list of parameters\n- return: the {@code Method} object that matches the specified  {@code name} and {@code parameterTypes}\n- throws NoSuchMethodException: if a matching method is not found or if the name is \"&lt;init&gt;\"or \"&lt;clinit&gt;\".\n- throws NullPointerException: if {@code name} is {@code null}\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class.\n- jls: 8.2 Class Members\n- jls: 8.4 Method Declarations\n- since: 1.1"
 ([this name parameterTypes]
  (.getMethod
   ^"java.lang.Class" this
   ^"java.lang.String" name
   ^"[Ljava.lang.Class;" parameterTypes)))

(clojure.core/defn
 Class:getDeclaredMethod
 "-- (String name, Class<?> parameterTypes) -> Method\nReturns a {@code Method} object that reflects the specified declared method of the class or interface represented by this {@code Class} object. The {@code name} parameter is a {@code String} that specifies the simple name of the desired method, and the {@code parameterTypes} parameter is an array of {@code Class} objects that identify the method's formal parameter types, in declared order.  If more than one method with the same parameter types is declared in a class, and one of these methods has a return type that is more specific than any of the others, that method is returned; otherwise one of the methods is chosen arbitrarily.  If the name is \"&lt;init&gt;\"or \"&lt;clinit&gt;\" a {@code NoSuchMethodException}  is raised.  <p> If this {@code Class} object represents an array type, then this method does not find the {@code clone()} method.\n- param name: the name of the method\n- param parameterTypes: the parameter array\n- return: the {@code Method} object for the method of this class matching the specified name and parameters\n- throws NoSuchMethodException: if a matching method is not found.\n- throws NullPointerException: if {@code name} is {@code null}\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of this class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the declared method  <li> the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class  </ul>\n- jls: 8.2 Class Members\n- jls: 8.4 Method Declarations\n- since: 1.1"
 ([this name parameterTypes]
  (.getDeclaredMethod
   ^"java.lang.Class" this
   ^"java.lang.String" name
   ^"[Ljava.lang.Class;" parameterTypes)))

(clojure.core/defn
 Class:getDeclaredFields
 "-- () -> Field[]\nReturns an array of {@code Field} objects reflecting all the fields declared by the class or interface represented by this {@code Class} object. This includes public, protected, default (package) access, and private fields, but excludes inherited fields.  <p> If this {@code Class} object represents a class or interface with no declared fields, then this method returns an array of length 0.  <p> If this {@code Class} object represents an array type, a primitive type, or void, then this method returns an array of length 0.  <p> The elements in the returned array are not sorted and are not in any particular order.\n- return: the array of {@code Field} objects representing all the declared fields of this class\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of this class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the declared fields within this class  <li> the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class  </ul>\n- since: 1.1\n- jls: 8.2 Class Members\n- jls: 8.3 Field Declarations"
 ([this] (.getDeclaredFields ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isAnnotationPresent
 "-- (Class<? extends Annotation> annotationClass) -> boolean\n{@inheritDoc}\n- throws NullPointerException: {@inheritDoc}\n- since: 1.5"
 ([this annotationClass]
  (.isAnnotationPresent
   ^"java.lang.Class" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Class:getEnclosingClass
 "-- () -> Class<?>\nReturns the immediately enclosing class of the underlying class.  If the underlying class is a top level class this method returns {@code null} .\n- return: the immediately enclosing class of the underlying class\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the enclosing class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()}  denies access to the package of the enclosing class\n- since: 1.5"
 ([this] (.getEnclosingClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isEnum
 "-- () -> boolean\nReturns true if and only if this class was declared as an enum in the source code.  Note that {@link java.lang.Enum} is not itself an enum class.  Also note that if an enum constant is declared with a class body, the class of that enum constant object is an anonymous class and <em>not</em> the class of the declaring enum class. The {@link Enum#getDeclaringClass} method of an enum constant can be used to get the class of the enum class declaring the constant.\n- return: true if and only if this class was declared as an enum in the source code\n- since: 1.5\n- jls: 8.9.1 Enum Constants"
 ([this] (.isEnum ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getFields
 "-- () -> Field[]\nReturns an array containing {@code Field} objects reflecting all the accessible public fields of the class or interface represented by this {@code Class} object.  <p> If this {@code Class} object represents a class or interface with no accessible public fields, then this method returns an array of length 0.  <p> If this {@code Class} object represents a class, then this method returns the public fields of the class and of all its superclasses and superinterfaces.  <p> If this {@code Class} object represents an interface, then this method returns the fields of the interface and of all its superinterfaces.  <p> If this {@code Class} object represents an array type, a primitive type, or void, then this method returns an array of length 0.  <p> The elements in the returned array are not sorted and are not in any particular order.\n- return: the array of {@code Field} objects representing the public fields\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class.\n- since: 1.1\n- jls: 8.2 Class Members\n- jls: 8.3 Field Declarations"
 ([this] (.getFields ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredClasses
 "-- () -> Class<?>[]\nReturns an array of {@code Class} objects reflecting all the classes and interfaces declared as members of the class represented by this {@code Class} object. This includes public, protected, default (package) access, and private classes and interfaces declared by the class, but excludes inherited classes and interfaces.  This method returns an array of length 0 if the class declares no classes or interfaces as members, or if this {@code Class} object represents a primitive type, an array class, or void.\n- return: the array of {@code Class} objects representing all the declared members of this class\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of this class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the declared classes within this class  <li> the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class  </ul>\n- since: 1.1"
 ([this] (.getDeclaredClasses ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredMethods
 "-- () -> Method[]\nReturns an array containing {@code Method} objects reflecting all the declared methods of the class or interface represented by this {@code Class} object, including public, protected, default (package) access, and private methods, but excluding inherited methods.  <p> If this {@code Class} object represents a class or interface that has multiple declared methods with the same name and parameter types, but different return types, then the returned array has a {@code Method}  object for each such method.  <p> If this {@code Class} object represents a class or interface that has a class initialization method {@code <clinit>} , then the returned array does <em>not</em> have a corresponding {@code Method} object.  <p> If this {@code Class} object represents a class or interface with no declared methods, then the returned array has length 0.  <p> If this {@code Class} object represents an array type, a primitive type, or void, then the returned array has length 0.  <p> The elements in the returned array are not sorted and are not in any particular order.\n- return: the array of {@code Method} objects representing all the declared methods of this class\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of this class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the declared methods within this class  <li> the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class  </ul>\n- jls: 8.2 Class Members\n- jls: 8.4 Method Declarations\n- since: 1.1"
 ([this] (.getDeclaredMethods ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getSigners
 "-- () -> Object[]\nGets the signers of this class.\n- return: the signers of this class, or null if there are no signers.  In particular, this method returns null if this {@code Class} object represents a primitive type or void.\n- since: 1.1"
 ([this] (.getSigners ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getSimpleName
 "-- () -> String\nReturns the simple name of the underlying class as given in the source code. Returns an empty string if the underlying class is anonymous.  <p>The simple name of an array is the simple name of the component type with \"[]\" appended.  In particular the simple name of an array whose component type is anonymous is \"[]\".\n- return: the simple name of the underlying class\n- since: 1.5"
 ([this] (.getSimpleName ^"java.lang.Class" this)))

(clojure.core/defn
 Class:asSubclass
 "-- (Class<U> clazz) -> Class<? extends U>\nCasts this {@code Class} object to represent a subclass of the class represented by the specified class object.  Checks that the cast is valid, and throws a {@code ClassCastException} if it is not.  If this method succeeds, it always returns a reference to this {@code Class} object.  <p>This method is useful when a client needs to \"narrow\" the type of a {@code Class} object to pass it to an API that restricts the {@code Class} objects that it is willing to accept.  A cast would generate a compile-time warning, as the correctness of the cast could not be checked at runtime (because generic types are implemented by erasure).\n- param <U>: the type to cast this {@code Class} object to\n- param clazz: the class of the type to cast this {@code Class} object to\n- return: this {@code Class} object, cast to represent a subclass of the specified class object.\n- throws ClassCastException: if this {@code Class} object does not represent a subclass of the specified class (here \"subclass\" includes the class itself).\n- since: 1.5"
 ([this clazz]
  (.asSubclass ^"java.lang.Class" this ^"java.lang.Class" clazz)))

(clojure.core/defn
 Class:getComponentType
 "-- () -> Class<?>\nReturns the {@code Class} representing the component type of an array.  If this class does not represent an array class this method returns null.\n- return: the {@code Class} representing the component type of this class if this class is an array\n- see: java.lang.reflect.Array\n- since: 1.1"
 ([this] (.getComponentType ^"java.lang.Class" this)))

(clojure.core/defn
 Class:desiredAssertionStatus
 "-- () -> boolean\nReturns the assertion status that would be assigned to this class if it were to be initialized at the time this method is invoked. If this class has had its assertion status set, the most recent setting will be returned; otherwise, if any package default assertion status pertains to this class, the most recent setting for the most specific pertinent package default assertion status is returned; otherwise, if this class is not a system class (i.e., it has a class loader) its class loader's default assertion status is returned; otherwise, the system class default assertion status is returned.\n- apiNote: Few programmers will have any need for this method; it is provided for the benefit of the JDK itself.  (It allows a class to determine at the time that it is initialized whether assertions should be enabled.) Note that this method is not guaranteed to return the actual assertion status that was (or will be) associated with the specified class when it was (or will be) initialized.\n- return: the desired assertion status of the specified class.\n- see: java.lang.ClassLoader#setClassAssertionStatus\n- see: java.lang.ClassLoader#setPackageAssertionStatus\n- see: java.lang.ClassLoader#setDefaultAssertionStatus\n- since: 1.4"
 ([this] (.desiredAssertionStatus ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getConstructors
 "-- () -> Constructor<?>[]\nReturns an array containing {@code Constructor} objects reflecting all the public constructors of the class represented by this {@code Class} object.  An array of length 0 is returned if the class has no public constructors, or if the class is an array class, or if the class reflects a primitive type or void.\n- apiNote: While this method returns an array of {@code Constructor<T>} objects (that is an array of constructors from this class), the return type of this method is {@code Constructor<?>[]} and <em>not</em> {@code Constructor<T>[]} as might be expected.  This less informative return type is necessary since after being returned from this method, the array could be modified to hold {@code Constructor} objects for different classes, which would violate the type guarantees of {@code Constructor<T>[]} .\n- return: the array of {@code Constructor} objects representing the public constructors of this class\n- throws SecurityException: If a security manager, <i>s</i>, is present and the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class.\n- since: 1.1"
 ([this] (.getConstructors ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getTypeName
 "-- () -> String\nReturn an informative string for the name of this class or interface.\n- return: an informative string for the name of this class or interface\n- since: 1.8"
 ([this] (.getTypeName ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getRecordComponents
 "-- () -> RecordComponent[]\nReturns an array of {@code RecordComponent} objects representing all the record components of this record class, or {@code null} if this class is not a record class.  <p> The components are returned in the same order that they are declared in the record header. The array is empty if this record class has no components. If the class is not a record class, that is {@link #isRecord()} returns {@code false} , then this method returns {@code null} . Conversely, if {@link #isRecord()} returns {@code true} , then this method returns a non-null value.\n- return: An array of {@code RecordComponent} objects representing all the record components of this record class, or {@code null} if this class is not a record class\n- throws SecurityException: If a security manager, <i>s</i>, is present and any of the following conditions is met:  <ul>  <li> the caller's class loader is not the same as the class loader of this class and invocation of  {@link SecurityManager#checkPermission s.checkPermission} method with  {@code RuntimePermission(\"accessDeclaredMembers\")}  denies access to the declared methods within this class  <li> the caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of {@link SecurityManager#checkPackageAccess s.checkPackageAccess()} denies access to the package of this class  </ul>\n- jls: 8.10 Record Classes\n- since: 16"
 ([this] (.getRecordComponents ^"java.lang.Class" this)))

(clojure.core/defn
 Class:describeConstable
 "-- () -> Optional<ClassDesc>\nReturns a nominal descriptor for this instance, if one can be constructed, or an empty {@link Optional} if one cannot be.\n- return: An {@link Optional} containing the resulting nominal descriptor, or an empty {@link Optional} if one cannot be constructed.\n- since: 12"
 ([this] (.describeConstable ^"java.lang.Class" this)))

(clojure.core/defn
 Class:descriptorString
 "-- () -> String\nReturns the descriptor string of the entity (class, interface, array class, primitive type, or {@code void} ) represented by this {@code Class} object.  <p> If this {@code Class} object represents a class or interface, not an array class, then: <ul> <li> If the class or interface is not {@linkplain Class#isHidden() hidden} , then the result is a field descriptor (JVMS {@jvms 4.3.2} ) for the class or interface. Calling  {@link ClassDesc#ofDescriptor(String) ClassDesc::ofDescriptor}  with the result descriptor string produces a {@link ClassDesc ClassDesc}  describing this class or interface. <li> If the class or interface is {@linkplain Class#isHidden() hidden} , then the result is a string of the form: <blockquote>  {@code \"L\" +} <em>N</em> {@code + \".\" + <suffix> + \";\"}  </blockquote> where <em>N</em> is the <a href=\"ClassLoader.html#binary-name\">binary name</a> encoded in internal form indicated by the {@code class} file passed to  {@link MethodHandles.Lookup#defineHiddenClass(byte[], boolean, MethodHandles.Lookup.ClassOption...) Lookup::defineHiddenClass} , and {@code <suffix>} is an unqualified name. A hidden class or interface has no {@linkplain ClassDesc nominal descriptor} . The result string is not a type descriptor. </ul>  <p> If this {@code Class} object represents an array class, then the result is a string consisting of one or more ' {@code [} ' characters representing the depth of the array nesting, followed by the descriptor string of the element type. <ul> <li> If the element type is not a {@linkplain Class#isHidden() hidden} class or interface, then this array class can be described nominally. Calling {@link ClassDesc#ofDescriptor(String) ClassDesc::ofDescriptor}  with the result descriptor string produces a {@link ClassDesc ClassDesc}  describing this array class. <li> If the element type is a {@linkplain Class#isHidden() hidden} class or interface, then this array class cannot be described nominally. The result string is not a type descriptor. </ul>  <p> If this {@code Class} object represents a primitive type or {@code void} , then the result is a field descriptor string which is a one-letter code corresponding to a primitive type or {@code void}  ( {@code \"B\", \"C\", \"D\", \"F\", \"I\", \"J\", \"S\", \"Z\", \"V\"} ) (JVMS {@jvms 4.3.2} ).\n- apiNote: This is not a strict inverse of {@link #forName} ; distinct classes which share a common name but have different class loaders will have identical descriptor strings.\n- return: the descriptor string for this {@code Class} object\n- jvms: 4.3.2 Field Descriptors\n- since: 12"
 ([this] (.descriptorString ^"java.lang.Class" this)))

(def
 Class:class
 "Instances of the class {@code Class} represent classes and interfaces in a running Java application. An enum class and a record class are kinds of class; an annotation interface is a kind of interface. Every array also belongs to a class that is reflected as a {@code Class} object that is shared by all arrays with the same element type and number of dimensions.  The primitive Java types ( {@code boolean} , {@code byte} , {@code char} , {@code short} , {@code int} , {@code long} , {@code float} , and {@code double} ), and the keyword {@code void} are also represented as {@code Class} objects.  <p> {@code Class} has no public constructor. Instead a {@code Class}  object is constructed automatically by the Java Virtual Machine when a class is derived from the bytes of a {@code class} file through the invocation of one of the following methods: <ul> <li> {@link ClassLoader#defineClass(String, byte[], int, int) ClassLoader::defineClass}  <li> {@link java.lang.invoke.MethodHandles.Lookup#defineClass(byte[]) java.lang.invoke.MethodHandles.Lookup::defineClass}  <li> {@link java.lang.invoke.MethodHandles.Lookup#defineHiddenClass(byte[], boolean, MethodHandles.Lookup.ClassOption...) java.lang.invoke.MethodHandles.Lookup::defineHiddenClass}  </ul>  <p> The methods of class {@code Class} expose many characteristics of a class or interface. Most characteristics are derived from the {@code class}  file that the class loader passed to the Java Virtual Machine or from the {@code class} file passed to {@code Lookup::defineClass}  or {@code Lookup::defineHiddenClass} . A few characteristics are determined by the class loading environment at run time, such as the module returned by {@link #getModule() getModule()} .  <p> The following example uses a {@code Class} object to print the class name of an object:  <blockquote><pre> void printClassName(Object obj) { System.out.println(\"The class of \" + obj + \" is \" + obj.getClass().getName()); } </pre></blockquote>  It is also possible to get the {@code Class} object for a named class or interface (or for {@code void} ) using a <i>class literal</i>. For example:  <blockquote>  {@code System.out.println(\"The name of class Foo is: \"+Foo.class.getName());}  </blockquote>  <p> Some methods of class {@code Class} expose whether the declaration of a class or interface in Java source code was <em>enclosed</em> within another declaration. Other methods describe how a class or interface is situated in a <em>nest</em>. A <a id=\"nest\">nest</a> is a set of classes and interfaces, in the same run-time package, that allow mutual access to their {@code private} members. The classes and interfaces are known as <em>nestmates</em>. One nestmate acts as the <em>nest host</em>, and enumerates the other nestmates which belong to the nest; each of them in turn records it as the nest host. The classes and interfaces which belong to a nest, including its host, are determined when {@code class} files are generated, for example, a Java compiler will typically record a top-level class as the host of a nest where the other members are the classes and interfaces whose declarations are enclosed within the top-level class declaration.  <p> A class or interface created by the invocation of {@link java.lang.invoke.MethodHandles.Lookup#defineHiddenClass(byte[], boolean, MethodHandles.Lookup.ClassOption...) Lookup::defineHiddenClass} is a {@linkplain Class#isHidden() <em>hidden</em>}  class or interface. All kinds of class, including enum classes and record classes, may be hidden classes; all kinds of interface, including annotation interfaces, may be hidden interfaces.  The {@linkplain #getName() name of a hidden class or interface} is not a <a href=\"ClassLoader.html#binary-name\">binary name</a>, which means the following: <ul> <li>A hidden class or interface cannot be referenced by the constant pools of other classes and interfaces. <li>A hidden class or interface cannot be described in  {@linkplain java.lang.constant.ConstantDesc <em>nominal form</em>} by  {@link #describeConstable() Class::describeConstable} ,  {@link ClassDesc#of(String) ClassDesc::of} , or  {@link ClassDesc#ofDescriptor(String) ClassDesc::ofDescriptor} . <li>A hidden class or interface cannot be discovered by {@link #forName Class::forName}  or {@link ClassLoader#loadClass(String, boolean) ClassLoader::loadClass} . </ul>  A hidden class or interface is never an array class, but may be the element type of an array. In all other respects, the fact that a class or interface is hidden has no bearing on the characteristics exposed by the methods of class {@code Class} .\n- param <T>: the type of the class modeled by this {@code Class}  object.  For example, the type of {@code String.class} is {@code Class<String>} .  Use {@code Class<?>} if the class being modeled is unknown.\n- see: java.lang.ClassLoader#defineClass(byte[], int, int)\n- since: 1.0\n- jls: 15.8.2 Class Literals"
 java.lang.Class)

(clojure.core/defn
 Class?
 "Checks if x is an instance of java.lang.Class."
 [x]
 (clojure.core/instance? java.lang.Class x))

(clojure.core/defn
 Method:invoke
 "-- (Object obj, Object args) -> Object\nInvokes the underlying method represented by this {@code Method}  object, on the specified object with the specified parameters. Individual parameters are automatically unwrapped to match primitive formal parameters, and both primitive and reference parameters are subject to method invocation conversions as necessary.  <p>If the underlying method is static, then the specified {@code obj}  argument is ignored. It may be null.  <p>If the number of formal parameters required by the underlying method is 0, the supplied {@code args} array may be of length 0 or null.  <p>If the underlying method is an instance method, it is invoked using dynamic method lookup as documented in The Java Language Specification, section {@jls 15.12.4.4} ; in particular, overriding based on the runtime type of the target object may occur.  <p>If the underlying method is static, the class that declared the method is initialized if it has not already been initialized.  <p>If the method completes normally, the value it returns is returned to the caller of invoke; if the value has a primitive type, it is first appropriately wrapped in an object. However, if the value has the type of an array of a primitive type, the elements of the array are <i>not</i> wrapped in objects; in other words, an array of primitive type is returned.  If the underlying method return type is void, the invocation returns null.\n- param obj: the object the underlying method is invoked from\n- param args: the arguments used for the method call\n- return: the result of dispatching the method represented by this object on {@code obj} with parameters {@code args}\n- throws IllegalAccessException: if this {@code Method} object is enforcing Java language access control and the underlying method is inaccessible.\n- throws IllegalArgumentException: if the method is an instance method and the specified object argument is not an instance of the class or interface declaring the underlying method (or of a subclass or implementor thereof); if the number of actual and formal parameters differ; if an unwrapping conversion for primitive arguments fails; or if, after possible unwrapping, a parameter value cannot be converted to the corresponding formal parameter type by a method invocation conversion.\n- throws InvocationTargetException: if the underlying method throws an exception.\n- throws NullPointerException: if the specified object is null and the method is an instance method.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails."
 ([this obj args]
  (.invoke
   ^"java.lang.reflect.Method" this
   ^"java.lang.Object" obj
   ^"[Ljava.lang.Object;" args)))

(clojure.core/defn
 Method:getGenericReturnType
 "-- () -> Type\nReturns a {@code Type} object that represents the formal return type of the method represented by this {@code Method} object.  <p>If the return type is a parameterized type, the {@code Type} object returned must accurately reflect the actual type arguments used in the source code.  <p>If the return type is a type variable or a parameterized type, it is created. Otherwise, it is resolved.\n- return: a {@code Type} object that represents the formal return type of the underlying  method\n- throws GenericSignatureFormatError: if the generic method signature does not conform to the format specified in <cite>The Java Virtual Machine Specification</cite>\n- throws TypeNotPresentException: if the underlying method's return type refers to a non-existent class or interface declaration\n- throws MalformedParameterizedTypeException: if the underlying method's return type refers to a parameterized type that cannot be instantiated for any reason\n- since: 1.5"
 ([this] (.getGenericReturnType ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:isVarArgs
 "-- () -> boolean\n{@inheritDoc}\n- since: 1.5"
 ([this] (.isVarArgs ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:toGenericString
 "-- () -> String\nReturns a string describing this {@code Method} , including type parameters.  The string is formatted as the method access modifiers, if any, followed by an angle-bracketed comma-separated list of the method's type parameters, if any, including informative bounds of the type parameters, if any, followed by the method's generic return type, followed by a space, followed by the class declaring the method, followed by a period, followed by the method name, followed by a parenthesized, comma-separated list of the method's generic formal parameter types.  If this method was declared to take a variable number of arguments, instead of denoting the last parameter as \"<code><i>Type</i>[]</code>\", it is denoted as \"<code><i>Type</i>...</code>\".  A space is used to separate access modifiers from one another and from the type parameters or return type.  If there are no type parameters, the type parameter list is elided; if the type parameter list is present, a space separates the list from the class name.  If the method is declared to throw exceptions, the parameter list is followed by a space, followed by the word \" {@code throws} \" followed by a comma-separated list of the generic thrown exception types.  <p>The access modifiers are placed in canonical order as specified by \"The Java Language Specification\".  This is {@code public} , {@code protected} or {@code private} first, and then other modifiers in the following order: {@code abstract} , {@code default} , {@code static} , {@code final} , {@code synchronized} , {@code native} , {@code strictfp} .\n- return: a string describing this {@code Method} , include type parameters\n- since: 1.5\n- jls: 8.4.3 Method Modifiers\n- jls: 9.4 Method Declarations\n- jls: 9.6.1 Annotation Interface Elements"
 ([this] (.toGenericString ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getModifiers
 "-- () -> int\n{@inheritDoc}"
 ([this] (.getModifiers ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getParameterCount
 "-- () -> int\n{@inheritDoc}\n- since: 1.8"
 ([this] (.getParameterCount ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getExceptionTypes
 "-- () -> Class<?>[]\n{@inheritDoc}"
 ([this] (.getExceptionTypes ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:isSynthetic
 "-- () -> boolean\n{@inheritDoc}\n- jls: 13.1 The Form of a Binary\n- since: 1.5"
 ([this] (.isSynthetic ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getGenericParameterTypes
 "-- () -> Type[]\n{@inheritDoc}\n- throws GenericSignatureFormatError: {@inheritDoc}\n- throws TypeNotPresentException: {@inheritDoc}\n- throws MalformedParameterizedTypeException: {@inheritDoc}\n- since: 1.5"
 ([this] (.getGenericParameterTypes ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:toString
 "-- () -> String\nReturns a string describing this {@code Method} .  The string is formatted as the method access modifiers, if any, followed by the method return type, followed by a space, followed by the class declaring the method, followed by a period, followed by the method name, followed by a parenthesized, comma-separated list of the method's formal parameter types. If the method throws checked exceptions, the parameter list is followed by a space, followed by the word \" {@code throws} \" followed by a comma-separated list of the thrown exception types. For example: <pre> public boolean java.lang.Object.equals(java.lang.Object) </pre>  <p>The access modifiers are placed in canonical order as specified by \"The Java Language Specification\".  This is {@code public} , {@code protected} or {@code private} first, and then other modifiers in the following order: {@code abstract} , {@code default} , {@code static} , {@code final} , {@code synchronized} , {@code native} , {@code strictfp} .\n- return: a string describing this {@code Method}\n- jls: 8.4.3 Method Modifiers\n- jls: 9.4 Method Declarations\n- jls: 9.6.1 Annotation Interface Elements"
 ([this] (.toString ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getAnnotation
 "-- (Class<T> annotationClass) -> T\n{@inheritDoc}\n- throws NullPointerException: {@inheritDoc}\n- since: 1.5"
 ([this annotationClass]
  (.getAnnotation
   ^"java.lang.reflect.Method" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Method:getDefaultValue
 "-- () -> Object\nReturns the default value for the annotation member represented by this {@code Method} instance.  If the member is of a primitive type, an instance of the corresponding wrapper type is returned. Returns null if no default is associated with the member, or if the method instance does not represent a declared member of an annotation type.\n- return: the default value for the annotation member represented by this {@code Method} instance.\n- throws TypeNotPresentException: if the annotation is of type  {@link Class} and no definition can be found for the default class value.\n- since: 1.5"
 ([this] (.getDefaultValue ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:isBridge
 "-- () -> boolean\nReturns {@code true} if this method is a bridge method; returns {@code false} otherwise.\n- return: true if and only if this method is a bridge method as defined by the Java Language Specification.\n- since: 1.5"
 ([this] (.isBridge ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getDeclaredAnnotations
 "-- () -> Annotation[]\n{@inheritDoc}\n- since: 1.5"
 ([this] (.getDeclaredAnnotations ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:setAccessible
 "-- (boolean flag) -> void\n\n- throws InaccessibleObjectException: {@inheritDoc}\n- throws SecurityException: {@inheritDoc}"
 ([this flag]
  (.setAccessible ^"java.lang.reflect.Method" this ^"boolean" flag)))

(clojure.core/defn
 Method:getName
 "-- () -> String\nReturns the name of the method represented by this {@code Method}  object, as a {@code String} ."
 ([this] (.getName ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getGenericExceptionTypes
 "-- () -> Type[]\n{@inheritDoc}\n- throws GenericSignatureFormatError: {@inheritDoc}\n- throws TypeNotPresentException: {@inheritDoc}\n- throws MalformedParameterizedTypeException: {@inheritDoc}\n- since: 1.5"
 ([this] (.getGenericExceptionTypes ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getTypeParameters
 "-- () -> TypeVariable<Method>[]\n{@inheritDoc}\n- throws GenericSignatureFormatError: {@inheritDoc}\n- since: 1.5"
 ([this] (.getTypeParameters ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getParameterTypes
 "-- () -> Class<?>[]\n{@inheritDoc}"
 ([this] (.getParameterTypes ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getReturnType
 "-- () -> Class<?>\nReturns a {@code Class} object that represents the formal return type of the method represented by this {@code Method} object.\n- return: the return type for the method this object represents"
 ([this] (.getReturnType ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getAnnotatedReturnType
 "-- () -> AnnotatedType\n{@inheritDoc}\n- since: 1.8"
 ([this] (.getAnnotatedReturnType ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getDeclaringClass
 "-- () -> Class<?>\nReturns the {@code Class} object representing the class or interface that declares the method represented by this object."
 ([this] (.getDeclaringClass ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:hashCode
 "-- () -> int\nReturns a hashcode for this {@code Method} .  The hashcode is computed as the exclusive-or of the hashcodes for the underlying method's declaring class name and the method's name."
 ([this] (.hashCode ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getParameterAnnotations
 "-- () -> Annotation[][]\n{@inheritDoc}\n- since: 1.5"
 ([this] (.getParameterAnnotations ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:isDefault
 "-- () -> boolean\nReturns {@code true} if this method is a default method; returns {@code false} otherwise.  A default method is a public non-abstract instance method, that is, a non-static method with a body, declared in an interface.\n- return: true if and only if this method is a default method as defined by the Java Language Specification.\n- since: 1.8"
 ([this] (.isDefault ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:equals
 "-- (Object obj) -> boolean\nCompares this {@code Method} against the specified object.  Returns true if the objects are the same.  Two {@code Methods} are the same if they were declared by the same class and have the same name and formal parameter types and return type."
 ([this obj]
  (.equals ^"java.lang.reflect.Method" this ^"java.lang.Object" obj)))

(def
 Method:class
 "A {@code Method} provides information about, and access to, a single method on a class or interface.  The reflected method may be a class method or an instance method (including an abstract method).  <p>A {@code Method} permits widening conversions to occur when matching the actual parameters to invoke with the underlying method's formal parameters, but it throws an {@code IllegalArgumentException} if a narrowing conversion would occur.\n- see: Member\n- see: java.lang.Class\n- see: java.lang.Class#getMethods()\n- see: java.lang.Class#getMethod(String, Class[])\n- see: java.lang.Class#getDeclaredMethods()\n- see: java.lang.Class#getDeclaredMethod(String, Class[])\n- author: Kenneth Russell\n- author: Nakul Saraiya\n- since: 1.1"
 java.lang.reflect.Method)

(clojure.core/defn
 Method?
 "Checks if x is an instance of java.lang.reflect.Method."
 [x]
 (clojure.core/instance? java.lang.reflect.Method x))

(clojure.core/defn
 Modifier:isNative
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code native} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code native} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isNative ^"int" mod)))

(clojure.core/defn
 Modifier:parameterModifiers
 "-- () -> int\nReturn an {@code int} value OR-ing together the source language modifiers that can be applied to a parameter.\n- return: an {@code int} value OR-ing together the source language modifiers that can be applied to a parameter.\n- jls: 8.4.1 Formal Parameters\n- since: 1.8"
 ([] (java.lang.reflect.Modifier/parameterModifiers)))

(clojure.core/defn
 Modifier:isPrivate
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code private} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code private} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isPrivate ^"int" mod)))

(clojure.core/defn
 Modifier:isStatic
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code static} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code static} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isStatic ^"int" mod)))

(clojure.core/defn
 Modifier:fieldModifiers
 "-- () -> int\nReturn an {@code int} value OR-ing together the source language modifiers that can be applied to a field.\n- return: an {@code int} value OR-ing together the source language modifiers that can be applied to a field.\n- jls: 8.3.1 Field Modifiers\n- since: 1.7"
 ([] (java.lang.reflect.Modifier/fieldModifiers)))

(clojure.core/defn
 Modifier:isAbstract
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code abstract} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code abstract} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isAbstract ^"int" mod)))

(clojure.core/defn
 Modifier:toString
 "-- (int mod) -> String\nReturn a string describing the access modifier flags in the specified modifier. For example: <blockquote><pre> public final synchronized strictfp </pre></blockquote> The modifier names are returned in an order consistent with the suggested modifier orderings given in sections 8.1.1, 8.3.1, 8.4.3, 8.8.3, and 9.1.1 of <cite>The Java Language Specification</cite>. The full modifier ordering used by this method is: <blockquote> {@code public protected private abstract static final transient volatile synchronized native strictfp interface } </blockquote> The {@code interface} modifier discussed in this class is not a true modifier in the Java language and it appears after all other modifiers listed by this method.  This method may return a string of modifiers that are not valid modifiers of a Java entity; in other words, no checking is done on the possible validity of the combination of modifiers represented by the input.  Note that to perform such checking for a known kind of entity, such as a constructor or method, first AND the argument of {@code toString} with the appropriate mask from a method like {@link #constructorModifiers} or {@link #methodModifiers} .\n- param mod: a set of modifiers\n- return: a string representation of the set of modifiers represented by {@code mod}"
 ([mod] (java.lang.reflect.Modifier/toString ^"int" mod)))

(clojure.core/defn
 Modifier:classModifiers
 "-- () -> int\nReturn an {@code int} value OR-ing together the source language modifiers that can be applied to a class.\n- return: an {@code int} value OR-ing together the source language modifiers that can be applied to a class.\n- jls: 8.1.1 Class Modifiers\n- since: 1.7"
 ([] (java.lang.reflect.Modifier/classModifiers)))

(clojure.core/defn
 Modifier:isStrict
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code strictfp} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code strictfp} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isStrict ^"int" mod)))

(clojure.core/defn
 Modifier:isInterface
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code interface} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code interface} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isInterface ^"int" mod)))

(clojure.core/defn
 Modifier:constructorModifiers
 "-- () -> int\nReturn an {@code int} value OR-ing together the source language modifiers that can be applied to a constructor.\n- return: an {@code int} value OR-ing together the source language modifiers that can be applied to a constructor.\n- jls: 8.8.3 Constructor Modifiers\n- since: 1.7"
 ([] (java.lang.reflect.Modifier/constructorModifiers)))

(clojure.core/defn
 Modifier:methodModifiers
 "-- () -> int\nReturn an {@code int} value OR-ing together the source language modifiers that can be applied to a method.\n- return: an {@code int} value OR-ing together the source language modifiers that can be applied to a method.\n- jls: 8.4.3 Method Modifiers\n- since: 1.7"
 ([] (java.lang.reflect.Modifier/methodModifiers)))

(clojure.core/defn
 Modifier:isSynchronized
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code synchronized} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code synchronized} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isSynchronized ^"int" mod)))

(clojure.core/defn
 Modifier:interfaceModifiers
 "-- () -> int\nReturn an {@code int} value OR-ing together the source language modifiers that can be applied to an interface.\n- return: an {@code int} value OR-ing together the source language modifiers that can be applied to an interface.\n- jls: 9.1.1 Interface Modifiers\n- since: 1.7"
 ([] (java.lang.reflect.Modifier/interfaceModifiers)))

(clojure.core/defn
 Modifier:isTransient
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code transient} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code transient} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isTransient ^"int" mod)))

(clojure.core/defn
 Modifier:isVolatile
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code volatile} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code volatile} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isVolatile ^"int" mod)))

(clojure.core/defn
 Modifier:isFinal
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code final} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code final} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isFinal ^"int" mod)))

(clojure.core/defn
 Modifier:isProtected
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code protected} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code protected} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isProtected ^"int" mod)))

(clojure.core/defn
 Modifier:isPublic
 "-- (int mod) -> boolean\nReturn {@code true} if the integer argument includes the {@code public} modifier, {@code false} otherwise.\n- param mod: a set of modifiers\n- return: {@code true} if {@code mod} includes the {@code public} modifier; {@code false} otherwise."
 ([mod] (java.lang.reflect.Modifier/isPublic ^"int" mod)))

(def
 ^"int" Modifier:PUBLIC
 "Type: int"
 java.lang.reflect.Modifier/PUBLIC)

(def
 ^"int" Modifier:PRIVATE
 "Type: int"
 java.lang.reflect.Modifier/PRIVATE)

(def
 ^"int" Modifier:PROTECTED
 "Type: int"
 java.lang.reflect.Modifier/PROTECTED)

(def
 ^"int" Modifier:STATIC
 "Type: int"
 java.lang.reflect.Modifier/STATIC)

(def
 ^"int" Modifier:FINAL
 "Type: int"
 java.lang.reflect.Modifier/FINAL)

(def
 ^"int" Modifier:SYNCHRONIZED
 "Type: int"
 java.lang.reflect.Modifier/SYNCHRONIZED)

(def
 ^"int" Modifier:VOLATILE
 "Type: int"
 java.lang.reflect.Modifier/VOLATILE)

(def
 ^"int" Modifier:TRANSIENT
 "Type: int"
 java.lang.reflect.Modifier/TRANSIENT)

(def
 ^"int" Modifier:NATIVE
 "Type: int"
 java.lang.reflect.Modifier/NATIVE)

(def
 ^"int" Modifier:INTERFACE
 "Type: int"
 java.lang.reflect.Modifier/INTERFACE)

(def
 ^"int" Modifier:ABSTRACT
 "Type: int"
 java.lang.reflect.Modifier/ABSTRACT)

(def
 ^"int" Modifier:STRICT
 "Type: int"
 java.lang.reflect.Modifier/STRICT)

(def
 Modifier:class
 "The Modifier class provides {@code static} methods and constants to decode class and member access modifiers.  The sets of modifiers are represented as integers with distinct bit positions representing different modifiers.  The values for the constants representing the modifiers are taken from the tables in sections {@jvms 4.1} , {@jvms 4.4} , {@jvms 4.5} , and {@jvms 4.7} of <cite>The Java Virtual Machine Specification</cite>.\n- see: Class#getModifiers()\n- see: Member#getModifiers()\n- author: Nakul Saraiya\n- author: Kenneth Russell\n- since: 1.1"
 java.lang.reflect.Modifier)

(clojure.core/defn
 Modifier?
 "Checks if x is an instance of java.lang.reflect.Modifier."
 [x]
 (clojure.core/instance? java.lang.reflect.Modifier x))

(clojure.core/defn
 Parameter:getDeclaredAnnotation
 "-- (Class<T> annotationClass) -> T\n{@inheritDoc}  <p>Note that any annotation returned by this method is a declaration annotation.\n- throws NullPointerException: {@inheritDoc}"
 ([this annotationClass]
  (.getDeclaredAnnotation
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Parameter:getDeclaredAnnotationsByType
 "-- (Class<T> annotationClass) -> T[]\n{@inheritDoc}  <p>Note that any annotations returned by this method are declaration annotations.\n- throws NullPointerException: {@inheritDoc}"
 ([this annotationClass]
  (.getDeclaredAnnotationsByType
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Parameter:isNamePresent
 "-- () -> boolean\nReturns true if the parameter has a name according to the class file; returns false otherwise. Whether a parameter has a name is determined by the {@literal MethodParameters} attribute of the method which declares the parameter.\n- return: true if and only if the parameter has a name according to the class file."
 ([this] (.isNamePresent ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getType
 "-- () -> Class<?>\nReturns a {@code Class} object that identifies the declared type for the parameter represented by this {@code Parameter} object.\n- return: a {@code Class} object identifying the declared type of the parameter represented by this object"
 ([this] (.getType ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:isVarArgs
 "-- () -> boolean\nReturns {@code true} if this parameter represents a variable argument list; returns {@code false} otherwise.\n- return: {@code true} if an only if this parameter represents a variable argument list."
 ([this] (.isVarArgs ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getModifiers
 "-- () -> int\nGet the modifier flags for this the parameter represented by this {@code Parameter} object.\n- return: The modifier flags for this parameter."
 ([this] (.getModifiers ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:isSynthetic
 "-- () -> boolean\nReturns {@code true} if this parameter is neither implicitly nor explicitly declared in source code; returns {@code false}  otherwise.\n- jls: 13.1 The Form of a Binary\n- return: true if and only if this parameter is a synthetic construct as defined by <cite>The Java Language Specification</cite>."
 ([this] (.isSynthetic ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:toString
 "-- () -> String\nReturns a string describing this parameter.  The format is the modifiers for the parameter, if any, in canonical order as recommended by <cite>The Java Language Specification</cite>, followed by the fully-qualified type of the parameter (excluding the last [] if the parameter is variable arity), followed by \"...\" if the parameter is variable arity, followed by a space, followed by the name of the parameter.\n- return: A string representation of the parameter and associated information."
 ([this] (.toString ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getAnnotation
 "-- (Class<T> annotationClass) -> T\n{@inheritDoc}  <p>Note that any annotation returned by this method is a declaration annotation.\n- throws NullPointerException: {@inheritDoc}"
 ([this annotationClass]
  (.getAnnotation
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Parameter:getDeclaredAnnotations
 "-- () -> Annotation[]\n{@inheritDoc}  <p>Note that any annotations returned by this method are declaration annotations."
 ([this]
  (.getDeclaredAnnotations ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getName
 "-- () -> String\nReturns the name of the parameter.  If the parameter's name is {@linkplain #isNamePresent() present} , then this method returns the name provided by the class file. Otherwise, this method synthesizes a name of the form argN, where N is the index of the parameter in the descriptor of the method which declares the parameter.\n- return: The name of the parameter, either provided by the class file or synthesized if the class file does not provide a name."
 ([this] (.getName ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getAnnotations
 "-- () -> Annotation[]\n{@inheritDoc}  <p>Note that any annotations returned by this method are declaration annotations."
 ([this] (.getAnnotations ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getParameterizedType
 "-- () -> Type\nReturns a {@code Type} object that identifies the parameterized type for the parameter represented by this {@code Parameter}  object.\n- return: a {@code Type} object identifying the parameterized type of the parameter represented by this object"
 ([this] (.getParameterizedType ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getAnnotatedType
 "-- () -> AnnotatedType\nReturns an AnnotatedType object that represents the use of a type to specify the type of the formal parameter represented by this Parameter.\n- return: an {@code AnnotatedType} object representing the use of a type to specify the type of the formal parameter represented by this Parameter"
 ([this] (.getAnnotatedType ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getDeclaringExecutable
 "-- () -> Executable\nReturn the {@code Executable} which declares this parameter.\n- return: The {@code Executable} declaring this parameter."
 ([this]
  (.getDeclaringExecutable ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:isImplicit
 "-- () -> boolean\nReturns {@code true} if this parameter is implicitly declared in source code; returns {@code false} otherwise.\n- return: true if and only if this parameter is implicitly declared as defined by <cite>The Java Language Specification</cite>."
 ([this] (.isImplicit ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getAnnotationsByType
 "-- (Class<T> annotationClass) -> T[]\n{@inheritDoc}  <p>Note that any annotations returned by this method are declaration annotations.\n- throws NullPointerException: {@inheritDoc}"
 ([this annotationClass]
  (.getAnnotationsByType
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Parameter:hashCode
 "-- () -> int\nReturns a hash code based on the executable's hash code and the index.\n- return: A hash code based on the executable's hash code."
 ([this] (.hashCode ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:equals
 "-- (Object obj) -> boolean\nCompares based on the executable and the index.\n- param obj: The object to compare.\n- return: Whether or not this is equal to the argument."
 ([this obj]
  (.equals
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Object" obj)))

(def
 Parameter:class
 "Information about method parameters.  A {@code Parameter} provides information about method parameters, including its name and modifiers.  It also provides an alternate means of obtaining attributes for the parameter.\n- since: 1.8"
 java.lang.reflect.Parameter)

(clojure.core/defn
 Parameter?
 "Checks if x is an instance of java.lang.reflect.Parameter."
 [x]
 (clojure.core/instance? java.lang.reflect.Parameter x))

(clojure.core/defn
 Executable:getAnnotatedExceptionTypes
 "-- () -> AnnotatedType[]\nReturns an array of {@code AnnotatedType} objects that represent the use of types to specify the declared exceptions of the method/constructor represented by this Executable. The order of the objects in the array corresponds to the order of the exception types in the declaration of the method/constructor.  Returns an array of length 0 if the method/constructor declares no exceptions.\n- return: an array of objects representing the declared exceptions of the method or constructor represented by this {@code Executable}"
 ([this]
  (.getAnnotatedExceptionTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:isVarArgs
 "-- () -> boolean\nReturns {@code true} if this executable was declared to take a variable number of arguments; returns {@code false} otherwise.\n- return: {@code true} if an only if this executable was declared to take a variable number of arguments."
 ([this] (.isVarArgs ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:toGenericString
 "-- () -> String\nReturns a string describing this {@code Executable} , including any type parameters.\n- return: a string describing this {@code Executable} , including any type parameters"
 ([this] (.toGenericString ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getModifiers
 "-- () -> int\nReturns the Java language {@linkplain Modifier modifiers} for the executable represented by this object."
 ([this] (.getModifiers ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getParameterCount
 "-- () -> int\nReturns the number of formal parameters (whether explicitly declared or implicitly declared or neither) for the executable represented by this object.\n- return: The number of formal parameters for the executable this object represents"
 ([this] (.getParameterCount ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getExceptionTypes
 "-- () -> Class<?>[]\nReturns an array of {@code Class} objects that represent the types of exceptions declared to be thrown by the underlying executable represented by this object.  Returns an array of length 0 if the executable declares no exceptions in its {@code throws} clause.\n- return: the exception types declared as being thrown by the executable this object represents"
 ([this] (.getExceptionTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:isSynthetic
 "-- () -> boolean\nReturns {@code true} if this executable is a synthetic construct; returns {@code false} otherwise.\n- return: true if and only if this executable is a synthetic construct as defined by <cite>The Java Language Specification</cite>.\n- jls: 13.1 The Form of a Binary"
 ([this] (.isSynthetic ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getGenericParameterTypes
 "-- () -> Type[]\nReturns an array of {@code Type} objects that represent the formal parameter types, in declaration order, of the executable represented by this object. Returns an array of length 0 if the underlying executable takes no parameters. Note that the constructors of some inner classes may have an implicitly declared parameter in addition to explicitly declared ones.  <p>If a formal parameter type is a parameterized type, the {@code Type} object returned for it must accurately reflect the actual type arguments used in the source code.  <p>If a formal parameter type is a type variable or a parameterized type, it is created. Otherwise, it is resolved.\n- return: an array of {@code Type} s that represent the formal parameter types of the underlying executable, in declaration order\n- throws GenericSignatureFormatError: if the generic method signature does not conform to the format specified in <cite>The Java Virtual Machine Specification</cite>\n- throws TypeNotPresentException: if any of the parameter types of the underlying executable refers to a non-existent type declaration\n- throws MalformedParameterizedTypeException: if any of the underlying executable's parameter types refer to a parameterized type that cannot be instantiated for any reason"
 ([this]
  (.getGenericParameterTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotation
 "-- (Class<T> annotationClass) -> T\n{@inheritDoc}\n- throws NullPointerException: {@inheritDoc}"
 ([this annotationClass]
  (.getAnnotation
   ^"java.lang.reflect.Executable" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Executable:getParameters
 "-- () -> Parameter[]\nReturns an array of {@code Parameter} objects that represent all the parameters to the underlying executable represented by this object.  Returns an array of length 0 if the executable has no parameters.  <p>The parameters of the underlying executable do not necessarily have unique names, or names that are legal identifiers in the Java programming language (JLS 3.8).\n- throws MalformedParametersException: if the class file contains a MethodParameters attribute that is improperly formatted.\n- return: an array of {@code Parameter} objects representing all the parameters to the executable this object represents."
 ([this] (.getParameters ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getDeclaredAnnotations
 "-- () -> Annotation[]\n{@inheritDoc}"
 ([this]
  (.getDeclaredAnnotations ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getName
 "-- () -> String\nReturns the name of the executable represented by this object."
 ([this] (.getName ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getGenericExceptionTypes
 "-- () -> Type[]\nReturns an array of {@code Type} objects that represent the exceptions declared to be thrown by this executable object. Returns an array of length 0 if the underlying executable declares no exceptions in its {@code throws} clause.  <p>If an exception type is a type variable or a parameterized type, it is created. Otherwise, it is resolved.\n- return: an array of Types that represent the exception types thrown by the underlying executable\n- throws GenericSignatureFormatError: if the generic method signature does not conform to the format specified in <cite>The Java Virtual Machine Specification</cite>\n- throws TypeNotPresentException: if the underlying executable's  {@code throws} clause refers to a non-existent type declaration\n- throws MalformedParameterizedTypeException: if the underlying executable's {@code throws} clause refers to a parameterized type that cannot be instantiated for any reason"
 ([this]
  (.getGenericExceptionTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getTypeParameters
 "-- () -> TypeVariable<?>[]\nReturns an array of {@code TypeVariable} objects that represent the type variables declared by the generic declaration represented by this {@code GenericDeclaration} object, in declaration order.  Returns an array of length 0 if the underlying generic declaration declares no type variables.\n- return: an array of {@code TypeVariable} objects that represent the type variables declared by this generic declaration\n- throws GenericSignatureFormatError: if the generic signature of this generic declaration does not conform to the format specified in <cite>The Java Virtual Machine Specification</cite>"
 ([this] (.getTypeParameters ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getParameterTypes
 "-- () -> Class<?>[]\nReturns an array of {@code Class} objects that represent the formal parameter types, in declaration order, of the executable represented by this object.  Returns an array of length 0 if the underlying executable takes no parameters. Note that the constructors of some inner classes may have an implicitly declared parameter in addition to explicitly declared ones.\n- return: the parameter types for the executable this object represents"
 ([this] (.getParameterTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotatedParameterTypes
 "-- () -> AnnotatedType[]\nReturns an array of {@code AnnotatedType} objects that represent the use of types to specify formal parameter types of the method/constructor represented by this Executable. The order of the objects in the array corresponds to the order of the formal parameter types in the declaration of the method/constructor.  Returns an array of length 0 if the method/constructor declares no parameters. Note that the constructors of some inner classes may have an implicitly declared parameter in addition to explicitly declared ones.\n- return: an array of objects representing the types of the formal parameters of the method or constructor represented by this {@code Executable}"
 ([this]
  (.getAnnotatedParameterTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotatedReceiverType
 "-- () -> AnnotatedType\nReturns an {@code AnnotatedType} object that represents the use of a type to specify the receiver type of the method/constructor represented by this {@code Executable} object.  The receiver type of a method/constructor is available only if the method/constructor has a receiver parameter (JLS 8.4.1). If this {@code Executable} object <em>represents an instance method or represents a constructor of an inner member class</em>, and the method/constructor <em>either</em> has no receiver parameter or has a receiver parameter with no annotations on its type, then the return value is an {@code AnnotatedType} object representing an element with no annotations.  If this {@code Executable} object represents a static method or represents a constructor of a top level, static member, local, or anonymous class, then the return value is null.\n- return: an object representing the receiver type of the method or constructor represented by this {@code Executable} or {@code null} if this {@code Executable} can not have a receiver parameter\n- jls: 8.4 Method Declarations\n- jls: 8.4.1 Formal Parameters\n- jls: 8.8 Constructor Declarations"
 ([this]
  (.getAnnotatedReceiverType ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotatedReturnType
 "-- () -> AnnotatedType\nReturns an {@code AnnotatedType} object that represents the use of a type to specify the return type of the method/constructor represented by this Executable.  If this {@code Executable} object represents a constructor, the {@code AnnotatedType} object represents the type of the constructed object.  If this {@code Executable} object represents a method, the {@code AnnotatedType} object represents the use of a type to specify the return type of the method.\n- return: an object representing the return type of the method or constructor represented by this {@code Executable}"
 ([this]
  (.getAnnotatedReturnType ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotationsByType
 "-- (Class<T> annotationClass) -> T[]\n{@inheritDoc}\n- throws NullPointerException: {@inheritDoc}"
 ([this annotationClass]
  (.getAnnotationsByType
   ^"java.lang.reflect.Executable" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Executable:getDeclaringClass
 "-- () -> Class<?>\nReturns the {@code Class} object representing the class or interface that declares the executable represented by this object."
 ([this] (.getDeclaringClass ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getParameterAnnotations
 "-- () -> Annotation[][]\nReturns an array of arrays of {@code Annotation} s that represent the annotations on the formal parameters, in declaration order, of the {@code Executable} represented by this object.  Synthetic and mandated parameters (see explanation below), such as the outer \"this\" parameter to an inner class constructor will be represented in the returned array.  If the executable has no parameters (meaning no formal, no synthetic, and no mandated parameters), a zero-length array will be returned.  If the {@code Executable} has one or more parameters, a nested array of length zero is returned for each parameter with no annotations. The annotation objects contained in the returned arrays are serializable.  The caller of this method is free to modify the returned arrays; it will have no effect on the arrays returned to other callers.  A compiler may add extra parameters that are implicitly declared in source (\"mandated\"), as well as parameters that are neither implicitly nor explicitly declared in source (\"synthetic\") to the parameter list for a method.  See {@link java.lang.reflect.Parameter} for more information.  <p>Note that any annotations returned by this method are declaration annotations.\n- see: java.lang.reflect.Parameter\n- see: java.lang.reflect.Parameter#getAnnotations\n- return: an array of arrays that represent the annotations on the formal and implicit parameters, in declaration order, of the executable represented by this object"
 ([this]
  (.getParameterAnnotations ^"java.lang.reflect.Executable" this)))

(def
 Executable:class
 "A shared superclass for the common functionality of {@link Method}  and {@link Constructor} .\n- since: 1.8"
 java.lang.reflect.Executable)

(clojure.core/defn
 Executable?
 "Checks if x is an instance of java.lang.reflect.Executable."
 [x]
 (clojure.core/instance? java.lang.reflect.Executable x))

(clojure.core/defn
 Field:isEnumConstant
 "-- () -> boolean\nReturns {@code true} if this field represents an element of an enumerated class; returns {@code false} otherwise.\n- return: {@code true} if and only if this field represents an element of an enumerated class.\n- since: 1.5"
 ([this] (.isEnumConstant ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getByte
 "-- (Object obj) -> byte\nGets the value of a static or instance {@code byte} field.\n- param obj: the object to extract the {@code byte} value from\n- return: the value of the {@code byte} field\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if the field value cannot be converted to the type {@code byte} by a widening conversion.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#get"
 ([this obj]
  (.getByte ^"java.lang.reflect.Field" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:setBoolean
 "-- (Object obj, boolean z) -> void\nSets the value of a field as a {@code boolean} on the specified object. This method is equivalent to {@code set(obj, zObj)} , where {@code zObj} is a {@code Boolean} object and {@code zObj.booleanValue() == z} .\n- param obj: the object whose field should be modified\n- param z: the new value for the field of {@code obj}  being modified\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is either inaccessible or final; or if this {@code Field} object has no write access.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if an unwrapping conversion fails.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#set"
 ([this obj z]
  (.setBoolean
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj
   ^"boolean" z)))

(clojure.core/defn
 Field:getType
 "-- () -> Class<?>\nReturns a {@code Class} object that identifies the declared type for the field represented by this {@code Field} object.\n- return: a {@code Class} object identifying the declared type of the field represented by this object"
 ([this] (.getType ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:toGenericString
 "-- () -> String\nReturns a string describing this {@code Field} , including its generic type.  The format is the access modifiers for the field, if any, followed by the generic field type, followed by a space, followed by the fully-qualified name of the class declaring the field, followed by a period, followed by the name of the field.  <p>The modifiers are placed in canonical order as specified by \"The Java Language Specification\".  This is {@code public} , {@code protected} or {@code private} first, and then other modifiers in the following order: {@code static} , {@code final} , {@code transient} , {@code volatile} .\n- return: a string describing this {@code Field} , including its generic type\n- since: 1.5\n- jls: 8.3.1 Field Modifiers"
 ([this] (.toGenericString ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getModifiers
 "-- () -> int\nReturns the Java language modifiers for the field represented by this {@code Field} object, as an integer. The {@code Modifier} class should be used to decode the modifiers.\n- see: Modifier"
 ([this] (.getModifiers ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getShort
 "-- (Object obj) -> short\nGets the value of a static or instance field of type {@code short} or of another primitive type convertible to type {@code short} via a widening conversion.\n- param obj: the object to extract the {@code short} value from\n- return: the value of the field converted to type {@code short}\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if the field value cannot be converted to the type {@code short} by a widening conversion.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#get"
 ([this obj]
  (.getShort ^"java.lang.reflect.Field" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:isSynthetic
 "-- () -> boolean\nReturns {@code true} if this field is a synthetic field; returns {@code false} otherwise.\n- return: true if and only if this field is a synthetic field as defined by the Java Language Specification.\n- since: 1.5"
 ([this] (.isSynthetic ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:toString
 "-- () -> String\nReturns a string describing this {@code Field} .  The format is the access modifiers for the field, if any, followed by the field type, followed by a space, followed by the fully-qualified name of the class declaring the field, followed by a period, followed by the name of the field. For example: <pre> public static final int java.lang.Thread.MIN_PRIORITY private int java.io.FileDescriptor.fd </pre>  <p>The modifiers are placed in canonical order as specified by \"The Java Language Specification\".  This is {@code public} , {@code protected} or {@code private} first, and then other modifiers in the following order: {@code static} , {@code final} , {@code transient} , {@code volatile} .\n- return: a string describing this {@code Field}\n- jls: 8.3.1 Field Modifiers"
 ([this] (.toString ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getAnnotation
 "-- (Class<T> annotationClass) -> T\n{@inheritDoc}\n- throws NullPointerException: {@inheritDoc}\n- since: 1.5"
 ([this annotationClass]
  (.getAnnotation
   ^"java.lang.reflect.Field" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Field:getDeclaredAnnotations
 "-- () -> Annotation[]\n{@inheritDoc}"
 ([this] (.getDeclaredAnnotations ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:setAccessible
 "-- (boolean flag) -> void\n\n- throws InaccessibleObjectException: {@inheritDoc}\n- throws SecurityException: {@inheritDoc}"
 ([this flag]
  (.setAccessible ^"java.lang.reflect.Field" this ^"boolean" flag)))

(clojure.core/defn
 Field:getName
 "-- () -> String\nReturns the name of the field represented by this {@code Field} object."
 ([this] (.getName ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getLong
 "-- (Object obj) -> long\nGets the value of a static or instance field of type {@code long} or of another primitive type convertible to type {@code long} via a widening conversion.\n- param obj: the object to extract the {@code long} value from\n- return: the value of the field converted to type {@code long}\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if the field value cannot be converted to the type {@code long} by a widening conversion.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#get"
 ([this obj]
  (.getLong ^"java.lang.reflect.Field" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:setDouble
 "-- (Object obj, double d) -> void\nSets the value of a field as a {@code double} on the specified object. This method is equivalent to {@code set(obj, dObj)} , where {@code dObj} is a {@code Double} object and {@code dObj.doubleValue() == d} .\n- param obj: the object whose field should be modified\n- param d: the new value for the field of {@code obj}  being modified\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is either inaccessible or final; or if this {@code Field} object has no write access.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if an unwrapping conversion fails.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#set"
 ([this obj d]
  (.setDouble
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj
   ^"double" d)))

(clojure.core/defn
 Field:getInt
 "-- (Object obj) -> int\nGets the value of a static or instance field of type {@code int} or of another primitive type convertible to type {@code int} via a widening conversion.\n- param obj: the object to extract the {@code int} value from\n- return: the value of the field converted to type {@code int}\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if the field value cannot be converted to the type {@code int} by a widening conversion.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#get"
 ([this obj]
  (.getInt ^"java.lang.reflect.Field" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:getAnnotatedType
 "-- () -> AnnotatedType\nReturns an AnnotatedType object that represents the use of a type to specify the declared type of the field represented by this Field.\n- return: an object representing the declared type of the field represented by this Field\n- since: 1.8"
 ([this] (.getAnnotatedType ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:setLong
 "-- (Object obj, long l) -> void\nSets the value of a field as a {@code long} on the specified object. This method is equivalent to {@code set(obj, lObj)} , where {@code lObj} is a {@code Long} object and {@code lObj.longValue() == l} .\n- param obj: the object whose field should be modified\n- param l: the new value for the field of {@code obj}  being modified\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is either inaccessible or final; or if this {@code Field} object has no write access.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if an unwrapping conversion fails.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#set"
 ([this obj l]
  (.setLong
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj
   ^"long" l)))

(clojure.core/defn
 Field:getChar
 "-- (Object obj) -> char\nGets the value of a static or instance field of type {@code char} or of another primitive type convertible to type {@code char} via a widening conversion.\n- param obj: the object to extract the {@code char} value from\n- return: the value of the field converted to type {@code char}\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if the field value cannot be converted to the type {@code char} by a widening conversion.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#get"
 ([this obj]
  (.getChar ^"java.lang.reflect.Field" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:getAnnotationsByType
 "-- (Class<T> annotationClass) -> T[]\n{@inheritDoc}\n- throws NullPointerException: {@inheritDoc}\n- since: 1.8"
 ([this annotationClass]
  (.getAnnotationsByType
   ^"java.lang.reflect.Field" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Field:setByte
 "-- (Object obj, byte b) -> void\nSets the value of a field as a {@code byte} on the specified object. This method is equivalent to {@code set(obj, bObj)} , where {@code bObj} is a {@code Byte} object and {@code bObj.byteValue() == b} .\n- param obj: the object whose field should be modified\n- param b: the new value for the field of {@code obj}  being modified\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is either inaccessible or final; or if this {@code Field} object has no write access.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if an unwrapping conversion fails.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#set"
 ([this obj b]
  (.setByte
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj
   ^"byte" b)))

(clojure.core/defn
 Field:getDeclaringClass
 "-- () -> Class<?>\nReturns the {@code Class} object representing the class or interface that declares the field represented by this {@code Field} object."
 ([this] (.getDeclaringClass ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:setShort
 "-- (Object obj, short s) -> void\nSets the value of a field as a {@code short} on the specified object. This method is equivalent to {@code set(obj, sObj)} , where {@code sObj} is a {@code Short} object and {@code sObj.shortValue() == s} .\n- param obj: the object whose field should be modified\n- param s: the new value for the field of {@code obj}  being modified\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is either inaccessible or final; or if this {@code Field} object has no write access.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if an unwrapping conversion fails.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#set"
 ([this obj s]
  (.setShort
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj
   ^"short" s)))

(clojure.core/defn
 Field:setInt
 "-- (Object obj, int i) -> void\nSets the value of a field as an {@code int} on the specified object. This method is equivalent to {@code set(obj, iObj)} , where {@code iObj} is an {@code Integer} object and {@code iObj.intValue() == i} .\n- param obj: the object whose field should be modified\n- param i: the new value for the field of {@code obj}  being modified\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is either inaccessible or final; or if this {@code Field} object has no write access.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if an unwrapping conversion fails.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#set"
 ([this obj i]
  (.setInt
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj
   ^"int" i)))

(clojure.core/defn
 Field:getGenericType
 "-- () -> Type\nReturns a {@code Type} object that represents the declared type for the field represented by this {@code Field} object.  <p>If the declared type of the field is a parameterized type, the {@code Type} object returned must accurately reflect the actual type arguments used in the source code.  <p>If the type of the underlying field is a type variable or a parameterized type, it is created. Otherwise, it is resolved.\n- return: a {@code Type} object that represents the declared type for the field represented by this {@code Field} object\n- throws GenericSignatureFormatError: if the generic field signature does not conform to the format specified in <cite>The Java Virtual Machine Specification</cite>\n- throws TypeNotPresentException: if the generic type signature of the underlying field refers to a non-existent class or interface declaration\n- throws MalformedParameterizedTypeException: if the generic signature of the underlying field refers to a parameterized type that cannot be instantiated for any reason\n- since: 1.5"
 ([this] (.getGenericType ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:hashCode
 "-- () -> int\nReturns a hashcode for this {@code Field} .  This is computed as the exclusive-or of the hashcodes for the underlying field's declaring class name and its name."
 ([this] (.hashCode ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:set
 "-- (Object obj, Object value) -> void\nSets the field represented by this {@code Field} object on the specified object argument to the specified new value. The new value is automatically unwrapped if the underlying field has a primitive type.  <p>The operation proceeds as follows:  <p>If the underlying field is static, the {@code obj} argument is ignored; it may be null.  <p>Otherwise the underlying field is an instance field.  If the specified object argument is null, the method throws a {@code NullPointerException} .  If the specified object argument is not an instance of the class or interface declaring the underlying field, the method throws an {@code IllegalArgumentException} .  <p>If this {@code Field} object is enforcing Java language access control, and the underlying field is inaccessible, the method throws an {@code IllegalAccessException} .  <p>If the underlying field is final, this {@code Field} object has <em>write</em> access if and only if the following conditions are met: <ul> <li> {@link #setAccessible(boolean) setAccessible(true)} has succeeded for this {@code Field} object;</li> <li>the field is non-static; and</li> <li>the field's declaring class is not a {@linkplain Class#isHidden() hidden class} ; and</li> <li>the field's declaring class is not a {@linkplain Class#isRecord() record class} .</li> </ul> If any of the above checks is not met, this method throws an {@code IllegalAccessException} .  <p> Setting a final field in this way is meaningful only during deserialization or reconstruction of instances of classes with blank final fields, before they are made available for access by other parts of a program. Use in any other context may have unpredictable effects, including cases in which other parts of a program continue to use the original value of this field.  <p>If the underlying field is of a primitive type, an unwrapping conversion is attempted to convert the new value to a value of a primitive type.  If this attempt fails, the method throws an {@code IllegalArgumentException} .  <p>If, after possible unwrapping, the new value cannot be converted to the type of the underlying field by an identity or widening conversion, the method throws an {@code IllegalArgumentException} .  <p>If the underlying field is static, the class that declared the field is initialized if it has not already been initialized.  <p>The field is set to the possibly unwrapped and widened new value.  <p>If the field is hidden in the type of {@code obj} , the field's value is set according to the preceding rules.\n- param obj: the object whose field should be modified\n- param value: the new value for the field of {@code obj}  being modified\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible or final; or if this {@code Field} object has no write access.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if an unwrapping conversion fails.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails."
 ([this obj value]
  (.set
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj
   ^"java.lang.Object" value)))

(clojure.core/defn
 Field:getBoolean
 "-- (Object obj) -> boolean\nGets the value of a static or instance {@code boolean} field.\n- param obj: the object to extract the {@code boolean} value from\n- return: the value of the {@code boolean} field\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if the field value cannot be converted to the type {@code boolean} by a widening conversion.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#get"
 ([this obj]
  (.getBoolean
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:getFloat
 "-- (Object obj) -> float\nGets the value of a static or instance field of type {@code float} or of another primitive type convertible to type {@code float} via a widening conversion.\n- param obj: the object to extract the {@code float} value from\n- return: the value of the field converted to type {@code float}\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if the field value cannot be converted to the type {@code float} by a widening conversion.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#get"
 ([this obj]
  (.getFloat ^"java.lang.reflect.Field" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:getDouble
 "-- (Object obj) -> double\nGets the value of a static or instance field of type {@code double} or of another primitive type convertible to type {@code double} via a widening conversion.\n- param obj: the object to extract the {@code double} value from\n- return: the value of the field converted to type {@code double}\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if the field value cannot be converted to the type {@code double} by a widening conversion.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#get"
 ([this obj]
  (.getDouble
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:get
 "-- (Object obj) -> Object\nReturns the value of the field represented by this {@code Field} , on the specified object. The value is automatically wrapped in an object if it has a primitive type.  <p>The underlying field's value is obtained as follows:  <p>If the underlying field is a static field, the {@code obj} argument is ignored; it may be null.  <p>Otherwise, the underlying field is an instance field.  If the specified {@code obj} argument is null, the method throws a {@code NullPointerException} . If the specified object is not an instance of the class or interface declaring the underlying field, the method throws an {@code IllegalArgumentException} .  <p>If this {@code Field} object is enforcing Java language access control, and the underlying field is inaccessible, the method throws an {@code IllegalAccessException} . If the underlying field is static, the class that declared the field is initialized if it has not already been initialized.  <p>Otherwise, the value is retrieved from the underlying instance or static field.  If the field has a primitive type, the value is wrapped in an object before being returned, otherwise it is returned as is.  <p>If the field is hidden in the type of {@code obj} , the field's value is obtained according to the preceding rules.\n- param obj: object from which the represented field's value is to be extracted\n- return: the value of the represented field in object {@code obj} ; primitive values are wrapped in an appropriate object before being returned\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is inaccessible.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof).\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails."
 ([this obj]
  (.get ^"java.lang.reflect.Field" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:equals
 "-- (Object obj) -> boolean\nCompares this {@code Field} against the specified object.  Returns true if the objects are the same.  Two {@code Field} objects are the same if they were declared by the same class and have the same name and type."
 ([this obj]
  (.equals ^"java.lang.reflect.Field" this ^"java.lang.Object" obj)))

(clojure.core/defn
 Field:setFloat
 "-- (Object obj, float f) -> void\nSets the value of a field as a {@code float} on the specified object. This method is equivalent to {@code set(obj, fObj)} , where {@code fObj} is a {@code Float} object and {@code fObj.floatValue() == f} .\n- param obj: the object whose field should be modified\n- param f: the new value for the field of {@code obj}  being modified\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is either inaccessible or final; or if this {@code Field} object has no write access.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if an unwrapping conversion fails.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#set"
 ([this obj f]
  (.setFloat
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj
   ^"float" f)))

(clojure.core/defn
 Field:setChar
 "-- (Object obj, char c) -> void\nSets the value of a field as a {@code char} on the specified object. This method is equivalent to {@code set(obj, cObj)} , where {@code cObj} is a {@code Character} object and {@code cObj.charValue() == c} .\n- param obj: the object whose field should be modified\n- param c: the new value for the field of {@code obj}  being modified\n- throws IllegalAccessException: if this {@code Field} object is enforcing Java language access control and the underlying field is either inaccessible or final; or if this {@code Field} object has no write access.\n- throws IllegalArgumentException: if the specified object is not an instance of the class or interface declaring the underlying field (or a subclass or implementor thereof), or if an unwrapping conversion fails.\n- throws NullPointerException: if the specified object is null and the field is an instance field.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails.\n- see: Field#set"
 ([this obj c]
  (.setChar
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" obj
   ^"char" c)))

(def
 Field:class
 "A {@code Field} provides information about, and dynamic access to, a single field of a class or an interface.  The reflected field may be a class (static) field or an instance field.  <p>A {@code Field} permits widening conversions to occur during a get or set access operation, but throws an {@code IllegalArgumentException} if a narrowing conversion would occur.\n- see: Member\n- see: java.lang.Class\n- see: java.lang.Class#getFields()\n- see: java.lang.Class#getField(String)\n- see: java.lang.Class#getDeclaredFields()\n- see: java.lang.Class#getDeclaredField(String)\n- author: Kenneth Russell\n- author: Nakul Saraiya\n- since: 1.1"
 java.lang.reflect.Field)

(clojure.core/defn
 Field?
 "Checks if x is an instance of java.lang.reflect.Field."
 [x]
 (clojure.core/instance? java.lang.reflect.Field x))

(clojure.core/defn
 Constructor:newInstance
 "-- (Object initargs) -> T\nUses the constructor represented by this {@code Constructor} object to create and initialize a new instance of the constructor's declaring class, with the specified initialization parameters. Individual parameters are automatically unwrapped to match primitive formal parameters, and both primitive and reference parameters are subject to method invocation conversions as necessary.  <p>If the number of formal parameters required by the underlying constructor is 0, the supplied {@code initargs} array may be of length 0 or null.  <p>If the constructor's declaring class is an inner class in a non-static context, the first argument to the constructor needs to be the enclosing instance; see section {@jls 15.9.3} of <cite>The Java Language Specification</cite>.  <p>If the required access and argument checks succeed and the instantiation will proceed, the constructor's declaring class is initialized if it has not already been initialized.  <p>If the constructor completes normally, returns the newly created and initialized instance.\n- param initargs: array of objects to be passed as arguments to the constructor call; values of primitive types are wrapped in a wrapper object of the appropriate type (e.g. a {@code float}  in a {@link java.lang.Float Float} )\n- return: a new object created by calling the constructor this object represents\n- throws IllegalAccessException: if this {@code Constructor} object is enforcing Java language access control and the underlying constructor is inaccessible.\n- throws IllegalArgumentException: if the number of actual and formal parameters differ; if an unwrapping conversion for primitive arguments fails; or if, after possible unwrapping, a parameter value cannot be converted to the corresponding formal parameter type by a method invocation conversion; if this constructor pertains to an enum class.\n- throws InstantiationException: if the class that declares the underlying constructor represents an abstract class.\n- throws InvocationTargetException: if the underlying constructor throws an exception.\n- throws ExceptionInInitializerError: if the initialization provoked by this method fails."
 ([this initargs]
  (.newInstance
   ^"java.lang.reflect.Constructor" this
   ^"[Ljava.lang.Object;" initargs)))

(clojure.core/defn
 Constructor:isVarArgs
 "-- () -> boolean\n{@inheritDoc}\n- since: 1.5"
 ([this] (.isVarArgs ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:toGenericString
 "-- () -> String\nReturns a string describing this {@code Constructor} , including type parameters.  The string is formatted as the constructor access modifiers, if any, followed by an angle-bracketed comma separated list of the constructor's type parameters, if any, including  informative bounds of the type parameters, if any, followed by the fully-qualified name of the declaring class, followed by a parenthesized, comma-separated list of the constructor's generic formal parameter types.  If this constructor was declared to take a variable number of arguments, instead of denoting the last parameter as \"<code><i>Type</i>[]</code>\", it is denoted as \"<code><i>Type</i>...</code>\".  A space is used to separate access modifiers from one another and from the type parameters or class name.  If there are no type parameters, the type parameter list is elided; if the type parameter list is present, a space separates the list from the class name.  If the constructor is declared to throw exceptions, the parameter list is followed by a space, followed by the word \" {@code throws} \" followed by a comma-separated list of the generic thrown exception types.  <p>The only possible modifiers for constructors are the access modifiers {@code public} , {@code protected} or {@code private} .  Only one of these may appear, or none if the constructor has default (package) access.\n- return: a string describing this {@code Constructor} , include type parameters\n- since: 1.5\n- jls: 8.8.3 Constructor Modifiers\n- jls: 8.9.2 Enum Body Declarations"
 ([this] (.toGenericString ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getModifiers
 "-- () -> int\n{@inheritDoc}"
 ([this] (.getModifiers ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getParameterCount
 "-- () -> int\n{@inheritDoc}\n- since: 1.8"
 ([this] (.getParameterCount ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getExceptionTypes
 "-- () -> Class<?>[]\n{@inheritDoc}"
 ([this] (.getExceptionTypes ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:isSynthetic
 "-- () -> boolean\n{@inheritDoc}\n- jls: 13.1 The Form of a Binary\n- since: 1.5"
 ([this] (.isSynthetic ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getGenericParameterTypes
 "-- () -> Type[]\n{@inheritDoc}\n- throws GenericSignatureFormatError: {@inheritDoc}\n- throws TypeNotPresentException: {@inheritDoc}\n- throws MalformedParameterizedTypeException: {@inheritDoc}\n- since: 1.5"
 ([this]
  (.getGenericParameterTypes ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:toString
 "-- () -> String\nReturns a string describing this {@code Constructor} .  The string is formatted as the constructor access modifiers, if any, followed by the fully-qualified name of the declaring class, followed by a parenthesized, comma-separated list of the constructor's formal parameter types.  For example: <pre> {@code public java.util.Hashtable(int,float) } </pre>  <p>If the constructor is declared to throw exceptions, the parameter list is followed by a space, followed by the word \" {@code throws} \" followed by a comma-separated list of the thrown exception types.  <p>The only possible modifiers for constructors are the access modifiers {@code public} , {@code protected} or {@code private} .  Only one of these may appear, or none if the constructor has default (package) access.\n- return: a string describing this {@code Constructor}\n- jls: 8.8.3 Constructor Modifiers\n- jls: 8.9.2 Enum Body Declarations"
 ([this] (.toString ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getAnnotation
 "-- (Class<T> annotationClass) -> T\n{@inheritDoc}\n- throws NullPointerException: {@inheritDoc}\n- since: 1.5"
 ([this annotationClass]
  (.getAnnotation
   ^"java.lang.reflect.Constructor" this
   ^"java.lang.Class" annotationClass)))

(clojure.core/defn
 Constructor:getDeclaredAnnotations
 "-- () -> Annotation[]\n{@inheritDoc}\n- since: 1.5"
 ([this]
  (.getDeclaredAnnotations ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:setAccessible
 "-- (boolean flag) -> void\n{@inheritDoc}   <p> A {@code SecurityException} is also thrown if this object is a {@code Constructor} object for the class {@code Class} and {@code flag}  is true. </p>\n- param flag: {@inheritDoc}\n- throws InaccessibleObjectException: {@inheritDoc}\n- throws SecurityException: if the request is denied by the security manager or this is a constructor for {@code java.lang.Class}"
 ([this flag]
  (.setAccessible
   ^"java.lang.reflect.Constructor" this
   ^"boolean" flag)))

(clojure.core/defn
 Constructor:getName
 "-- () -> String\nReturns the name of this constructor, as a string.  This is the binary name of the constructor's declaring class."
 ([this] (.getName ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getGenericExceptionTypes
 "-- () -> Type[]\n{@inheritDoc}\n- throws GenericSignatureFormatError: {@inheritDoc}\n- throws TypeNotPresentException: {@inheritDoc}\n- throws MalformedParameterizedTypeException: {@inheritDoc}\n- since: 1.5"
 ([this]
  (.getGenericExceptionTypes ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getTypeParameters
 "-- () -> TypeVariable<Constructor<T>>[]\n{@inheritDoc}\n- throws GenericSignatureFormatError: {@inheritDoc}\n- since: 1.5"
 ([this] (.getTypeParameters ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getParameterTypes
 "-- () -> Class<?>[]\n{@inheritDoc}"
 ([this] (.getParameterTypes ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getAnnotatedReceiverType
 "-- () -> AnnotatedType\n{@inheritDoc}\n- since: 1.8"
 ([this]
  (.getAnnotatedReceiverType ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getAnnotatedReturnType
 "-- () -> AnnotatedType\n{@inheritDoc}\n- since: 1.8"
 ([this]
  (.getAnnotatedReturnType ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getDeclaringClass
 "-- () -> Class<T>\nReturns the {@code Class} object representing the class that declares the constructor represented by this object."
 ([this] (.getDeclaringClass ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:hashCode
 "-- () -> int\nReturns a hashcode for this {@code Constructor} . The hashcode is the same as the hashcode for the underlying constructor's declaring class name."
 ([this] (.hashCode ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getParameterAnnotations
 "-- () -> Annotation[][]\n{@inheritDoc}\n- since: 1.5"
 ([this]
  (.getParameterAnnotations ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:equals
 "-- (Object obj) -> boolean\nCompares this {@code Constructor} against the specified object. Returns true if the objects are the same.  Two {@code Constructor} objects are the same if they were declared by the same class and have the same formal parameter types."
 ([this obj]
  (.equals
   ^"java.lang.reflect.Constructor" this
   ^"java.lang.Object" obj)))

(def
 Constructor:class
 "{@code Constructor} provides information about, and access to, a single constructor for a class.  <p> {@code Constructor} permits widening conversions to occur when matching the actual parameters to newInstance() with the underlying constructor's formal parameters, but throws an {@code IllegalArgumentException} if a narrowing conversion would occur.\n- param <T>: the class in which the constructor is declared\n- see: Member\n- see: java.lang.Class\n- see: java.lang.Class#getConstructors()\n- see: java.lang.Class#getConstructor(Class[])\n- see: java.lang.Class#getDeclaredConstructors()\n- author: Kenneth Russell\n- author: Nakul Saraiya\n- since: 1.1"
 java.lang.reflect.Constructor)

(clojure.core/defn
 Constructor?
 "Checks if x is an instance of java.lang.reflect.Constructor."
 [x]
 (clojure.core/instance? java.lang.reflect.Constructor x))

(clojure.core/defn
 System:setSecurityManager
 "-- (SecurityManager sm) -> void\nSets the system-wide security manager.  If there is a security manager already installed, this method first calls the security manager's {@code checkPermission} method with a {@code RuntimePermission(\"setSecurityManager\")}  permission to ensure it's ok to replace the existing security manager. This may result in throwing a {@code SecurityException} .  <p> Otherwise, the argument is established as the current security manager. If the argument is {@code null} and no security manager has been established, then no action is taken and the method simply returns.\n- implNote: In the JDK implementation, if the Java virtual machine is started with the system property {@code java.security.manager} set to the special token \" {@code disallow} \" then the {@code setSecurityManager}  method cannot be used to set a security manager.\n- param sm: the security manager or {@code null}\n- throws SecurityException: if the security manager has already been set and its {@code checkPermission} method doesn't allow it to be replaced\n- throws UnsupportedOperationException: if {@code sm} is non-null and a security manager is not allowed to be set dynamically\n- see: #getSecurityManager\n- see: SecurityManager#checkPermission\n- see: java.lang.RuntimePermission"
 ([sm]
  (java.lang.System/setSecurityManager
   ^"java.lang.SecurityManager" sm)))

(clojure.core/defn
 System:mapLibraryName
 "-- (String libname) -> String\nMaps a library name into a platform-specific string representing a native library.\n- param libname: the name of the library.\n- return: a platform-dependent native library name.\n- throws NullPointerException: if {@code libname} is {@code null}\n- see: java.lang.System#loadLibrary(java.lang.String)\n- see: java.lang.ClassLoader#findLibrary(java.lang.String)\n- since: 1.2"
 ([libname]
  (java.lang.System/mapLibraryName ^"java.lang.String" libname)))

(clojure.core/defn
 System:arraycopy
 "-- (Object src, int srcPos, Object dest, int destPos, int length) -> void\nCopies an array from the specified source array, beginning at the specified position, to the specified position of the destination array. A subsequence of array components are copied from the source array referenced by {@code src} to the destination array referenced by {@code dest} . The number of components copied is equal to the {@code length} argument. The components at positions {@code srcPos} through {@code srcPos+length-1} in the source array are copied into positions {@code destPos} through {@code destPos+length-1} , respectively, of the destination array. <p> If the {@code src} and {@code dest} arguments refer to the same array object, then the copying is performed as if the components at positions {@code srcPos} through {@code srcPos+length-1} were first copied to a temporary array with {@code length} components and then the contents of the temporary array were copied into positions {@code destPos} through {@code destPos+length-1} of the destination array. <p> If {@code dest} is {@code null} , then a {@code NullPointerException} is thrown. <p> If {@code src} is {@code null} , then a {@code NullPointerException} is thrown and the destination array is not modified. <p> Otherwise, if any of the following is true, an {@code ArrayStoreException} is thrown and the destination is not modified: <ul> <li>The {@code src} argument refers to an object that is not an array. <li>The {@code dest} argument refers to an object that is not an array. <li>The {@code src} argument and {@code dest} argument refer to arrays whose component types are different primitive types. <li>The {@code src} argument refers to an array with a primitive component type and the {@code dest} argument refers to an array with a reference component type. <li>The {@code src} argument refers to an array with a reference component type and the {@code dest} argument refers to an array with a primitive component type. </ul> <p> Otherwise, if any of the following is true, an {@code IndexOutOfBoundsException} is thrown and the destination is not modified: <ul> <li>The {@code srcPos} argument is negative. <li>The {@code destPos} argument is negative. <li>The {@code length} argument is negative. <li> {@code srcPos+length} is greater than  {@code src.length} , the length of the source array. <li> {@code destPos+length} is greater than  {@code dest.length} , the length of the destination array. </ul> <p> Otherwise, if any actual component of the source array from position {@code srcPos} through {@code srcPos+length-1} cannot be converted to the component type of the destination array by assignment conversion, an {@code ArrayStoreException} is thrown. In this case, let <b><i>k</i></b> be the smallest nonnegative integer less than length such that {@code src[srcPos+} <i>k</i> {@code ]}  cannot be converted to the component type of the destination array; when the exception is thrown, source array components from positions {@code srcPos} through {@code srcPos+} <i>k</i> {@code -1}  will already have been copied to destination array positions {@code destPos} through {@code destPos+} <i>k</I> {@code -1} and no other positions of the destination array will have been modified. (Because of the restrictions already itemized, this paragraph effectively applies only to the situation where both arrays have component types that are reference types.)\n- param src: the source array.\n- param srcPos: starting position in the source array.\n- param dest: the destination array.\n- param destPos: starting position in the destination data.\n- param length: the number of array elements to be copied.\n- throws IndexOutOfBoundsException: if copying would cause access of data outside array bounds.\n- throws ArrayStoreException: if an element in the {@code src}  array could not be stored into the {@code dest} array because of a type mismatch.\n- throws NullPointerException: if either {@code src} or  {@code dest} is {@code null} ."
 ([src srcPos dest destPos length]
  (java.lang.System/arraycopy
   ^"java.lang.Object" src
   ^"int" srcPos
   ^"java.lang.Object" dest
   ^"int" destPos
   ^"int" length)))

(clojure.core/defn
 System:inheritedChannel
 "-- () -> Channel\nReturns the channel inherited from the entity that created this Java virtual machine.  This method returns the channel obtained by invoking the {@link java.nio.channels.spi.SelectorProvider#inheritedChannel inheritedChannel} method of the system-wide default {@link java.nio.channels.spi.SelectorProvider} object.  <p> In addition to the network-oriented channels described in {@link java.nio.channels.spi.SelectorProvider#inheritedChannel inheritedChannel} , this method may return other kinds of channels in the future.\n- return: The inherited channel, if any, otherwise {@code null} .\n- throws IOException: If an I/O error occurs\n- throws SecurityException: If a security manager is present and it does not permit access to the channel.\n- since: 1.5"
 ([] (java.lang.System/inheritedChannel)))

(clojure.core/defn
 System:load
 "-- (String filename) -> void\nLoads the native library specified by the filename argument.  The filename argument must be an absolute path name.  If the filename argument, when stripped of any platform-specific library prefix, path, and file extension, indicates a library whose name is, for example, L, and a native library called L is statically linked with the VM, then the JNI_OnLoad_L function exported by the library is invoked rather than attempting to load a dynamic library. A filename matching the argument does not have to exist in the file system. See the <a href=\" {@docRoot} /../specs/jni/index.html\"> JNI Specification</a> for more details.  Otherwise, the filename argument is mapped to a native library image in an implementation-dependent manner.  <p> The call {@code System.load(name)} is effectively equivalent to the call: <blockquote><pre> Runtime.getRuntime().load(name) </pre></blockquote>\n- param filename: the file to load.\n- throws SecurityException: if a security manager exists and its  {@code checkLink} method doesn't allow loading of the specified dynamic library\n- throws UnsatisfiedLinkError: if either the filename is not an absolute path name, the native library is not statically linked with the VM, or the library cannot be mapped to a native library image by the host system.\n- throws NullPointerException: if {@code filename} is {@code null}\n- see: java.lang.Runtime#load(java.lang.String)\n- see: java.lang.SecurityManager#checkLink(java.lang.String)"
 ([filename] (java.lang.System/load ^"java.lang.String" filename)))

(clojure.core/defn
 System:clearProperty
 "-- (String key) -> String\nRemoves the system property indicated by the specified key.  First, if a security manager exists, its {@code SecurityManager.checkPermission} method is called with a {@code PropertyPermission(key, \"write\")}  permission. This may result in a SecurityException being thrown. If no exception is thrown, the specified property is removed.\n- apiNote: <strong>Changing a standard system property may have unpredictable results unless otherwise specified</strong>. See {@linkplain #getProperties getProperties} method for details.\n- param key: the name of the system property to be removed.\n- return: the previous string value of the system property, or {@code null} if there was no property with that key.\n- throws SecurityException: if a security manager exists and its  {@code checkPropertyAccess} method doesn't allow access to the specified system property.\n- throws NullPointerException: if {@code key} is {@code null} .\n- throws IllegalArgumentException: if {@code key} is empty.\n- see: #getProperty\n- see: #setProperty\n- see: java.util.Properties\n- see: java.lang.SecurityException\n- see: java.lang.SecurityManager#checkPropertiesAccess()\n- since: 1.5"
 ([key] (java.lang.System/clearProperty ^"java.lang.String" key)))

(clojure.core/defn
 System:currentTimeMillis
 "-- () -> long\nReturns the current time in milliseconds.  Note that while the unit of time of the return value is a millisecond, the granularity of the value depends on the underlying operating system and may be larger.  For example, many operating systems measure time in units of tens of milliseconds.  <p> See the description of the class {@code Date} for a discussion of slight discrepancies that may arise between \"computer time\" and coordinated universal time (UTC).\n- return: the difference, measured in milliseconds, between the current time and midnight, January 1, 1970 UTC.\n- see: java.util.Date"
 ([] (java.lang.System/currentTimeMillis)))

(clojure.core/defn
 System:getSecurityManager
 "-- () -> SecurityManager\nGets the system-wide security manager.\n- return: if a security manager has already been established for the current application, then that security manager is returned; otherwise, {@code null} is returned.\n- see: #setSecurityManager"
 ([] (java.lang.System/getSecurityManager)))

(clojure.core/defn
 System:setIn
 "-- (InputStream in) -> void\nReassigns the \"standard\" input stream.  First, if there is a security manager, its {@code checkPermission}  method is called with a {@code RuntimePermission(\"setIO\")} permission to see if it's ok to reassign the \"standard\" input stream.\n- param in: the new standard input stream.\n- throws SecurityException: if a security manager exists and its  {@code checkPermission} method doesn't allow reassigning of the standard input stream.\n- see: SecurityManager#checkPermission\n- see: java.lang.RuntimePermission\n- since: 1.1"
 ([in] (java.lang.System/setIn ^"java.io.InputStream" in)))

(clojure.core/defn
 System:console
 "-- () -> Console\nReturns the unique {@link java.io.Console Console} object associated with the current Java virtual machine, if any.\n- return: The system console, if any, otherwise {@code null} .\n- since: 1.6"
 ([] (java.lang.System/console)))

(clojure.core/defn
 System:getenv
 "-- () -> java.util.Map<String, String>\nReturns an unmodifiable string map view of the current system environment. The environment is a system-dependent mapping from names to values which is passed from parent to child processes.  <p>If the system does not support environment variables, an empty map is returned.  <p>The returned map will never contain null keys or values. Attempting to query the presence of a null key or value will throw a {@link NullPointerException} .  Attempting to query the presence of a key or value which is not of type {@link String} will throw a {@link ClassCastException} .  <p>The returned map and its collection views may not obey the general contract of the {@link Object#equals} and {@link Object#hashCode} methods.  <p>The returned map is typically case-sensitive on all platforms.  <p>If a security manager exists, its {@link SecurityManager#checkPermission checkPermission}  method is called with a {@link RuntimePermission RuntimePermission(\"getenv.*\")} permission. This may result in a {@link SecurityException} being thrown.  <p>When passing information to a Java subprocess, <a href=#EnvironmentVSSystemProperties>system properties</a> are generally preferred over environment variables.\n- return: the environment as a map of variable names to values\n- throws SecurityException: if a security manager exists and its  {@link SecurityManager#checkPermission checkPermission}  method doesn't allow access to the process environment\n- see: #getenv(String)\n- see: ProcessBuilder#environment()\n- since: 1.5\n-- (String name) -> String\nGets the value of the specified environment variable. An environment variable is a system-dependent external named value.  <p>If a security manager exists, its {@link SecurityManager#checkPermission checkPermission}  method is called with a {@link RuntimePermission RuntimePermission(\"getenv.\"+name)}  permission.  This may result in a {@link SecurityException}  being thrown.  If no exception is thrown the value of the variable {@code name} is returned.  <p><a id=\"EnvironmentVSSystemProperties\"><i>System properties</i> and <i>environment variables</i></a> are both conceptually mappings between names and values.  Both mechanisms can be used to pass user-defined information to a Java process.  Environment variables have a more global effect, because they are visible to all descendants of the process which defines them, not just the immediate Java subprocess. They can have subtly different semantics, such as case insensitivity, on different operating systems.  For these reasons, environment variables are more likely to have unintended side effects.  It is best to use system properties where possible.  Environment variables should be used when a global effect is desired, or when an external system interface requires an environment variable (such as {@code PATH} ).  <p>On UNIX systems the alphabetic case of {@code name} is typically significant, while on Microsoft Windows systems it is typically not.  For example, the expression {@code System.getenv(\"FOO\").equals(System.getenv(\"foo\"))}  is likely to be true on Microsoft Windows.\n- param name: the name of the environment variable\n- return: the string value of the variable, or {@code null}  if the variable is not defined in the system environment\n- throws NullPointerException: if {@code name} is {@code null}\n- throws SecurityException: if a security manager exists and its  {@link SecurityManager#checkPermission checkPermission}  method doesn't allow access to the environment variable  {@code name}\n- see: #getenv()\n- see: ProcessBuilder#environment()"
 ([] (java.lang.System/getenv))
 ([name] (java.lang.System/getenv ^"java.lang.String" name)))

(clojure.core/defn
 System:getProperties
 "-- () -> Properties\nDetermines the current system properties.  First, if there is a security manager, its {@code checkPropertiesAccess} method is called with no arguments. This may result in a security exception. <p> The current set of system properties for use by the {@link #getProperty(String)} method is returned as a {@code Properties} object. If there is no current set of system properties, a set of system properties is first created and initialized. This set of system properties includes a value for each of the following keys unless the description of the associated value indicates that the value is optional. <table class=\"striped\" style=\"text-align:left\"> <caption style=\"display:none\">Shows property keys and associated values</caption> <thead> <tr><th scope=\"col\">Key</th> <th scope=\"col\">Description of Associated Value</th></tr> </thead> <tbody> <tr><th scope=\"row\"> {@systemProperty java.version} </th> <td>Java Runtime Environment version, which may be interpreted as a {@link Runtime.Version} </td></tr> <tr><th scope=\"row\"> {@systemProperty java.version.date} </th> <td>Java Runtime Environment version date, in ISO-8601 YYYY-MM-DD format, which may be interpreted as a {@link java.time.LocalDate} </td></tr> <tr><th scope=\"row\"> {@systemProperty java.vendor} </th> <td>Java Runtime Environment vendor</td></tr> <tr><th scope=\"row\"> {@systemProperty java.vendor.url} </th> <td>Java vendor URL</td></tr> <tr><th scope=\"row\"> {@systemProperty java.vendor.version} </th> <td>Java vendor version <em>(optional)</em> </td></tr> <tr><th scope=\"row\"> {@systemProperty java.home} </th> <td>Java installation directory</td></tr> <tr><th scope=\"row\"> {@systemProperty java.vm.specification.version} </th> <td>Java Virtual Machine specification version, whose value is the  {@linkplain Runtime.Version#feature feature} element of the  {@linkplain Runtime#version() runtime version} </td></tr> <tr><th scope=\"row\"> {@systemProperty java.vm.specification.vendor} </th> <td>Java Virtual Machine specification vendor</td></tr> <tr><th scope=\"row\"> {@systemProperty java.vm.specification.name} </th> <td>Java Virtual Machine specification name</td></tr> <tr><th scope=\"row\"> {@systemProperty java.vm.version} </th> <td>Java Virtual Machine implementation version which may be interpreted as a {@link Runtime.Version} </td></tr> <tr><th scope=\"row\"> {@systemProperty java.vm.vendor} </th> <td>Java Virtual Machine implementation vendor</td></tr> <tr><th scope=\"row\"> {@systemProperty java.vm.name} </th> <td>Java Virtual Machine implementation name</td></tr> <tr><th scope=\"row\"> {@systemProperty java.specification.version} </th> <td>Java Runtime Environment specification version, whose value is the {@linkplain Runtime.Version#feature feature} element of the  {@linkplain Runtime#version() runtime version} </td></tr> <tr><th scope=\"row\"> {@systemProperty java.specification.vendor} </th> <td>Java Runtime Environment specification  vendor</td></tr> <tr><th scope=\"row\"> {@systemProperty java.specification.name} </th> <td>Java Runtime Environment specification  name</td></tr> <tr><th scope=\"row\"> {@systemProperty java.class.version} </th> <td>Java class format version number</td></tr> <tr><th scope=\"row\"> {@systemProperty java.class.path} </th> <td>Java class path  (refer to  {@link ClassLoader#getSystemClassLoader()} for details)</td></tr> <tr><th scope=\"row\"> {@systemProperty java.library.path} </th> <td>List of paths to search when loading libraries</td></tr> <tr><th scope=\"row\"> {@systemProperty java.io.tmpdir} </th> <td>Default temp file path</td></tr> <tr><th scope=\"row\"> {@systemProperty java.compiler} </th> <td>Name of JIT compiler to use</td></tr> <tr><th scope=\"row\"> {@systemProperty os.name} </th> <td>Operating system name</td></tr> <tr><th scope=\"row\"> {@systemProperty os.arch} </th> <td>Operating system architecture</td></tr> <tr><th scope=\"row\"> {@systemProperty os.version} </th> <td>Operating system version</td></tr> <tr><th scope=\"row\"> {@systemProperty file.separator} </th> <td>File separator (\"/\" on UNIX)</td></tr> <tr><th scope=\"row\"> {@systemProperty path.separator} </th> <td>Path separator (\":\" on UNIX)</td></tr> <tr><th scope=\"row\"> {@systemProperty line.separator} </th> <td>Line separator (\"\\n\" on UNIX)</td></tr> <tr><th scope=\"row\"> {@systemProperty user.name} </th> <td>User's account name</td></tr> <tr><th scope=\"row\"> {@systemProperty user.home} </th> <td>User's home directory</td></tr> <tr><th scope=\"row\"> {@systemProperty user.dir} </th> <td>User's current working directory</td></tr> </tbody> </table> <p> Multiple paths in a system property value are separated by the path separator character of the platform. <p> Note that even if the security manager does not permit the {@code getProperties} operation, it may choose to permit the {@link #getProperty(String)} operation.\n- apiNote: <strong>Changing a standard system property may have unpredictable results unless otherwise specified.</strong> Property values may be cached during initialization or on first use. Setting a standard property after initialization using {@link #getProperties()} , {@link #setProperties(Properties)} , {@link #setProperty(String, String)} , or {@link #clearProperty(String)} may not have the desired effect.\n- implNote: In addition to the standard system properties, the system properties may include the following keys: <table class=\"striped\"> <caption style=\"display:none\">Shows property keys and associated values</caption> <thead> <tr><th scope=\"col\">Key</th> <th scope=\"col\">Description of Associated Value</th></tr> </thead> <tbody> <tr><th scope=\"row\"> {@systemProperty jdk.module.path} </th> <td>The application module path</td></tr> <tr><th scope=\"row\"> {@systemProperty jdk.module.upgrade.path} </th> <td>The upgrade module path</td></tr> <tr><th scope=\"row\"> {@systemProperty jdk.module.main} </th> <td>The module name of the initial/main module</td></tr> <tr><th scope=\"row\"> {@systemProperty jdk.module.main.class} </th> <td>The main class name of the initial module</td></tr> </tbody> </table>\n- return: the system properties\n- throws SecurityException: if a security manager exists and its  {@code checkPropertiesAccess} method doesn't allow access to the system properties.\n- see: #setProperties\n- see: java.lang.SecurityException\n- see: java.lang.SecurityManager#checkPropertiesAccess()\n- see: java.util.Properties"
 ([] (java.lang.System/getProperties)))

(clojure.core/defn
 System:nanoTime
 "-- () -> long\nReturns the current value of the running Java Virtual Machine's high-resolution time source, in nanoseconds.  This method can only be used to measure elapsed time and is not related to any other notion of system or wall-clock time. The value returned represents nanoseconds since some fixed but arbitrary <i>origin</i> time (perhaps in the future, so values may be negative).  The same origin is used by all invocations of this method in an instance of a Java virtual machine; other virtual machine instances are likely to use a different origin.  <p>This method provides nanosecond precision, but not necessarily nanosecond resolution (that is, how frequently the value changes) - no guarantees are made except that the resolution is at least as good as that of {@link #currentTimeMillis()} .  <p>Differences in successive calls that span greater than approximately 292 years (2<sup>63</sup> nanoseconds) will not correctly compute elapsed time due to numerical overflow.  <p>The values returned by this method become meaningful only when the difference between two such values, obtained within the same instance of a Java virtual machine, is computed.  <p>For example, to measure how long some code takes to execute: <pre> {@code long startTime = System.nanoTime(); // ... the code being measured ... long elapsedNanos = System.nanoTime() - startTime;} </pre>  <p>To compare elapsed time against a timeout, use <pre> {@code if (System.nanoTime() - startTime >= timeoutNanos) ...} </pre> instead of <pre> {@code if (System.nanoTime() >= startTime + timeoutNanos) ...} </pre> because of the possibility of numerical overflow.\n- return: the current value of the running Java Virtual Machine's high-resolution time source, in nanoseconds\n- since: 1.5"
 ([] (java.lang.System/nanoTime)))

(clojure.core/defn
 System:loadLibrary
 "-- (String libname) -> void\nLoads the native library specified by the {@code libname}  argument.  The {@code libname} argument must not contain any platform specific prefix, file extension or path. If a native library called {@code libname} is statically linked with the VM, then the JNI_OnLoad_ {@code libname} function exported by the library is invoked. See the <a href=\" {@docRoot} /../specs/jni/index.html\"> JNI Specification</a> for more details.  Otherwise, the libname argument is loaded from a system library location and mapped to a native library image in an implementation-dependent manner. <p> The call {@code System.loadLibrary(name)} is effectively equivalent to the call <blockquote><pre> Runtime.getRuntime().loadLibrary(name) </pre></blockquote>\n- param libname: the name of the library.\n- throws SecurityException: if a security manager exists and its  {@code checkLink} method doesn't allow loading of the specified dynamic library\n- throws UnsatisfiedLinkError: if either the libname argument contains a file path, the native library is not statically linked with the VM,  or the library cannot be mapped to a native library image by the host system.\n- throws NullPointerException: if {@code libname} is {@code null}\n- see: java.lang.Runtime#loadLibrary(java.lang.String)\n- see: java.lang.SecurityManager#checkLink(java.lang.String)"
 ([libname]
  (java.lang.System/loadLibrary ^"java.lang.String" libname)))

(clojure.core/defn
 System:setErr
 "-- (PrintStream err) -> void\nReassigns the \"standard\" error output stream.  First, if there is a security manager, its {@code checkPermission}  method is called with a {@code RuntimePermission(\"setIO\")} permission to see if it's ok to reassign the \"standard\" error output stream.\n- param err: the new standard error output stream.\n- throws SecurityException: if a security manager exists and its  {@code checkPermission} method doesn't allow reassigning of the standard error output stream.\n- see: SecurityManager#checkPermission\n- see: java.lang.RuntimePermission\n- since: 1.1"
 ([err] (java.lang.System/setErr ^"java.io.PrintStream" err)))

(clojure.core/defn
 System:setProperties
 "-- (Properties props) -> void\nSets the system properties to the {@code Properties} argument.  First, if there is a security manager, its {@code checkPropertiesAccess} method is called with no arguments. This may result in a security exception. <p> The argument becomes the current set of system properties for use by the {@link #getProperty(String)} method. If the argument is {@code null} , then the current set of system properties is forgotten.\n- apiNote: <strong>Changing a standard system property may have unpredictable results unless otherwise specified</strong>. See {@linkplain #getProperties getProperties} for details.\n- param props: the new system properties.\n- throws SecurityException: if a security manager exists and its  {@code checkPropertiesAccess} method doesn't allow access to the system properties.\n- see: #getProperties\n- see: java.util.Properties\n- see: java.lang.SecurityException\n- see: java.lang.SecurityManager#checkPropertiesAccess()"
 ([props]
  (java.lang.System/setProperties ^"java.util.Properties" props)))

(clojure.core/defn
 System:identityHashCode
 "-- (Object x) -> int\nReturns the same hash code for the given object as would be returned by the default method hashCode(), whether or not the given object's class overrides hashCode(). The hash code for the null reference is zero.\n- param x: object for which the hashCode is to be calculated\n- return: the hashCode\n- since: 1.1\n- see: Object#hashCode\n- see: java.util.Objects#hashCode(Object)"
 ([x] (java.lang.System/identityHashCode ^"java.lang.Object" x)))

(clojure.core/defn
 System:getProperty
 "-- (String key) -> String\nGets the system property indicated by the specified key.  First, if there is a security manager, its {@code checkPropertyAccess} method is called with the key as its argument. This may result in a SecurityException. <p> If there is no current set of system properties, a set of system properties is first created and initialized in the same manner as for the {@code getProperties} method.\n- apiNote: <strong>Changing a standard system property may have unpredictable results unless otherwise specified</strong>. See {@linkplain #getProperties getProperties} for details.\n- param key: the name of the system property.\n- return: the string value of the system property, or {@code null} if there is no property with that key.\n- throws SecurityException: if a security manager exists and its  {@code checkPropertyAccess} method doesn't allow access to the specified system property.\n- throws NullPointerException: if {@code key} is {@code null} .\n- throws IllegalArgumentException: if {@code key} is empty.\n- see: #setProperty\n- see: java.lang.SecurityException\n- see: java.lang.SecurityManager#checkPropertyAccess(java.lang.String)\n- see: java.lang.System#getProperties()\n-- (String key, String def) -> String\nGets the system property indicated by the specified key.  First, if there is a security manager, its {@code checkPropertyAccess} method is called with the {@code key} as its argument. <p> If there is no current set of system properties, a set of system properties is first created and initialized in the same manner as for the {@code getProperties} method.\n- param key: the name of the system property.\n- param def: a default value.\n- return: the string value of the system property, or the default value if there is no property with that key.\n- throws SecurityException: if a security manager exists and its  {@code checkPropertyAccess} method doesn't allow access to the specified system property.\n- throws NullPointerException: if {@code key} is {@code null} .\n- throws IllegalArgumentException: if {@code key} is empty.\n- see: #setProperty\n- see: java.lang.SecurityManager#checkPropertyAccess(java.lang.String)\n- see: java.lang.System#getProperties()"
 ([key] (java.lang.System/getProperty ^"java.lang.String" key))
 ([key def]
  (java.lang.System/getProperty
   ^"java.lang.String" key
   ^"java.lang.String" def)))

(clojure.core/defn
 System:lineSeparator
 "-- () -> String\nReturns the system-dependent line separator string.  It always returns the same value - the initial value of the {@linkplain #getProperty(String) system property}  {@code line.separator} .  <p>On UNIX systems, it returns {@code \"\\n\"} ; on Microsoft Windows systems it returns {@code \"\\r\\n\"} .\n- return: the system-dependent line separator string\n- since: 1.7"
 ([] (java.lang.System/lineSeparator)))

(clojure.core/defn
 System:exit
 "-- (int status) -> void\nTerminates the currently running Java Virtual Machine. The argument serves as a status code; by convention, a nonzero status code indicates abnormal termination. <p> This method calls the {@code exit} method in class {@code Runtime} . This method never returns normally. <p> The call {@code System.exit(n)} is effectively equivalent to the call: <blockquote><pre> Runtime.getRuntime().exit(n) </pre></blockquote>\n- param status: exit status.\n- throws SecurityException: if a security manager exists and its {@code checkExit}  method doesn't allow exit with the specified status.\n- see: java.lang.Runtime#exit(int)"
 ([status] (java.lang.System/exit ^"int" status)))

(clojure.core/defn
 System:setProperty
 "-- (String key, String value) -> String\nSets the system property indicated by the specified key.  First, if a security manager exists, its {@code SecurityManager.checkPermission} method is called with a {@code PropertyPermission(key, \"write\")}  permission. This may result in a SecurityException being thrown. If no exception is thrown, the specified property is set to the given value.\n- apiNote: <strong>Changing a standard system property may have unpredictable results unless otherwise specified</strong>. See {@linkplain #getProperties getProperties} for details.\n- param key: the name of the system property.\n- param value: the value of the system property.\n- return: the previous value of the system property, or {@code null} if it did not have one.\n- throws SecurityException: if a security manager exists and its  {@code checkPermission} method doesn't allow setting of the specified property.\n- throws NullPointerException: if {@code key} or  {@code value} is {@code null} .\n- throws IllegalArgumentException: if {@code key} is empty.\n- see: #getProperty\n- see: java.lang.System#getProperty(java.lang.String)\n- see: java.lang.System#getProperty(java.lang.String, java.lang.String)\n- see: java.util.PropertyPermission\n- see: SecurityManager#checkPermission\n- since: 1.2"
 ([key value]
  (java.lang.System/setProperty
   ^"java.lang.String" key
   ^"java.lang.String" value)))

(clojure.core/defn
 System:getLogger
 "-- (String name) -> Logger\nReturns an instance of {@link Logger Logger} for the caller's use.\n- implSpec: Instances returned by this method route messages to loggers obtained by calling {@link LoggerFinder#getLogger(java.lang.String, java.lang.Module) LoggerFinder.getLogger(name, module)} , where {@code module} is the caller's module. In cases where {@code System.getLogger} is called from a context where there is no caller frame on the stack (e.g when called directly from a JNI attached thread), {@code IllegalCallerException} is thrown. To obtain a logger in such a context, use an auxiliary class that will implicitly be identified as the caller, or use the system {@link LoggerFinder#getLoggerFinder() LoggerFinder} to obtain a logger instead. Note that doing the latter may eagerly initialize the underlying logging system.\n- apiNote: This method may defer calling the {@link LoggerFinder#getLogger(java.lang.String, java.lang.Module) LoggerFinder.getLogger} method to create an actual logger supplied by the logging backend, for instance, to allow loggers to be obtained during the system initialization time.\n- param name: the name of the logger.\n- return: an instance of {@link Logger} that can be used by the calling class.\n- throws NullPointerException: if {@code name} is {@code null} .\n- throws IllegalCallerException: if there is no Java caller frame on the stack.\n- since: 9\n-- (String name, ResourceBundle bundle) -> Logger\nReturns a localizable instance of {@link Logger Logger} for the caller's use. The returned logger will use the provided resource bundle for message localization.\n- implSpec: The returned logger will perform message localization as specified by {@link LoggerFinder#getLocalizedLogger(java.lang.String, java.util.ResourceBundle, java.lang.Module) LoggerFinder.getLocalizedLogger(name, bundle, module)} , where {@code module} is the caller's module. In cases where {@code System.getLogger} is called from a context where there is no caller frame on the stack (e.g when called directly from a JNI attached thread), {@code IllegalCallerException} is thrown. To obtain a logger in such a context, use an auxiliary class that will implicitly be identified as the caller, or use the system {@link LoggerFinder#getLoggerFinder() LoggerFinder} to obtain a logger instead. Note that doing the latter may eagerly initialize the underlying logging system.\n- apiNote: This method is intended to be used after the system is fully initialized. This method may trigger the immediate loading and initialization of the {@link LoggerFinder} service, which may cause issues if the Java Runtime is not ready to initialize the concrete service implementation yet. System classes which may be loaded early in the boot sequence and need to log localized messages should create a logger using {@link #getLogger(java.lang.String)} and then use the log methods that take a resource bundle as parameter.\n- param name: the name of the logger.\n- param bundle: a resource bundle.\n- return: an instance of {@link Logger} which will use the provided resource bundle for message localization.\n- throws NullPointerException: if {@code name} is {@code null} or  {@code bundle} is {@code null} .\n- throws IllegalCallerException: if there is no Java caller frame on the stack.\n- since: 9"
 ([name] (java.lang.System/getLogger ^"java.lang.String" name))
 ([name bundle]
  (java.lang.System/getLogger
   ^"java.lang.String" name
   ^"java.util.ResourceBundle" bundle)))

(clojure.core/defn
 System:runFinalization
 "-- () -> void\nRuns the finalization methods of any objects pending finalization.  Calling this method suggests that the Java Virtual Machine expend effort toward running the {@code finalize} methods of objects that have been found to be discarded but whose {@code finalize}  methods have not yet been run. When control returns from the method call, the Java Virtual Machine has made a best effort to complete all outstanding finalizations. <p> The call {@code System.runFinalization()} is effectively equivalent to the call: <blockquote><pre> Runtime.getRuntime().runFinalization() </pre></blockquote>\n- see: java.lang.Runtime#runFinalization()"
 ([] (java.lang.System/runFinalization)))

(clojure.core/defn
 System:gc
 "-- () -> void\nRuns the garbage collector in the Java Virtual Machine. <p> Calling the {@code gc} method suggests that the Java Virtual Machine expend effort toward recycling unused objects in order to make the memory they currently occupy available for reuse by the Java Virtual Machine. When control returns from the method call, the Java Virtual Machine has made a best effort to reclaim space from all unused objects. There is no guarantee that this effort will recycle any particular number of unused objects, reclaim any particular amount of space, or complete at any particular time, if at all, before the method returns or ever. <p> The call {@code System.gc()} is effectively equivalent to the call: <blockquote><pre> Runtime.getRuntime().gc() </pre></blockquote>\n- see: java.lang.Runtime#gc()"
 ([] (java.lang.System/gc)))

(clojure.core/defn
 System:setOut
 "-- (PrintStream out) -> void\nReassigns the \"standard\" output stream.  First, if there is a security manager, its {@code checkPermission}  method is called with a {@code RuntimePermission(\"setIO\")} permission to see if it's ok to reassign the \"standard\" output stream.\n- param out: the new standard output stream\n- throws SecurityException: if a security manager exists and its  {@code checkPermission} method doesn't allow reassigning of the standard output stream.\n- see: SecurityManager#checkPermission\n- see: java.lang.RuntimePermission\n- since: 1.1"
 ([out] (java.lang.System/setOut ^"java.io.PrintStream" out)))

(def
 ^"java.io.InputStream" System:in
 "Type: java.io.InputStream"
 java.lang.System/in)

(def
 ^"java.io.PrintStream" System:out
 "Type: java.io.PrintStream"
 java.lang.System/out)

(def
 ^"java.io.PrintStream" System:err
 "Type: java.io.PrintStream"
 java.lang.System/err)

(def
 System:class
 "The {@code System} class contains several useful class fields and methods. It cannot be instantiated.  Among the facilities provided by the {@code System} class are standard input, standard output, and error output streams; access to externally defined properties and environment variables; a means of loading files and libraries; and a utility method for quickly copying a portion of an array.\n- since: 1.0"
 java.lang.System)

(clojure.core/defn
 System?
 "Checks if x is an instance of java.lang.System."
 [x]
 (clojure.core/instance? java.lang.System x))

(clojure.core/defn
 ZipFile:stream
 "-- () -> Stream<? extends ZipEntry>\nReturns an ordered {@code Stream} over the ZIP file entries.  Entries appear in the {@code Stream} in the order they appear in the central directory of the ZIP file.\n- return: an ordered {@code Stream} of entries in this ZIP file\n- throws IllegalStateException: if the zip file has been closed\n- since: 1.8"
 ([this] (.stream ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:getEntry
 "-- (String name) -> ZipEntry\nReturns the zip file entry for the specified name, or null if not found.\n- param name: the name of the entry\n- return: the zip file entry, or null if not found\n- throws IllegalStateException: if the zip file has been closed"
 ([this name]
  (.getEntry ^"java.util.zip.ZipFile" this ^"java.lang.String" name)))

(clojure.core/defn
 ->ZipFile
 "-- (String name)\nOpens a zip file for reading.  <p>First, if there is a security manager, its {@code checkRead}  method is called with the {@code name} argument as its argument to ensure the read is allowed.  <p>The UTF-8 {@link java.nio.charset.Charset charset} is used to decode the entry names and comments.\n- param name: the name of the zip file\n- throws ZipException: if a ZIP format error has occurred\n- throws IOException: if an I/O error has occurred\n- throws SecurityException: if a security manager exists and its  {@code checkRead} method doesn't allow read access to the file.\n- see: SecurityManager#checkRead(java.lang.String)\n-- (File file)\nOpens a ZIP file for reading given the specified File object.  <p>The UTF-8 {@link java.nio.charset.Charset charset} is used to decode the entry names and comments.\n- param file: the ZIP file to be opened for reading\n- throws ZipException: if a ZIP format error has occurred\n- throws IOException: if an I/O error has occurred\n-- (File file, int mode)\nOpens a new {@code ZipFile} to read from the specified {@code File} object in the specified mode.  The mode argument must be either {@code OPEN_READ} or {@code OPEN_READ | OPEN_DELETE} .  <p>First, if there is a security manager, its {@code checkRead}  method is called with the {@code name} argument as its argument to ensure the read is allowed.  <p>The UTF-8 {@link java.nio.charset.Charset charset} is used to decode the entry names and comments\n- param file: the ZIP file to be opened for reading\n- param mode: the mode in which the file is to be opened\n- throws ZipException: if a ZIP format error has occurred\n- throws IOException: if an I/O error has occurred\n- throws SecurityException: if a security manager exists and its {@code checkRead} method doesn't allow read access to the file, or its {@code checkDelete} method doesn't allow deleting the file when the {@code OPEN_DELETE} flag is set.\n- throws IllegalArgumentException: if the {@code mode} argument is invalid\n- see: SecurityManager#checkRead(java.lang.String)\n- since: 1.3\n-- (String name, Charset charset)\nOpens a zip file for reading.  <p>First, if there is a security manager, its {@code checkRead}  method is called with the {@code name} argument as its argument to ensure the read is allowed.\n- param name: the name of the zip file\n- param charset: the {@linkplain java.nio.charset.Charset charset} to be used to decode the ZIP entry name and comment that are not encoded by using UTF-8 encoding (indicated by entry's general purpose flag).\n- throws ZipException: if a ZIP format error has occurred\n- throws IOException: if an I/O error has occurred\n- throws SecurityException: if a security manager exists and its {@code checkRead}  method doesn't allow read access to the file\n- see: SecurityManager#checkRead(java.lang.String)\n- since: 1.7\n-- (File file, Charset charset)\nOpens a ZIP file for reading given the specified File object.\n- param file: the ZIP file to be opened for reading\n- param charset: The {@linkplain java.nio.charset.Charset charset} to be used to decode the ZIP entry name and comment (ignored if the <a href=\"package-summary.html#lang_encoding\"> language encoding bit</a> of the ZIP entry's general purpose bit flag is set).\n- throws ZipException: if a ZIP format error has occurred\n- throws IOException: if an I/O error has occurred\n- since: 1.7\n-- (File file, int mode, Charset charset)\nOpens a new {@code ZipFile} to read from the specified {@code File} object in the specified mode.  The mode argument must be either {@code OPEN_READ} or {@code OPEN_READ | OPEN_DELETE} .  <p>First, if there is a security manager, its {@code checkRead}  method is called with the {@code name} argument as its argument to ensure the read is allowed.\n- param file: the ZIP file to be opened for reading\n- param mode: the mode in which the file is to be opened\n- param charset: the {@linkplain java.nio.charset.Charset charset} to be used to decode the ZIP entry name and comment that are not encoded by using UTF-8 encoding (indicated by entry's general purpose flag).\n- throws ZipException: if a ZIP format error has occurred\n- throws IOException: if an I/O error has occurred\n- throws SecurityException: if a security manager exists and its {@code checkRead}  method doesn't allow read access to the file,or its  {@code checkDelete} method doesn't allow deleting the file when the {@code OPEN_DELETE} flag is set\n- throws IllegalArgumentException: if the {@code mode} argument is invalid\n- see: SecurityManager#checkRead(java.lang.String)\n- since: 1.7"
 ([name|file]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String name|file)
   (java.util.zip.ZipFile. ^"java.lang.String" name|file)
   (clojure.core/instance? java.io.File name|file)
   (java.util.zip.ZipFile. ^"java.io.File" name|file)))
 ([name|file mode|charset]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String name|file)
   (java.util.zip.ZipFile.
    ^"java.lang.String" name|file
    ^"java.nio.charset.Charset" mode|charset)
   (clojure.core/instance? java.io.File name|file)
   (clojure.core/cond
    (clojure.core/instance? java.nio.charset.Charset mode|charset)
    (java.util.zip.ZipFile.
     ^"java.io.File" name|file
     ^"java.nio.charset.Charset" mode|charset)
    (clojure.core/instance? java.lang.Integer mode|charset)
    (java.util.zip.ZipFile.
     ^"java.io.File" name|file
     ^"int" mode|charset))))
 ([file mode charset]
  (java.util.zip.ZipFile.
   ^"java.io.File" file
   ^"int" mode
   ^"java.nio.charset.Charset" charset)))

(clojure.core/defn
 ZipFile:getName
 "-- () -> String\nReturns the path name of the ZIP file.\n- return: the path name of the ZIP file"
 ([this] (.getName ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:getComment
 "-- () -> String\nReturns the zip file comment, or null if none.\n- return: the comment string for the zip file, or null if none\n- throws IllegalStateException: if the zip file has been closed\n- since: 1.7"
 ([this] (.getComment ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:close
 "-- () -> void\nCloses the ZIP file.  <p> Closing this ZIP file will close all of the input streams previously returned by invocations of the {@link #getInputStream getInputStream} method.\n- throws IOException: if an I/O error has occurred"
 ([this] (.close ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:entries
 "-- () -> Enumeration<? extends ZipEntry>\nReturns an enumeration of the ZIP file entries.\n- return: an enumeration of the ZIP file entries\n- throws IllegalStateException: if the zip file has been closed"
 ([this] (.entries ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:getInputStream
 "-- (ZipEntry entry) -> InputStream\nReturns an input stream for reading the contents of the specified zip file entry. <p> Closing this ZIP file will, in turn, close all input streams that have been returned by invocations of this method.\n- param entry: the zip file entry\n- return: the input stream for reading the contents of the specified zip file entry.\n- throws ZipException: if a ZIP format error has occurred\n- throws IOException: if an I/O error has occurred\n- throws IllegalStateException: if the zip file has been closed"
 ([this entry]
  (.getInputStream
   ^"java.util.zip.ZipFile" this
   ^"java.util.zip.ZipEntry" entry)))

(clojure.core/defn
 ZipFile:size
 "-- () -> int\nReturns the number of entries in the ZIP file.\n- return: the number of entries in the ZIP file\n- throws IllegalStateException: if the zip file has been closed"
 ([this] (.size ^"java.util.zip.ZipFile" this)))

(def
 ^"int" ZipFile:OPEN_READ
 "Type: int"
 java.util.zip.ZipFile/OPEN_READ)

(def
 ^"int" ZipFile:OPEN_DELETE
 "Type: int"
 java.util.zip.ZipFile/OPEN_DELETE)

(def
 ZipFile:class
 "This class is used to read entries from a zip file.  <p> Unless otherwise noted, passing a {@code null} argument to a constructor or method in this class will cause a {@link NullPointerException} to be thrown.\n- apiNote: To release resources used by this {@code ZipFile} , the {@link #close()} method should be called explicitly or by try-with-resources. Subclasses are responsible for the cleanup of resources acquired by the subclass. Subclasses that override {@link #finalize()} in order to perform cleanup should be modified to use alternative cleanup mechanisms such as {@link java.lang.ref.Cleaner} and remove the overriding {@code finalize} method.\n- author: David Connelly\n- since: 1.1"
 java.util.zip.ZipFile)

(clojure.core/defn
 ZipFile?
 "Checks if x is an instance of java.util.zip.ZipFile."
 [x]
 (clojure.core/instance? java.util.zip.ZipFile x))

(clojure.core/defn
 ZipEntry:setCrc
 "-- (long crc) -> void\nSets the CRC-32 checksum of the uncompressed entry data.\n- param crc: the CRC-32 value\n- throws IllegalArgumentException: if the specified CRC-32 value is less than 0 or greater than 0xFFFFFFFF\n- see: #getCrc()"
 ([this crc] (.setCrc ^"java.util.zip.ZipEntry" this ^"long" crc)))

(clojure.core/defn
 ZipEntry:setTime
 "-- (long time) -> void\nSets the last modification time of the entry.  <p> If the entry is output to a ZIP file or ZIP file formatted output stream the last modification time set by this method will be stored into the {@code date and time fields} of the zip file entry and encoded in standard {@code MS-DOS date and time format} . The {@link java.util.TimeZone#getDefault() default TimeZone} is used to convert the epoch time to the MS-DOS data and time.\n- param time: The last modification time of the entry in milliseconds since the epoch\n- see: #getTime()\n- see: #getLastModifiedTime()"
 ([this time] (.setTime ^"java.util.zip.ZipEntry" this ^"long" time)))

(clojure.core/defn
 ZipEntry:setCompressedSize
 "-- (long csize) -> void\nSets the size of the compressed entry data.\n- param csize: the compressed size to set\n- see: #getCompressedSize()"
 ([this csize]
  (.setCompressedSize ^"java.util.zip.ZipEntry" this ^"long" csize)))

(clojure.core/defn
 ZipEntry:setMethod
 "-- (int method) -> void\nSets the compression method for the entry.\n- param method: the compression method, either STORED or DEFLATED\n- throws IllegalArgumentException: if the specified compression method is invalid\n- see: #getMethod()"
 ([this method]
  (.setMethod ^"java.util.zip.ZipEntry" this ^"int" method)))

(clojure.core/defn
 ZipEntry:setComment
 "-- (String comment) -> void\nSets the optional comment string for the entry.  <p>ZIP entry comments have maximum length of 0xffff. If the length of the specified comment string is greater than 0xFFFF bytes after encoding, only the first 0xFFFF bytes are output to the ZIP file entry.\n- param comment: the comment string\n- see: #getComment()"
 ([this comment]
  (.setComment
   ^"java.util.zip.ZipEntry" this
   ^"java.lang.String" comment)))

(clojure.core/defn
 ZipEntry:setExtra
 "-- (byte[] extra) -> void\nSets the optional extra field data for the entry.  <p> Invoking this method may change this entry's last modification time, last access time and creation time, if the {@code extra} field data includes the extensible timestamp fields, such as {@code NTFS tag 0x0001} or {@code Info-ZIP Extended Timestamp} , as specified in <a href=\"http://www.info-zip.org/doc/appnote-19970311-iz.zip\">Info-ZIP Application Note 970311</a>.\n- param extra: The extra field data bytes\n- throws IllegalArgumentException: if the length of the specified extra field data is greater than 0xFFFF bytes\n- see: #getExtra()"
 ([this extra] (.setExtra ^"java.util.zip.ZipEntry" this ^"[B" extra)))

(clojure.core/defn
 ZipEntry:getCompressedSize
 "-- () -> long\nReturns the size of the compressed entry data.  <p> In the case of a stored entry, the compressed size will be the same as the uncompressed size of the entry.\n- return: the size of the compressed entry data, or -1 if not known\n- see: #setCompressedSize(long)"
 ([this] (.getCompressedSize ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:setCreationTime
 "-- (FileTime time) -> ZipEntry\nSets the creation time of the entry.  <p> If set, the creation time will be stored into the extended timestamp fields of entry's {@code optional extra data} , when output to a ZIP file or ZIP file formatted stream.\n- param time: The creation time of the entry\n- return: This zip entry\n- throws NullPointerException: if the {@code time} is null\n- see: #getCreationTime()\n- since: 1.8"
 ([this time]
  (.setCreationTime
   ^"java.util.zip.ZipEntry" this
   ^"java.nio.file.attribute.FileTime" time)))

(clojure.core/defn
 ZipEntry:getCrc
 "-- () -> long\nReturns the CRC-32 checksum of the uncompressed entry data.\n- return: the CRC-32 checksum of the uncompressed entry data, or -1 if not known\n- see: #setCrc(long)"
 ([this] (.getCrc ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:toString
 "-- () -> String\nReturns a string representation of the ZIP entry."
 ([this] (.toString ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getName
 "-- () -> String\nReturns the name of the entry.\n- return: the name of the entry"
 ([this] (.getName ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:isDirectory
 "-- () -> boolean\nReturns true if this is a directory entry. A directory entry is defined to be one whose name ends with a '/'.\n- return: true if this is a directory entry"
 ([this] (.isDirectory ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getTimeLocal
 "-- () -> LocalDateTime\nReturns the last modification time of the entry in local date-time.  <p> If the entry is read from a ZIP file or ZIP file formatted input stream, this is the last modification time from the zip file entry's {@code optional extra data} if the extended timestamp fields are present. Otherwise, the last modification time is read from entry's standard MS-DOS formatted {@code date and time fields} .  <p> The {@link java.time.ZoneId#systemDefault() system default TimeZone}  is used to convert the UTC time to local date-time.\n- return: The last modification time of the entry in local date-time\n- see: #setTimeLocal(LocalDateTime)\n- since: 9"
 ([this] (.getTimeLocal ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getExtra
 "-- () -> byte[]\nReturns the extra field data for the entry.\n- return: the extra field data for the entry, or null if none\n- see: #setExtra(byte[])"
 ([this] (.getExtra ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getComment
 "-- () -> String\nReturns the comment string for the entry.\n- return: the comment string for the entry, or null if none\n- see: #setComment(String)"
 ([this] (.getComment ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:setLastModifiedTime
 "-- (FileTime time) -> ZipEntry\nSets the last modification time of the entry.  <p> When output to a ZIP file or ZIP file formatted output stream the last modification time set by this method will be stored into zip file entry's {@code date and time fields} in {@code standard MS-DOS date and time format} ), and the extended timestamp fields in {@code optional extra data} in UTC time.\n- param time: The last modification time of the entry\n- return: This zip entry\n- throws NullPointerException: if the {@code time} is null\n- see: #getLastModifiedTime()\n- since: 1.8"
 ([this time]
  (.setLastModifiedTime
   ^"java.util.zip.ZipEntry" this
   ^"java.nio.file.attribute.FileTime" time)))

(clojure.core/defn
 ZipEntry:setTimeLocal
 "-- (LocalDateTime time) -> void\nSets the last modification time of the entry in local date-time.  <p> If the entry is output to a ZIP file or ZIP file formatted output stream the last modification time set by this method will be stored into the {@code date and time fields} of the zip file entry and encoded in standard {@code MS-DOS date and time format} . If the date-time set is out of the range of the standard {@code MS-DOS date and time format} , the time will also be stored into zip file entry's extended timestamp fields in {@code optional extra data} in UTC time. The {@link java.time.ZoneId#systemDefault() system default TimeZone} is used to convert the local date-time to UTC time.  <p> {@code LocalDateTime} uses a precision of nanoseconds, whereas this class uses a precision of milliseconds. The conversion will truncate any excess precision information as though the amount in nanoseconds was subject to integer division by one million.\n- param time: The last modification time of the entry in local date-time\n- see: #getTimeLocal()\n- since: 9"
 ([this time]
  (.setTimeLocal
   ^"java.util.zip.ZipEntry" this
   ^"java.time.LocalDateTime" time)))

(clojure.core/defn
 ZipEntry:setLastAccessTime
 "-- (FileTime time) -> ZipEntry\nSets the last access time of the entry.  <p> If set, the last access time will be stored into the extended timestamp fields of entry's {@code optional extra data} , when output to a ZIP file or ZIP file formatted stream.\n- param time: The last access time of the entry\n- return: This zip entry\n- throws NullPointerException: if the {@code time} is null\n- see: #getLastAccessTime()\n- since: 1.8"
 ([this time]
  (.setLastAccessTime
   ^"java.util.zip.ZipEntry" this
   ^"java.nio.file.attribute.FileTime" time)))

(clojure.core/defn
 ZipEntry:getLastModifiedTime
 "-- () -> FileTime\nReturns the last modification time of the entry.  <p> If the entry is read from a ZIP file or ZIP file formatted input stream, this is the last modification time from the zip file entry's {@code optional extra data} if the extended timestamp fields are present. Otherwise the last modification time is read from the entry's {@code date and time fields} , the {@link java.util.TimeZone#getDefault() default TimeZone} is used to convert the standard MS-DOS formatted date and time to the epoch time.\n- return: The last modification time of the entry, null if not specified\n- see: #setLastModifiedTime(FileTime)\n- since: 1.8"
 ([this] (.getLastModifiedTime ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:setSize
 "-- (long size) -> void\nSets the uncompressed size of the entry data.\n- param size: the uncompressed size in bytes\n- throws IllegalArgumentException: if the specified size is less than 0, is greater than 0xFFFFFFFF when <a href=\"package-summary.html#zip64\">ZIP64 format</a> is not supported, or is less than 0 when ZIP64 is supported\n- see: #getSize()"
 ([this size] (.setSize ^"java.util.zip.ZipEntry" this ^"long" size)))

(clojure.core/defn
 ZipEntry:clone
 "-- () -> Object\nReturns a copy of this entry."
 ([this] (.clone ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:hashCode
 "-- () -> int\nReturns the hash code value for this entry."
 ([this] (.hashCode ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getMethod
 "-- () -> int\nReturns the compression method of the entry.\n- return: the compression method of the entry, or -1 if not specified\n- see: #setMethod(int)"
 ([this] (.getMethod ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getLastAccessTime
 "-- () -> FileTime\nReturns the last access time of the entry.  <p> The last access time is from the extended timestamp fields of entry's {@code optional extra data} when read from a ZIP file or ZIP file formatted stream.\n- return: The last access time of the entry, null if not specified\n- see: #setLastAccessTime(FileTime)\n- since: 1.8"
 ([this] (.getLastAccessTime ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ->ZipEntry
 "-- (String name)\nCreates a new zip entry with the specified name.\n- param name: The entry name\n- throws NullPointerException: if the entry name is null\n- throws IllegalArgumentException: if the entry name is longer than 0xFFFF bytes\n-- (ZipEntry e)\nCreates a new zip entry with fields taken from the specified zip entry.\n- param e: A zip Entry object\n- throws NullPointerException: if the entry object is null"
 ([e|name]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String e|name)
   (java.util.zip.ZipEntry. ^"java.lang.String" e|name)
   (clojure.core/instance? java.util.zip.ZipEntry e|name)
   (java.util.zip.ZipEntry. ^"java.util.zip.ZipEntry" e|name))))

(clojure.core/defn
 ZipEntry:getTime
 "-- () -> long\nReturns the last modification time of the entry.  <p> If the entry is read from a ZIP file or ZIP file formatted input stream, this is the last modification time from the {@code date and time fields} of the zip file entry. The {@link java.util.TimeZone#getDefault() default TimeZone} is used to convert the standard MS-DOS formatted date and time to the epoch time.\n- return: The last modification time of the entry in milliseconds since the epoch, or -1 if not specified\n- see: #setTime(long)\n- see: #setLastModifiedTime(FileTime)"
 ([this] (.getTime ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getSize
 "-- () -> long\nReturns the uncompressed size of the entry data.\n- return: the uncompressed size of the entry data, or -1 if not known\n- see: #setSize(long)"
 ([this] (.getSize ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getCreationTime
 "-- () -> FileTime\nReturns the creation time of the entry.  <p> The creation time is from the extended timestamp fields of entry's {@code optional extra data} when read from a ZIP file or ZIP file formatted stream.\n- return: the creation time of the entry, null if not specified\n- see: #setCreationTime(FileTime)\n- since: 1.8"
 ([this] (.getCreationTime ^"java.util.zip.ZipEntry" this)))

(def ^"int" ZipEntry:STORED "Type: int" java.util.zip.ZipEntry/STORED)

(def
 ^"int" ZipEntry:DEFLATED
 "Type: int"
 java.util.zip.ZipEntry/DEFLATED)

(def
 ZipEntry:class
 "This class is used to represent a ZIP file entry.\n- author: David Connelly\n- since: 1.1"
 java.util.zip.ZipEntry)

(clojure.core/defn
 ZipEntry?
 "Checks if x is an instance of java.util.zip.ZipEntry."
 [x]
 (clojure.core/instance? java.util.zip.ZipEntry x))

(clojure.core/defn
 Function:apply
 "-- (T t) -> R\nApplies this function to the given argument.\n- param t: the function argument\n- return: the function result"
 ([this arg1]
  (.apply
   ^"java.util.function.Function" this
   ^"java.lang.Object" arg1)))

(clojure.core/defn
 Function:identity
 "-- () -> Function<T, T>\nReturns a function that always returns its input argument.\n- param <T>: the type of the input and output objects to the function\n- return: a function that always returns its input argument"
 ([] (java.util.function.Function/identity)))

(clojure.core/defn
 Function:compose
 "-- (Function<? super V, ? extends T> before) -> Function<V, R>\nReturns a composed function that first applies the {@code before}  function to its input, and then applies this function to the result. If evaluation of either function throws an exception, it is relayed to the caller of the composed function.\n- param <V>: the type of input to the {@code before} function, and to the composed function\n- param before: the function to apply before this function is applied\n- return: a composed function that first applies the {@code before}  function and then applies this function\n- throws NullPointerException: if before is null\n- see: #andThen(Function)"
 ([this arg1]
  (.compose
   ^"java.util.function.Function" this
   ^"java.util.function.Function" arg1)))

(clojure.core/defn
 Function:andThen
 "-- (Function<? super R, ? extends V> after) -> Function<T, V>\nReturns a composed function that first applies this function to its input, and then applies the {@code after} function to the result. If evaluation of either function throws an exception, it is relayed to the caller of the composed function.\n- param <V>: the type of output of the {@code after} function, and of the composed function\n- param after: the function to apply after this function is applied\n- return: a composed function that first applies this function and then applies the {@code after} function\n- throws NullPointerException: if after is null\n- see: #compose(Function)"
 ([this arg1]
  (.andThen
   ^"java.util.function.Function" this
   ^"java.util.function.Function" arg1)))

(def
 Function:class
 "Represents a function that accepts one argument and produces a result.  <p>This is a <a href=\"package-summary.html\">functional interface</a> whose functional method is {@link #apply(Object)} .\n- param <T>: the type of the input to the function\n- param <R>: the type of the result of the function\n- since: 1.8"
 java.util.function.Function)

(clojure.core/defn
 Function?
 "Checks if x is an instance of java.util.function.Function."
 [x]
 (clojure.core/instance? java.util.function.Function x))

(clojure.core/defn
 ^java.util.function.Function ->Function
 "Costructs java.util.function.Function that invokes x."
 [x]
 (clojure.core/reify
  java.util.function.Function
  (apply [_ arg1] (x arg1))))
