(clojure.core/ns intoclj.interop.java)

(defmacro ^:private array-class [c]
    (let [s (with-meta (gensym) {:private true})]
      (symbol (eval `(def ~s (class (make-array ~c 0)))))))
(clojure.core/defn
 File:createTempFile
 ([arg1 arg2]
  (java.io.File/createTempFile
   ^"java.lang.String" arg1
   ^"java.lang.String" arg2))
 ([arg1 arg2 arg3]
  (java.io.File/createTempFile
   ^"java.lang.String" arg1
   ^"java.lang.String" arg2
   ^"java.io.File" arg3)))

(clojure.core/defn
 File:lastModified
 ([this] (.lastModified ^"java.io.File" this)))

(clojure.core/defn File:isFile ([this] (.isFile ^"java.io.File" this)))

(clojure.core/defn
 File:setReadOnly
 ([this] (.setReadOnly ^"java.io.File" this)))

(clojure.core/defn
 File:list
 ([this] (.list ^"java.io.File" this))
 ([this arg1]
  (.list ^"java.io.File" this ^"java.io.FilenameFilter" arg1)))

(clojure.core/defn File:delete ([this] (.delete ^"java.io.File" this)))

(clojure.core/defn
 File:deleteOnExit
 ([this] (.deleteOnExit ^"java.io.File" this)))

(clojure.core/defn File:toURI ([this] (.toURI ^"java.io.File" this)))

(clojure.core/defn File:mkdirs ([this] (.mkdirs ^"java.io.File" this)))

(clojure.core/defn
 File:getCanonicalPath
 ([this] (.getCanonicalPath ^"java.io.File" this)))

(clojure.core/defn
 File:toString
 ([this] (.toString ^"java.io.File" this)))

(clojure.core/defn
 File:getPath
 ([this] (.getPath ^"java.io.File" this)))

(clojure.core/defn
 File:getFreeSpace
 ([this] (.getFreeSpace ^"java.io.File" this)))

(clojure.core/defn
 File:getTotalSpace
 ([this] (.getTotalSpace ^"java.io.File" this)))

(clojure.core/defn
 File:getName
 ([this] (.getName ^"java.io.File" this)))

(clojure.core/defn
 File:renameTo
 ([this arg1] (.renameTo ^"java.io.File" this ^"java.io.File" arg1)))

(clojure.core/defn
 File:canRead
 ([this] (.canRead ^"java.io.File" this)))

(clojure.core/defn
 File:isDirectory
 ([this] (.isDirectory ^"java.io.File" this)))

(clojure.core/defn
 ->File
 ([arg1]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String arg1)
   (java.io.File. ^"java.lang.String" arg1)
   (clojure.core/instance? java.net.URI arg1)
   (java.io.File. ^"java.net.URI" arg1)))
 ([arg1 arg2]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String arg1)
   (java.io.File. ^"java.lang.String" arg1 ^"java.lang.String" arg2)
   (clojure.core/instance? java.io.File arg1)
   (java.io.File. ^"java.io.File" arg1 ^"java.lang.String" arg2))))

(clojure.core/defn
 File:getParent
 ([this] (.getParent ^"java.io.File" this)))

(clojure.core/defn
 File:isHidden
 ([this] (.isHidden ^"java.io.File" this)))

(clojure.core/defn
 File:setLastModified
 ([this arg1] (.setLastModified ^"java.io.File" this ^"long" arg1)))

(clojure.core/defn
 File:getUsableSpace
 ([this] (.getUsableSpace ^"java.io.File" this)))

(clojure.core/defn File:length ([this] (.length ^"java.io.File" this)))

(clojure.core/defn
 File:setReadable
 ([this arg1] (.setReadable ^"java.io.File" this ^"boolean" arg1))
 ([this arg1 arg2]
  (.setReadable ^"java.io.File" this ^"boolean" arg1 ^"boolean" arg2)))

(clojure.core/defn
 File:listFiles
 ([this] (.listFiles ^"java.io.File" this))
 ([this arg1]
  (clojure.core/cond
   (clojure.core/instance? java.io.FilenameFilter arg1)
   (.listFiles ^"java.io.File" this ^"java.io.FilenameFilter" arg1)
   (clojure.core/instance? java.io.FileFilter arg1)
   (.listFiles ^"java.io.File" this ^"java.io.FileFilter" arg1))))

(clojure.core/defn File:toPath ([this] (.toPath ^"java.io.File" this)))

(clojure.core/defn
 File:setWritable
 ([this arg1] (.setWritable ^"java.io.File" this ^"boolean" arg1))
 ([this arg1 arg2]
  (.setWritable ^"java.io.File" this ^"boolean" arg1 ^"boolean" arg2)))

(clojure.core/defn
 File:canExecute
 ([this] (.canExecute ^"java.io.File" this)))

(clojure.core/defn
 File:createNewFile
 ([this] (.createNewFile ^"java.io.File" this)))

(clojure.core/defn
 File:hashCode
 ([this] (.hashCode ^"java.io.File" this)))

(clojure.core/defn
 File:canWrite
 ([this] (.canWrite ^"java.io.File" this)))

(clojure.core/defn File:exists ([this] (.exists ^"java.io.File" this)))

(clojure.core/defn
 File:getParentFile
 ([this] (.getParentFile ^"java.io.File" this)))

(clojure.core/defn
 File:compareTo
 ([this arg1]
  (clojure.core/cond
   (clojure.core/instance? java.lang.Object arg1)
   (.compareTo ^"java.io.File" this ^"java.lang.Object" arg1)
   (clojure.core/instance? java.io.File arg1)
   (.compareTo ^"java.io.File" this ^"java.io.File" arg1))))

(clojure.core/defn
 File:setExecutable
 ([this arg1] (.setExecutable ^"java.io.File" this ^"boolean" arg1))
 ([this arg1 arg2]
  (.setExecutable
   ^"java.io.File" this
   ^"boolean" arg1
   ^"boolean" arg2)))

(clojure.core/defn
 File:getAbsolutePath
 ([this] (.getAbsolutePath ^"java.io.File" this)))

(clojure.core/defn
 File:getAbsoluteFile
 ([this] (.getAbsoluteFile ^"java.io.File" this)))

(clojure.core/defn
 File:equals
 ([this arg1] (.equals ^"java.io.File" this ^"java.lang.Object" arg1)))

(clojure.core/defn File:toURL ([this] (.toURL ^"java.io.File" this)))

(clojure.core/defn
 File:isAbsolute
 ([this] (.isAbsolute ^"java.io.File" this)))

(clojure.core/defn File:mkdir ([this] (.mkdir ^"java.io.File" this)))

(clojure.core/defn File:listRoots ([] (java.io.File/listRoots)))

(clojure.core/defn
 File:getCanonicalFile
 ([this] (.getCanonicalFile ^"java.io.File" this)))

(def
 ^"char" File:separatorChar
 "Type: char"
 java.io.File/separatorChar)

(def
 ^"java.lang.String" File:separator
 "Type: java.lang.String"
 java.io.File/separator)

(def
 ^"char" File:pathSeparatorChar
 "Type: char"
 java.io.File/pathSeparatorChar)

(def
 ^"java.lang.String" File:pathSeparator
 "Type: java.lang.String"
 java.io.File/pathSeparator)

(def File:class java.io.File)

(clojure.core/defn
 File?
 "Checks if x is an instance of java.io.File."
 [x]
 (clojure.core/instance? java.io.File x))

(clojure.core/defn
 BufferedReader:skip
 ([this arg1] (.skip ^"java.io.BufferedReader" this ^"long" arg1)))

(clojure.core/defn
 BufferedReader:ready
 ([this] (.ready ^"java.io.BufferedReader" this)))

(clojure.core/defn
 BufferedReader:lines
 ([this] (.lines ^"java.io.BufferedReader" this)))

(clojure.core/defn
 BufferedReader:read
 ([this] (.read ^"java.io.BufferedReader" this))
 ([this arg1 arg2 arg3]
  (.read
   ^"java.io.BufferedReader" this
   ^"[C" arg1
   ^"int" arg2
   ^"int" arg3)))

(clojure.core/defn
 BufferedReader:reset
 ([this] (.reset ^"java.io.BufferedReader" this)))

(clojure.core/defn
 BufferedReader:markSupported
 ([this] (.markSupported ^"java.io.BufferedReader" this)))

(clojure.core/defn
 ->BufferedReader
 ([arg1] (java.io.BufferedReader. ^"java.io.Reader" arg1))
 ([arg1 arg2]
  (java.io.BufferedReader. ^"java.io.Reader" arg1 ^"int" arg2)))

(clojure.core/defn
 BufferedReader:close
 ([this] (.close ^"java.io.BufferedReader" this)))

(clojure.core/defn
 BufferedReader:mark
 ([this arg1] (.mark ^"java.io.BufferedReader" this ^"int" arg1)))

(clojure.core/defn
 BufferedReader:readLine
 ([this] (.readLine ^"java.io.BufferedReader" this)))

(def BufferedReader:class java.io.BufferedReader)

(clojure.core/defn
 BufferedReader?
 "Checks if x is an instance of java.io.BufferedReader."
 [x]
 (clojure.core/instance? java.io.BufferedReader x))

(clojure.core/defn
 Optional:map
 ([this arg1]
  (.map
   ^"java.util.Optional" this
   ^"java.util.function.Function" arg1)))

(clojure.core/defn
 Optional:of
 ([arg1] (java.util.Optional/of ^"java.lang.Object" arg1)))

(clojure.core/defn
 Optional:orElseThrow
 ([this arg1]
  (.orElseThrow
   ^"java.util.Optional" this
   ^"java.util.function.Supplier" arg1)))

(clojure.core/defn
 Optional:isPresent
 ([this] (.isPresent ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:toString
 ([this] (.toString ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:flatMap
 ([this arg1]
  (.flatMap
   ^"java.util.Optional" this
   ^"java.util.function.Function" arg1)))

(clojure.core/defn
 Optional:orElseGet
 ([this arg1]
  (.orElseGet
   ^"java.util.Optional" this
   ^"java.util.function.Supplier" arg1)))

(clojure.core/defn
 Optional:ofNullable
 ([arg1] (java.util.Optional/ofNullable ^"java.lang.Object" arg1)))

(clojure.core/defn
 Optional:filter
 ([this arg1]
  (.filter
   ^"java.util.Optional" this
   ^"java.util.function.Predicate" arg1)))

(clojure.core/defn Optional:empty ([] (java.util.Optional/empty)))

(clojure.core/defn
 Optional:ifPresent
 ([this arg1]
  (.ifPresent
   ^"java.util.Optional" this
   ^"java.util.function.Consumer" arg1)))

(clojure.core/defn
 Optional:hashCode
 ([this] (.hashCode ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:orElse
 ([this arg1]
  (.orElse ^"java.util.Optional" this ^"java.lang.Object" arg1)))

(clojure.core/defn
 Optional:get
 ([this] (.get ^"java.util.Optional" this)))

(clojure.core/defn
 Optional:equals
 ([this arg1]
  (.equals ^"java.util.Optional" this ^"java.lang.Object" arg1)))

(def Optional:class java.util.Optional)

(clojure.core/defn
 Optional?
 "Checks if x is an instance of java.util.Optional."
 [x]
 (clojure.core/instance? java.util.Optional x))

(clojure.core/defn
 Class:getDeclaredField
 ([this arg1]
  (.getDeclaredField
   ^"java.lang.Class" this
   ^"java.lang.String" arg1)))

(clojure.core/defn
 Class:isAnnotation
 ([this] (.isAnnotation ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getGenericInterfaces
 ([this] (.getGenericInterfaces ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredAnnotation
 ([this arg1]
  (.getDeclaredAnnotation
   ^"java.lang.Class" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Class:getDeclaredAnnotationsByType
 ([this arg1]
  (.getDeclaredAnnotationsByType
   ^"java.lang.Class" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Class:newInstance
 ([this] (.newInstance ^"java.lang.Class" this)))

(clojure.core/defn
 Class:cast
 ([this arg1]
  (.cast ^"java.lang.Class" this ^"java.lang.Object" arg1)))

(clojure.core/defn
 Class:getResource
 ([this arg1]
  (.getResource ^"java.lang.Class" this ^"java.lang.String" arg1)))

(clojure.core/defn
 Class:isArray
 ([this] (.isArray ^"java.lang.Class" this)))

(clojure.core/defn
 Class:forName
 ([arg1] (java.lang.Class/forName ^"java.lang.String" arg1))
 ([arg1 arg2 arg3]
  (java.lang.Class/forName
   ^"java.lang.String" arg1
   ^"boolean" arg2
   ^"java.lang.ClassLoader" arg3)))

(clojure.core/defn
 Class:getProtectionDomain
 ([this] (.getProtectionDomain ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getSuperclass
 ([this] (.getSuperclass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:toGenericString
 ([this] (.toGenericString ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredConstructors
 ([this] (.getDeclaredConstructors ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getModifiers
 ([this] (.getModifiers ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getResourceAsStream
 ([this arg1]
  (.getResourceAsStream
   ^"java.lang.Class" this
   ^"java.lang.String" arg1)))

(clojure.core/defn
 Class:getEnumConstants
 ([this] (.getEnumConstants ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotatedSuperclass
 ([this] (.getAnnotatedSuperclass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isSynthetic
 ([this] (.isSynthetic ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getInterfaces
 ([this] (.getInterfaces ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getCanonicalName
 ([this] (.getCanonicalName ^"java.lang.Class" this)))

(clojure.core/defn
 Class:toString
 ([this] (.toString ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotation
 ([this arg1]
  (.getAnnotation ^"java.lang.Class" this ^"java.lang.Class" arg1)))

(clojure.core/defn
 Class:isAssignableFrom
 ([this arg1]
  (.isAssignableFrom ^"java.lang.Class" this ^"java.lang.Class" arg1)))

(clojure.core/defn
 Class:isInterface
 ([this] (.isInterface ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isPrimitive
 ([this] (.isPrimitive ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getClasses
 ([this] (.getClasses ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredAnnotations
 ([this] (.getDeclaredAnnotations ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getName
 ([this] (.getName ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isAnonymousClass
 ([this] (.isAnonymousClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getEnclosingConstructor
 ([this] (.getEnclosingConstructor ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotations
 ([this] (.getAnnotations ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotatedInterfaces
 ([this] (.getAnnotatedInterfaces ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getTypeParameters
 ([this] (.getTypeParameters ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getClassLoader
 ([this] (.getClassLoader ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getField
 ([this arg1]
  (.getField ^"java.lang.Class" this ^"java.lang.String" arg1)))

(clojure.core/defn
 Class:getEnclosingMethod
 ([this] (.getEnclosingMethod ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getGenericSuperclass
 ([this] (.getGenericSuperclass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isInstance
 ([this arg1]
  (.isInstance ^"java.lang.Class" this ^"java.lang.Object" arg1)))

(clojure.core/defn
 Class:getConstructor
 ([this arg1]
  (.getConstructor
   ^"java.lang.Class" this
   ^"[Ljava.lang.Class;" arg1)))

(clojure.core/defn
 Class:getMethods
 ([this] (.getMethods ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isLocalClass
 ([this] (.isLocalClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getAnnotationsByType
 ([this arg1]
  (.getAnnotationsByType
   ^"java.lang.Class" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Class:getDeclaringClass
 ([this] (.getDeclaringClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredConstructor
 ([this arg1]
  (.getDeclaredConstructor
   ^"java.lang.Class" this
   ^"[Ljava.lang.Class;" arg1)))

(clojure.core/defn
 Class:getPackage
 ([this] (.getPackage ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isMemberClass
 ([this] (.isMemberClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getMethod
 ([this arg1 arg2]
  (.getMethod
   ^"java.lang.Class" this
   ^"java.lang.String" arg1
   ^"[Ljava.lang.Class;" arg2)))

(clojure.core/defn
 Class:getDeclaredMethod
 ([this arg1 arg2]
  (.getDeclaredMethod
   ^"java.lang.Class" this
   ^"java.lang.String" arg1
   ^"[Ljava.lang.Class;" arg2)))

(clojure.core/defn
 Class:getDeclaredFields
 ([this] (.getDeclaredFields ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isAnnotationPresent
 ([this arg1]
  (.isAnnotationPresent
   ^"java.lang.Class" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Class:getEnclosingClass
 ([this] (.getEnclosingClass ^"java.lang.Class" this)))

(clojure.core/defn
 Class:isEnum
 ([this] (.isEnum ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getFields
 ([this] (.getFields ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredClasses
 ([this] (.getDeclaredClasses ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getDeclaredMethods
 ([this] (.getDeclaredMethods ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getSigners
 ([this] (.getSigners ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getSimpleName
 ([this] (.getSimpleName ^"java.lang.Class" this)))

(clojure.core/defn
 Class:asSubclass
 ([this arg1]
  (.asSubclass ^"java.lang.Class" this ^"java.lang.Class" arg1)))

(clojure.core/defn
 Class:getComponentType
 ([this] (.getComponentType ^"java.lang.Class" this)))

(clojure.core/defn
 Class:desiredAssertionStatus
 ([this] (.desiredAssertionStatus ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getConstructors
 ([this] (.getConstructors ^"java.lang.Class" this)))

(clojure.core/defn
 Class:getTypeName
 ([this] (.getTypeName ^"java.lang.Class" this)))

(def Class:class java.lang.Class)

(clojure.core/defn
 Class?
 "Checks if x is an instance of java.lang.Class."
 [x]
 (clojure.core/instance? java.lang.Class x))

(clojure.core/defn
 Method:invoke
 ([this arg1 arg2]
  (.invoke
   ^"java.lang.reflect.Method" this
   ^"java.lang.Object" arg1
   ^"[Ljava.lang.Object;" arg2)))

(clojure.core/defn
 Method:getGenericReturnType
 ([this] (.getGenericReturnType ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:isVarArgs
 ([this] (.isVarArgs ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:toGenericString
 ([this] (.toGenericString ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getModifiers
 ([this] (.getModifiers ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getParameterCount
 ([this] (.getParameterCount ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getExceptionTypes
 ([this] (.getExceptionTypes ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:isSynthetic
 ([this] (.isSynthetic ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getGenericParameterTypes
 ([this] (.getGenericParameterTypes ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:toString
 ([this] (.toString ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getAnnotation
 ([this arg1]
  (.getAnnotation
   ^"java.lang.reflect.Method" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Method:getDefaultValue
 ([this] (.getDefaultValue ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:isBridge
 ([this] (.isBridge ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getDeclaredAnnotations
 ([this] (.getDeclaredAnnotations ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getName
 ([this] (.getName ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getGenericExceptionTypes
 ([this] (.getGenericExceptionTypes ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getTypeParameters
 ([this] (.getTypeParameters ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getParameterTypes
 ([this] (.getParameterTypes ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getReturnType
 ([this] (.getReturnType ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getAnnotatedReturnType
 ([this] (.getAnnotatedReturnType ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getDeclaringClass
 ([this] (.getDeclaringClass ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:hashCode
 ([this] (.hashCode ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:getParameterAnnotations
 ([this] (.getParameterAnnotations ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:isDefault
 ([this] (.isDefault ^"java.lang.reflect.Method" this)))

(clojure.core/defn
 Method:equals
 ([this arg1]
  (.equals ^"java.lang.reflect.Method" this ^"java.lang.Object" arg1)))

(def Method:class java.lang.reflect.Method)

(clojure.core/defn
 Method?
 "Checks if x is an instance of java.lang.reflect.Method."
 [x]
 (clojure.core/instance? java.lang.reflect.Method x))

(clojure.core/defn
 Modifier:isNative
 ([arg1] (java.lang.reflect.Modifier/isNative ^"int" arg1)))

(clojure.core/defn
 Modifier:parameterModifiers
 ([] (java.lang.reflect.Modifier/parameterModifiers)))

(clojure.core/defn
 Modifier:isPrivate
 ([arg1] (java.lang.reflect.Modifier/isPrivate ^"int" arg1)))

(clojure.core/defn
 Modifier:isStatic
 ([arg1] (java.lang.reflect.Modifier/isStatic ^"int" arg1)))

(clojure.core/defn
 Modifier:fieldModifiers
 ([] (java.lang.reflect.Modifier/fieldModifiers)))

(clojure.core/defn
 Modifier:isAbstract
 ([arg1] (java.lang.reflect.Modifier/isAbstract ^"int" arg1)))

(clojure.core/defn
 Modifier:toString
 ([arg1] (java.lang.reflect.Modifier/toString ^"int" arg1)))

(clojure.core/defn
 Modifier:classModifiers
 ([] (java.lang.reflect.Modifier/classModifiers)))

(clojure.core/defn
 Modifier:isStrict
 ([arg1] (java.lang.reflect.Modifier/isStrict ^"int" arg1)))

(clojure.core/defn
 Modifier:isInterface
 ([arg1] (java.lang.reflect.Modifier/isInterface ^"int" arg1)))

(clojure.core/defn ->Modifier ([] (java.lang.reflect.Modifier.)))

(clojure.core/defn
 Modifier:constructorModifiers
 ([] (java.lang.reflect.Modifier/constructorModifiers)))

(clojure.core/defn
 Modifier:methodModifiers
 ([] (java.lang.reflect.Modifier/methodModifiers)))

(clojure.core/defn
 Modifier:isSynchronized
 ([arg1] (java.lang.reflect.Modifier/isSynchronized ^"int" arg1)))

(clojure.core/defn
 Modifier:interfaceModifiers
 ([] (java.lang.reflect.Modifier/interfaceModifiers)))

(clojure.core/defn
 Modifier:isTransient
 ([arg1] (java.lang.reflect.Modifier/isTransient ^"int" arg1)))

(clojure.core/defn
 Modifier:isVolatile
 ([arg1] (java.lang.reflect.Modifier/isVolatile ^"int" arg1)))

(clojure.core/defn
 Modifier:isFinal
 ([arg1] (java.lang.reflect.Modifier/isFinal ^"int" arg1)))

(clojure.core/defn
 Modifier:isProtected
 ([arg1] (java.lang.reflect.Modifier/isProtected ^"int" arg1)))

(clojure.core/defn
 Modifier:isPublic
 ([arg1] (java.lang.reflect.Modifier/isPublic ^"int" arg1)))

(def
 ^"int" Modifier:PUBLIC
 "Type: int"
 java.lang.reflect.Modifier/PUBLIC)

(def
 ^"int" Modifier:PRIVATE
 "Type: int"
 java.lang.reflect.Modifier/PRIVATE)

(def
 ^"int" Modifier:PROTECTED
 "Type: int"
 java.lang.reflect.Modifier/PROTECTED)

(def
 ^"int" Modifier:STATIC
 "Type: int"
 java.lang.reflect.Modifier/STATIC)

(def
 ^"int" Modifier:FINAL
 "Type: int"
 java.lang.reflect.Modifier/FINAL)

(def
 ^"int" Modifier:SYNCHRONIZED
 "Type: int"
 java.lang.reflect.Modifier/SYNCHRONIZED)

(def
 ^"int" Modifier:VOLATILE
 "Type: int"
 java.lang.reflect.Modifier/VOLATILE)

(def
 ^"int" Modifier:TRANSIENT
 "Type: int"
 java.lang.reflect.Modifier/TRANSIENT)

(def
 ^"int" Modifier:NATIVE
 "Type: int"
 java.lang.reflect.Modifier/NATIVE)

(def
 ^"int" Modifier:INTERFACE
 "Type: int"
 java.lang.reflect.Modifier/INTERFACE)

(def
 ^"int" Modifier:ABSTRACT
 "Type: int"
 java.lang.reflect.Modifier/ABSTRACT)

(def
 ^"int" Modifier:STRICT
 "Type: int"
 java.lang.reflect.Modifier/STRICT)

(def Modifier:class java.lang.reflect.Modifier)

(clojure.core/defn
 Modifier?
 "Checks if x is an instance of java.lang.reflect.Modifier."
 [x]
 (clojure.core/instance? java.lang.reflect.Modifier x))

(clojure.core/defn
 Parameter:getDeclaredAnnotation
 ([this arg1]
  (.getDeclaredAnnotation
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Parameter:getDeclaredAnnotationsByType
 ([this arg1]
  (.getDeclaredAnnotationsByType
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Parameter:isNamePresent
 ([this] (.isNamePresent ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getType
 ([this] (.getType ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:isVarArgs
 ([this] (.isVarArgs ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getModifiers
 ([this] (.getModifiers ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:isSynthetic
 ([this] (.isSynthetic ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:toString
 ([this] (.toString ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getAnnotation
 ([this arg1]
  (.getAnnotation
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Parameter:getDeclaredAnnotations
 ([this]
  (.getDeclaredAnnotations ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getName
 ([this] (.getName ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getAnnotations
 ([this] (.getAnnotations ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getParameterizedType
 ([this] (.getParameterizedType ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getAnnotatedType
 ([this] (.getAnnotatedType ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getDeclaringExecutable
 ([this]
  (.getDeclaringExecutable ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:isImplicit
 ([this] (.isImplicit ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:getAnnotationsByType
 ([this arg1]
  (.getAnnotationsByType
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Parameter:hashCode
 ([this] (.hashCode ^"java.lang.reflect.Parameter" this)))

(clojure.core/defn
 Parameter:equals
 ([this arg1]
  (.equals
   ^"java.lang.reflect.Parameter" this
   ^"java.lang.Object" arg1)))

(def Parameter:class java.lang.reflect.Parameter)

(clojure.core/defn
 Parameter?
 "Checks if x is an instance of java.lang.reflect.Parameter."
 [x]
 (clojure.core/instance? java.lang.reflect.Parameter x))

(clojure.core/defn
 Executable:getAnnotatedExceptionTypes
 ([this]
  (.getAnnotatedExceptionTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:isVarArgs
 ([this] (.isVarArgs ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:toGenericString
 ([this] (.toGenericString ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getModifiers
 ([this] (.getModifiers ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getParameterCount
 ([this] (.getParameterCount ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getExceptionTypes
 ([this] (.getExceptionTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:isSynthetic
 ([this] (.isSynthetic ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getGenericParameterTypes
 ([this]
  (.getGenericParameterTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotation
 ([this arg1]
  (.getAnnotation
   ^"java.lang.reflect.Executable" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Executable:getParameters
 ([this] (.getParameters ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getDeclaredAnnotations
 ([this]
  (.getDeclaredAnnotations ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getName
 ([this] (.getName ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getGenericExceptionTypes
 ([this]
  (.getGenericExceptionTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getTypeParameters
 ([this] (.getTypeParameters ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getParameterTypes
 ([this] (.getParameterTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotatedParameterTypes
 ([this]
  (.getAnnotatedParameterTypes ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotatedReceiverType
 ([this]
  (.getAnnotatedReceiverType ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotatedReturnType
 ([this]
  (.getAnnotatedReturnType ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getAnnotationsByType
 ([this arg1]
  (.getAnnotationsByType
   ^"java.lang.reflect.Executable" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Executable:getDeclaringClass
 ([this] (.getDeclaringClass ^"java.lang.reflect.Executable" this)))

(clojure.core/defn
 Executable:getParameterAnnotations
 ([this]
  (.getParameterAnnotations ^"java.lang.reflect.Executable" this)))

(def Executable:class java.lang.reflect.Executable)

(clojure.core/defn
 Executable?
 "Checks if x is an instance of java.lang.reflect.Executable."
 [x]
 (clojure.core/instance? java.lang.reflect.Executable x))

(clojure.core/defn
 Field:isEnumConstant
 ([this] (.isEnumConstant ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getByte
 ([this arg1]
  (.getByte ^"java.lang.reflect.Field" this ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:setBoolean
 ([this arg1 arg2]
  (.setBoolean
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1
   ^"boolean" arg2)))

(clojure.core/defn
 Field:getType
 ([this] (.getType ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:toGenericString
 ([this] (.toGenericString ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getModifiers
 ([this] (.getModifiers ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getShort
 ([this arg1]
  (.getShort
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:isSynthetic
 ([this] (.isSynthetic ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:toString
 ([this] (.toString ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getAnnotation
 ([this arg1]
  (.getAnnotation
   ^"java.lang.reflect.Field" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Field:getDeclaredAnnotations
 ([this] (.getDeclaredAnnotations ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getName
 ([this] (.getName ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:getLong
 ([this arg1]
  (.getLong ^"java.lang.reflect.Field" this ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:setDouble
 ([this arg1 arg2]
  (.setDouble
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1
   ^"double" arg2)))

(clojure.core/defn
 Field:getInt
 ([this arg1]
  (.getInt ^"java.lang.reflect.Field" this ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:getAnnotatedType
 ([this] (.getAnnotatedType ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:setLong
 ([this arg1 arg2]
  (.setLong
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1
   ^"long" arg2)))

(clojure.core/defn
 Field:getChar
 ([this arg1]
  (.getChar ^"java.lang.reflect.Field" this ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:getAnnotationsByType
 ([this arg1]
  (.getAnnotationsByType
   ^"java.lang.reflect.Field" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Field:setByte
 ([this arg1 arg2]
  (.setByte
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1
   ^"byte" arg2)))

(clojure.core/defn
 Field:getDeclaringClass
 ([this] (.getDeclaringClass ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:setShort
 ([this arg1 arg2]
  (.setShort
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1
   ^"short" arg2)))

(clojure.core/defn
 Field:setInt
 ([this arg1 arg2]
  (.setInt
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1
   ^"int" arg2)))

(clojure.core/defn
 Field:getGenericType
 ([this] (.getGenericType ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:hashCode
 ([this] (.hashCode ^"java.lang.reflect.Field" this)))

(clojure.core/defn
 Field:set
 ([this arg1 arg2]
  (.set
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1
   ^"java.lang.Object" arg2)))

(clojure.core/defn
 Field:getBoolean
 ([this arg1]
  (.getBoolean
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:getFloat
 ([this arg1]
  (.getFloat
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:getDouble
 ([this arg1]
  (.getDouble
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:get
 ([this arg1]
  (.get ^"java.lang.reflect.Field" this ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:equals
 ([this arg1]
  (.equals ^"java.lang.reflect.Field" this ^"java.lang.Object" arg1)))

(clojure.core/defn
 Field:setFloat
 ([this arg1 arg2]
  (.setFloat
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1
   ^"float" arg2)))

(clojure.core/defn
 Field:setChar
 ([this arg1 arg2]
  (.setChar
   ^"java.lang.reflect.Field" this
   ^"java.lang.Object" arg1
   ^"char" arg2)))

(def Field:class java.lang.reflect.Field)

(clojure.core/defn
 Field?
 "Checks if x is an instance of java.lang.reflect.Field."
 [x]
 (clojure.core/instance? java.lang.reflect.Field x))

(clojure.core/defn
 Constructor:newInstance
 ([this arg1]
  (.newInstance
   ^"java.lang.reflect.Constructor" this
   ^"[Ljava.lang.Object;" arg1)))

(clojure.core/defn
 Constructor:isVarArgs
 ([this] (.isVarArgs ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:toGenericString
 ([this] (.toGenericString ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getModifiers
 ([this] (.getModifiers ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getParameterCount
 ([this] (.getParameterCount ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getExceptionTypes
 ([this] (.getExceptionTypes ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:isSynthetic
 ([this] (.isSynthetic ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getGenericParameterTypes
 ([this]
  (.getGenericParameterTypes ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:toString
 ([this] (.toString ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getAnnotation
 ([this arg1]
  (.getAnnotation
   ^"java.lang.reflect.Constructor" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 Constructor:getDeclaredAnnotations
 ([this]
  (.getDeclaredAnnotations ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getName
 ([this] (.getName ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getGenericExceptionTypes
 ([this]
  (.getGenericExceptionTypes ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getTypeParameters
 ([this] (.getTypeParameters ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getParameterTypes
 ([this] (.getParameterTypes ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getAnnotatedReceiverType
 ([this]
  (.getAnnotatedReceiverType ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getAnnotatedReturnType
 ([this]
  (.getAnnotatedReturnType ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getDeclaringClass
 ([this] (.getDeclaringClass ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:hashCode
 ([this] (.hashCode ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:getParameterAnnotations
 ([this]
  (.getParameterAnnotations ^"java.lang.reflect.Constructor" this)))

(clojure.core/defn
 Constructor:equals
 ([this arg1]
  (.equals
   ^"java.lang.reflect.Constructor" this
   ^"java.lang.Object" arg1)))

(def Constructor:class java.lang.reflect.Constructor)

(clojure.core/defn
 Constructor?
 "Checks if x is an instance of java.lang.reflect.Constructor."
 [x]
 (clojure.core/instance? java.lang.reflect.Constructor x))

(clojure.core/defn
 System:setSecurityManager
 ([arg1]
  (java.lang.System/setSecurityManager
   ^"java.lang.SecurityManager" arg1)))

(clojure.core/defn
 System:mapLibraryName
 ([arg1] (java.lang.System/mapLibraryName ^"java.lang.String" arg1)))

(clojure.core/defn
 System:arraycopy
 ([arg1 arg2 arg3 arg4 arg5]
  (java.lang.System/arraycopy
   ^"java.lang.Object" arg1
   ^"int" arg2
   ^"java.lang.Object" arg3
   ^"int" arg4
   ^"int" arg5)))

(clojure.core/defn
 System:inheritedChannel
 ([] (java.lang.System/inheritedChannel)))

(clojure.core/defn
 System:load
 ([arg1] (java.lang.System/load ^"java.lang.String" arg1)))

(clojure.core/defn
 System:runFinalizersOnExit
 ([arg1] (java.lang.System/runFinalizersOnExit ^"boolean" arg1)))

(clojure.core/defn
 System:clearProperty
 ([arg1] (java.lang.System/clearProperty ^"java.lang.String" arg1)))

(clojure.core/defn
 System:currentTimeMillis
 ([] (java.lang.System/currentTimeMillis)))

(clojure.core/defn
 System:getSecurityManager
 ([] (java.lang.System/getSecurityManager)))

(clojure.core/defn
 System:setIn
 ([arg1] (java.lang.System/setIn ^"java.io.InputStream" arg1)))

(clojure.core/defn System:console ([] (java.lang.System/console)))

(clojure.core/defn
 System:getenv
 ([] (java.lang.System/getenv))
 ([arg1] (java.lang.System/getenv ^"java.lang.String" arg1)))

(clojure.core/defn
 System:getProperties
 ([] (java.lang.System/getProperties)))

(clojure.core/defn System:nanoTime ([] (java.lang.System/nanoTime)))

(clojure.core/defn
 System:loadLibrary
 ([arg1] (java.lang.System/loadLibrary ^"java.lang.String" arg1)))

(clojure.core/defn
 System:setErr
 ([arg1] (java.lang.System/setErr ^"java.io.PrintStream" arg1)))

(clojure.core/defn
 System:setProperties
 ([arg1]
  (java.lang.System/setProperties ^"java.util.Properties" arg1)))

(clojure.core/defn
 System:identityHashCode
 ([arg1] (java.lang.System/identityHashCode ^"java.lang.Object" arg1)))

(clojure.core/defn
 System:getProperty
 ([arg1] (java.lang.System/getProperty ^"java.lang.String" arg1))
 ([arg1 arg2]
  (java.lang.System/getProperty
   ^"java.lang.String" arg1
   ^"java.lang.String" arg2)))

(clojure.core/defn
 System:lineSeparator
 ([] (java.lang.System/lineSeparator)))

(clojure.core/defn
 System:exit
 ([arg1] (java.lang.System/exit ^"int" arg1)))

(clojure.core/defn
 System:setProperty
 ([arg1 arg2]
  (java.lang.System/setProperty
   ^"java.lang.String" arg1
   ^"java.lang.String" arg2)))

(clojure.core/defn
 System:runFinalization
 ([] (java.lang.System/runFinalization)))

(clojure.core/defn System:gc ([] (java.lang.System/gc)))

(clojure.core/defn
 System:setOut
 ([arg1] (java.lang.System/setOut ^"java.io.PrintStream" arg1)))

(def
 ^"java.io.InputStream" System:in
 "Type: java.io.InputStream"
 java.lang.System/in)

(def
 ^"java.io.PrintStream" System:out
 "Type: java.io.PrintStream"
 java.lang.System/out)

(def
 ^"java.io.PrintStream" System:err
 "Type: java.io.PrintStream"
 java.lang.System/err)

(def System:class java.lang.System)

(clojure.core/defn
 System?
 "Checks if x is an instance of java.lang.System."
 [x]
 (clojure.core/instance? java.lang.System x))

(clojure.core/defn
 ZipFile:stream
 ([this] (.stream ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:getEntry
 ([this arg1]
  (.getEntry ^"java.util.zip.ZipFile" this ^"java.lang.String" arg1)))

(clojure.core/defn
 ->ZipFile
 ([arg1]
  (clojure.core/cond
   (clojure.core/instance? java.io.File arg1)
   (java.util.zip.ZipFile. ^"java.io.File" arg1)
   (clojure.core/instance? java.lang.String arg1)
   (java.util.zip.ZipFile. ^"java.lang.String" arg1)))
 ([arg1 arg2]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String arg1)
   (java.util.zip.ZipFile.
    ^"java.lang.String" arg1
    ^"java.nio.charset.Charset" arg2)
   (clojure.core/instance? java.io.File arg1)
   (clojure.core/cond
    (clojure.core/instance? java.nio.charset.Charset arg2)
    (java.util.zip.ZipFile.
     ^"java.io.File" arg1
     ^"java.nio.charset.Charset" arg2)
    (clojure.core/instance? java.lang.Integer arg2)
    (java.util.zip.ZipFile. ^"java.io.File" arg1 ^"int" arg2))))
 ([arg1 arg2 arg3]
  (java.util.zip.ZipFile.
   ^"java.io.File" arg1
   ^"int" arg2
   ^"java.nio.charset.Charset" arg3)))

(clojure.core/defn
 ZipFile:getName
 ([this] (.getName ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:getComment
 ([this] (.getComment ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:close
 ([this] (.close ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:entries
 ([this] (.entries ^"java.util.zip.ZipFile" this)))

(clojure.core/defn
 ZipFile:getInputStream
 ([this arg1]
  (.getInputStream
   ^"java.util.zip.ZipFile" this
   ^"java.util.zip.ZipEntry" arg1)))

(clojure.core/defn
 ZipFile:size
 ([this] (.size ^"java.util.zip.ZipFile" this)))

(def
 ^"int" ZipFile:OPEN_READ
 "Type: int"
 java.util.zip.ZipFile/OPEN_READ)

(def
 ^"int" ZipFile:OPEN_DELETE
 "Type: int"
 java.util.zip.ZipFile/OPEN_DELETE)

(def ZipFile:class java.util.zip.ZipFile)

(clojure.core/defn
 ZipFile?
 "Checks if x is an instance of java.util.zip.ZipFile."
 [x]
 (clojure.core/instance? java.util.zip.ZipFile x))

(clojure.core/defn
 ZipEntry:setCrc
 ([this arg1] (.setCrc ^"java.util.zip.ZipEntry" this ^"long" arg1)))

(clojure.core/defn
 ZipEntry:setTime
 ([this arg1] (.setTime ^"java.util.zip.ZipEntry" this ^"long" arg1)))

(clojure.core/defn
 ZipEntry:setCompressedSize
 ([this arg1]
  (.setCompressedSize ^"java.util.zip.ZipEntry" this ^"long" arg1)))

(clojure.core/defn
 ZipEntry:setMethod
 ([this arg1] (.setMethod ^"java.util.zip.ZipEntry" this ^"int" arg1)))

(clojure.core/defn
 ZipEntry:setComment
 ([this arg1]
  (.setComment
   ^"java.util.zip.ZipEntry" this
   ^"java.lang.String" arg1)))

(clojure.core/defn
 ZipEntry:setExtra
 ([this arg1] (.setExtra ^"java.util.zip.ZipEntry" this ^"[B" arg1)))

(clojure.core/defn
 ZipEntry:getCompressedSize
 ([this] (.getCompressedSize ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:setCreationTime
 ([this arg1]
  (.setCreationTime
   ^"java.util.zip.ZipEntry" this
   ^"java.nio.file.attribute.FileTime" arg1)))

(clojure.core/defn
 ZipEntry:getCrc
 ([this] (.getCrc ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:toString
 ([this] (.toString ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getName
 ([this] (.getName ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:isDirectory
 ([this] (.isDirectory ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getExtra
 ([this] (.getExtra ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getComment
 ([this] (.getComment ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:setLastModifiedTime
 ([this arg1]
  (.setLastModifiedTime
   ^"java.util.zip.ZipEntry" this
   ^"java.nio.file.attribute.FileTime" arg1)))

(clojure.core/defn
 ZipEntry:setLastAccessTime
 ([this arg1]
  (.setLastAccessTime
   ^"java.util.zip.ZipEntry" this
   ^"java.nio.file.attribute.FileTime" arg1)))

(clojure.core/defn
 ZipEntry:getLastModifiedTime
 ([this] (.getLastModifiedTime ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:setSize
 ([this arg1] (.setSize ^"java.util.zip.ZipEntry" this ^"long" arg1)))

(clojure.core/defn
 ZipEntry:clone
 ([this] (.clone ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:hashCode
 ([this] (.hashCode ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getMethod
 ([this] (.getMethod ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getLastAccessTime
 ([this] (.getLastAccessTime ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ->ZipEntry
 ([arg1]
  (clojure.core/cond
   (clojure.core/instance? java.util.zip.ZipEntry arg1)
   (java.util.zip.ZipEntry. ^"java.util.zip.ZipEntry" arg1)
   (clojure.core/instance? java.lang.String arg1)
   (java.util.zip.ZipEntry. ^"java.lang.String" arg1))))

(clojure.core/defn
 ZipEntry:getTime
 ([this] (.getTime ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getSize
 ([this] (.getSize ^"java.util.zip.ZipEntry" this)))

(clojure.core/defn
 ZipEntry:getCreationTime
 ([this] (.getCreationTime ^"java.util.zip.ZipEntry" this)))

(def ^"int" ZipEntry:STORED "Type: int" java.util.zip.ZipEntry/STORED)

(def
 ^"int" ZipEntry:DEFLATED
 "Type: int"
 java.util.zip.ZipEntry/DEFLATED)

(def ZipEntry:class java.util.zip.ZipEntry)

(clojure.core/defn
 ZipEntry?
 "Checks if x is an instance of java.util.zip.ZipEntry."
 [x]
 (clojure.core/instance? java.util.zip.ZipEntry x))

(clojure.core/defn
 Function:apply
 ([this arg1]
  (.apply
   ^"java.util.function.Function" this
   ^"java.lang.Object" arg1)))

(clojure.core/defn
 Function:identity
 ([] (java.util.function.Function/identity)))

(clojure.core/defn
 Function:andThen
 ([this arg1]
  (.andThen
   ^"java.util.function.Function" this
   ^"java.util.function.Function" arg1)))

(clojure.core/defn
 Function:compose
 ([this arg1]
  (.compose
   ^"java.util.function.Function" this
   ^"java.util.function.Function" arg1)))

(def Function:class java.util.function.Function)

(clojure.core/defn
 Function?
 "Checks if x is an instance of java.util.function.Function."
 [x]
 (clojure.core/instance? java.util.function.Function x))

(clojure.core/defn
 ^java.util.function.Function ->Function
 "Costructs java.util.function.Function that invokes x."
 [x]
 (clojure.core/reify
  java.util.function.Function
  (apply [_ arg1] (x arg1))))

