(clojure.core/ns intoclj.interop.javaparser)

(defmacro ^:private array-class [c]
    (let [s (with-meta (gensym) {:private true})]
      (symbol (eval `(def ~s (class (make-array ~c 0)))))))
(clojure.core/defn
 ClassOrInterfaceDeclaration:resolve
 "-- () -> ResolvedReferenceTypeDeclaration"
 ([this]
  (.resolve
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:setTypeParameters
 "-- (NodeList<TypeParameter> typeParameters) -> ClassOrInterfaceDeclaration"
 ([this typeParameters]
  (.setTypeParameters
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this
   ^"com.github.javaparser.ast.NodeList" typeParameters)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:isClassOrInterfaceDeclaration
 "-- () -> boolean"
 ([this]
  (.isClassOrInterfaceDeclaration
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:getFullyQualifiedName
 "-- () -> Optional<String>"
 ([this]
  (.getFullyQualifiedName
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:getExtendedTypes
 "-- () -> NodeList<ClassOrInterfaceType>"
 ([this]
  (.getExtendedTypes
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:isInterface
 "-- () -> boolean"
 ([this]
  (.isInterface
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:ifClassOrInterfaceDeclaration
 "-- (Consumer<ClassOrInterfaceDeclaration> action) -> void"
 ([this action]
  (.ifClassOrInterfaceDeclaration
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this
   ^"java.util.function.Consumer" action)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:setInterface
 "-- (boolean isInterface) -> ClassOrInterfaceDeclaration"
 ([this isInterface]
  (.setInterface
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this
   ^"boolean" isInterface)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:getTypeParameters
 "-- () -> NodeList<TypeParameter>"
 ([this]
  (.getTypeParameters
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:accept
 "-- (GenericVisitor<R, A> v, A arg) -> R\n-- (VoidVisitor<A> v, A arg) -> void"
 ([this v arg]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.VoidVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this
    ^"com.github.javaparser.ast.visitor.VoidVisitor" v
    ^"java.lang.Object" arg)
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.GenericVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this
    ^"com.github.javaparser.ast.visitor.GenericVisitor" v
    ^"java.lang.Object" arg))))

(clojure.core/defn
 ClassOrInterfaceDeclaration:asClassOrInterfaceDeclaration
 "-- () -> ClassOrInterfaceDeclaration"
 ([this]
  (.asClassOrInterfaceDeclaration
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:setExtendedTypes
 "-- (NodeList<ClassOrInterfaceType> extendedTypes) -> ClassOrInterfaceDeclaration"
 ([this extendedTypes]
  (.setExtendedTypes
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this
   ^"com.github.javaparser.ast.NodeList" extendedTypes)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:toClassOrInterfaceDeclaration
 "-- () -> Optional<ClassOrInterfaceDeclaration>"
 ([this]
  (.toClassOrInterfaceDeclaration
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:isInnerClass
 "-- () -> boolean\n\n- return: is this an inner class? NOTE: many people are confused over terminology. Refer to https://docs.oracle.com/javase/tutorial/java/javaOO/nested.html ."
 ([this]
  (.isInnerClass
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:isLocalClassDeclaration
 "-- () -> boolean\n\n- return: is this class's parent a LocalClassDeclarationStmt ?"
 ([this]
  (.isLocalClassDeclaration
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:setImplementedTypes
 "-- (NodeList<ClassOrInterfaceType> implementedTypes) -> ClassOrInterfaceDeclaration"
 ([this implementedTypes]
  (.setImplementedTypes
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this
   ^"com.github.javaparser.ast.NodeList" implementedTypes)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:clone
 "-- () -> ClassOrInterfaceDeclaration"
 ([this]
  (.clone
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ->ClassOrInterfaceDeclaration
 "-- ()\n-- (NodeList<Modifier> modifiers, boolean isInterface, String name)\n-- (NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, boolean isInterface, SimpleName name, NodeList<TypeParameter> typeParameters, NodeList<ClassOrInterfaceType> extendedTypes, NodeList<ClassOrInterfaceType> implementedTypes, NodeList<BodyDeclaration<?>> members)\n-- (TokenRange tokenRange, NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, boolean isInterface, SimpleName name, NodeList<TypeParameter> typeParameters, NodeList<ClassOrInterfaceType> extendedTypes, NodeList<ClassOrInterfaceType> implementedTypes, NodeList<BodyDeclaration<?>> members)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.body.ClassOrInterfaceDeclaration.))
 ([modifiers isInterface name]
  (com.github.javaparser.ast.body.ClassOrInterfaceDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"boolean" isInterface
   ^"java.lang.String" name))
 ([modifiers
   annotations
   isInterface
   name
   typeParameters
   extendedTypes
   implementedTypes
   members]
  (com.github.javaparser.ast.body.ClassOrInterfaceDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"boolean" isInterface
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" typeParameters
   ^"com.github.javaparser.ast.NodeList" extendedTypes
   ^"com.github.javaparser.ast.NodeList" implementedTypes
   ^"com.github.javaparser.ast.NodeList" members))
 ([tokenRange
   modifiers
   annotations
   isInterface
   name
   typeParameters
   extendedTypes
   implementedTypes
   members]
  (com.github.javaparser.ast.body.ClassOrInterfaceDeclaration.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"boolean" isInterface
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" typeParameters
   ^"com.github.javaparser.ast.NodeList" extendedTypes
   ^"com.github.javaparser.ast.NodeList" implementedTypes
   ^"com.github.javaparser.ast.NodeList" members)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:getMetaModel
 "-- () -> ClassOrInterfaceDeclarationMetaModel"
 ([this]
  (.getMetaModel
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(clojure.core/defn
 ClassOrInterfaceDeclaration:getImplementedTypes
 "-- () -> NodeList<ClassOrInterfaceType>"
 ([this]
  (.getImplementedTypes
   ^"com.github.javaparser.ast.body.ClassOrInterfaceDeclaration" this)))

(def
 ClassOrInterfaceDeclaration:class
 "A definition of a class or interface.<br> {@code class X { ... } }<br> {@code interface X { ... } }\n- author: Julio Vilmar Gesser"
 com.github.javaparser.ast.body.ClassOrInterfaceDeclaration)

(clojure.core/defn
 ClassOrInterfaceDeclaration?
 "Checks if x is an instance of com.github.javaparser.ast.body.ClassOrInterfaceDeclaration."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.body.ClassOrInterfaceDeclaration
  x))

(clojure.core/defn
 MethodDeclaration:setDefault
 "-- (boolean set) -> MethodDeclaration"
 ([this set]
  (.setDefault
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"boolean" set)))

(clojure.core/defn
 MethodDeclaration:resolve
 "-- () -> ResolvedMethodDeclaration"
 ([this]
  (.resolve ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:setTypeParameters
 "-- (NodeList<TypeParameter> typeParameters) -> MethodDeclaration"
 ([this typeParameters]
  (.setTypeParameters
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"com.github.javaparser.ast.NodeList" typeParameters)))

(clojure.core/defn
 MethodDeclaration:getType
 "-- () -> Type"
 ([this]
  (.getType ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:isNative
 "-- () -> boolean"
 ([this]
  (.isNative
   ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:setParameters
 "-- (NodeList<Parameter> parameters) -> MethodDeclaration"
 ([this parameters]
  (.setParameters
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"com.github.javaparser.ast.NodeList" parameters)))

(clojure.core/defn
 MethodDeclaration:setBody
 "-- (BlockStmt body) -> MethodDeclaration\nSets the body\n- param body: the body, can be null\n- return: this, the MethodDeclaration"
 ([this body]
  (.setBody
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"com.github.javaparser.ast.stmt.BlockStmt" body)))

(clojure.core/defn
 MethodDeclaration:setType
 "-- (Type type) -> MethodDeclaration"
 ([this type]
  (.setType
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"com.github.javaparser.ast.type.Type" type)))

(clojure.core/defn
 MethodDeclaration:isMethodDeclaration
 "-- () -> boolean"
 ([this]
  (.isMethodDeclaration
   ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:setThrownExceptions
 "-- (NodeList<ReferenceType> thrownExceptions) -> MethodDeclaration"
 ([this thrownExceptions]
  (.setThrownExceptions
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"com.github.javaparser.ast.NodeList" thrownExceptions)))

(clojure.core/defn
 MethodDeclaration:setName
 "-- (SimpleName name) -> MethodDeclaration"
 ([this name]
  (.setName
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"com.github.javaparser.ast.expr.SimpleName" name)))

(clojure.core/defn
 MethodDeclaration:setNative
 "-- (boolean set) -> MethodDeclaration"
 ([this set]
  (.setNative
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"boolean" set)))

(clojure.core/defn
 MethodDeclaration:toDescriptor
 "-- () -> String"
 ([this]
  (.toDescriptor
   ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 ->MethodDeclaration
 "-- ()\n-- (NodeList<Modifier> modifiers, Type type, String name)\n-- (NodeList<Modifier> modifiers, String name, Type type, NodeList<Parameter> parameters)\n-- (NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, Type type, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions, BlockStmt body)\n-- (NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, Type type, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions, BlockStmt body, ReceiverParameter receiverParameter)\n-- (TokenRange tokenRange, NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, Type type, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions, BlockStmt body, ReceiverParameter receiverParameter)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.body.MethodDeclaration.))
 ([modifiers type name]
  (com.github.javaparser.ast.body.MethodDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.type.Type" type
   ^"java.lang.String" name))
 ([modifiers name type parameters]
  (com.github.javaparser.ast.body.MethodDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"java.lang.String" name
   ^"com.github.javaparser.ast.type.Type" type
   ^"com.github.javaparser.ast.NodeList" parameters))
 ([modifiers
   annotations
   typeParameters
   type
   name
   parameters
   thrownExceptions
   body]
  (com.github.javaparser.ast.body.MethodDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.NodeList" typeParameters
   ^"com.github.javaparser.ast.type.Type" type
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" parameters
   ^"com.github.javaparser.ast.NodeList" thrownExceptions
   ^"com.github.javaparser.ast.stmt.BlockStmt" body))
 ([modifiers
   annotations
   typeParameters
   type
   name
   parameters
   thrownExceptions
   body
   receiverParameter]
  (com.github.javaparser.ast.body.MethodDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.NodeList" typeParameters
   ^"com.github.javaparser.ast.type.Type" type
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" parameters
   ^"com.github.javaparser.ast.NodeList" thrownExceptions
   ^"com.github.javaparser.ast.stmt.BlockStmt" body
   ^"com.github.javaparser.ast.body.ReceiverParameter" receiverParameter))
 ([tokenRange
   modifiers
   annotations
   typeParameters
   type
   name
   parameters
   thrownExceptions
   body
   receiverParameter]
  (com.github.javaparser.ast.body.MethodDeclaration.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.NodeList" typeParameters
   ^"com.github.javaparser.ast.type.Type" type
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" parameters
   ^"com.github.javaparser.ast.NodeList" thrownExceptions
   ^"com.github.javaparser.ast.stmt.BlockStmt" body
   ^"com.github.javaparser.ast.body.ReceiverParameter" receiverParameter)))

(clojure.core/defn
 MethodDeclaration:asMethodDeclaration
 "-- () -> MethodDeclaration"
 ([this]
  (.asMethodDeclaration
   ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 MethodDeclaration:isSynchronized
 "-- () -> boolean"
 ([this]
  (.isSynchronized
   ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:accept
 "-- (GenericVisitor<R, A> v, A arg) -> R\n-- (VoidVisitor<A> v, A arg) -> void"
 ([this v arg]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.GenericVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.MethodDeclaration" this
    ^"com.github.javaparser.ast.visitor.GenericVisitor" v
    ^"java.lang.Object" arg)
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.VoidVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.MethodDeclaration" this
    ^"com.github.javaparser.ast.visitor.VoidVisitor" v
    ^"java.lang.Object" arg))))

(clojure.core/defn
 MethodDeclaration:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 MethodDeclaration:setModifiers
 "-- (NodeList<Modifier> modifiers) -> MethodDeclaration"
 ([this modifiers]
  (.setModifiers
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"com.github.javaparser.ast.NodeList" modifiers)))

(clojure.core/defn
 MethodDeclaration:getBody
 "-- () -> Optional<BlockStmt>"
 ([this]
  (.getBody ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:removeBody
 "-- () -> MethodDeclaration"
 ([this]
  (.removeBody
   ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:clone
 "-- () -> MethodDeclaration"
 ([this]
  (.clone ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:setSynchronized
 "-- (boolean set) -> MethodDeclaration"
 ([this set]
  (.setSynchronized
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"boolean" set)))

(clojure.core/defn
 MethodDeclaration:getMetaModel
 "-- () -> MethodDeclarationMetaModel"
 ([this]
  (.getMetaModel
   ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:toMethodDeclaration
 "-- () -> Optional<MethodDeclaration>"
 ([this]
  (.toMethodDeclaration
   ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(clojure.core/defn
 MethodDeclaration:ifMethodDeclaration
 "-- (Consumer<MethodDeclaration> action) -> void"
 ([this action]
  (.ifMethodDeclaration
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"java.util.function.Consumer" action)))

(clojure.core/defn
 MethodDeclaration:getDeclarationAsString
 "-- (boolean includingModifiers, boolean includingThrows, boolean includingParameterName) -> String\nThe declaration returned has this schema: <p> [accessSpecifier] [static] [abstract] [final] [native] [synchronized] returnType methodName ([paramType [paramName]]) [throws exceptionsList]\n- return: method declaration as String"
 ([this includingModifiers includingThrows includingParameterName]
  (.getDeclarationAsString
   ^"com.github.javaparser.ast.body.MethodDeclaration" this
   ^"boolean" includingModifiers
   ^"boolean" includingThrows
   ^"boolean" includingParameterName)))

(clojure.core/defn
 MethodDeclaration:isDefault
 "-- () -> boolean"
 ([this]
  (.isDefault
   ^"com.github.javaparser.ast.body.MethodDeclaration" this)))

(def
 MethodDeclaration:class
 "A method declaration. \"public int abc() {return 1;}\" in this example: {@code class X { public int abc() {return 1;}  }} <p> <br>All annotations preceding the return type will be set on this object, not on the return type. JavaParser doesn't know if it they are applicable to the method or the type.\n- author: Julio Vilmar Gesser"
 com.github.javaparser.ast.body.MethodDeclaration)

(clojure.core/defn
 MethodDeclaration?
 "Checks if x is an instance of com.github.javaparser.ast.body.MethodDeclaration."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.body.MethodDeclaration
  x))

(clojure.core/defn
 FieldDeclaration:createGetter
 "-- () -> MethodDeclaration\nCreate a getter for this field, <b>will only work if this field declares only 1 identifier and if this field is already added to a ClassOrInterfaceDeclaration</b>\n- return: the {@link MethodDeclaration} created\n- throws IllegalStateException: if there is more than 1 variable identifier or if this field isn't attached to a class or enum"
 ([this]
  (.createGetter
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:resolve
 "-- () -> ResolvedFieldDeclaration"
 ([this]
  (.resolve ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:isFieldDeclaration
 "-- () -> boolean"
 ([this]
  (.isFieldDeclaration
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:getModifiers
 "-- () -> NodeList<Modifier>\nReturn the modifiers of this member declaration.\n- return: modifiers\n- see: Modifier"
 ([this]
  (.getModifiers
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:getVariables
 "-- () -> NodeList<VariableDeclarator>"
 ([this]
  (.getVariables
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.body.FieldDeclaration" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 FieldDeclaration:asFieldDeclaration
 "-- () -> FieldDeclaration"
 ([this]
  (.asFieldDeclaration
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:accept
 "-- (GenericVisitor<R, A> v, A arg) -> R\n-- (VoidVisitor<A> v, A arg) -> void"
 ([this v arg]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.VoidVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.FieldDeclaration" this
    ^"com.github.javaparser.ast.visitor.VoidVisitor" v
    ^"java.lang.Object" arg)
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.GenericVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.FieldDeclaration" this
    ^"com.github.javaparser.ast.visitor.GenericVisitor" v
    ^"java.lang.Object" arg))))

(clojure.core/defn
 FieldDeclaration:setVariables
 "-- (NodeList<VariableDeclarator> variables) -> FieldDeclaration"
 ([this variables]
  (.setVariables
   ^"com.github.javaparser.ast.body.FieldDeclaration" this
   ^"com.github.javaparser.ast.NodeList" variables)))

(clojure.core/defn
 FieldDeclaration:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.body.FieldDeclaration" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 FieldDeclaration:toFieldDeclaration
 "-- () -> Optional<FieldDeclaration>"
 ([this]
  (.toFieldDeclaration
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:isTransient
 "-- () -> boolean"
 ([this]
  (.isTransient
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:setModifiers
 "-- (NodeList<Modifier> modifiers) -> FieldDeclaration"
 ([this modifiers]
  (.setModifiers
   ^"com.github.javaparser.ast.body.FieldDeclaration" this
   ^"com.github.javaparser.ast.NodeList" modifiers)))

(clojure.core/defn
 FieldDeclaration:isVolatile
 "-- () -> boolean"
 ([this]
  (.isVolatile
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:ifFieldDeclaration
 "-- (Consumer<FieldDeclaration> action) -> void"
 ([this action]
  (.ifFieldDeclaration
   ^"com.github.javaparser.ast.body.FieldDeclaration" this
   ^"java.util.function.Consumer" action)))

(clojure.core/defn
 ->FieldDeclaration
 "-- ()\n-- (NodeList<Modifier> modifiers, VariableDeclarator variable)\n-- (NodeList<Modifier> modifiers, NodeList<VariableDeclarator> variables)\n-- (NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<VariableDeclarator> variables)\n-- (NodeList<Modifier> modifiers, Type type, String name)\nCreates a {@link FieldDeclaration} .\n- param modifiers: modifiers\n- param type: type\n- param name: field name\n-- (TokenRange tokenRange, NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<VariableDeclarator> variables)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.body.FieldDeclaration.))
 ([modifiers variable|variables]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.body.VariableDeclarator
    variable|variables)
   (com.github.javaparser.ast.body.FieldDeclaration.
    ^"com.github.javaparser.ast.NodeList" modifiers
    ^"com.github.javaparser.ast.body.VariableDeclarator" variable|variables)
   (clojure.core/instance?
    com.github.javaparser.ast.NodeList
    variable|variables)
   (com.github.javaparser.ast.body.FieldDeclaration.
    ^"com.github.javaparser.ast.NodeList" modifiers
    ^"com.github.javaparser.ast.NodeList" variable|variables)))
 ([modifiers annotations|type name|variables]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.type.Type
    annotations|type)
   (com.github.javaparser.ast.body.FieldDeclaration.
    ^"com.github.javaparser.ast.NodeList" modifiers
    ^"com.github.javaparser.ast.type.Type" annotations|type
    ^"java.lang.String" name|variables)
   (clojure.core/instance?
    com.github.javaparser.ast.NodeList
    annotations|type)
   (com.github.javaparser.ast.body.FieldDeclaration.
    ^"com.github.javaparser.ast.NodeList" modifiers
    ^"com.github.javaparser.ast.NodeList" annotations|type
    ^"com.github.javaparser.ast.NodeList" name|variables)))
 ([tokenRange modifiers annotations variables]
  (com.github.javaparser.ast.body.FieldDeclaration.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.NodeList" variables)))

(clojure.core/defn
 FieldDeclaration:createSetter
 "-- () -> MethodDeclaration\nCreate a setter for this field, <b>will only work if this field declares only 1 identifier and if this field is already added to a ClassOrInterfaceDeclaration</b>\n- return: the {@link MethodDeclaration} created\n- throws IllegalStateException: if there is more than 1 variable identifier or if this field isn't attached to a class or enum"
 ([this]
  (.createSetter
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:clone
 "-- () -> FieldDeclaration"
 ([this]
  (.clone ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:getMetaModel
 "-- () -> FieldDeclarationMetaModel"
 ([this]
  (.getMetaModel
   ^"com.github.javaparser.ast.body.FieldDeclaration" this)))

(clojure.core/defn
 FieldDeclaration:setTransient
 "-- (boolean set) -> FieldDeclaration"
 ([this set]
  (.setTransient
   ^"com.github.javaparser.ast.body.FieldDeclaration" this
   ^"boolean" set)))

(clojure.core/defn
 FieldDeclaration:setVolatile
 "-- (boolean set) -> FieldDeclaration"
 ([this set]
  (.setVolatile
   ^"com.github.javaparser.ast.body.FieldDeclaration" this
   ^"boolean" set)))

(def
 FieldDeclaration:class
 "The declaration of a field in a class. \"private static int a=15*15;\" in this example: {@code class X { private static int a=15*15; } }  <br>All annotations preceding the type will be set on this object, not on the type. JavaParser doesn't know if it they are applicable to the method or the type.\n- author: Julio Vilmar Gesser"
 com.github.javaparser.ast.body.FieldDeclaration)

(clojure.core/defn
 FieldDeclaration?
 "Checks if x is an instance of com.github.javaparser.ast.body.FieldDeclaration."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.body.FieldDeclaration
  x))

(clojure.core/defn
 Modifier:transitiveModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/transitiveModifier)))

(clojure.core/defn
 Modifier:finalModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/finalModifier)))

(clojure.core/defn
 Modifier:transientModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/transientModifier)))

(clojure.core/defn
 Modifier:nativeModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/nativeModifier)))

(clojure.core/defn
 Modifier:privateModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/privateModifier)))

(clojure.core/defn
 Modifier:publicModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/publicModifier)))

(clojure.core/defn
 ->Modifier
 "-- ()\n-- (Keyword keyword)\n-- (TokenRange tokenRange, Keyword keyword)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.Modifier.))
 ([keyword]
  (com.github.javaparser.ast.Modifier.
   ^"com.github.javaparser.ast.Modifier$Keyword" keyword))
 ([tokenRange keyword]
  (com.github.javaparser.ast.Modifier.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.Modifier$Keyword" keyword)))

(clojure.core/defn
 Modifier:synchronizedModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/synchronizedModifier)))

(clojure.core/defn
 Modifier:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.Modifier" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 Modifier:accept
 "-- (GenericVisitor<R, A> v, A arg) -> R\n-- (VoidVisitor<A> v, A arg) -> void"
 ([this v arg]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.GenericVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.Modifier" this
    ^"com.github.javaparser.ast.visitor.GenericVisitor" v
    ^"java.lang.Object" arg)
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.VoidVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.Modifier" this
    ^"com.github.javaparser.ast.visitor.VoidVisitor" v
    ^"java.lang.Object" arg))))

(clojure.core/defn
 Modifier:strictfpModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/strictfpModifier)))

(clojure.core/defn
 Modifier:createModifierList
 "-- (Modifier.Keyword modifiers) -> NodeList<Modifier>\nUtility method that instantiaties \"Modifier\"s for the keywords, and puts them in a NodeList."
 ([modifiers]
  (com.github.javaparser.ast.Modifier/createModifierList
   ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" modifiers)))

(clojure.core/defn
 Modifier:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.Modifier" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 Modifier:volatileModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/volatileModifier)))

(clojure.core/defn
 Modifier:setKeyword
 "-- (Keyword keyword) -> Modifier"
 ([this keyword]
  (.setKeyword
   ^"com.github.javaparser.ast.Modifier" this
   ^"com.github.javaparser.ast.Modifier$Keyword" keyword)))

(clojure.core/defn
 Modifier:getKeyword
 "-- () -> Keyword"
 ([this] (.getKeyword ^"com.github.javaparser.ast.Modifier" this)))

(clojure.core/defn
 Modifier:clone
 "-- () -> Modifier"
 ([this] (.clone ^"com.github.javaparser.ast.Modifier" this)))

(clojure.core/defn
 Modifier:protectedModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/protectedModifier)))

(clojure.core/defn
 Modifier:getMetaModel
 "-- () -> ModifierMetaModel"
 ([this] (.getMetaModel ^"com.github.javaparser.ast.Modifier" this)))

(clojure.core/defn
 Modifier:abstractModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/abstractModifier)))

(clojure.core/defn
 Modifier:staticModifier
 "-- () -> Modifier"
 ([] (com.github.javaparser.ast.Modifier/staticModifier)))

(def
 Modifier:class
 "A modifier, like private, public, or volatile."
 com.github.javaparser.ast.Modifier)

(clojure.core/defn
 Modifier?
 "Checks if x is an instance of com.github.javaparser.ast.Modifier."
 [x]
 (clojure.core/instance? com.github.javaparser.ast.Modifier x))

(clojure.core/defn
 VariableDeclarator:removeInitializer
 "-- () -> VariableDeclarator"
 ([this]
  (.removeInitializer
   ^"com.github.javaparser.ast.body.VariableDeclarator" this)))

(clojure.core/defn
 VariableDeclarator:resolve
 "-- () -> ResolvedValueDeclaration"
 ([this]
  (.resolve
   ^"com.github.javaparser.ast.body.VariableDeclarator" this)))

(clojure.core/defn
 VariableDeclarator:getType
 "-- () -> Type"
 ([this]
  (.getType
   ^"com.github.javaparser.ast.body.VariableDeclarator" this)))

(clojure.core/defn
 VariableDeclarator:setType
 "-- (Type type) -> VariableDeclarator"
 ([this type]
  (.setType
   ^"com.github.javaparser.ast.body.VariableDeclarator" this
   ^"com.github.javaparser.ast.type.Type" type)))

(clojure.core/defn
 VariableDeclarator:setName
 "-- (SimpleName name) -> VariableDeclarator"
 ([this name]
  (.setName
   ^"com.github.javaparser.ast.body.VariableDeclarator" this
   ^"com.github.javaparser.ast.expr.SimpleName" name)))

(clojure.core/defn
 VariableDeclarator:getName
 "-- () -> SimpleName"
 ([this]
  (.getName
   ^"com.github.javaparser.ast.body.VariableDeclarator" this)))

(clojure.core/defn
 VariableDeclarator:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.body.VariableDeclarator" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 VariableDeclarator:getInitializer
 "-- () -> Optional<Expression>"
 ([this]
  (.getInitializer
   ^"com.github.javaparser.ast.body.VariableDeclarator" this)))

(clojure.core/defn
 VariableDeclarator:accept
 "-- (GenericVisitor<R, A> v, A arg) -> R\n-- (VoidVisitor<A> v, A arg) -> void"
 ([this v arg]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.GenericVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.VariableDeclarator" this
    ^"com.github.javaparser.ast.visitor.GenericVisitor" v
    ^"java.lang.Object" arg)
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.VoidVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.VariableDeclarator" this
    ^"com.github.javaparser.ast.visitor.VoidVisitor" v
    ^"java.lang.Object" arg))))

(clojure.core/defn
 VariableDeclarator:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.body.VariableDeclarator" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 VariableDeclarator:setInitializer
 "-- (Expression initializer) -> VariableDeclarator\nSets the initializer expression\n- param initializer: the initializer expression, can be null\n- return: this, the VariableDeclarator\n-- (String init) -> VariableDeclarator\nWill create a {@link NameExpr} with the initializer param\n- param init: the initializer expression, can be null\n- return: this, the VariableDeclarator"
 ([this initializer|init]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.expr.Expression
    initializer|init)
   (.setInitializer
    ^"com.github.javaparser.ast.body.VariableDeclarator" this
    ^"com.github.javaparser.ast.expr.Expression" initializer|init)
   (clojure.core/instance? java.lang.String initializer|init)
   (.setInitializer
    ^"com.github.javaparser.ast.body.VariableDeclarator" this
    ^"java.lang.String" initializer|init))))

(clojure.core/defn
 VariableDeclarator:clone
 "-- () -> VariableDeclarator"
 ([this]
  (.clone ^"com.github.javaparser.ast.body.VariableDeclarator" this)))

(clojure.core/defn
 VariableDeclarator:getMetaModel
 "-- () -> VariableDeclaratorMetaModel"
 ([this]
  (.getMetaModel
   ^"com.github.javaparser.ast.body.VariableDeclarator" this)))

(clojure.core/defn
 ->VariableDeclarator
 "-- ()\n-- (Type type, String variableName)\n-- (Type type, SimpleName name)\n-- (Type type, String variableName, Expression initializer)\n-- (Type type, SimpleName name, Expression initializer)\nDefines the declaration of a variable.\n- param name: The identifier for this variable. IE. The variables name.\n- param initializer: What this variable should be initialized to. An {@link com.github.javaparser.ast.expr.AssignExpr}  is unnecessary as the {@code =} operator is already added.\n-- (TokenRange tokenRange, Type type, SimpleName name, Expression initializer)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.body.VariableDeclarator.))
 ([type name|variableName]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String name|variableName)
   (com.github.javaparser.ast.body.VariableDeclarator.
    ^"com.github.javaparser.ast.type.Type" type
    ^"java.lang.String" name|variableName)
   (clojure.core/instance?
    com.github.javaparser.ast.expr.SimpleName
    name|variableName)
   (com.github.javaparser.ast.body.VariableDeclarator.
    ^"com.github.javaparser.ast.type.Type" type
    ^"com.github.javaparser.ast.expr.SimpleName" name|variableName)))
 ([type name|variableName initializer]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.expr.SimpleName
    name|variableName)
   (com.github.javaparser.ast.body.VariableDeclarator.
    ^"com.github.javaparser.ast.type.Type" type
    ^"com.github.javaparser.ast.expr.SimpleName" name|variableName
    ^"com.github.javaparser.ast.expr.Expression" initializer)
   (clojure.core/instance? java.lang.String name|variableName)
   (com.github.javaparser.ast.body.VariableDeclarator.
    ^"com.github.javaparser.ast.type.Type" type
    ^"java.lang.String" name|variableName
    ^"com.github.javaparser.ast.expr.Expression" initializer)))
 ([tokenRange type name initializer]
  (com.github.javaparser.ast.body.VariableDeclarator.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.type.Type" type
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.expr.Expression" initializer)))

(def
 VariableDeclarator:class
 "The declaration of a variable.<br>In {@code int x = 14, y = 3;} \"int x = 14\"  and \"int y = 3\"  are VariableDeclarators. <p>The type is on all of the variable declarators because, thanks to array brackets, each variable can have a different type.\n- author: Julio Vilmar Gesser"
 com.github.javaparser.ast.body.VariableDeclarator)

(clojure.core/defn
 VariableDeclarator?
 "Checks if x is an instance of com.github.javaparser.ast.body.VariableDeclarator."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.body.VariableDeclarator
  x))

(clojure.core/defn
 ConstructorDeclaration:resolve
 "-- () -> ResolvedConstructorDeclaration"
 ([this]
  (.resolve
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this)))

(clojure.core/defn
 ConstructorDeclaration:setTypeParameters
 "-- (NodeList<TypeParameter> typeParameters) -> ConstructorDeclaration"
 ([this typeParameters]
  (.setTypeParameters
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"com.github.javaparser.ast.NodeList" typeParameters)))

(clojure.core/defn
 ->ConstructorDeclaration
 "-- ()\n-- (String name)\n-- (NodeList<Modifier> modifiers, String name)\n-- (NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions, BlockStmt body)\n-- (NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions, BlockStmt body, ReceiverParameter receiverParameter)\n-- (TokenRange tokenRange, NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, SimpleName name, NodeList<Parameter> parameters, NodeList<ReferenceType> thrownExceptions, BlockStmt body, ReceiverParameter receiverParameter)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.body.ConstructorDeclaration.))
 ([name]
  (com.github.javaparser.ast.body.ConstructorDeclaration.
   ^"java.lang.String" name))
 ([modifiers name]
  (com.github.javaparser.ast.body.ConstructorDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"java.lang.String" name))
 ([modifiers
   annotations
   typeParameters
   name
   parameters
   thrownExceptions
   body]
  (com.github.javaparser.ast.body.ConstructorDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.NodeList" typeParameters
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" parameters
   ^"com.github.javaparser.ast.NodeList" thrownExceptions
   ^"com.github.javaparser.ast.stmt.BlockStmt" body))
 ([modifiers
   annotations
   typeParameters
   name
   parameters
   thrownExceptions
   body
   receiverParameter]
  (com.github.javaparser.ast.body.ConstructorDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.NodeList" typeParameters
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" parameters
   ^"com.github.javaparser.ast.NodeList" thrownExceptions
   ^"com.github.javaparser.ast.stmt.BlockStmt" body
   ^"com.github.javaparser.ast.body.ReceiverParameter" receiverParameter))
 ([tokenRange
   modifiers
   annotations
   typeParameters
   name
   parameters
   thrownExceptions
   body
   receiverParameter]
  (com.github.javaparser.ast.body.ConstructorDeclaration.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.NodeList" typeParameters
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" parameters
   ^"com.github.javaparser.ast.NodeList" thrownExceptions
   ^"com.github.javaparser.ast.stmt.BlockStmt" body
   ^"com.github.javaparser.ast.body.ReceiverParameter" receiverParameter)))

(clojure.core/defn
 ConstructorDeclaration:setParameters
 "-- (NodeList<Parameter> parameters) -> ConstructorDeclaration"
 ([this parameters]
  (.setParameters
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"com.github.javaparser.ast.NodeList" parameters)))

(clojure.core/defn
 ConstructorDeclaration:setBody
 "-- (BlockStmt body) -> ConstructorDeclaration\nSets the body\n- param body: the body, can not be null\n- return: this, the ConstructorDeclaration"
 ([this body]
  (.setBody
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"com.github.javaparser.ast.stmt.BlockStmt" body)))

(clojure.core/defn
 ConstructorDeclaration:setThrownExceptions
 "-- (NodeList<ReferenceType> thrownExceptions) -> ConstructorDeclaration"
 ([this thrownExceptions]
  (.setThrownExceptions
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"com.github.javaparser.ast.NodeList" thrownExceptions)))

(clojure.core/defn
 ConstructorDeclaration:setName
 "-- (SimpleName name) -> ConstructorDeclaration"
 ([this name]
  (.setName
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"com.github.javaparser.ast.expr.SimpleName" name)))

(clojure.core/defn
 ConstructorDeclaration:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 ConstructorDeclaration:accept
 "-- (GenericVisitor<R, A> v, A arg) -> R\n-- (VoidVisitor<A> v, A arg) -> void"
 ([this v arg]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.GenericVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
    ^"com.github.javaparser.ast.visitor.GenericVisitor" v
    ^"java.lang.Object" arg)
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.VoidVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
    ^"com.github.javaparser.ast.visitor.VoidVisitor" v
    ^"java.lang.Object" arg))))

(clojure.core/defn
 ConstructorDeclaration:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 ConstructorDeclaration:setModifiers
 "-- (NodeList<Modifier> modifiers) -> ConstructorDeclaration"
 ([this modifiers]
  (.setModifiers
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"com.github.javaparser.ast.NodeList" modifiers)))

(clojure.core/defn
 ConstructorDeclaration:asConstructorDeclaration
 "-- () -> ConstructorDeclaration"
 ([this]
  (.asConstructorDeclaration
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this)))

(clojure.core/defn
 ConstructorDeclaration:getBody
 "-- () -> BlockStmt"
 ([this]
  (.getBody
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this)))

(clojure.core/defn
 ConstructorDeclaration:isConstructorDeclaration
 "-- () -> boolean"
 ([this]
  (.isConstructorDeclaration
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this)))

(clojure.core/defn
 ConstructorDeclaration:ifConstructorDeclaration
 "-- (Consumer<ConstructorDeclaration> action) -> void"
 ([this action]
  (.ifConstructorDeclaration
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"java.util.function.Consumer" action)))

(clojure.core/defn
 ConstructorDeclaration:clone
 "-- () -> ConstructorDeclaration"
 ([this]
  (.clone
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this)))

(clojure.core/defn
 ConstructorDeclaration:toConstructorDeclaration
 "-- () -> Optional<ConstructorDeclaration>"
 ([this]
  (.toConstructorDeclaration
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this)))

(clojure.core/defn
 ConstructorDeclaration:getMetaModel
 "-- () -> ConstructorDeclarationMetaModel"
 ([this]
  (.getMetaModel
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this)))

(clojure.core/defn
 ConstructorDeclaration:getDeclarationAsString
 "-- (boolean includingModifiers, boolean includingThrows, boolean includingParameterName) -> String\nThe declaration returned has this schema: <p> [accessSpecifier] className ([paramType [paramName]]) [throws exceptionsList]"
 ([this includingModifiers includingThrows includingParameterName]
  (.getDeclarationAsString
   ^"com.github.javaparser.ast.body.ConstructorDeclaration" this
   ^"boolean" includingModifiers
   ^"boolean" includingThrows
   ^"boolean" includingParameterName)))

(def
 ConstructorDeclaration:class
 "A constructor declaration: {@code class X { X() { } }} where X(){} is the constructor declaration. <p> <br>All annotations preceding the name will be set on this object, not on the class. JavaParser doesn't know if it they are applicable to the method or the class.\n- author: Julio Vilmar Gesser"
 com.github.javaparser.ast.body.ConstructorDeclaration)

(clojure.core/defn
 ConstructorDeclaration?
 "Checks if x is an instance of com.github.javaparser.ast.body.ConstructorDeclaration."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.body.ConstructorDeclaration
  x))

(clojure.core/defn
 Parameter:setAnnotations
 "-- (NodeList<AnnotationExpr> annotations) -> Parameter\n\n- param annotations: a null value is currently treated as an empty list. This behavior could change in the future, so please avoid passing null"
 ([this annotations]
  (.setAnnotations
   ^"com.github.javaparser.ast.body.Parameter" this
   ^"com.github.javaparser.ast.NodeList" annotations)))

(clojure.core/defn
 Parameter:resolve
 "-- () -> ResolvedParameterDeclaration"
 ([this] (.resolve ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:getType
 "-- () -> Type"
 ([this] (.getType ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:isVarArgs
 "-- () -> boolean"
 ([this]
  (.isVarArgs ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:getModifiers
 "-- () -> NodeList<Modifier>\nReturn the modifiers of this parameter declaration.\n- return: modifiers\n- see: Modifier"
 ([this]
  (.getModifiers ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:setType
 "-- (Type type) -> Parameter"
 ([this type]
  (.setType
   ^"com.github.javaparser.ast.body.Parameter" this
   ^"com.github.javaparser.ast.type.Type" type)))

(clojure.core/defn
 Parameter:setName
 "-- (SimpleName name) -> Parameter"
 ([this name]
  (.setName
   ^"com.github.javaparser.ast.body.Parameter" this
   ^"com.github.javaparser.ast.expr.SimpleName" name)))

(clojure.core/defn
 Parameter:getName
 "-- () -> SimpleName"
 ([this] (.getName ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:getAnnotations
 "-- () -> NodeList<AnnotationExpr>\n\n- return: the list returned could be immutable (in that case it will be empty)"
 ([this]
  (.getAnnotations ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.body.Parameter" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 Parameter:accept
 "-- (GenericVisitor<R, A> v, A arg) -> R\n-- (VoidVisitor<A> v, A arg) -> void"
 ([this v arg]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.VoidVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.Parameter" this
    ^"com.github.javaparser.ast.visitor.VoidVisitor" v
    ^"java.lang.Object" arg)
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.GenericVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.Parameter" this
    ^"com.github.javaparser.ast.visitor.GenericVisitor" v
    ^"java.lang.Object" arg))))

(clojure.core/defn
 Parameter:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.body.Parameter" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 Parameter:setModifiers
 "-- (NodeList<Modifier> modifiers) -> Parameter"
 ([this modifiers]
  (.setModifiers
   ^"com.github.javaparser.ast.body.Parameter" this
   ^"com.github.javaparser.ast.NodeList" modifiers)))

(clojure.core/defn
 ->Parameter
 "-- ()\n-- (Type type, SimpleName name)\n-- (Type type, String name)\nCreates a new {@link Parameter} .\n- param type: type of the parameter\n- param name: name of the parameter\n-- (NodeList<Modifier> modifiers, Type type, SimpleName name)\n-- (NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, Type type, boolean isVarArgs, NodeList<AnnotationExpr> varArgsAnnotations, SimpleName name)\n-- (TokenRange tokenRange, NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, Type type, boolean isVarArgs, NodeList<AnnotationExpr> varArgsAnnotations, SimpleName name)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.body.Parameter.))
 ([type name]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.expr.SimpleName
    name)
   (com.github.javaparser.ast.body.Parameter.
    ^"com.github.javaparser.ast.type.Type" type
    ^"com.github.javaparser.ast.expr.SimpleName" name)
   (clojure.core/instance? java.lang.String name)
   (com.github.javaparser.ast.body.Parameter.
    ^"com.github.javaparser.ast.type.Type" type
    ^"java.lang.String" name)))
 ([modifiers type name]
  (com.github.javaparser.ast.body.Parameter.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.type.Type" type
   ^"com.github.javaparser.ast.expr.SimpleName" name))
 ([modifiers annotations type isVarArgs varArgsAnnotations name]
  (com.github.javaparser.ast.body.Parameter.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.type.Type" type
   ^"boolean" isVarArgs
   ^"com.github.javaparser.ast.NodeList" varArgsAnnotations
   ^"com.github.javaparser.ast.expr.SimpleName" name))
 ([tokenRange
   modifiers
   annotations
   type
   isVarArgs
   varArgsAnnotations
   name]
  (com.github.javaparser.ast.body.Parameter.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.type.Type" type
   ^"boolean" isVarArgs
   ^"com.github.javaparser.ast.NodeList" varArgsAnnotations
   ^"com.github.javaparser.ast.expr.SimpleName" name)))

(clojure.core/defn
 Parameter:getVarArgsAnnotations
 "-- () -> NodeList<AnnotationExpr>"
 ([this]
  (.getVarArgsAnnotations
   ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:clone
 "-- () -> Parameter"
 ([this] (.clone ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:isFinal
 "-- () -> boolean\nRecord components (parameters here) are implicitly final, even without the explicitly-added modifier. https://openjdk.java.net/jeps/359#Restrictions-on-records  If wanting to find out if the keyword {@code final} has been explicitly added to this parameter, you should use {@code node.hasModifier(Modifier.Keyword.FINAL)}\n- return: true if the node parameter is explicitly final (keyword attached) or implicitly final (e.g. parameters to a record)"
 ([this] (.isFinal ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:setVarArgsAnnotations
 "-- (NodeList<AnnotationExpr> varArgsAnnotations) -> Parameter"
 ([this varArgsAnnotations]
  (.setVarArgsAnnotations
   ^"com.github.javaparser.ast.body.Parameter" this
   ^"com.github.javaparser.ast.NodeList" varArgsAnnotations)))

(clojure.core/defn
 Parameter:getMetaModel
 "-- () -> ParameterMetaModel"
 ([this]
  (.getMetaModel ^"com.github.javaparser.ast.body.Parameter" this)))

(clojure.core/defn
 Parameter:setVarArgs
 "-- (boolean isVarArgs) -> Parameter"
 ([this isVarArgs]
  (.setVarArgs
   ^"com.github.javaparser.ast.body.Parameter" this
   ^"boolean" isVarArgs)))

(def
 Parameter:class
 "The parameters to a method or lambda. Lambda parameters may have inferred types, in that case \"type\" is UnknownType. <br>Note that <a href=\"https://en.wikipedia.org/wiki/Parameter_(computer_programming)#Parameters_and_arguments\">parameters are different from arguments.</a> <br>\"String x\" and \"float y\" are the parameters in {@code int abc(String x, float y) {...} }  <br>All annotations preceding the type will be set on this object, not on the type. JavaParser doesn't know if it they are applicable to the parameter or the type.\n- author: Julio Vilmar Gesser"
 com.github.javaparser.ast.body.Parameter)

(clojure.core/defn
 Parameter?
 "Checks if x is an instance of com.github.javaparser.ast.body.Parameter."
 [x]
 (clojure.core/instance? com.github.javaparser.ast.body.Parameter x))

(clojure.core/defn
 Javadoc:toString
 "-- () -> String"
 ([this] (.toString ^"com.github.javaparser.javadoc.Javadoc" this)))

(clojure.core/defn
 ->Javadoc
 "-- (JavadocDescription description)"
 ([description]
  (com.github.javaparser.javadoc.Javadoc.
   ^"com.github.javaparser.javadoc.description.JavadocDescription" description)))

(clojure.core/defn
 Javadoc:getDescription
 "-- () -> JavadocDescription"
 ([this]
  (.getDescription ^"com.github.javaparser.javadoc.Javadoc" this)))

(clojure.core/defn
 Javadoc:addBlockTag
 "-- (JavadocBlockTag blockTag) -> Javadoc\n-- (String tagName) -> Javadoc\n-- (String tagName, String content) -> Javadoc\nFor tags like \"@return good things\" where tagName is \"return\", and the rest is content.\n-- (String tagName, String parameter, String content) -> Javadoc\nFor tags like \"@param abc this is a parameter\" where tagName is \"param\", parameter is \"abc\" and the rest is content."
 ([this tagName|blockTag]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.javadoc.JavadocBlockTag
    tagName|blockTag)
   (.addBlockTag
    ^"com.github.javaparser.javadoc.Javadoc" this
    ^"com.github.javaparser.javadoc.JavadocBlockTag" tagName|blockTag)
   (clojure.core/instance? java.lang.String tagName|blockTag)
   (.addBlockTag
    ^"com.github.javaparser.javadoc.Javadoc" this
    ^"java.lang.String" tagName|blockTag)))
 ([this tagName content]
  (.addBlockTag
   ^"com.github.javaparser.javadoc.Javadoc" this
   ^"java.lang.String" tagName
   ^"java.lang.String" content))
 ([this tagName parameter content]
  (.addBlockTag
   ^"com.github.javaparser.javadoc.Javadoc" this
   ^"java.lang.String" tagName
   ^"java.lang.String" parameter
   ^"java.lang.String" content)))

(clojure.core/defn
 Javadoc:hashCode
 "-- () -> int"
 ([this] (.hashCode ^"com.github.javaparser.javadoc.Javadoc" this)))

(clojure.core/defn
 Javadoc:toText
 "-- () -> String\nReturn the text content of the document. It does not containing trailing spaces and asterisks at the start of the line."
 ([this] (.toText ^"com.github.javaparser.javadoc.Javadoc" this)))

(clojure.core/defn
 Javadoc:equals
 "-- (Object o) -> boolean"
 ([this o]
  (.equals
   ^"com.github.javaparser.javadoc.Javadoc" this
   ^"java.lang.Object" o)))

(clojure.core/defn
 Javadoc:toComment
 "-- () -> JavadocComment\nCreate a JavadocComment, by formatting the text of the Javadoc using no indentation (expecting the pretty printer to do the formatting.)\n-- (String indentation) -> JavadocComment\nCreate a JavadocComment, by formatting the text of the Javadoc using the given indentation."
 ([this] (.toComment ^"com.github.javaparser.javadoc.Javadoc" this))
 ([this indentation]
  (.toComment
   ^"com.github.javaparser.javadoc.Javadoc" this
   ^"java.lang.String" indentation)))

(clojure.core/defn
 Javadoc:getBlockTags
 "-- () -> List<JavadocBlockTag>\n\n- return: the current List of associated JavadocBlockTags"
 ([this]
  (.getBlockTags ^"com.github.javaparser.javadoc.Javadoc" this)))

(def
 Javadoc:class
 "The structured content of a single Javadoc comment. <p> It is composed by a description and a list of block tags. <p> An example would be the text contained in this very Javadoc comment. At the moment of this writing this comment does not contain any block tags (such as {@code @see AnotherClass} )"
 com.github.javaparser.javadoc.Javadoc)

(clojure.core/defn
 Javadoc?
 "Checks if x is an instance of com.github.javaparser.javadoc.Javadoc."
 [x]
 (clojure.core/instance? com.github.javaparser.javadoc.Javadoc x))

(clojure.core/defn
 JavadocBlockTag:getType
 "-- () -> Type"
 ([this]
  (.getType ^"com.github.javaparser.javadoc.JavadocBlockTag" this)))

(clojure.core/defn
 ->JavadocBlockTag
 "-- (Type type, String content)\n-- (String tagName, String content)"
 ([type|tagName content]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.javadoc.JavadocBlockTag$Type
    type|tagName)
   (com.github.javaparser.javadoc.JavadocBlockTag.
    ^"com.github.javaparser.javadoc.JavadocBlockTag$Type" type|tagName
    ^"java.lang.String" content)
   (clojure.core/instance? java.lang.String type|tagName)
   (com.github.javaparser.javadoc.JavadocBlockTag.
    ^"java.lang.String" type|tagName
    ^"java.lang.String" content))))

(clojure.core/defn
 JavadocBlockTag:toString
 "-- () -> String"
 ([this]
  (.toString ^"com.github.javaparser.javadoc.JavadocBlockTag" this)))

(clojure.core/defn
 JavadocBlockTag:createParamBlockTag
 "-- (String paramName, String content) -> JavadocBlockTag"
 ([paramName content]
  (com.github.javaparser.javadoc.JavadocBlockTag/createParamBlockTag
   ^"java.lang.String" paramName
   ^"java.lang.String" content)))

(clojure.core/defn
 JavadocBlockTag:getName
 "-- () -> Optional<String>"
 ([this]
  (.getName ^"com.github.javaparser.javadoc.JavadocBlockTag" this)))

(clojure.core/defn
 JavadocBlockTag:hashCode
 "-- () -> int"
 ([this]
  (.hashCode ^"com.github.javaparser.javadoc.JavadocBlockTag" this)))

(clojure.core/defn
 JavadocBlockTag:toText
 "-- () -> String"
 ([this]
  (.toText ^"com.github.javaparser.javadoc.JavadocBlockTag" this)))

(clojure.core/defn
 JavadocBlockTag:equals
 "-- (Object o) -> boolean"
 ([this o]
  (.equals
   ^"com.github.javaparser.javadoc.JavadocBlockTag" this
   ^"java.lang.Object" o)))

(clojure.core/defn
 JavadocBlockTag:getTagName
 "-- () -> String"
 ([this]
  (.getTagName ^"com.github.javaparser.javadoc.JavadocBlockTag" this)))

(clojure.core/defn
 JavadocBlockTag:getContent
 "-- () -> JavadocDescription"
 ([this]
  (.getContent ^"com.github.javaparser.javadoc.JavadocBlockTag" this)))

(def
 JavadocBlockTag:class
 "A block tag. <p> Typically they are found at the end of Javadoc comments. <p> Examples: {@code @see AnotherClass} {@code @since v0.0.1} {@code @author Jim O'Java}"
 com.github.javaparser.javadoc.JavadocBlockTag)

(clojure.core/defn
 JavadocBlockTag?
 "Checks if x is an instance of com.github.javaparser.javadoc.JavadocBlockTag."
 [x]
 (clojure.core/instance?
  com.github.javaparser.javadoc.JavadocBlockTag
  x))

(clojure.core/defn
 JavadocDescription:addElement
 "-- (JavadocDescriptionElement element) -> boolean"
 ([this element]
  (.addElement
   ^"com.github.javaparser.javadoc.description.JavadocDescription" this
   ^"com.github.javaparser.javadoc.description.JavadocDescriptionElement" element)))

(clojure.core/defn
 JavadocDescription:toString
 "-- () -> String"
 ([this]
  (.toString
   ^"com.github.javaparser.javadoc.description.JavadocDescription" this)))

(clojure.core/defn
 ->JavadocDescription
 "-- ()\n-- (List<JavadocDescriptionElement> elements)"
 ([] (com.github.javaparser.javadoc.description.JavadocDescription.))
 ([elements]
  (com.github.javaparser.javadoc.description.JavadocDescription.
   ^"java.util.List" elements)))

(clojure.core/defn
 JavadocDescription:parseText
 "-- (String text) -> JavadocDescription"
 ([text]
  (com.github.javaparser.javadoc.description.JavadocDescription/parseText
   ^"java.lang.String" text)))

(clojure.core/defn
 JavadocDescription:getElements
 "-- () -> List<JavadocDescriptionElement>"
 ([this]
  (.getElements
   ^"com.github.javaparser.javadoc.description.JavadocDescription" this)))

(clojure.core/defn
 JavadocDescription:hashCode
 "-- () -> int"
 ([this]
  (.hashCode
   ^"com.github.javaparser.javadoc.description.JavadocDescription" this)))

(clojure.core/defn
 JavadocDescription:toText
 "-- () -> String"
 ([this]
  (.toText
   ^"com.github.javaparser.javadoc.description.JavadocDescription" this)))

(clojure.core/defn
 JavadocDescription:isEmpty
 "-- () -> boolean"
 ([this]
  (.isEmpty
   ^"com.github.javaparser.javadoc.description.JavadocDescription" this)))

(clojure.core/defn
 JavadocDescription:equals
 "-- (Object o) -> boolean"
 ([this o]
  (.equals
   ^"com.github.javaparser.javadoc.description.JavadocDescription" this
   ^"java.lang.Object" o)))

(def
 JavadocDescription:class
 "A javadoc text, potentially containing inline tags.  For example <code>This class is totally unrelated to {@link com.github.javaparser.Range} </code>"
 com.github.javaparser.javadoc.description.JavadocDescription)

(clojure.core/defn
 JavadocDescription?
 "Checks if x is an instance of com.github.javaparser.javadoc.description.JavadocDescription."
 [x]
 (clojure.core/instance?
  com.github.javaparser.javadoc.description.JavadocDescription
  x))

(clojure.core/defn
 JavadocDescriptionElement:toText
 "-- () -> String"
 ([this]
  (.toText
   ^"com.github.javaparser.javadoc.description.JavadocDescriptionElement" this)))

(def
 JavadocDescriptionElement:class
 "An element of a description: either an inline tag or a piece of text. <p> So for example {@code a text} or <code> {@link String} </code> could be valid description elements."
 com.github.javaparser.javadoc.description.JavadocDescriptionElement)

(clojure.core/defn
 JavadocDescriptionElement?
 "Checks if x is an instance of com.github.javaparser.javadoc.description.JavadocDescriptionElement."
 [x]
 (clojure.core/instance?
  com.github.javaparser.javadoc.description.JavadocDescriptionElement
  x))

(clojure.core/defn
 ^com.github.javaparser.javadoc.description.JavadocDescriptionElement ->JavadocDescriptionElement
 "Costructs com.github.javaparser.javadoc.description.JavadocDescriptionElement that invokes x."
 [x]
 (clojure.core/reify
  com.github.javaparser.javadoc.description.JavadocDescriptionElement
  (toText [_] (x))))

(clojure.core/defn
 NodeWithJavadoc:getComment
 "-- () -> Optional<Comment>"
 ([this]
  (.getComment
   ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this)))

(clojure.core/defn
 NodeWithJavadoc:setComment
 "-- (Comment comment) -> Node"
 ([this arg1]
  (.setComment
   ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this
   ^"com.github.javaparser.ast.comments.Comment" arg1)))

(clojure.core/defn
 NodeWithJavadoc:getJavadoc
 "-- () -> Optional<Javadoc>\nGets the Javadoc for this node. You can set the Javadoc by calling setJavadocComment passing a Javadoc.\n- return: The Javadoc for this node wrapped in an optional as it may be absent."
 ([this]
  (.getJavadoc
   ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this)))

(clojure.core/defn
 NodeWithJavadoc:getJavadocComment
 "-- () -> Optional<JavadocComment>\nGets the JavadocComment for this node. You can set the JavadocComment by calling setJavadocComment passing a JavadocComment.\n- return: The JavadocComment for this node wrapped in an optional as it may be absent."
 ([this]
  (.getJavadocComment
   ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this)))

(clojure.core/defn
 NodeWithJavadoc:setJavadocComment
 "-- (String comment) -> N\nUse this to store additional information to this node.\n- param comment: to be set\n-- (JavadocComment comment) -> N\n-- (Javadoc javadoc) -> N\n-- (String indentation, Javadoc javadoc) -> N"
 ([this arg1]
  (clojure.core/cond
   (clojure.core/instance? com.github.javaparser.javadoc.Javadoc arg1)
   (.setJavadocComment
    ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this
    ^"com.github.javaparser.javadoc.Javadoc" arg1)
   (clojure.core/instance? java.lang.String arg1)
   (.setJavadocComment
    ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this
    ^"java.lang.String" arg1)
   (clojure.core/instance?
    com.github.javaparser.ast.comments.JavadocComment
    arg1)
   (.setJavadocComment
    ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this
    ^"com.github.javaparser.ast.comments.JavadocComment" arg1)))
 ([this arg1 arg2]
  (.setJavadocComment
   ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this
   ^"java.lang.String" arg1
   ^"com.github.javaparser.javadoc.Javadoc" arg2)))

(clojure.core/defn
 NodeWithJavadoc:hasJavaDocComment
 "-- () -> boolean"
 ([this]
  (.hasJavaDocComment
   ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this)))

(clojure.core/defn
 NodeWithJavadoc:removeJavaDocComment
 "-- () -> boolean"
 ([this]
  (.removeJavaDocComment
   ^"com.github.javaparser.ast.nodeTypes.NodeWithJavadoc" this)))

(def
 NodeWithJavadoc:class
 "A node that can be documented with a Javadoc comment."
 com.github.javaparser.ast.nodeTypes.NodeWithJavadoc)

(clojure.core/defn
 NodeWithJavadoc?
 "Checks if x is an instance of com.github.javaparser.ast.nodeTypes.NodeWithJavadoc."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.nodeTypes.NodeWithJavadoc
  x))

(clojure.core/defn
 NodeWithParameters:setParameters
 "-- (NodeList<Parameter> parameters) -> N"
 ([this arg1]
  (.setParameters
   ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
   ^"com.github.javaparser.ast.NodeList" arg1)))

(clojure.core/defn
 NodeWithParameters:getParameters
 "-- () -> NodeList<Parameter>"
 ([this]
  (.getParameters
   ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this)))

(clojure.core/defn
 NodeWithParameters:tryAddImportToParentCompilationUnit
 "-- (Class<?> clazz) -> void"
 ([this arg1]
  (.tryAddImportToParentCompilationUnit
   ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 NodeWithParameters:addParameter
 "-- (Parameter parameter) -> N\n-- (Type type, String name) -> N\n-- (Class<?> paramClass, String name) -> N\n-- (String className, String name) -> N\nRemember to import the class in the compilation unit yourself\n- param className: the name of the class, ex : org.test.Foo or Foo if you added manually the import\n- param name: the name of the parameter"
 ([this arg1]
  (.addParameter
   ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
   ^"com.github.javaparser.ast.body.Parameter" arg1))
 ([this arg1 arg2]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String arg1)
   (.addParameter
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"java.lang.String" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? com.github.javaparser.ast.type.Type arg1)
   (.addParameter
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"com.github.javaparser.ast.type.Type" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? java.lang.Class arg1)
   (.addParameter
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"java.lang.Class" arg1
    ^"java.lang.String" arg2))))

(clojure.core/defn
 NodeWithParameters:getParameterByName
 "-- (String name) -> Optional<Parameter>\nTry to find a {@link Parameter} by its name\n- param name: the name of the param\n- return: null if not found, the param found otherwise"
 ([this arg1]
  (.getParameterByName
   ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
   ^"java.lang.String" arg1)))

(clojure.core/defn
 NodeWithParameters:getParameter
 "-- (int i) -> Parameter"
 ([this arg1]
  (.getParameter
   ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
   ^"int" arg1)))

(clojure.core/defn
 NodeWithParameters:addAndGetParameter
 "-- (Parameter parameter) -> Parameter\n-- (Type type, String name) -> Parameter\n-- (Class<?> paramClass, String name) -> Parameter\n-- (String className, String name) -> Parameter\nRemember to import the class in the compilation unit yourself\n- param className: the name of the class, ex : org.test.Foo or Foo if you added manually the import\n- param name: the name of the parameter\n- return: the {@link Parameter} created"
 ([this arg1]
  (.addAndGetParameter
   ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
   ^"com.github.javaparser.ast.body.Parameter" arg1))
 ([this arg1 arg2]
  (clojure.core/cond
   (clojure.core/instance? com.github.javaparser.ast.type.Type arg1)
   (.addAndGetParameter
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"com.github.javaparser.ast.type.Type" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? java.lang.Class arg1)
   (.addAndGetParameter
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"java.lang.Class" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? java.lang.String arg1)
   (.addAndGetParameter
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"java.lang.String" arg1
    ^"java.lang.String" arg2))))

(clojure.core/defn
 NodeWithParameters:hasParametersOfType
 "-- (String paramTypes) -> boolean\nCheck if the parameters have certain types. The given parameter types must <i>literally</i> match the declared types of this node's parameters, so passing the string {@code \"List\"} to this method will be considered a match if this node has exactly one parameter whose type is declared as {@code List} , but not if the parameter type is declared as {@code java.util.List} or {@code java.awt.List} . Conversely, passing the string {@code \"java.util.List\"} to this method will be considered a match if this node has exactly one parameter whose type is declared as {@code java.util.List} , but not if the parameter type is declared as {@code List} . Similarly, note that generics are matched as well: If this node has one parameter declared as {@code List&lt;String&gt;} , then it will be considered as a match only if the given string is {@code \"List&lt;String&gt;\"} , but not if the given string is only {@code \"List\"} .\n- param paramTypes: the types of parameters like {@code \"Map&lt;Integer,String&gt;\", \"int\"} to match  {@code void foo(Map&lt;Integer,String&gt; myMap, int number)} .\n- return: {@code true} if all parameters match one by one, in the given order.\n-- (Class<?> paramTypes) -> boolean\nCheck if the parameters have certain types. Note that this is a match in SimpleName, so {@code java.awt.List} and {@code java.util.List} are identical to this algorithm. In addition, note that it is the erasure of each type which is considered, so passing {@code List.class} to this method will be considered a match if this node has exactly one parameter whose type is named {@code List} , regardless of whether the parameter type is declared without generics as {@code List} , or with generics as {@code List&lt;String&gt;} , or {@code List&lt;Integer&gt;} , etc.\n- param paramTypes: the types of parameters like {@code Map.class, int.class} to match  {@code void foo(Map&lt;Integer,String&gt; myMap, int number)} .\n- return: {@code true} if all parameters match one by one, in the given order."
 ([this arg1]
  (clojure.core/cond
   (clojure.core/instance? (array-class java.lang.String) arg1)
   (.hasParametersOfType
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"[Ljava.lang.String;" arg1)
   (clojure.core/instance? (array-class java.lang.Class) arg1)
   (.hasParametersOfType
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"[Ljava.lang.Class;" arg1))))

(clojure.core/defn
 NodeWithParameters:getParameterByType
 "-- (String type) -> Optional<Parameter>\nTry to find a {@link Parameter} by its type\n- param type: the type of the param\n- return: null if not found, the param found otherwise\n-- (Class<?> type) -> Optional<Parameter>\nTry to find a {@link Parameter} by its type\n- param type: the type of the param <b>take care about generics, it wont work</b>\n- return: null if not found, the param found otherwise"
 ([this arg1]
  (clojure.core/cond
   (clojure.core/instance? java.lang.Class arg1)
   (.getParameterByType
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"java.lang.Class" arg1)
   (clojure.core/instance? java.lang.String arg1)
   (.getParameterByType
    ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
    ^"java.lang.String" arg1))))

(clojure.core/defn
 NodeWithParameters:setParameter
 "-- (int i, Parameter parameter) -> N"
 ([this arg1 arg2]
  (.setParameter
   ^"com.github.javaparser.ast.nodeTypes.NodeWithParameters" this
   ^"int" arg1
   ^"com.github.javaparser.ast.body.Parameter" arg2)))

(def
 NodeWithParameters:class
 com.github.javaparser.ast.nodeTypes.NodeWithParameters)

(clojure.core/defn
 NodeWithParameters?
 "Checks if x is an instance of com.github.javaparser.ast.nodeTypes.NodeWithParameters."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.nodeTypes.NodeWithParameters
  x))

(clojure.core/defn
 NodeWithSimpleName:getName
 "-- () -> SimpleName"
 ([this]
  (.getName
   ^"com.github.javaparser.ast.nodeTypes.NodeWithSimpleName" this)))

(clojure.core/defn
 NodeWithSimpleName:setName
 "-- (SimpleName name) -> N\n-- (String name) -> N"
 ([this arg1]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String arg1)
   (.setName
    ^"com.github.javaparser.ast.nodeTypes.NodeWithSimpleName" this
    ^"java.lang.String" arg1)
   (clojure.core/instance?
    com.github.javaparser.ast.expr.SimpleName
    arg1)
   (.setName
    ^"com.github.javaparser.ast.nodeTypes.NodeWithSimpleName" this
    ^"com.github.javaparser.ast.expr.SimpleName" arg1))))

(clojure.core/defn
 NodeWithSimpleName:getNameAsString
 "-- () -> String"
 ([this]
  (.getNameAsString
   ^"com.github.javaparser.ast.nodeTypes.NodeWithSimpleName" this)))

(clojure.core/defn
 NodeWithSimpleName:getNameAsExpression
 "-- () -> NameExpr"
 ([this]
  (.getNameAsExpression
   ^"com.github.javaparser.ast.nodeTypes.NodeWithSimpleName" this)))

(def
 NodeWithSimpleName:class
 "A node with a name. <p> The main reason for this interface is to permit users to manipulate homogeneously all nodes with a getName method."
 com.github.javaparser.ast.nodeTypes.NodeWithSimpleName)

(clojure.core/defn
 NodeWithSimpleName?
 "Checks if x is an instance of com.github.javaparser.ast.nodeTypes.NodeWithSimpleName."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.nodeTypes.NodeWithSimpleName
  x))

(clojure.core/defn
 NodeWithModifiers:getModifiers
 "-- () -> NodeList<Modifier>\nReturn the modifiers of this variable declaration. Warning: modifying the returned set will not trigger observers, you have to use setModifiers for that.\n- return: modifiers\n- see: Modifier"
 ([this]
  (.getModifiers
   ^"com.github.javaparser.ast.nodeTypes.NodeWithModifiers" this)))

(clojure.core/defn
 NodeWithModifiers:setModifiers
 "-- (NodeList<Modifier> modifiers) -> N\n-- (Modifier.Keyword modifiers) -> N\nCreates a list of modifier nodes corresponding to the keywords passed, and set it."
 ([this arg1]
  (clojure.core/cond
   (clojure.core/instance?
    (array-class com.github.javaparser.ast.Modifier$Keyword)
    arg1)
   (.setModifiers
    ^"com.github.javaparser.ast.nodeTypes.NodeWithModifiers" this
    ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg1)
   (clojure.core/instance? com.github.javaparser.ast.NodeList arg1)
   (.setModifiers
    ^"com.github.javaparser.ast.nodeTypes.NodeWithModifiers" this
    ^"com.github.javaparser.ast.NodeList" arg1))))

(clojure.core/defn
 NodeWithModifiers:hasModifier
 "-- (Modifier.Keyword modifier) -> boolean\n\n- param modifier: the modifer being searched for\n- return: true if the modifier has been explicitly added to this node, else false"
 ([this arg1]
  (.hasModifier
   ^"com.github.javaparser.ast.nodeTypes.NodeWithModifiers" this
   ^"com.github.javaparser.ast.Modifier$Keyword" arg1)))

(clojure.core/defn
 NodeWithModifiers:removeModifier
 "-- (Modifier.Keyword modifiersToRemove) -> N"
 ([this arg1]
  (.removeModifier
   ^"com.github.javaparser.ast.nodeTypes.NodeWithModifiers" this
   ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg1)))

(clojure.core/defn
 NodeWithModifiers:setModifier
 "-- (Modifier.Keyword m, boolean set) -> N"
 ([this arg1 arg2]
  (.setModifier
   ^"com.github.javaparser.ast.nodeTypes.NodeWithModifiers" this
   ^"com.github.javaparser.ast.Modifier$Keyword" arg1
   ^"boolean" arg2)))

(clojure.core/defn
 NodeWithModifiers:addModifier
 "-- (Modifier.Keyword newModifiers) -> N"
 ([this arg1]
  (.addModifier
   ^"com.github.javaparser.ast.nodeTypes.NodeWithModifiers" this
   ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg1)))

(clojure.core/defn
 NodeWithModifiers:getAccessSpecifier
 "-- () -> AccessSpecifier\n\n- return: the access specifier as far as it can be derived from the modifiers. Does not take anything else into account (like \"interface methods are implicitly public\")"
 ([this]
  (.getAccessSpecifier
   ^"com.github.javaparser.ast.nodeTypes.NodeWithModifiers" this)))

(def
 NodeWithModifiers:class
 "A Node with Modifiers. Note that not all modifiers may be valid for this node."
 com.github.javaparser.ast.nodeTypes.NodeWithModifiers)

(clojure.core/defn
 NodeWithModifiers?
 "Checks if x is an instance of com.github.javaparser.ast.nodeTypes.NodeWithModifiers."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.nodeTypes.NodeWithModifiers
  x))

(clojure.core/defn
 EnumConstantDeclaration:toEnumConstantDeclaration
 "-- () -> Optional<EnumConstantDeclaration>"
 ([this]
  (.toEnumConstantDeclaration
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this)))

(clojure.core/defn
 ->EnumConstantDeclaration
 "-- ()\n-- (String name)\n-- (NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<Expression> arguments, NodeList<BodyDeclaration<?>> classBody)\n-- (TokenRange tokenRange, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<Expression> arguments, NodeList<BodyDeclaration<?>> classBody)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.body.EnumConstantDeclaration.))
 ([name]
  (com.github.javaparser.ast.body.EnumConstantDeclaration.
   ^"java.lang.String" name))
 ([annotations name arguments classBody]
  (com.github.javaparser.ast.body.EnumConstantDeclaration.
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" arguments
   ^"com.github.javaparser.ast.NodeList" classBody))
 ([tokenRange annotations name arguments classBody]
  (com.github.javaparser.ast.body.EnumConstantDeclaration.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" arguments
   ^"com.github.javaparser.ast.NodeList" classBody)))

(clojure.core/defn
 EnumConstantDeclaration:resolve
 "-- () -> ResolvedEnumConstantDeclaration"
 ([this]
  (.resolve
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this)))

(clojure.core/defn
 EnumConstantDeclaration:setArguments
 "-- (NodeList<Expression> arguments) -> EnumConstantDeclaration"
 ([this arguments]
  (.setArguments
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this
   ^"com.github.javaparser.ast.NodeList" arguments)))

(clojure.core/defn
 EnumConstantDeclaration:getArguments
 "-- () -> NodeList<Expression>"
 ([this]
  (.getArguments
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this)))

(clojure.core/defn
 EnumConstantDeclaration:asEnumConstantDeclaration
 "-- () -> EnumConstantDeclaration"
 ([this]
  (.asEnumConstantDeclaration
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this)))

(clojure.core/defn
 EnumConstantDeclaration:ifEnumConstantDeclaration
 "-- (Consumer<EnumConstantDeclaration> action) -> void"
 ([this action]
  (.ifEnumConstantDeclaration
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this
   ^"java.util.function.Consumer" action)))

(clojure.core/defn
 EnumConstantDeclaration:getClassBody
 "-- () -> NodeList<BodyDeclaration<?>>"
 ([this]
  (.getClassBody
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this)))

(clojure.core/defn
 EnumConstantDeclaration:setName
 "-- (SimpleName name) -> EnumConstantDeclaration"
 ([this name]
  (.setName
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this
   ^"com.github.javaparser.ast.expr.SimpleName" name)))

(clojure.core/defn
 EnumConstantDeclaration:isEnumConstantDeclaration
 "-- () -> boolean"
 ([this]
  (.isEnumConstantDeclaration
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this)))

(clojure.core/defn
 EnumConstantDeclaration:setClassBody
 "-- (NodeList<BodyDeclaration<?>> classBody) -> EnumConstantDeclaration"
 ([this classBody]
  (.setClassBody
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this
   ^"com.github.javaparser.ast.NodeList" classBody)))

(clojure.core/defn
 EnumConstantDeclaration:getName
 "-- () -> SimpleName"
 ([this]
  (.getName
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this)))

(clojure.core/defn
 EnumConstantDeclaration:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 EnumConstantDeclaration:accept
 "-- (GenericVisitor<R, A> v, A arg) -> R\n-- (VoidVisitor<A> v, A arg) -> void"
 ([this v arg]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.GenericVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this
    ^"com.github.javaparser.ast.visitor.GenericVisitor" v
    ^"java.lang.Object" arg)
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.VoidVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this
    ^"com.github.javaparser.ast.visitor.VoidVisitor" v
    ^"java.lang.Object" arg))))

(clojure.core/defn
 EnumConstantDeclaration:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 EnumConstantDeclaration:clone
 "-- () -> EnumConstantDeclaration"
 ([this]
  (.clone
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this)))

(clojure.core/defn
 EnumConstantDeclaration:getMetaModel
 "-- () -> EnumConstantDeclarationMetaModel"
 ([this]
  (.getMetaModel
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" this)))

(def
 EnumConstantDeclaration:class
 "One of the values an enum can take. A(1) and B(2) in this example: {@code enum X { A(1), B(2) } }\n- author: Julio Vilmar Gesser"
 com.github.javaparser.ast.body.EnumConstantDeclaration)

(clojure.core/defn
 EnumConstantDeclaration?
 "Checks if x is an instance of com.github.javaparser.ast.body.EnumConstantDeclaration."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.body.EnumConstantDeclaration
  x))

(clojure.core/defn
 TypeDeclaration:getCallablesWithSignature
 "-- (CallableDeclaration.Signature signature) -> List<CallableDeclaration<?>>\n\n- return: methods or constructors whose signatures match the passed signature."
 ([this signature]
  (.getCallablesWithSignature
   ^"com.github.javaparser.ast.body.TypeDeclaration" this
   ^"com.github.javaparser.ast.body.CallableDeclaration$Signature" signature)))

(clojure.core/defn
 TypeDeclaration:resolve
 "-- () -> ResolvedReferenceTypeDeclaration"
 ([this]
  (.resolve ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:setMembers
 "-- (NodeList<BodyDeclaration<?>> members) -> T"
 ([this members]
  (.setMembers
   ^"com.github.javaparser.ast.body.TypeDeclaration" this
   ^"com.github.javaparser.ast.NodeList" members)))

(clojure.core/defn
 TypeDeclaration:getMembers
 "-- () -> NodeList<BodyDeclaration<?>>"
 ([this]
  (.getMembers
   ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:ifTypeDeclaration
 "-- (Consumer<TypeDeclaration> action) -> void"
 ([this action]
  (.ifTypeDeclaration
   ^"com.github.javaparser.ast.body.TypeDeclaration" this
   ^"java.util.function.Consumer" action)))

(clojure.core/defn
 TypeDeclaration:getModifiers
 "-- () -> NodeList<Modifier>\nReturn the modifiers of this type declaration.\n- return: modifiers\n- see: Modifier"
 ([this]
  (.getModifiers
   ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:getFullyQualifiedName
 "-- () -> Optional<String>\nReturns the fully qualified name of this type, derived only from information available in this compilation unit. (So no symbol solving happens.) If the declared type is a local class declaration, it will return Optional.empty(). If the declared type is a local record declaration, it will return Optional.empty(). If the declared type is not contained in a compilation unit, it will return Optional.empty().\n- see: com.github.javaparser.ast.stmt.LocalClassDeclarationStmt\n- see: com.github.javaparser.ast.stmt.LocalRecordDeclarationStmt"
 ([this]
  (.getFullyQualifiedName
   ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:setName
 "-- (SimpleName name) -> T"
 ([this name]
  (.setName
   ^"com.github.javaparser.ast.body.TypeDeclaration" this
   ^"com.github.javaparser.ast.expr.SimpleName" name)))

(clojure.core/defn
 TypeDeclaration:toTypeDeclaration
 "-- () -> Optional<TypeDeclaration>"
 ([this]
  (.toTypeDeclaration
   ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:getName
 "-- () -> SimpleName"
 ([this]
  (.getName ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.body.TypeDeclaration" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 TypeDeclaration:isTopLevelType
 "-- () -> boolean\n\n- return: is this type's parent a CompilationUnit?"
 ([this]
  (.isTopLevelType
   ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:addMember
 "-- (BodyDeclaration<?> decl) -> T\nAdds the given declaration to the specified type.\n- param decl: member declaration"
 ([this decl]
  (.addMember
   ^"com.github.javaparser.ast.body.TypeDeclaration" this
   ^"com.github.javaparser.ast.body.BodyDeclaration" decl)))

(clojure.core/defn
 ->TypeDeclaration
 "-- ()\n-- (NodeList<Modifier> modifiers, String name)\n-- (NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<BodyDeclaration<?>> members)\n-- (TokenRange tokenRange, NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<BodyDeclaration<?>> members)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.body.TypeDeclaration.))
 ([modifiers name]
  (com.github.javaparser.ast.body.TypeDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"java.lang.String" name))
 ([modifiers annotations name members]
  (com.github.javaparser.ast.body.TypeDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" members))
 ([tokenRange modifiers annotations name members]
  (com.github.javaparser.ast.body.TypeDeclaration.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" members)))

(clojure.core/defn
 TypeDeclaration:isTypeDeclaration
 "-- () -> boolean"
 ([this]
  (.isTypeDeclaration
   ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.body.TypeDeclaration" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 TypeDeclaration:setModifiers
 "-- (NodeList<Modifier> modifiers) -> T"
 ([this modifiers]
  (.setModifiers
   ^"com.github.javaparser.ast.body.TypeDeclaration" this
   ^"com.github.javaparser.ast.NodeList" modifiers)))

(clojure.core/defn
 TypeDeclaration:clone
 "-- () -> TypeDeclaration<?>"
 ([this]
  (.clone ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:isNestedType
 "-- () -> boolean\n\n- return: is this type's parent a TypeDeclaration? NOTE: many people are confused over terminology. Refer to https://docs.oracle.com/javase/tutorial/java/javaOO/nested.html ."
 ([this]
  (.isNestedType
   ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:asTypeDeclaration
 "-- () -> TypeDeclaration"
 ([this]
  (.asTypeDeclaration
   ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(clojure.core/defn
 TypeDeclaration:getMetaModel
 "-- () -> TypeDeclarationMetaModel"
 ([this]
  (.getMetaModel
   ^"com.github.javaparser.ast.body.TypeDeclaration" this)))

(def
 TypeDeclaration:class
 "A base class for all types of type declarations.\n- author: Julio Vilmar Gesser"
 com.github.javaparser.ast.body.TypeDeclaration)

(clojure.core/defn
 TypeDeclaration?
 "Checks if x is an instance of com.github.javaparser.ast.body.TypeDeclaration."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.body.TypeDeclaration
  x))

(clojure.core/defn
 NodeWithMembers:setMember
 "-- (int i, BodyDeclaration<?> member) -> N"
 ([this arg1 arg2]
  (.setMember
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"int" arg1
   ^"com.github.javaparser.ast.body.BodyDeclaration" arg2)))

(clojure.core/defn
 NodeWithMembers:addPublicField
 "-- (Class<?> typeClass, String name) -> FieldDeclaration\nAdd a public field to this.\n- param typeClass: the type of the field\n- param name: the name of the field\n- return: the {@link FieldDeclaration} created\n-- (String type, String name) -> FieldDeclaration\nAdd a public field to this and automatically add the import of the type if needed.\n- param type: the type of the field\n- param name: the name of the field\n- return: the {@link FieldDeclaration} created\n-- (Type type, String name) -> FieldDeclaration\nAdd a public field to this.\n- param type: the type of the field\n- param name: the name of the field\n- return: the {@link FieldDeclaration} created"
 ([this arg1 arg2]
  (clojure.core/cond
   (clojure.core/instance? java.lang.Class arg1)
   (.addPublicField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.Class" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? com.github.javaparser.ast.type.Type arg1)
   (.addPublicField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"com.github.javaparser.ast.type.Type" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? java.lang.String arg1)
   (.addPublicField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.String" arg1
    ^"java.lang.String" arg2))))

(clojure.core/defn
 NodeWithMembers:setMembers
 "-- (NodeList<BodyDeclaration<?>> members) -> N"
 ([this arg1]
  (.setMembers
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"com.github.javaparser.ast.NodeList" arg1)))

(clojure.core/defn
 NodeWithMembers:getMembers
 "-- () -> NodeList<BodyDeclaration<?>>\n\n- return: all members inside the braces of this node, like fields, methods, nested types, etc."
 ([this]
  (.getMembers
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this)))

(clojure.core/defn
 NodeWithMembers:addMethod
 "-- (String methodName, Keyword modifiers) -> MethodDeclaration\nAdds a methods with void return by default to this.\n- param methodName: the method name\n- param modifiers: the modifiers like {@link Modifier.Keyword#PUBLIC}\n- return: the {@link MethodDeclaration} created"
 ([this arg1 arg2]
  (.addMethod
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"java.lang.String" arg1
   ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg2)))

(clojure.core/defn
 NodeWithMembers:getDefaultConstructor
 "-- () -> Optional<ConstructorDeclaration>\nTry to find a {@link ConstructorDeclaration} with no parameters.\n- return: the constructor found, if any."
 ([this]
  (.getDefaultConstructor
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this)))

(clojure.core/defn
 NodeWithMembers:tryAddImportToParentCompilationUnit
 "-- (Class<?> clazz) -> void"
 ([this arg1]
  (.tryAddImportToParentCompilationUnit
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"java.lang.Class" arg1)))

(clojure.core/defn
 NodeWithMembers:addField
 "-- (Class<?> typeClass, String name, Modifier.Keyword modifiers) -> FieldDeclaration\nAdd a field to this and automatically add the import of the type if needed\n- param typeClass: the type of the field\n- param name: the name of the field\n- param modifiers: the modifiers like {@link Modifier.Keyword#PUBLIC}\n- return: the {@link FieldDeclaration} created\n-- (String type, String name, Modifier.Keyword modifiers) -> FieldDeclaration\nAdd a field to this.\n- param type: the type of the field\n- param name: the name of the field\n- param modifiers: the modifiers like {@link Modifier.Keyword#PUBLIC}\n- return: the {@link FieldDeclaration} created\n-- (Type type, String name, Modifier.Keyword modifiers) -> FieldDeclaration\nAdd a field to this.\n- param type: the type of the field\n- param name: the name of the field\n- param modifiers: the modifiers like {@link Modifier.Keyword#PUBLIC}\n- return: the {@link FieldDeclaration} created"
 ([this arg1 arg2 arg3]
  (clojure.core/cond
   (clojure.core/instance? com.github.javaparser.ast.type.Type arg1)
   (.addField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"com.github.javaparser.ast.type.Type" arg1
    ^"java.lang.String" arg2
    ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg3)
   (clojure.core/instance? java.lang.Class arg1)
   (.addField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.Class" arg1
    ^"java.lang.String" arg2
    ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg3)
   (clojure.core/instance? java.lang.String arg1)
   (.addField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.String" arg1
    ^"java.lang.String" arg2
    ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg3))))

(clojure.core/defn
 NodeWithMembers:getMethodsByName
 "-- (String name) -> List<MethodDeclaration>\nTry to find a {@link MethodDeclaration} by its name\n- param name: the name of the method\n- return: the methods found (multiple in case of overloading)"
 ([this arg1]
  (.getMethodsByName
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"java.lang.String" arg1)))

(clojure.core/defn
 NodeWithMembers:addMember
 "-- (BodyDeclaration<?> member) -> N"
 ([this arg1]
  (.addMember
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"com.github.javaparser.ast.body.BodyDeclaration" arg1)))

(clojure.core/defn
 NodeWithMembers:getMethodsBySignature
 "-- (String name, String paramTypes) -> List<MethodDeclaration>\nTry to find {@link MethodDeclaration} s by their name and parameter types. Parameter types are matched exactly as in the case of {@link #getMethodsByParameterTypes(String...)} .\n- param paramTypes: the types of parameters like {@code \"Map&lt;Integer, String&gt;\", \"int\"} to match  {@code void foo(Map&lt;Integer,String&gt; myMap, int number)}\n- return: the methods found"
 ([this arg1 arg2]
  (.getMethodsBySignature
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"java.lang.String" arg1
   ^"[Ljava.lang.String;" arg2)))

(clojure.core/defn
 NodeWithMembers:getMethods
 "-- () -> List<MethodDeclaration>\nFind all methods in the members of this node.\n- return: the methods found. This list is immutable."
 ([this]
  (.getMethods
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this)))

(clojure.core/defn
 NodeWithMembers:addProtectedField
 "-- (Class<?> typeClass, String name) -> FieldDeclaration\nAdd a protected field to this.\n- param typeClass: the type of the field\n- param name: the name of the field\n- return: the {@link FieldDeclaration} created\n-- (String type, String name) -> FieldDeclaration\nAdd a protected field to this and automatically add the import of the type if needed.\n- param type: the type of the field\n- param name: the name of the field\n- return: the {@link FieldDeclaration} created\n-- (Type type, String name) -> FieldDeclaration\nAdd a protected field to this.\n- param type: the type of the field\n- param name: the name of the field\n- return: the {@link FieldDeclaration} created"
 ([this arg1 arg2]
  (clojure.core/cond
   (clojure.core/instance? com.github.javaparser.ast.type.Type arg1)
   (.addProtectedField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"com.github.javaparser.ast.type.Type" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? java.lang.String arg1)
   (.addProtectedField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.String" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? java.lang.Class arg1)
   (.addProtectedField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.Class" arg1
    ^"java.lang.String" arg2))))

(clojure.core/defn
 NodeWithMembers:getMethodsByParameterTypes
 "-- (String paramTypes) -> List<MethodDeclaration>\nTry to find a {@link MethodDeclaration} by its parameter types. The given parameter types must <i>literally</i> match the declared types of this node's parameters, so passing the string {@code \"List\"} to this method will find all methods that have exactly one parameter whose type is declared as {@code List} , but not methods with exactly one parameter whose type is declared as {@code java.util.List} or {@code java.awt.List} . Conversely, passing the string {@code \"java.util.List\"} to this method will find all methods that have exactly one parameter whose type is declared as {@code java.util.List} , but not if the parameter type is declared as {@code List} . Similarly, note that generics are matched as well: If there is a method that has a parameter declared as {@code List&lt;String&gt;} , then it will be considered as a match only if the given string is {@code \"List&lt;String&gt;\"} , but not if the given string is only {@code \"List\"} .\n- param paramTypes: the types of parameters like {@code \"Map&lt;Integer, String&gt;\", \"int\"} to match  {@code void foo(Map&lt;Integer,String&gt; myMap, int number)}\n- return: the methods found\n-- (Class<?> paramTypes) -> List<MethodDeclaration>\nTry to find a {@link MethodDeclaration} by its parameter types. Note that this is a match in SimpleName, so {@code java.awt.List} and {@code java.util.List} are identical to this algorithm. In addition, note that it is the erasure of each type which is considered, so passing {@code List.class} to this method will return all methods that have exactly one parameter whose type is named {@code List} , regardless of whether the parameter type is declared without generics as {@code List} , or with generics as {@code List&lt;String&gt;} , or {@code List&lt;Integer&gt;} , etc.\n- param paramTypes: the types of parameters like {@code Map.class, int.class} to match  {@code void foo(Map&lt;Integer,String&gt; myMap, int number)}\n- return: the methods found"
 ([this arg1]
  (clojure.core/cond
   (clojure.core/instance? (array-class java.lang.String) arg1)
   (.getMethodsByParameterTypes
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"[Ljava.lang.String;" arg1)
   (clojure.core/instance? (array-class java.lang.Class) arg1)
   (.getMethodsByParameterTypes
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"[Ljava.lang.Class;" arg1))))

(clojure.core/defn
 NodeWithMembers:getFieldByName
 "-- (String name) -> Optional<FieldDeclaration>\nTry to find a {@link FieldDeclaration} by its name\n- param name: the name of the field\n- return: null if not found, the FieldDeclaration otherwise"
 ([this arg1]
  (.getFieldByName
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"java.lang.String" arg1)))

(clojure.core/defn
 NodeWithMembers:getConstructorByParameterTypes
 "-- (String paramTypes) -> Optional<ConstructorDeclaration>\nTry to find a {@link ConstructorDeclaration} by its parameter types. The given parameter types must <i>literally</i> match the declared types of the desired constructor, so passing the string {@code \"List\"} to this method will search for a constructor that has exactly one parameter whose type is declared as {@code List} , but not for a constructor with exactly one parameter whose type is declared as {@code java.util.List} or {@code java.awt.List} . Conversely, passing the string {@code \"java.util.List\"} to this method will search for a constructor that has exactly one parameter whose type is declared as {@code java.util.List} , but not for a constructor whose type is declared as {@code List} . Similarly, note that generics are matched as well: If there is a constructor that has a parameter declared as {@code List&lt;String&gt;} , then it will be considered as a match only if the given string is {@code \"List&lt;String&gt;\"} , but not if the given string is only {@code \"List\"} .\n- param paramTypes: the types of parameters like {@code \"Map&lt;Integer, String&gt;\", \"int\"} to match  {@code Foo(Map&lt;Integer,String&gt; myMap, int number)}\n- return: the constructor found, if any.\n-- (Class<?> paramTypes) -> Optional<ConstructorDeclaration>\nTry to find a {@link ConstructorDeclaration} by its parameter types.  Note that this is a match in SimpleName, so {@code java.awt.List} and {@code java.util.List} are identical to this algorithm. In addition, note that it is the erasure of each type which is considered, so passing {@code List.class} to this method will search for a constructor that has exactly one parameter whose type is named {@code List} , regardless of whether the parameter type is declared without generics as {@code List} , or with generics as {@code List&lt;String&gt;} , or {@code List&lt;Integer&gt;} , etc.\n- param paramTypes: the types of parameters like {@code Map.class, int.class} to match  {@code Foo(Map&lt;Integer,String&gt; myMap, int number)}\n- return: the constructor found, if any."
 ([this arg1]
  (clojure.core/cond
   (clojure.core/instance? (array-class java.lang.Class) arg1)
   (.getConstructorByParameterTypes
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"[Ljava.lang.Class;" arg1)
   (clojure.core/instance? (array-class java.lang.String) arg1)
   (.getConstructorByParameterTypes
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"[Ljava.lang.String;" arg1))))

(clojure.core/defn
 NodeWithMembers:addStaticInitializer
 "-- () -> BlockStmt\nAdd a static initializer block ( {@link InitializerDeclaration} ) to this."
 ([this]
  (.addStaticInitializer
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this)))

(clojure.core/defn
 NodeWithMembers:isEmpty
 "-- () -> boolean\n\n- return: true if there are no members contained in this node."
 ([this]
  (.isEmpty
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this)))

(clojure.core/defn
 NodeWithMembers:addConstructor
 "-- (Modifier.Keyword modifiers) -> ConstructorDeclaration\nAdds a constructor to this node with members.\n- param modifiers: the modifiers like {@link Modifier.Keyword#PUBLIC}\n- return: the created constructor"
 ([this arg1]
  (.addConstructor
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg1)))

(clojure.core/defn
 NodeWithMembers:getFields
 "-- () -> List<FieldDeclaration>\nFind all fields in the members of this node.\n- return: the fields found. This list is immutable."
 ([this]
  (.getFields
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this)))

(clojure.core/defn
 NodeWithMembers:addFieldWithInitializer
 "-- (Class<?> typeClass, String name, Expression initializer, Modifier.Keyword modifiers) -> FieldDeclaration\nAdd a field to this and automatically add the import of the type if needed\n- param typeClass: the type of the field\n- param name: the name of the field\n- param initializer: the initializer of the field\n- param modifiers: the modifiers like {@link Modifier.Keyword#PUBLIC}\n- return: the {@link FieldDeclaration} created\n-- (String type, String name, Expression initializer, Modifier.Keyword modifiers) -> FieldDeclaration\nAdd a field to this.\n- param type: the type of the field\n- param name: the name of the field\n- param initializer: the initializer of the field\n- param modifiers: the modifiers like {@link Modifier.Keyword#PUBLIC}\n- return: the {@link FieldDeclaration} created\n-- (Type type, String name, Expression initializer, Modifier.Keyword modifiers) -> FieldDeclaration\nAdd a field to this.\n- param type: the type of the field\n- param name: the name of the field\n- param initializer: the initializer of the field\n- param modifiers: the modifiers like {@link Modifier.Keyword#PUBLIC}\n- return: the {@link FieldDeclaration} created"
 ([this arg1 arg2 arg3 arg4]
  (clojure.core/cond
   (clojure.core/instance? java.lang.String arg1)
   (.addFieldWithInitializer
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.String" arg1
    ^"java.lang.String" arg2
    ^"com.github.javaparser.ast.expr.Expression" arg3
    ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg4)
   (clojure.core/instance? com.github.javaparser.ast.type.Type arg1)
   (.addFieldWithInitializer
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"com.github.javaparser.ast.type.Type" arg1
    ^"java.lang.String" arg2
    ^"com.github.javaparser.ast.expr.Expression" arg3
    ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg4)
   (clojure.core/instance? java.lang.Class arg1)
   (.addFieldWithInitializer
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.Class" arg1
    ^"java.lang.String" arg2
    ^"com.github.javaparser.ast.expr.Expression" arg3
    ^"[Lcom.github.javaparser.ast.Modifier$Keyword;" arg4))))

(clojure.core/defn
 NodeWithMembers:addPrivateField
 "-- (Class<?> typeClass, String name) -> FieldDeclaration\nAdd a private field to this.\n- param typeClass: the type of the field\n- param name: the name of the field\n- return: the {@link FieldDeclaration} created\n-- (String type, String name) -> FieldDeclaration\nAdd a private field to this and automatically add the import of the type if needed.\n- param type: the type of the field\n- param name: the name of the field\n- return: the {@link FieldDeclaration} created\n-- (Type type, String name) -> FieldDeclaration\nAdd a private field to this.\n- param type: the type of the field\n- param name: the name of the field\n- return: the {@link FieldDeclaration} created"
 ([this arg1 arg2]
  (clojure.core/cond
   (clojure.core/instance? java.lang.Class arg1)
   (.addPrivateField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.Class" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? java.lang.String arg1)
   (.addPrivateField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"java.lang.String" arg1
    ^"java.lang.String" arg2)
   (clojure.core/instance? com.github.javaparser.ast.type.Type arg1)
   (.addPrivateField
    ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
    ^"com.github.javaparser.ast.type.Type" arg1
    ^"java.lang.String" arg2))))

(clojure.core/defn
 NodeWithMembers:addInitializer
 "-- () -> BlockStmt\nAdd an initializer block ( {@link InitializerDeclaration} ) to this."
 ([this]
  (.addInitializer
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this)))

(clojure.core/defn
 NodeWithMembers:getConstructors
 "-- () -> List<ConstructorDeclaration>\nFind all constructors in the members of this node. Note that only \"normal\" constructors, not the \"compact\" constructors\", within {@link RecordDeclaration}  are included in the output of this method.\n- return: the constructors found. This list is immutable."
 ([this]
  (.getConstructors
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this)))

(clojure.core/defn
 NodeWithMembers:getMember
 "-- (int i) -> BodyDeclaration<?>"
 ([this arg1]
  (.getMember
   ^"com.github.javaparser.ast.nodeTypes.NodeWithMembers" this
   ^"int" arg1)))

(def
 NodeWithMembers:class
 "A node having members. <p> The main reason for this interface is to permit users to manipulate homogeneously all nodes with a getMembers method."
 com.github.javaparser.ast.nodeTypes.NodeWithMembers)

(clojure.core/defn
 NodeWithMembers?
 "Checks if x is an instance of com.github.javaparser.ast.nodeTypes.NodeWithMembers."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.nodeTypes.NodeWithMembers
  x))

(clojure.core/defn
 EnumDeclaration:resolve
 "-- () -> ResolvedEnumDeclaration"
 ([this]
  (.resolve ^"com.github.javaparser.ast.body.EnumDeclaration" this)))

(clojure.core/defn
 EnumDeclaration:getEntry
 "-- (int i) -> EnumConstantDeclaration"
 ([this i]
  (.getEntry
   ^"com.github.javaparser.ast.body.EnumDeclaration" this
   ^"int" i)))

(clojure.core/defn
 EnumDeclaration:toEnumDeclaration
 "-- () -> Optional<EnumDeclaration>"
 ([this]
  (.toEnumDeclaration
   ^"com.github.javaparser.ast.body.EnumDeclaration" this)))

(clojure.core/defn
 EnumDeclaration:asEnumDeclaration
 "-- () -> EnumDeclaration"
 ([this]
  (.asEnumDeclaration
   ^"com.github.javaparser.ast.body.EnumDeclaration" this)))

(clojure.core/defn
 EnumDeclaration:setEntries
 "-- (NodeList<EnumConstantDeclaration> entries) -> EnumDeclaration"
 ([this entries]
  (.setEntries
   ^"com.github.javaparser.ast.body.EnumDeclaration" this
   ^"com.github.javaparser.ast.NodeList" entries)))

(clojure.core/defn
 EnumDeclaration:replace
 "-- (Node node, Node replacementNode) -> boolean"
 ([this node replacementNode]
  (.replace
   ^"com.github.javaparser.ast.body.EnumDeclaration" this
   ^"com.github.javaparser.ast.Node" node
   ^"com.github.javaparser.ast.Node" replacementNode)))

(clojure.core/defn
 EnumDeclaration:accept
 "-- (GenericVisitor<R, A> v, A arg) -> R\n-- (VoidVisitor<A> v, A arg) -> void"
 ([this v arg]
  (clojure.core/cond
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.GenericVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.EnumDeclaration" this
    ^"com.github.javaparser.ast.visitor.GenericVisitor" v
    ^"java.lang.Object" arg)
   (clojure.core/instance?
    com.github.javaparser.ast.visitor.VoidVisitor
    v)
   (.accept
    ^"com.github.javaparser.ast.body.EnumDeclaration" this
    ^"com.github.javaparser.ast.visitor.VoidVisitor" v
    ^"java.lang.Object" arg))))

(clojure.core/defn
 EnumDeclaration:getEntries
 "-- () -> NodeList<EnumConstantDeclaration>"
 ([this]
  (.getEntries
   ^"com.github.javaparser.ast.body.EnumDeclaration" this)))

(clojure.core/defn
 EnumDeclaration:remove
 "-- (Node node) -> boolean"
 ([this node]
  (.remove
   ^"com.github.javaparser.ast.body.EnumDeclaration" this
   ^"com.github.javaparser.ast.Node" node)))

(clojure.core/defn
 EnumDeclaration:setImplementedTypes
 "-- (NodeList<ClassOrInterfaceType> implementedTypes) -> EnumDeclaration"
 ([this implementedTypes]
  (.setImplementedTypes
   ^"com.github.javaparser.ast.body.EnumDeclaration" this
   ^"com.github.javaparser.ast.NodeList" implementedTypes)))

(clojure.core/defn
 EnumDeclaration:setEntry
 "-- (int i, EnumConstantDeclaration element) -> EnumDeclaration"
 ([this i element]
  (.setEntry
   ^"com.github.javaparser.ast.body.EnumDeclaration" this
   ^"int" i
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" element)))

(clojure.core/defn
 EnumDeclaration:clone
 "-- () -> EnumDeclaration"
 ([this]
  (.clone ^"com.github.javaparser.ast.body.EnumDeclaration" this)))

(clojure.core/defn
 EnumDeclaration:addEntry
 "-- (EnumConstantDeclaration element) -> EnumDeclaration"
 ([this element]
  (.addEntry
   ^"com.github.javaparser.ast.body.EnumDeclaration" this
   ^"com.github.javaparser.ast.body.EnumConstantDeclaration" element)))

(clojure.core/defn
 EnumDeclaration:ifEnumDeclaration
 "-- (Consumer<EnumDeclaration> action) -> void"
 ([this action]
  (.ifEnumDeclaration
   ^"com.github.javaparser.ast.body.EnumDeclaration" this
   ^"java.util.function.Consumer" action)))

(clojure.core/defn
 EnumDeclaration:isEnumDeclaration
 "-- () -> boolean"
 ([this]
  (.isEnumDeclaration
   ^"com.github.javaparser.ast.body.EnumDeclaration" this)))

(clojure.core/defn
 EnumDeclaration:getMetaModel
 "-- () -> EnumDeclarationMetaModel"
 ([this]
  (.getMetaModel
   ^"com.github.javaparser.ast.body.EnumDeclaration" this)))

(clojure.core/defn
 ->EnumDeclaration
 "-- ()\n-- (NodeList<Modifier> modifiers, String name)\n-- (NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<ClassOrInterfaceType> implementedTypes, NodeList<EnumConstantDeclaration> entries, NodeList<BodyDeclaration<?>> members)\n-- (TokenRange tokenRange, NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, SimpleName name, NodeList<ClassOrInterfaceType> implementedTypes, NodeList<EnumConstantDeclaration> entries, NodeList<BodyDeclaration<?>> members)\nThis constructor is used by the parser and is considered private."
 ([] (com.github.javaparser.ast.body.EnumDeclaration.))
 ([modifiers name]
  (com.github.javaparser.ast.body.EnumDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"java.lang.String" name))
 ([modifiers annotations name implementedTypes entries members]
  (com.github.javaparser.ast.body.EnumDeclaration.
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" implementedTypes
   ^"com.github.javaparser.ast.NodeList" entries
   ^"com.github.javaparser.ast.NodeList" members))
 ([tokenRange
   modifiers
   annotations
   name
   implementedTypes
   entries
   members]
  (com.github.javaparser.ast.body.EnumDeclaration.
   ^"com.github.javaparser.TokenRange" tokenRange
   ^"com.github.javaparser.ast.NodeList" modifiers
   ^"com.github.javaparser.ast.NodeList" annotations
   ^"com.github.javaparser.ast.expr.SimpleName" name
   ^"com.github.javaparser.ast.NodeList" implementedTypes
   ^"com.github.javaparser.ast.NodeList" entries
   ^"com.github.javaparser.ast.NodeList" members)))

(clojure.core/defn
 EnumDeclaration:getImplementedTypes
 "-- () -> NodeList<ClassOrInterfaceType>"
 ([this]
  (.getImplementedTypes
   ^"com.github.javaparser.ast.body.EnumDeclaration" this)))

(clojure.core/defn
 EnumDeclaration:addEnumConstant
 "-- (String name) -> EnumConstantDeclaration"
 ([this name]
  (.addEnumConstant
   ^"com.github.javaparser.ast.body.EnumDeclaration" this
   ^"java.lang.String" name)))

(def
 EnumDeclaration:class
 "The declaration of an enum.<br> {@code enum X { ... } }\n- author: Julio Vilmar Gesser"
 com.github.javaparser.ast.body.EnumDeclaration)

(clojure.core/defn
 EnumDeclaration?
 "Checks if x is an instance of com.github.javaparser.ast.body.EnumDeclaration."
 [x]
 (clojure.core/instance?
  com.github.javaparser.ast.body.EnumDeclaration
  x))

