/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.trigger.properties;

import com.novemberain.quartz.mongodb.trigger.TriggerPropertiesConverter;
import java.text.ParseException;
import java.util.Map;
import java.util.TimeZone;
import org.bson.Document;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CronTriggerPropertiesConverter
extends TriggerPropertiesConverter {
    private static final String TRIGGER_CRON_EXPRESSION = "cronExpression";
    private static final String TRIGGER_TIMEZONE = "timezone";

    @Override
    protected boolean canHandle(OperableTrigger trigger) {
        return trigger instanceof CronTriggerImpl && !((CronTriggerImpl)trigger).hasAdditionalProperties();
    }

    @Override
    public Document injectExtraPropertiesForInsert(OperableTrigger trigger, Document original) {
        CronTrigger t = (CronTrigger)trigger;
        return new Document((Map)original).append(TRIGGER_CRON_EXPRESSION, (Object)t.getCronExpression()).append(TRIGGER_TIMEZONE, (Object)t.getTimeZone().getID());
    }

    @Override
    public void setExtraPropertiesAfterInstantiation(OperableTrigger trigger, Document stored) {
        String tz;
        CronTriggerImpl t = (CronTriggerImpl)trigger;
        String expression = stored.getString((Object)TRIGGER_CRON_EXPRESSION);
        if (expression != null) {
            try {
                t.setCronExpression(new CronExpression(expression));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((tz = stored.getString((Object)TRIGGER_TIMEZONE)) != null) {
            t.setTimeZone(TimeZone.getTimeZone(tz));
        }
    }
}

