/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.dao;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.novemberain.quartz.mongodb.util.SerialUtils;
import java.util.LinkedList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.quartz.Calendar;
import org.quartz.JobPersistenceException;

public class CalendarDao {
    static final String CALENDAR_NAME = "name";
    static final String CALENDAR_SERIALIZED_OBJECT = "serializedObject";
    private final MongoCollection<Document> calendarCollection;

    public CalendarDao(MongoCollection<Document> calendarCollection) {
        this.calendarCollection = calendarCollection;
    }

    public void clear() {
        this.calendarCollection.deleteMany((Bson)new Document());
    }

    public void createIndex() {
        this.calendarCollection.createIndex(Projections.include((String[])new String[]{CALENDAR_NAME}), new IndexOptions().unique(true));
    }

    public MongoCollection<Document> getCollection() {
        return this.calendarCollection;
    }

    public int getCount() {
        return (int)this.calendarCollection.countDocuments();
    }

    public boolean remove(String name) {
        Bson searchObj = Filters.eq((String)CALENDAR_NAME, (Object)name);
        if (this.calendarCollection.countDocuments(searchObj) > 0L) {
            this.calendarCollection.deleteMany(searchObj);
            return true;
        }
        return false;
    }

    public Calendar retrieveCalendar(String calName) throws JobPersistenceException {
        Bson searchObj;
        Document doc;
        if (calName != null && (doc = (Document)this.calendarCollection.find(searchObj = Filters.eq((String)CALENDAR_NAME, (Object)calName)).first()) != null) {
            Binary serializedCalendar = (Binary)doc.get((Object)CALENDAR_SERIALIZED_OBJECT, Binary.class);
            return SerialUtils.deserialize(serializedCalendar, Calendar.class);
        }
        return null;
    }

    public void store(String name, Calendar calendar) throws JobPersistenceException {
        Document doc = new Document(CALENDAR_NAME, (Object)name).append(CALENDAR_SERIALIZED_OBJECT, SerialUtils.serialize(calendar));
        this.calendarCollection.insertOne((Object)doc);
    }

    public List<String> retrieveCalendarNames() {
        return (List)this.calendarCollection.find().projection(Projections.include((String[])new String[]{CALENDAR_NAME})).map(document -> document.getString((Object)CALENDAR_NAME)).into(new LinkedList());
    }
}

