/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.cluster;

import java.util.Date;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class RecoveryTriggerFactory {
    private final String instanceId;

    public RecoveryTriggerFactory(String instanceId) {
        this.instanceId = instanceId;
    }

    public OperableTrigger from(OperableTrigger trigger) {
        TriggerKey tKey = trigger.getKey();
        JobKey jKey = trigger.getJobKey();
        long scheduleTimestamp = System.currentTimeMillis();
        long fireTimestamp = System.currentTimeMillis();
        SimpleTriggerImpl rcvryTrig = new SimpleTriggerImpl();
        rcvryTrig.setName("recover_" + this.instanceId + "_" + System.currentTimeMillis());
        rcvryTrig.setGroup("RECOVERING_JOBS");
        rcvryTrig.setStartTime(new Date(scheduleTimestamp));
        rcvryTrig.setJobName(jKey.getName());
        rcvryTrig.setJobGroup(jKey.getGroup());
        rcvryTrig.setMisfireInstruction(-1);
        rcvryTrig.setPriority(trigger.getPriority());
        JobDataMap jd = new JobDataMap((Map)trigger.getJobDataMap());
        jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", tKey.getName());
        jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", tKey.getGroup());
        jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(fireTimestamp));
        rcvryTrig.setJobDataMap(jd);
        rcvryTrig.computeFirstFireTime(null);
        return rcvryTrig;
    }
}

