/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.db;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.novemberain.quartz.mongodb.db.ExternalMongoConnector;
import com.novemberain.quartz.mongodb.db.InternalMongoConnector;
import com.novemberain.quartz.mongodb.db.MongoConnector;
import com.novemberain.quartz.mongodb.db.SSLContextFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.quartz.SchedulerConfigException;

public class MongoConnectorBuilder {
    private static final String PARAM_NOT_ALLOWED = "'%s' parameter is not allowed. %s";
    private MongoConnector connector;
    private String writeConcernW;
    private Integer writeConcernWriteTimeout;
    private MongoDatabase database;
    private MongoClient client;
    private String dbName;
    private String uri;
    private String[] addresses;
    private String username;
    private String password;
    private String authDbName;
    private Integer maxConnections;
    private Integer connectTimeoutMillis;
    private Integer readTimeoutMillis;
    private Boolean socketKeepAlive;
    private Boolean enableSSL;
    private Boolean sslInvalidHostNameAllowed;
    private String trustStorePath;
    private String trustStorePassword;
    private String trustStoreType;
    private String keyStorePath;
    private String keyStorePassword;
    private String keyStoreType;
    private SSLContextFactory sslContextFactory = new SSLContextFactory();

    private MongoConnectorBuilder() {
    }

    public static MongoConnectorBuilder builder() {
        return new MongoConnectorBuilder();
    }

    public MongoConnector build() throws SchedulerConfigException {
        if (this.connector != null) {
            this.validateForConnector();
            return this.connector;
        }
        WriteConcern writeConcern = this.createWriteConcern();
        if (this.database != null) {
            this.validateForDatabase();
            return new ExternalMongoConnector(writeConcern, this.database);
        }
        this.resolveDbNameByUriIfNull();
        MongoConnectorBuilder.checkNotNull(this.dbName, "'Database name' is required, as parameter or in MongoDB URI path.");
        if (this.client != null) {
            this.validateForClient();
            return new ExternalMongoConnector(writeConcern, this.client, this.dbName);
        }
        MongoClientSettings.Builder settingsBuilder = this.createSettingsBuilder();
        if (this.uri != null) {
            this.validateForUri();
            return new InternalMongoConnector(writeConcern, this.uri, this.dbName, settingsBuilder);
        }
        MongoConnectorBuilder.checkNotNull(this.addresses, "At least one MongoDB address or a MongoDB URI must be specified.");
        List<ServerAddress> serverAddresses = this.collectServerAddresses();
        Optional<MongoCredential> credentials = this.createCredentials();
        return new InternalMongoConnector(writeConcern, serverAddresses, credentials, settingsBuilder, this.dbName);
    }

    private void resolveDbNameByUriIfNull() {
        String path;
        if (this.dbName == null && this.uri != null && (path = URI.create(this.uri).getPath()) != null && path.startsWith("/") && path.length() > 1) {
            this.dbName = path.substring(1);
        }
    }

    private List<ServerAddress> collectServerAddresses() {
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>(this.addresses.length);
        for (String address : this.addresses) {
            serverAddresses.add(new ServerAddress(address));
        }
        return serverAddresses;
    }

    private Optional<MongoCredential> createCredentials() {
        if (this.username != null) {
            MongoCredential cred = this.authDbName != null ? MongoCredential.createCredential((String)this.username, (String)this.authDbName, (char[])this.password.toCharArray()) : MongoCredential.createCredential((String)this.username, (String)this.dbName, (char[])this.password.toCharArray());
            return Optional.of(cred);
        }
        return Optional.empty();
    }

    private MongoClientSettings.Builder createSettingsBuilder() throws SchedulerConfigException {
        MongoClientSettings.Builder settingsBuilder = MongoClientSettings.builder();
        if (this.maxConnections != null) {
            settingsBuilder.applyToConnectionPoolSettings(builder -> builder.maxSize(this.maxConnections.intValue()));
        }
        if (this.connectTimeoutMillis != null) {
            settingsBuilder.applyToSocketSettings(builder -> builder.connectTimeout((long)this.connectTimeoutMillis.intValue(), TimeUnit.MILLISECONDS));
        }
        if (this.readTimeoutMillis != null) {
            settingsBuilder.applyToSocketSettings(builder -> builder.readTimeout((long)this.readTimeoutMillis.intValue(), TimeUnit.MILLISECONDS));
        }
        if (this.socketKeepAlive != null) {
            // empty if block
        }
        if (this.username != null && this.authDbName != null && this.password != null) {
            MongoCredential credential = MongoCredential.createScramSha1Credential((String)this.username, (String)this.authDbName, (char[])this.password.toCharArray());
            settingsBuilder.credential(credential);
        }
        this.hanldeSSLContext(settingsBuilder);
        return settingsBuilder;
    }

    private void hanldeSSLContext(MongoClientSettings.Builder optionsBuilder) throws SchedulerConfigException {
        try {
            SSLContext sslContext = this.sslContextFactory.getSSLContext(this.trustStorePath, this.trustStorePassword, this.trustStoreType, this.keyStorePath, this.keyStorePassword, this.keyStoreType);
            if (sslContext == null) {
                if (this.enableSSL != null) {
                    optionsBuilder.applyToSslSettings(builder -> builder.enabled(this.enableSSL.booleanValue()));
                    if (this.sslInvalidHostNameAllowed != null) {
                        optionsBuilder.applyToSslSettings(builder -> builder.invalidHostNameAllowed(this.sslInvalidHostNameAllowed.booleanValue()));
                    }
                }
            } else {
                optionsBuilder.applyToSslSettings(builder -> builder.enabled(true));
                if (this.sslInvalidHostNameAllowed != null) {
                    optionsBuilder.applyToSslSettings(builder -> builder.invalidHostNameAllowed(this.sslInvalidHostNameAllowed.booleanValue()));
                }
                optionsBuilder.applyToSslSettings(builder -> builder.context(sslContext));
            }
        }
        catch (SSLException e) {
            throw new SchedulerConfigException("Cannot setup SSL context", (Throwable)e);
        }
    }

    private WriteConcern createWriteConcern() throws SchedulerConfigException {
        MongoConnectorBuilder.checkNotNull(this.writeConcernWriteTimeout, "Write timeout is expected.");
        if (this.writeConcernW != null) {
            return WriteConcern.valueOf((String)this.writeConcernW).withWTimeout((long)this.writeConcernWriteTimeout.intValue(), TimeUnit.MILLISECONDS).withJournal(Boolean.valueOf(true));
        }
        return WriteConcern.MAJORITY.withWTimeout((long)this.writeConcernWriteTimeout.intValue(), TimeUnit.MILLISECONDS).withJournal(Boolean.valueOf(true));
    }

    private void validateForConnector() throws SchedulerConfigException {
        String suffix = "'Connector' parameter is used.";
        MongoConnectorBuilder.checkIsNull(this.database, MongoConnectorBuilder.paramNotAllowed("Database", "'Connector' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.client, MongoConnectorBuilder.paramNotAllowed("Client", "'Connector' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.dbName, MongoConnectorBuilder.paramNotAllowed("Database name", "'Connector' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.uri, MongoConnectorBuilder.paramNotAllowed("URI", "'Connector' parameter is used."));
        this.checkServerPropertiesAreNull("'Connector' parameter is used.");
        this.checkConnectionOptionsAreNull("'Connector' parameter is used.");
    }

    private void validateForDatabase() throws SchedulerConfigException {
        String suffix = "'Database' parameter is used.";
        MongoConnectorBuilder.checkIsNull(this.client, MongoConnectorBuilder.paramNotAllowed("Client", "'Database' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.dbName, MongoConnectorBuilder.paramNotAllowed("Database name", "'Database' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.uri, MongoConnectorBuilder.paramNotAllowed("URI", "'Database' parameter is used."));
        this.checkServerPropertiesAreNull("'Database' parameter is used.");
        this.checkConnectionOptionsAreNull("'Database' parameter is used.");
    }

    private void validateForClient() throws SchedulerConfigException {
        String suffix = "'Client' parameter is used.";
        MongoConnectorBuilder.checkIsNull(this.uri, MongoConnectorBuilder.paramNotAllowed("URI", "'Client' parameter is used."));
        this.checkServerPropertiesAreNull("'Client' parameter is used.");
        this.checkConnectionOptionsAreNull("'Client' parameter is used.");
    }

    private void validateForUri() throws SchedulerConfigException {
        this.checkServerPropertiesAreNull("'URI' parameter is used.");
    }

    private static <T> T checkNotNull(T reference, String message) throws SchedulerConfigException {
        if (reference == null) {
            throw new SchedulerConfigException(message);
        }
        return reference;
    }

    private static void checkIsNull(Object reference, String message) throws SchedulerConfigException {
        if (reference != null) {
            throw new SchedulerConfigException(message);
        }
    }

    private void checkServerPropertiesAreNull(String suffix) throws SchedulerConfigException {
        MongoConnectorBuilder.checkIsNull(this.addresses, MongoConnectorBuilder.paramNotAllowed("Addresses array", suffix));
    }

    private void checkConnectionOptionsAreNull(String suffix) throws SchedulerConfigException {
        MongoConnectorBuilder.checkIsNull(this.maxConnections, MongoConnectorBuilder.paramNotAllowed("Max connections", suffix));
        MongoConnectorBuilder.checkIsNull(this.connectTimeoutMillis, MongoConnectorBuilder.paramNotAllowed("Connect timeout millis", suffix));
        MongoConnectorBuilder.checkIsNull(this.readTimeoutMillis, MongoConnectorBuilder.paramNotAllowed("Socket timeout millis", suffix));
        MongoConnectorBuilder.checkIsNull(this.socketKeepAlive, MongoConnectorBuilder.paramNotAllowed("Socket keepAlive", suffix));
        MongoConnectorBuilder.checkIsNull(this.enableSSL, MongoConnectorBuilder.paramNotAllowed("Enable ssl", suffix));
        MongoConnectorBuilder.checkIsNull(this.sslInvalidHostNameAllowed, MongoConnectorBuilder.paramNotAllowed("SSL invalid hostname allowed", suffix));
        MongoConnectorBuilder.checkIsNull(this.trustStorePath, MongoConnectorBuilder.paramNotAllowed("TrustStore path", suffix));
        MongoConnectorBuilder.checkIsNull(this.trustStorePassword, MongoConnectorBuilder.paramNotAllowed("TrustStore password", suffix));
        MongoConnectorBuilder.checkIsNull(this.trustStoreType, MongoConnectorBuilder.paramNotAllowed("TrustStore type", suffix));
        MongoConnectorBuilder.checkIsNull(this.keyStorePath, MongoConnectorBuilder.paramNotAllowed("KeyStore path", suffix));
        MongoConnectorBuilder.checkIsNull(this.keyStorePassword, MongoConnectorBuilder.paramNotAllowed("KeyStore password", suffix));
        MongoConnectorBuilder.checkIsNull(this.keyStoreType, MongoConnectorBuilder.paramNotAllowed("KeyStore type", suffix));
    }

    private static String paramNotAllowed(String paramName, String suffix) {
        return String.format(PARAM_NOT_ALLOWED, paramName, suffix);
    }

    public MongoConnectorBuilder withConnector(MongoConnector connector) {
        this.connector = connector;
        return this;
    }

    public MongoConnectorBuilder withWriteConcernWriteTimeout(int writeConcernWriteTimeout) {
        this.writeConcernWriteTimeout = writeConcernWriteTimeout;
        return this;
    }

    public MongoConnectorBuilder withWriteConcernW(String writeConcernW) {
        this.writeConcernW = writeConcernW;
        return this;
    }

    public MongoConnectorBuilder withDatabase(MongoDatabase database) {
        this.database = database;
        return this;
    }

    public MongoConnectorBuilder withClient(MongoClient client) {
        this.client = client;
        return this;
    }

    public MongoConnectorBuilder withDatabaseName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public MongoConnectorBuilder withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public MongoConnectorBuilder withAddresses(String[] addresses) {
        this.addresses = addresses;
        return this;
    }

    public MongoConnectorBuilder withCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public MongoConnectorBuilder withAuthDatabaseName(String authDbName) {
        this.authDbName = authDbName;
        return this;
    }

    public MongoConnectorBuilder withMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public MongoConnectorBuilder withConnectTimeoutMillis(Integer connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public MongoConnectorBuilder withReadTimeoutMillis(Integer readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public MongoConnectorBuilder withSocketKeepAlive(Boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
        return this;
    }

    public MongoConnectorBuilder withSSL(Boolean enableSSL, Boolean sslInvalidHostNameAllowed) {
        this.enableSSL = enableSSL;
        this.sslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
        return this;
    }

    public MongoConnectorBuilder withTrustStore(String trustStorePath, String trustStorePassword, String trustStoreType) {
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        return this;
    }

    public MongoConnectorBuilder withKeyStore(String keyStorePath, String keyStorePassword, String keyStoreType) {
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        return this;
    }
}

