/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.db;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.novemberain.quartz.mongodb.db.MongoConnector;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.quartz.SchedulerConfigException;

public class InternalMongoConnector
implements MongoConnector {
    private final WriteConcern writeConcern;
    private final MongoClient mongoClient;
    private final MongoDatabase database;

    private InternalMongoConnector(WriteConcern writeConcern, MongoClient mongoClient, String dbName) {
        this.writeConcern = writeConcern;
        this.mongoClient = mongoClient;
        this.database = mongoClient.getDatabase(dbName);
    }

    public InternalMongoConnector(WriteConcern writeConcern, String uri, String dbName) throws SchedulerConfigException {
        this(writeConcern, uri, dbName, null);
    }

    public InternalMongoConnector(WriteConcern writeConcern, String uri, String dbName, MongoClientSettings.Builder settingsBuilder) throws SchedulerConfigException {
        this(writeConcern, InternalMongoConnector.createClient(uri, settingsBuilder), dbName);
    }

    public InternalMongoConnector(WriteConcern writeConcern, List<ServerAddress> seeds, Optional<MongoCredential> credentials, MongoClientSettings.Builder settingsBuilder, String dbName) throws SchedulerConfigException {
        this(writeConcern, InternalMongoConnector.createClient(seeds, credentials, settingsBuilder), dbName);
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.database.getCollection(collectionName).withWriteConcern(this.writeConcern);
    }

    @Override
    public void close() {
        this.mongoClient.close();
    }

    private static MongoClient createClient(MongoClientSettings settings) throws SchedulerConfigException {
        try {
            return MongoClients.create((MongoClientSettings)settings);
        }
        catch (MongoException e) {
            throw new SchedulerConfigException("MongoDB driver thrown an exception.", (Throwable)e);
        }
    }

    private static MongoClient createClient(String uri, MongoClientSettings.Builder settingsBuilder) throws SchedulerConfigException {
        ConnectionString mongoUri;
        try {
            mongoUri = new ConnectionString(uri);
        }
        catch (MongoException e) {
            throw new SchedulerConfigException("Invalid mongo client uri.", (Throwable)e);
        }
        return InternalMongoConnector.createClient(settingsBuilder.applyConnectionString(mongoUri).build());
    }

    private static MongoClient createClient(List<ServerAddress> seeds, Optional<MongoCredential> credentials, MongoClientSettings.Builder settingsBuilder) throws SchedulerConfigException {
        try {
            settingsBuilder.applyToClusterSettings(builder -> builder.hosts(seeds));
            credentials.ifPresent(arg_0 -> ((MongoClientSettings.Builder)settingsBuilder).credential(arg_0));
            return MongoClients.create((MongoClientSettings)settingsBuilder.build());
        }
        catch (MongoException e) {
            throw new SchedulerConfigException("MongoDB driver thrown an exception.", (Throwable)e);
        }
    }
}

