/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb;

import com.novemberain.quartz.mongodb.TriggerAndJobPersister;
import com.novemberain.quartz.mongodb.dao.JobDao;
import com.novemberain.quartz.mongodb.dao.LocksDao;
import com.novemberain.quartz.mongodb.dao.TriggerDao;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.Trigger;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCompleteHandler {
    private static final Logger log = LoggerFactory.getLogger(JobCompleteHandler.class);
    private final TriggerAndJobPersister persister;
    private final SchedulerSignaler signaler;
    private final JobDao jobDao;
    private final LocksDao locksDao;
    private TriggerDao triggerDao;

    public JobCompleteHandler(TriggerAndJobPersister persister, SchedulerSignaler signaler, JobDao jobDao, LocksDao locksDao, TriggerDao triggerDao) {
        this.persister = persister;
        this.signaler = signaler;
        this.jobDao = jobDao;
        this.locksDao = locksDao;
        this.triggerDao = triggerDao;
    }

    public void jobComplete(OperableTrigger trigger, JobDetail job, Trigger.CompletedExecutionInstruction executionInstruction) {
        log.debug("Trigger completed {}", (Object)trigger.getKey());
        if (job.isPersistJobDataAfterExecution() && job.getJobDataMap().isDirty()) {
            log.debug("Job data map dirty, will store {}", (Object)job.getKey());
            try {
                this.jobDao.storeJobInMongo(job, true);
            }
            catch (JobPersistenceException e) {
                throw new RuntimeException(e);
            }
        }
        if (job.isConcurrentExecutionDisallowed()) {
            this.locksDao.unlockJob(job);
        }
        try {
            this.process(trigger, executionInstruction);
        }
        catch (JobPersistenceException e) {
            throw new RuntimeException(e);
        }
        this.locksDao.unlockTrigger(trigger);
    }

    private boolean isTriggerDeletionRequested(Trigger.CompletedExecutionInstruction triggerInstCode) {
        return triggerInstCode == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER;
    }

    private void process(OperableTrigger trigger, Trigger.CompletedExecutionInstruction executionInstruction) throws JobPersistenceException {
        OperableTrigger dbTrigger = this.triggerDao.getTrigger(trigger.getKey());
        if (dbTrigger != null) {
            if (this.isTriggerDeletionRequested(executionInstruction)) {
                if (trigger.getNextFireTime() == null) {
                    if (dbTrigger.getNextFireTime() == null) {
                        this.persister.removeTrigger(trigger.getKey());
                    }
                } else {
                    this.persister.removeTrigger(trigger.getKey());
                    this.signaler.signalSchedulingChange(0L);
                }
            } else if (executionInstruction == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                this.signaler.signalSchedulingChange(0L);
            } else if (executionInstruction == Trigger.CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                this.signaler.signalSchedulingChange(0L);
            } else if (executionInstruction == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                this.signaler.signalSchedulingChange(0L);
            } else if (executionInstruction == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                this.signaler.signalSchedulingChange(0L);
            }
        }
    }
}

