(ns clj-mysql.core
  (:require [clojure.java.jdbc :as j])
  (:import (com.mchange.v2.c3p0 ComboPooledDataSource)))

(def db-spec nil)
;(def db-spec
;  {:classname "com.mysql.jdbc.Driver"
;   :subprotocol "mysql"
;   :subname "//127.0.0.1:3306"
;   :user "root"
;   :password nil
;   :verifyServerCertificate false})

(defn pool
  [spec]
  (let [cpds (doto (ComboPooledDataSource.)
               (.setDriverClass (:classname spec))
               (.setJdbcUrl (str "jdbc:" (:subprotocol spec) ":" (:subname spec)))
               (.setUser (:user spec))
               (.setPassword (:password spec))
               ;; expire excess connections after 30 minutes of inactivity:
               (.setMaxIdleTimeExcessConnections (* 30 60))
               ;; expire connections after 3 hours of inactivity:
               (.setMaxIdleTime (* 3 60 60)))]
    {:datasource cpds}))

(def pooled-db (delay (pool db-spec)))

(defn db-connection [] @pooled-db)

(defn mysql-query
  "query mysql"
  [& rest]
  (j/query (db-connection) rest))

(defn mysql-insert
  "insert row to mysql
  table: keyword
  row: dict
  "
  [table row]
  (j/insert! (db-connection) table row))
