/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojurescript;

import gradle_clojure.plugin.clojurescript.ClojureScriptBuild;
import gradle_clojure.plugin.clojurescript.ClojureScriptExtension;
import gradle_clojure.plugin.clojurescript.internal.DefaultClojureScriptSourceSet;
import gradle_clojure.plugin.clojurescript.tasks.ClojureScriptCompile;
import gradle_clojure.plugin.common.internal.ClojureCommonBasePlugin;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;

public class ClojureScriptBasePlugin
implements Plugin<Project> {
    private final ObjectFactory objects;

    @Inject
    public ClojureScriptBasePlugin(ObjectFactory objects) {
        this.objects = objects;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ClojureCommonBasePlugin.class);
        ClojureScriptExtension extension = (ClojureScriptExtension)project.getExtensions().create("clojurescript", ClojureScriptExtension.class, new Object[]{project});
        this.configureSourceSetDefaults(project, extension);
        this.configureBuildDefaults(project, extension);
    }

    private void configureSourceSetDefaults(Project project, ClojureScriptExtension extension) {
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> {
            DefaultClojureScriptSourceSet clojurescriptSourceSet = new DefaultClojureScriptSourceSet("clojurescript", this.objects);
            new DslObject(sourceSet).getConvention().getPlugins().put("clojurescript", clojurescriptSourceSet);
            clojurescriptSourceSet.getClojureScript().srcDir((Object)String.format("src/%s/clojurescript", sourceSet.getName()));
            sourceSet.getResources().getFilter().exclude(element -> clojurescriptSourceSet.getClojureScript().contains(element.getFile()));
            sourceSet.getAllSource().source(clojurescriptSourceSet.getClojureScript());
            ClojureScriptBuild build = (ClojureScriptBuild)extension.getBuilds().create(sourceSet.getName());
            build.getSourceSet().set(sourceSet);
            sourceSet.getOutput().dir((Object)build.getOutputDir());
            project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(new Object[]{build.getTaskName("compile")});
            sourceSet.getOutput().dir((Object)project.provider(() -> {
                if (build.isCompilerConfigured()) {
                    return build.getOutputDir();
                }
                return clojurescriptSourceSet.getClojureScript().getSourceDirectories();
            }));
        });
    }

    private void configureBuildDefaults(Project project, ClojureScriptExtension extension) {
        extension.getRootOutputDir().set(project.getLayout().getBuildDirectory().dir("clojurescript"));
        extension.getBuilds().all(build -> {
            String compileTaskName = build.getTaskName("compile");
            ClojureScriptCompile compile = (ClojureScriptCompile)project.getTasks().create(compileTaskName, ClojureScriptCompile.class);
            compile.setDescription(String.format("Compiles the ClojureScript source for the %s build.", build.getName()));
            compile.getDestinationDir().set((Provider)build.getOutputDir());
            compile.getSourceRoots().from(new Object[]{build.getSourceRoots()});
            compile.getClasspath().from(new Object[]{build.getSourceSet().map(SourceSet::getCompileClasspath)});
            compile.setOptions(build.getCompiler());
        });
    }
}

