/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojure.tasks;

import gradle_clojure.plugin.clojure.tasks.ClojureCompileOptions;
import gradle_clojure.plugin.common.internal.ClojureExecSpec;
import gradle_clojure.plugin.common.internal.ClojureExecutor;
import gradle_clojure.plugin.common.internal.Namespaces;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.process.JavaForkOptions;

public class ClojureCompile
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(ClojureCompile.class);
    private final ClojureExecutor clojureExecutor = new ClojureExecutor(this.getProject());
    private final DirectoryProperty destinationDir = this.getProject().getObjects().directoryProperty();
    private final ConfigurableFileCollection sourceRoots = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection classpath = this.getProject().files(new Object[0]);
    private ClojureCompileOptions options = new ClojureCompileOptions();
    private final ForkOptions forkOptions = new ForkOptions();
    private final SetProperty<String> namespaces = this.getProject().getObjects().setProperty(String.class);

    public ClojureCompile() {
        this.onlyIf(task -> !((Set)this.getNamespaces().getOrElse(Collections.emptySet())).isEmpty());
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @InputFiles
    @SkipWhenEmpty
    public FileTree getSource() {
        return Namespaces.getSources((FileCollection)this.sourceRoots, Namespaces.CLOJURE_EXTENSIONS);
    }

    @Internal
    public ConfigurableFileCollection getSourceRoots() {
        return this.sourceRoots;
    }

    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Nested
    public ClojureCompileOptions getOptions() {
        return this.options;
    }

    public void setOptions(ClojureCompileOptions options) {
        this.options = options;
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void forkOptions(Action<? super ForkOptions> configureAction) {
        configureAction.execute((Object)this.forkOptions);
    }

    @Input
    public SetProperty<String> getNamespaces() {
        return this.namespaces;
    }

    @TaskAction
    public void compile() {
        File outputDir = ((Directory)this.getDestinationDir().get()).getAsFile();
        if (!this.getProject().delete(new Object[]{outputDir})) {
            throw new GradleException("Cannot clean destination directory: " + outputDir.getAbsolutePath());
        }
        if (!outputDir.mkdirs()) {
            throw new GradleException("Cannot create destination directory: " + outputDir.getAbsolutePath());
        }
        Set namespaces = (Set)this.getNamespaces().getOrElse(Collections.emptySet());
        if (namespaces.isEmpty()) {
            logger.info("No AOT namespaces requested, skipping {}", (Object)this.getName());
            return;
        }
        logger.info("Compiling {}", (Object)String.join((CharSequence)", ", namespaces));
        FileCollection classpath = this.getClasspath().plus((FileCollection)this.sourceRoots).plus((FileCollection)this.getProject().files(new Object[]{outputDir}));
        this.clojureExecutor.exec((Action<ClojureExecSpec>)((Action)spec -> {
            spec.setClasspath(classpath);
            spec.setMain("gradle-clojure.tools.clojure-compiler");
            spec.args(outputDir, namespaces, this.getOptions());
            spec.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                fork.setJvmArgs(this.forkOptions.getJvmArgs());
                fork.setMinHeapSize(this.forkOptions.getMemoryInitialSize());
                fork.setMaxHeapSize(this.forkOptions.getMemoryMaximumSize());
                fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
            }));
        }));
    }
}

