/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.common.internal;

import gradle_clojure.plugin.common.internal.ClojureExecSpec;
import gradle_clojure.plugin.common.internal.Edn;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;

public final class ClojureExecutor {
    private final Project project;

    public ClojureExecutor(Project project) {
        this.project = project;
    }

    public void exec(Action<ClojureExecSpec> action) {
        ClojureExecSpec cljSpec = new ClojureExecSpec();
        action.execute((Object)cljSpec);
        this.exec(cljSpec);
    }

    public void exec(ClojureExecSpec cljSpec) {
        FileCollection fullClasspath = cljSpec.getClasspath();
        this.project.javaexec(spec -> {
            spec.setMain("clojure.main");
            spec.args(new Object[]{"-m", cljSpec.getMain()});
            String ednArgs = Edn.print(Arrays.asList(cljSpec.getArgs()));
            ByteArrayInputStream input = new ByteArrayInputStream(ednArgs.getBytes(StandardCharsets.UTF_8));
            spec.setStandardInput((InputStream)input);
            spec.setClasspath(fullClasspath);
            cljSpec.getConfigureFork().forEach(forkAction -> forkAction.execute(spec));
            spec.systemProperty("gradle-clojure.tools.logger.level", (Object)this.getLogLevel());
        });
    }

    private String getLogLevel() {
        Supplier<String> gradleLevel = () -> Stream.of(LogLevel.DEBUG, LogLevel.INFO, LogLevel.LIFECYCLE, LogLevel.WARN, LogLevel.QUIET, LogLevel.ERROR).filter(arg_0 -> ((Logger)this.project.getLogger()).isEnabled(arg_0)).map(Enum::toString).map(String::toLowerCase).findFirst().orElse("info");
        return Optional.ofNullable(this.project.findProperty("gradle-clojure.tools.logger.level")).map(Object::toString).orElseGet(gradleLevel);
    }
}

