/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojurescript.tasks;

import gradle_clojure.plugin.clojurescript.tasks.CheckedArrays;
import gradle_clojure.plugin.clojurescript.tasks.ForeignLib;
import gradle_clojure.plugin.clojurescript.tasks.Module;
import gradle_clojure.plugin.clojurescript.tasks.Optimizations;
import gradle_clojure.plugin.clojurescript.tasks.Target;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.util.ConfigureUtil;

public final class ClojureScriptCompileOptions {
    private final Project project;
    private final DirectoryProperty destinationDir;
    private final RegularFileProperty outputTo;
    private final DirectoryProperty outputDir;
    private Optimizations optimizations;
    private String main;
    private String assetPath;
    private final RegularFileProperty sourceMapFile;
    private Boolean sourceMapEnabled;
    private Boolean verbose;
    private Boolean prettyPrint;
    private Target target;
    private List<ForeignLib> foreignLibs = new ArrayList<ForeignLib>();
    private List<String> externs = new ArrayList<String>();
    private Map<String, Module> modules = new HashMap<String, Module>();
    private List<String> preloads;
    private Map<String, String> npmDeps = new HashMap<String, String>();
    private Boolean installDeps;
    private CheckedArrays checkedArrays;

    public ClojureScriptCompileOptions(Project project, DirectoryProperty destinationDir) {
        this.project = project;
        this.destinationDir = destinationDir;
        this.outputTo = project.getLayout().fileProperty();
        this.outputDir = project.getLayout().directoryProperty();
        this.sourceMapFile = project.getLayout().fileProperty();
    }

    @OutputFile
    @Optional
    public RegularFileProperty getOutputTo() {
        return this.outputTo;
    }

    public void setOutputTo(String outputTo) {
        this.outputTo.set(this.destinationDir.file(outputTo));
    }

    public void setOutputTo(File outputTo) {
        this.outputTo.set(outputTo);
    }

    @Optional
    @OutputDirectory
    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir.set(this.destinationDir.dir(outputDir));
    }

    public void setOutputDir(File outputDir) {
        this.outputDir.set(outputDir);
    }

    @Input
    @Optional
    public Optimizations getOptimizations() {
        return this.optimizations;
    }

    public void setOptimizations(Optimizations optimizations) {
        this.optimizations = optimizations;
    }

    @Input
    @Optional
    public String getMain() {
        return this.main;
    }

    public void setMain(String main) {
        this.main = main;
    }

    @Input
    @Optional
    public String getAssetPath() {
        return this.assetPath;
    }

    public void setAssetPath(String assetPath) {
        this.assetPath = assetPath;
    }

    @Internal
    public Object getSourceMap() {
        File sourceMap = (File)this.sourceMapFile.getAsFile().getOrNull();
        if (sourceMap == null) {
            return this.sourceMapEnabled;
        }
        return sourceMap;
    }

    @OutputFile
    @Optional
    public RegularFileProperty getSourceMapPath() {
        return this.sourceMapFile;
    }

    public void setSourceMap(String sourceMap) {
        this.sourceMapEnabled = true;
        this.sourceMapFile.set(this.destinationDir.file(sourceMap));
    }

    public void setSourceMap(File sourceMap) {
        this.sourceMapEnabled = true;
        this.sourceMapFile.set(sourceMap);
    }

    public void setSourceMap(boolean sourceMap) {
        this.sourceMapEnabled = sourceMap;
        this.sourceMapFile.set((File)null);
    }

    @Console
    public Boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    @Input
    @Optional
    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Input
    @Optional
    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    @Input
    @Optional
    public List<ForeignLib> getForeignLibs() {
        return this.foreignLibs;
    }

    public ClojureScriptCompileOptions foreignLib(Closure<?> configureAction) {
        ForeignLib lib = new ForeignLib();
        ConfigureUtil.configure(configureAction, (Object)lib);
        this.foreignLibs.add(lib);
        return this;
    }

    public void setForeignLibs(List<ForeignLib> foreignLibs) {
        this.foreignLibs = foreignLibs;
    }

    @Input
    @Optional
    public List<String> getExterns() {
        return this.externs;
    }

    public void setExterns(List<String> externs) {
        this.externs = externs;
    }

    @Input
    @Optional
    public Map<String, Module> getModules() {
        return this.modules;
    }

    public ClojureScriptCompileOptions module(String name, Closure<?> configureAction) {
        Module module = new Module(this.project, this.destinationDir);
        ConfigureUtil.configure(configureAction, (Object)module);
        this.modules.put(name, module);
        return this;
    }

    public void setModules(Map<String, Module> modules) {
        this.modules = modules;
    }

    @Input
    @Optional
    public List<String> getPreloads() {
        return this.preloads;
    }

    public void setPreloads(List<String> preloads) {
        this.preloads = preloads;
    }

    @Input
    @Optional
    public Map<String, String> getNpmDeps() {
        return this.npmDeps;
    }

    public void setNpmDeps(Map<String, String> npmDeps) {
        this.npmDeps = npmDeps;
    }

    @Input
    @Optional
    public Boolean getInstallDeps() {
        return this.installDeps;
    }

    public void setInstallDeps(Boolean installDeps) {
        this.installDeps = installDeps;
    }

    @Input
    @Optional
    public CheckedArrays getCheckedArrays() {
        return this.checkedArrays;
    }

    public void setCheckedArrays(CheckedArrays checkedArrays) {
        this.checkedArrays = checkedArrays;
    }
}

