/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojurescript.tasks;

import gradle_clojure.plugin.clojurescript.tasks.ClojureScriptCompileOptions;
import gradle_clojure.plugin.common.internal.ClojureExecSpec;
import gradle_clojure.plugin.common.internal.ClojureExecutor;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaForkOptions;

public class ClojureScriptCompile
extends DefaultTask {
    private final ClojureExecutor clojureExecutor = new ClojureExecutor(this.getProject());
    private SourceDirectorySet source;
    private final DirectoryProperty destinationDir = this.getProject().getLayout().directoryProperty();
    private final ConfigurableFileCollection classpath = this.getProject().files(new Object[0]);
    private final ClojureScriptCompileOptions options = new ClojureScriptCompileOptions(this.getProject(), this.destinationDir);

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSource() {
        return this.source;
    }

    public void setSource(SourceDirectorySet source) {
        this.source = source;
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Nested
    public ClojureScriptCompileOptions getOptions() {
        return this.options;
    }

    public ClojureScriptCompile options(Action<? super ClojureScriptCompileOptions> configureAction) {
        configureAction.execute((Object)this.options);
        return this;
    }

    @TaskAction
    public void compile() {
        FileCollection classpath = this.getClasspath().plus((FileCollection)this.getProject().files(new Object[]{this.getSourceRootsFiles()}));
        this.clojureExecutor.exec((Action<ClojureExecSpec>)((Action)spec -> {
            spec.setClasspath(classpath);
            spec.setMain("gradle-clojure.tools.clojurescript-compiler");
            spec.args(this.getSourceRootsFiles(), this.getOptions());
            spec.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                fork.setJvmArgs(this.options.getForkOptions().getJvmArgs());
                fork.setMinHeapSize(this.options.getForkOptions().getMemoryInitialSize());
                fork.setMaxHeapSize(this.options.getForkOptions().getMemoryMaximumSize());
                fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
            }));
        }));
    }

    private Set<File> getSourceRootsFiles() {
        return this.source.getSrcDirs();
    }
}

