/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojure.tasks;

import gradle_clojure.plugin.clojure.tasks.ClojureCompile;
import gradle_clojure.plugin.clojure.tasks.ClojureCompileOptions;
import gradle_clojure.plugin.common.internal.ClojureExecSpec;
import gradle_clojure.plugin.common.internal.ClojureExecutor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaForkOptions;

public class ClojureCheck
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(ClojureCompile.class);
    private final ClojureExecutor clojureExecutor = new ClojureExecutor(this.getProject());
    private SourceDirectorySet source;
    private final ConfigurableFileCollection classpath = this.getProject().files(new Object[0]);
    private final RegularFileProperty outputFile = this.getProject().getLayout().fileProperty();
    private final ClojureCompileOptions options = new ClojureCompileOptions();
    private static final Map<Character, String> CHAR_MAP = new HashMap<Character, String>();
    private static final Map<String, Character> DEMUNGE_MAP;
    private static final Pattern DEMUNGE_PATTERN;

    public ClojureCheck() {
        this.outputFile.set(new File(this.getTemporaryDir(), "internal.txt"));
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSource() {
        return this.source;
    }

    public void setSource(SourceDirectorySet source) {
        this.source = source;
    }

    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @OutputFile
    public RegularFileProperty getInternalOutputFile() {
        return this.outputFile;
    }

    @Nested
    public ClojureCompileOptions getOptions() {
        return this.options;
    }

    public void options(Action<? super ClojureCompileOptions> configureAction) {
        configureAction.execute((Object)this.options);
    }

    @TaskAction
    public void check() {
        if (!this.getProject().delete(new Object[]{this.getTemporaryDir()})) {
            throw new GradleException("Cannot clean temporary directory: " + this.getTemporaryDir().getAbsolutePath());
        }
        List<String> namespaces = this.findNamespaces();
        if (namespaces.isEmpty()) {
            logger.warn("No Clojure namespaces defined, skipping {}", (Object)this.getName());
            return;
        }
        logger.info("Checking {}", (Object)String.join((CharSequence)", ", namespaces));
        FileCollection classpath = this.getClasspath().plus((FileCollection)this.getProject().files(new Object[]{this.getSourceRootsFiles()})).plus((FileCollection)this.getProject().files(new Object[]{this.getTemporaryDir()}));
        this.clojureExecutor.exec((Action<ClojureExecSpec>)((Action)spec -> {
            spec.setClasspath(classpath);
            spec.setMain("gradle-clojure.tools.clojure-compiler");
            spec.args(this.getSourceRootsFiles(), this.getTemporaryDir(), namespaces, this.getOptions());
            spec.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                fork.setJvmArgs(this.options.getForkOptions().getJvmArgs());
                fork.setMinHeapSize(this.options.getForkOptions().getMemoryInitialSize());
                fork.setMaxHeapSize(this.options.getForkOptions().getMemoryMaximumSize());
                fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
            }));
        }));
        Path output = ((RegularFile)this.getInternalOutputFile().get()).getAsFile().toPath();
        try {
            Files.write(output, Arrays.asList(Instant.now().toString()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<String> findNamespaces() {
        Set<String> roots = this.getSourceRoots();
        return StreamSupport.stream(this.getSource().spliterator(), false).filter(it -> it.getName().endsWith(".clj") || it.getName().endsWith(".cljc")).map(it -> this.findNamespace((File)it, roots)).collect(Collectors.toList());
    }

    private String findNamespace(File file, Set<String> roots) {
        try {
            String namespace = ClojureCheck.demunge(file.getName().substring(0, file.getName().lastIndexOf(46)));
            for (File current = file.getParentFile(); current != null; current = current.getParentFile()) {
                if (roots.contains(current.getCanonicalPath())) {
                    return namespace;
                }
                namespace = ClojureCheck.demunge(current.getName()) + "." + namespace;
            }
            throw new RuntimeException("No source root found for " + file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Set<String> getSourceRoots() {
        return this.getSourceRootsFiles().stream().map(it -> {
            try {
                return it.getCanonicalPath();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toSet());
    }

    private Set<File> getSourceRootsFiles() {
        return this.source.getSrcDirs();
    }

    private static String demunge(String mungedName) {
        StringBuilder sb = new StringBuilder();
        Matcher m = DEMUNGE_PATTERN.matcher(mungedName);
        int lastMatchEnd = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            sb.append(mungedName.substring(lastMatchEnd, start));
            lastMatchEnd = end;
            char origCh = DEMUNGE_MAP.get(m.group()).charValue();
            sb.append(origCh);
        }
        sb.append(mungedName.substring(lastMatchEnd));
        return sb.toString();
    }

    static {
        CHAR_MAP.put(Character.valueOf('-'), "_");
        CHAR_MAP.put(Character.valueOf(':'), "_COLON_");
        CHAR_MAP.put(Character.valueOf('+'), "_PLUS_");
        CHAR_MAP.put(Character.valueOf('>'), "_GT_");
        CHAR_MAP.put(Character.valueOf('<'), "_LT_");
        CHAR_MAP.put(Character.valueOf('='), "_EQ_");
        CHAR_MAP.put(Character.valueOf('~'), "_TILDE_");
        CHAR_MAP.put(Character.valueOf('!'), "_BANG_");
        CHAR_MAP.put(Character.valueOf('@'), "_CIRCA_");
        CHAR_MAP.put(Character.valueOf('#'), "_SHARP_");
        CHAR_MAP.put(Character.valueOf('\''), "_SINGLEQUOTE_");
        CHAR_MAP.put(Character.valueOf('\"'), "_DOUBLEQUOTE_");
        CHAR_MAP.put(Character.valueOf('%'), "_PERCENT_");
        CHAR_MAP.put(Character.valueOf('^'), "_CARET_");
        CHAR_MAP.put(Character.valueOf('&'), "_AMPERSAND_");
        CHAR_MAP.put(Character.valueOf('*'), "_STAR_");
        CHAR_MAP.put(Character.valueOf('|'), "_BAR_");
        CHAR_MAP.put(Character.valueOf('{'), "_LBRACE_");
        CHAR_MAP.put(Character.valueOf('}'), "_RBRACE_");
        CHAR_MAP.put(Character.valueOf('['), "_LBRACK_");
        CHAR_MAP.put(Character.valueOf(']'), "_RBRACK_");
        CHAR_MAP.put(Character.valueOf('/'), "_SLASH_");
        CHAR_MAP.put(Character.valueOf('\\'), "_BSLASH_");
        CHAR_MAP.put(Character.valueOf('?'), "_QMARK_");
        DEMUNGE_MAP = CHAR_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        DEMUNGE_PATTERN = Pattern.compile(DEMUNGE_MAP.keySet().stream().sorted(Comparator.comparingInt(String::length).reversed()).map(it -> "\\Q" + it + "\\E").collect(Collectors.joining("|")));
    }
}

