/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.clojure;

import gradle_clojure.plugin.clojure.internal.DefaultClojureSourceSet;
import gradle_clojure.plugin.clojure.tasks.ClojureCompile;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ComponentModuleMetadataDetails;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;

public class ClojureBasePlugin
implements Plugin<Project> {
    private final SourceDirectorySetFactory sourceDirectorySetFactory;

    @Inject
    public ClojureBasePlugin(SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.sourceDirectorySetFactory = sourceDirectorySetFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureSourceSetDefaults(project);
        this.configureModuleReplacements(project);
    }

    private void configureSourceSetDefaults(Project project) {
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> {
            DefaultClojureSourceSet clojureSourceSet = new DefaultClojureSourceSet("clojure", this.sourceDirectorySetFactory);
            new DslObject(sourceSet).getConvention().getPlugins().put("clojure", clojureSourceSet);
            clojureSourceSet.getClojure().srcDir((Object)String.format("src/%s/clojure", sourceSet.getName()));
            sourceSet.getResources().getFilter().exclude(element -> clojureSourceSet.getClojure().contains(element.getFile()));
            sourceSet.getAllSource().source(clojureSourceSet.getClojure());
            String compileTaskName = sourceSet.getCompileTaskName("clojure");
            ClojureCompile compile = (ClojureCompile)project.getTasks().create(compileTaskName, ClojureCompile.class);
            compile.setDescription(String.format("Compiles the %s Clojure source.", sourceSet.getName()));
            compile.setSource((FileTree)clojureSourceSet.getClojure());
            Provider classpath = project.provider(() -> sourceSet.getCompileClasspath().plus((FileCollection)project.files(new Object[]{sourceSet.getJava().getOutputDir()})).plus((FileCollection)project.files(new Object[]{sourceSet.getOutput().getResourcesDir()})));
            compile.setClasspath((FileCollection)project.files(new Object[]{classpath}));
            DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
            String outputDirPath = String.format("classes/%s/%s", clojureSourceSet.getClojure().getName(), sourceSet.getName());
            Provider outputDir = buildDir.dir(outputDirPath);
            clojureSourceSet.getClojure().setOutputDir(outputDir.map(dir -> dir.getAsFile()));
            ((DefaultSourceSetOutput)sourceSet.getOutput()).addClassesDir(() -> ((Directory)outputDir.get()).getAsFile());
            compile.setDestinationDir(outputDir.map(dir -> dir.getAsFile()));
            compile.dependsOn(new Object[]{project.getTasks().getByName(sourceSet.getCompileJavaTaskName())});
            compile.dependsOn(new Object[]{project.getTasks().getByName(sourceSet.getProcessResourcesTaskName())});
            project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(new Object[]{compile});
        });
    }

    private void configureModuleReplacements(Project project) {
        project.getDependencies().getModules().module((Object)"org.clojure:tools.nrepl", module -> {
            ComponentModuleMetadataDetails details = (ComponentModuleMetadataDetails)module;
            details.replacedBy((Object)"nrepl:nrepl", "nREPL was moved out of Clojure Contrib to its own project.");
        });
    }
}

