/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.tasks;

import gradle_clojure.plugin.internal.ClojureExecutor;
import gradle_clojure.plugin.internal.ExperimentalSettings;
import gradle_clojure.plugin.tasks.ClojureExecSpec;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.WorkerExecutor;

public class ClojureExec
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(ClojureExec.class);
    private final ClojureExecutor clojureExecutor;
    private FileCollection classpath;
    private String main;
    private List<Object> args = new ArrayList<Object>();

    @Inject
    public ClojureExec(WorkerExecutor workerExecutor) {
        this.clojureExecutor = new ClojureExecutor(this.getProject(), workerExecutor);
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Input
    public String getMain() {
        return this.main;
    }

    public void setMain(String main) {
        this.main = main;
    }

    @Input
    public List<Object> getArgs() {
        return this.args;
    }

    public void setArgs(List<Object> args) {
        this.args = args;
    }

    public void args(Object ... args) {
        Collections.addAll(this.args, args);
    }

    @TaskAction
    public void exec() {
        Action action = spec -> {
            spec.setClasspath(this.getClasspath());
            spec.setMain(this.getMain());
            spec.setArgs(this.getArgs().toArray(new Object[this.getArgs().size()]));
            spec.forkOptions((Action<JavaForkOptions>)((Action)fork -> fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name())));
        };
        if (ExperimentalSettings.isUseWorkers()) {
            this.clojureExecutor.submit((Action<ClojureExecSpec>)action);
        } else {
            this.clojureExecutor.exec((Action<ClojureExecSpec>)action);
        }
    }
}

