/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.internal;

import gradle_clojure.plugin.internal.ClojureWorker;
import gradle_clojure.plugin.tasks.ClojureExecSpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;
import us.bpsm.edn.printer.Printers;
import us.bpsm.edn.protocols.Protocol;

public final class ClojureExecutor {
    private static final String SHIMDANDY_VERSION = "1.2.1";
    private static final String NREPL_VERSION = "0.2.12";
    private static final String GRADLE_CLOJURE_VERSION = ClojureExecutor.getVersion();
    private final Project project;
    private final WorkerExecutor workerExecutor;

    public ClojureExecutor(Project project, WorkerExecutor workerExecutor) {
        this.project = project;
        this.workerExecutor = workerExecutor;
    }

    public void exec(Action<ClojureExecSpec> action) {
        ClojureExecSpec cljSpec = new ClojureExecSpec();
        action.execute((Object)cljSpec);
        this.exec(cljSpec);
    }

    public void exec(ClojureExecSpec cljSpec) {
        FileCollection fullClasspath = cljSpec.getClasspath().plus(this.resolve(this.tools(), this.nrepl()));
        this.project.javaexec(spec -> {
            spec.setMain("clojure.main");
            spec.args(new Object[]{"-m", cljSpec.getMain()});
            String ednArgs = Printers.printString((Protocol)Printers.prettyPrinterProtocol(), Arrays.asList(cljSpec.getArgs()));
            ByteArrayInputStream input = new ByteArrayInputStream(ednArgs.getBytes(StandardCharsets.UTF_8));
            spec.setStandardInput((InputStream)input);
            spec.setClasspath(fullClasspath);
            cljSpec.getConfigureFork().forEach(forkAction -> forkAction.execute(spec));
        });
    }

    public void submit(Action<ClojureExecSpec> action) {
        ClojureExecSpec cljSpec = new ClojureExecSpec();
        action.execute((Object)cljSpec);
        FileCollection additionalClasspath = this.resolve(this.tools(), this.nrepl(), this.shimImpl());
        FileCollection realClasspath = cljSpec.getClasspath().plus(additionalClasspath);
        this.workerExecutor.submit(ClojureWorker.class, worker -> {
            worker.setIsolationMode(IsolationMode.PROCESS);
            worker.params(new Object[]{cljSpec.getMain(), cljSpec.getArgs(), realClasspath.getFiles()});
            cljSpec.getConfigureFork().forEach(arg_0 -> ((WorkerConfiguration)worker).forkOptions(arg_0));
            worker.forkOptions(fork -> fork.systemProperty("gradle-clojure.tools.logger.level", (Object)this.getLogLevel()));
            worker.classpath((Iterable)this.resolve(this.shimApi()));
        });
    }

    public void await() {
        this.workerExecutor.await();
    }

    public FileCollection resolve(Dependency ... deps) {
        return this.project.getConfigurations().detachedConfiguration(deps).setTransitive(false);
    }

    public Dependency tools() {
        return this.project.getDependencies().create((Object)("io.github.gradle-clojure:gradle-clojure-tools:" + GRADLE_CLOJURE_VERSION));
    }

    public Dependency nrepl() {
        return this.project.getDependencies().create((Object)"org.clojure:tools.nrepl:0.2.12");
    }

    public Dependency shimApi() {
        return this.project.getDependencies().create((Object)"org.projectodd.shimdandy:shimdandy-api:1.2.1");
    }

    public Dependency shimImpl() {
        return this.project.getDependencies().create((Object)"org.projectodd.shimdandy:shimdandy-impl:1.2.1");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersion() {
        try (InputStream stream = ClojureExecutor.class.getResourceAsStream("/gradle-clojure.properties");){
            Properties props = new Properties();
            props.load(stream);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getLogLevel() {
        Supplier<String> gradleLevel = () -> Stream.of(LogLevel.DEBUG, LogLevel.INFO, LogLevel.LIFECYCLE, LogLevel.WARN, LogLevel.QUIET, LogLevel.ERROR).filter(arg_0 -> ((Logger)this.project.getLogger()).isEnabled(arg_0)).map(Enum::toString).map(String::toLowerCase).findFirst().orElse("info");
        return Optional.ofNullable(this.project.findProperty("gradle-clojure.tools.logger.level")).map(Object::toString).orElseGet(gradleLevel);
    }
}

