/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin;

import gradle_clojure.plugin.internal.DefaultClojureSourceSet;
import gradle_clojure.plugin.tasks.ClojureCompile;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.SourceSetUtil;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;

public class ClojureBasePlugin
implements Plugin<Project> {
    private final SourceDirectorySetFactory sourceDirectorySetFactory;

    @Inject
    public ClojureBasePlugin(SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.sourceDirectorySetFactory = sourceDirectorySetFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureSourceSetDefaults(project);
    }

    private void configureSourceSetDefaults(Project project) {
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> {
            DefaultClojureSourceSet clojureSourceSet = new DefaultClojureSourceSet("clojure", this.sourceDirectorySetFactory);
            new DslObject(sourceSet).getConvention().getPlugins().put("clojure", clojureSourceSet);
            clojureSourceSet.getClojure().srcDir((Object)String.format("src/%s/clojure", sourceSet.getName()));
            sourceSet.getResources().getFilter().exclude(element -> clojureSourceSet.getClojure().contains(element.getFile()));
            sourceSet.getAllSource().source(clojureSourceSet.getClojure());
            String compileTaskName = sourceSet.getCompileTaskName("clojure");
            ClojureCompile compile = (ClojureCompile)project.getTasks().create(compileTaskName, ClojureCompile.class);
            compile.setDescription(String.format("Compiles the %s Clojure source.", sourceSet.getName()));
            compile.setSource((FileTree)clojureSourceSet.getClojure());
            compile.getConventionMapping().map("classpath", () -> sourceSet.getCompileClasspath().plus((FileCollection)project.files(new Object[]{sourceSet.getJava().getOutputDir()})).plus((FileCollection)project.files(new Object[]{sourceSet.getOutput().getResourcesDir()})));
            compile.getConventionMapping().map("namespaces", compile::findNamespaces);
            SourceSetUtil.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)clojureSourceSet.getClojure(), (AbstractCompile)compile, (Project)project);
            compile.dependsOn(new Object[]{project.getTasks().getByName(sourceSet.getCompileJavaTaskName())});
            compile.dependsOn(new Object[]{project.getTasks().getByName(sourceSet.getProcessResourcesTaskName())});
            project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(new Object[]{compile});
        });
    }
}

