/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.tasks;

import gradle_clojure.plugin.internal.ClojureWorkerExecutor;
import gradle_clojure.plugin.tasks.ClojureForkOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.WorkerExecutor;

public class ClojureNRepl
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(ClojureNRepl.class);
    private final ClojureWorkerExecutor workerExecutor;
    private ClojureForkOptions forkOptions = new ClojureForkOptions();
    private FileCollection classpath;
    private int port = -1;
    private int controlPort = -1;

    @Inject
    public ClojureNRepl(WorkerExecutor workerExecutor) {
        this.workerExecutor = new ClojureWorkerExecutor(this.getProject(), workerExecutor);
    }

    @TaskAction
    public void run() {
        Throwable throwable;
        ServerSocket socket;
        if (this.port < 0) {
            try {
                socket = new ServerSocket(0);
                throwable = null;
                try {
                    this.port = socket.getLocalPort();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (socket != null) {
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            socket.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try {
            socket = new ServerSocket(0);
            throwable = null;
            try {
                this.controlPort = socket.getLocalPort();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (socket != null) {
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        socket.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.start();
        this.stopOnSignal();
        this.workerExecutor.await();
    }

    private void start() {
        this.workerExecutor.submit((Action<ClojureWorkerExecutor.ClojureWorkerConfiguration>)((Action)config -> {
            config.setClasspath(this.getClasspath());
            config.setNamespace("gradle-clojure.tools.clojure-nrepl");
            config.setFunction("start!");
            config.setArgs(this.port, this.controlPort);
            config.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                fork.setJvmArgs(this.getForkOptions().getJvmArgs());
                fork.setMinHeapSize(this.getForkOptions().getMemoryInitialSize());
                fork.setMaxHeapSize(this.getForkOptions().getMemoryMaximumSize());
                fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
            }));
        }));
    }

    private void stopOnSignal() {
        Runnable waitLoop = () -> {
            try {
                int c;
                while ((c = System.in.read()) != -1 && c != 4) {
                }
                this.stop();
            }
            catch (IOException e) {
                this.stop();
                throw new UncheckedIOException(e);
            }
        };
        new Thread(waitLoop).start();
    }

    private void stop() {
        try (SocketChannel socket = SocketChannel.open();
             PrintWriter writer = new PrintWriter(Channels.newWriter((WritableByteChannel)socket, StandardCharsets.UTF_8.name()), true);
             BufferedReader reader = new BufferedReader(Channels.newReader((ReadableByteChannel)socket, StandardCharsets.UTF_8.name()));){
            socket.connect(new InetSocketAddress("localhost", this.controlPort));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nested
    public ClojureForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public ClojureNRepl forkOptions(Action<? super ClojureForkOptions> configureAction) {
        configureAction.execute((Object)this.forkOptions);
        return this;
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Input
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

