/*
 * Decompiled with CFR 0.152.
 */
package gradle_clojure.plugin.tasks;

import gradle_clojure.plugin.internal.ClojureWorkerExecutor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.WorkerExecutor;

public class ClojureExec
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(ClojureExec.class);
    private final ClojureWorkerExecutor workerExecutor;
    private FileCollection classpath;
    private String namespace;
    private String function;
    private List<Object> args = new ArrayList<Object>();

    @Inject
    public ClojureExec(WorkerExecutor workerExecutor) {
        this.workerExecutor = new ClojureWorkerExecutor(this.getProject(), workerExecutor);
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Input
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Input
    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    @Input
    public List<Object> getArgs() {
        return this.args;
    }

    public void setArgs(List<Object> args) {
        this.args = args;
    }

    public void args(Object ... args) {
        Collections.addAll(this.args, args);
    }

    @TaskAction
    public void exec() {
        this.workerExecutor.submit((Action<ClojureWorkerExecutor.ClojureWorkerConfiguration>)((Action)config -> {
            config.setClasspath(this.getClasspath());
            config.setNamespace(this.getNamespace());
            config.setFunction(this.getFunction());
            config.setArgs(this.getArgs().toArray(new Object[this.getArgs().size()]));
            config.forkOptions((Action<JavaForkOptions>)((Action)fork -> fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name())));
        }));
    }
}

